/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.camel.camelplugin;

import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.BrokerContext;
import org.apache.activemq.broker.BrokerFilter;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.ConsumerBrokerExchange;
import org.apache.activemq.broker.ProducerBrokerExchange;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.command.ConsumerControl;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageDispatch;
import org.apache.activemq.command.MessagePull;
import org.apache.activemq.command.Response;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.spring.Utils;
import org.apache.activemq.usage.Usage;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RoutesDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class CamelRoutesBroker
extends BrokerFilter {
    private static Logger LOG = LoggerFactory.getLogger(CamelRoutesBroker.class);
    private String routesFile = "";
    private int checkPeriod = 1000;
    private Resource theRoutes;
    private DefaultCamelContext camelContext;
    private long lastRoutesModified = -1L;
    private CountDownLatch countDownLatch;

    @Override
    public void send(ProducerBrokerExchange producerExchange, Message message) throws Exception {
        this.blockWhileLoadingCamelRoutes();
        super.send(producerExchange, message);
    }

    @Override
    public void acknowledge(ConsumerBrokerExchange consumerExchange, MessageAck ack) throws Exception {
        this.blockWhileLoadingCamelRoutes();
        super.acknowledge(consumerExchange, ack);
    }

    @Override
    public Response messagePull(ConnectionContext context, MessagePull pull) throws Exception {
        this.blockWhileLoadingCamelRoutes();
        return super.messagePull(context, pull);
    }

    @Override
    public void processConsumerControl(ConsumerBrokerExchange consumerExchange, ConsumerControl control) {
        this.blockWhileLoadingCamelRoutes();
        super.processConsumerControl(consumerExchange, control);
    }

    @Override
    public void reapplyInterceptor() {
        this.blockWhileLoadingCamelRoutes();
        super.reapplyInterceptor();
    }

    @Override
    public void beginTransaction(ConnectionContext context, TransactionId xid) throws Exception {
        this.blockWhileLoadingCamelRoutes();
        super.beginTransaction(context, xid);
    }

    @Override
    public int prepareTransaction(ConnectionContext context, TransactionId xid) throws Exception {
        this.blockWhileLoadingCamelRoutes();
        return super.prepareTransaction(context, xid);
    }

    @Override
    public void rollbackTransaction(ConnectionContext context, TransactionId xid) throws Exception {
        this.blockWhileLoadingCamelRoutes();
        super.rollbackTransaction(context, xid);
    }

    @Override
    public void commitTransaction(ConnectionContext context, TransactionId xid, boolean onePhase) throws Exception {
        this.blockWhileLoadingCamelRoutes();
        super.commitTransaction(context, xid, onePhase);
    }

    @Override
    public void forgetTransaction(ConnectionContext context, TransactionId transactionId) throws Exception {
        this.blockWhileLoadingCamelRoutes();
        super.forgetTransaction(context, transactionId);
    }

    @Override
    public void preProcessDispatch(MessageDispatch messageDispatch) {
        this.blockWhileLoadingCamelRoutes();
        super.preProcessDispatch(messageDispatch);
    }

    @Override
    public void postProcessDispatch(MessageDispatch messageDispatch) {
        this.blockWhileLoadingCamelRoutes();
        super.postProcessDispatch(messageDispatch);
    }

    @Override
    public boolean sendToDeadLetterQueue(ConnectionContext context, MessageReference messageReference, Subscription subscription, Throwable poisonCause) {
        this.blockWhileLoadingCamelRoutes();
        return super.sendToDeadLetterQueue(context, messageReference, subscription, poisonCause);
    }

    @Override
    public void messageConsumed(ConnectionContext context, MessageReference messageReference) {
        this.blockWhileLoadingCamelRoutes();
        super.messageConsumed(context, messageReference);
    }

    @Override
    public void messageDelivered(ConnectionContext context, MessageReference messageReference) {
        this.blockWhileLoadingCamelRoutes();
        super.messageDelivered(context, messageReference);
    }

    @Override
    public void messageDiscarded(ConnectionContext context, Subscription sub, MessageReference messageReference) {
        this.blockWhileLoadingCamelRoutes();
        super.messageDiscarded(context, sub, messageReference);
    }

    @Override
    public void isFull(ConnectionContext context, Destination destination, Usage<?> usage) {
        this.blockWhileLoadingCamelRoutes();
        super.isFull(context, destination, usage);
    }

    @Override
    public void nowMasterBroker() {
        this.blockWhileLoadingCamelRoutes();
        super.nowMasterBroker();
    }

    public String getRoutesFile() {
        return this.routesFile;
    }

    public void setRoutesFile(String routesFile) {
        this.routesFile = routesFile;
    }

    public int getCheckPeriod() {
        return this.checkPeriod;
    }

    public void setCheckPeriod(int checkPeriod) {
        this.checkPeriod = checkPeriod;
    }

    public CamelRoutesBroker(Broker next) {
        super(next);
    }

    @Override
    public void start() throws Exception {
        super.start();
        LOG.info("Starting CamelRoutesBroker");
        this.camelContext = new DefaultCamelContext();
        this.camelContext.setName("EmbeddedCamel-" + this.getBrokerName());
        this.camelContext.start();
        this.getBrokerService().getScheduler().executePeriodically(new Runnable(){

            @Override
            public void run() {
                try {
                    CamelRoutesBroker.this.loadCamelRoutes();
                }
                catch (Throwable e) {
                    LOG.error("Failed to load Camel Routes", e);
                }
            }
        }, this.getCheckPeriod());
    }

    @Override
    public void stop() throws Exception {
        CountDownLatch latch = this.countDownLatch;
        if (latch != null) {
            latch.countDown();
        }
        if (this.camelContext != null) {
            this.camelContext.stop();
        }
        super.stop();
    }

    private void loadCamelRoutes() throws Exception {
        long lastModified;
        if (this.theRoutes == null) {
            String uri;
            Resource resource;
            BrokerContext brokerContext;
            String fileToUse = this.getRoutesFile();
            if ((fileToUse == null || fileToUse.trim().isEmpty()) && (brokerContext = this.getBrokerService().getBrokerContext()) != null && (resource = Utils.resourceFromString(uri = brokerContext.getConfigurationUrl())).exists()) {
                fileToUse = resource.getFile().getParent();
                fileToUse = fileToUse + File.separator;
                fileToUse = fileToUse + "routes.xml";
            }
            if (fileToUse != null && !fileToUse.isEmpty()) {
                this.theRoutes = Utils.resourceFromString(fileToUse);
                this.setRoutesFile(this.theRoutes.getFile().getAbsolutePath());
            }
        }
        if (!this.isStopped() && this.camelContext != null && this.theRoutes != null && this.theRoutes.exists() && (lastModified = this.theRoutes.lastModified()) != this.lastRoutesModified) {
            CountDownLatch latch;
            this.countDownLatch = latch = new CountDownLatch(1);
            this.lastRoutesModified = lastModified;
            List<RouteDefinition> currentRoutes = this.camelContext.getRouteDefinitions();
            for (RouteDefinition rd : currentRoutes) {
                this.camelContext.stopRoute(rd);
                this.camelContext.removeRouteDefinition(rd);
            }
            InputStream is = this.theRoutes.getInputStream();
            RoutesDefinition routesDefinition = this.camelContext.loadRoutesDefinition(is);
            for (RouteDefinition rd : routesDefinition.getRoutes()) {
                this.camelContext.startRoute(rd);
            }
            is.close();
            latch.countDown();
            this.countDownLatch = null;
        }
    }

    private void blockWhileLoadingCamelRoutes() {
        CountDownLatch latch = this.countDownLatch;
        if (latch != null) {
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

