/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kahadb.index;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.kahadb.index.BTreeNode;
import org.apache.kahadb.index.BTreeVisitor;
import org.apache.kahadb.index.Index;
import org.apache.kahadb.page.Page;
import org.apache.kahadb.page.PageFile;
import org.apache.kahadb.page.Transaction;
import org.apache.kahadb.util.Marshaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BTreeIndex<Key, Value>
implements Index<Key, Value> {
    private static final Log LOG = LogFactory.getLog(BTreeIndex.class);
    private PageFile pageFile;
    private long pageId;
    private AtomicBoolean loaded = new AtomicBoolean();
    private final BTreeNode.Marshaller<Key, Value> marshaller = new BTreeNode.Marshaller(this);
    private Marshaller<Key> keyMarshaller;
    private Marshaller<Value> valueMarshaller;
    private Prefixer<Key> prefixer;

    public BTreeIndex() {
    }

    public BTreeIndex(long rootPageId) {
        this.pageId = rootPageId;
    }

    public BTreeIndex(Page page) {
        this(page.getPageId());
    }

    public BTreeIndex(PageFile pageFile, long rootPageId) {
        this.pageFile = pageFile;
        this.pageId = rootPageId;
    }

    public BTreeIndex(PageFile pageFile, Page page) {
        this(pageFile, page.getPageId());
    }

    @Override
    public synchronized void load(Transaction tx) throws IOException {
        if (this.loaded.compareAndSet(false, true)) {
            LOG.debug("loading");
            if (this.keyMarshaller == null) {
                throw new IllegalArgumentException("The key marshaller must be set before loading the BTreeIndex");
            }
            if (this.valueMarshaller == null) {
                throw new IllegalArgumentException("The value marshaller must be set before loading the BTreeIndex");
            }
            Page<BTreeNode<Key, Value>> p = tx.load(this.pageId, null);
            if (p.getType() == 0) {
                BTreeNode<Key, Value> root = this.createNode(p, null);
                this.storeNode(tx, root, true);
            }
        }
    }

    @Override
    public synchronized void unload(Transaction tx) {
        if (this.loaded.compareAndSet(true, false)) {
            // empty if block
        }
    }

    private BTreeNode<Key, Value> getRoot(Transaction tx) throws IOException {
        return this.loadNode(tx, this.pageId, null);
    }

    @Override
    public synchronized boolean containsKey(Transaction tx, Key key) throws IOException {
        this.assertLoaded();
        return this.getRoot(tx).contains(tx, key);
    }

    @Override
    public synchronized Value get(Transaction tx, Key key) throws IOException {
        this.assertLoaded();
        return this.getRoot(tx).get(tx, key);
    }

    @Override
    public synchronized Value put(Transaction tx, Key key, Value value) throws IOException {
        this.assertLoaded();
        return this.getRoot(tx).put(tx, key, value);
    }

    @Override
    public synchronized Value remove(Transaction tx, Key key) throws IOException {
        this.assertLoaded();
        return this.getRoot(tx).remove(tx, key);
    }

    @Override
    public boolean isTransient() {
        return false;
    }

    @Override
    public synchronized void clear(Transaction tx) throws IOException {
        this.getRoot(tx).clear(tx);
    }

    public synchronized int getMinLeafDepth(Transaction tx) throws IOException {
        return this.getRoot(tx).getMinLeafDepth(tx, 0);
    }

    public synchronized int getMaxLeafDepth(Transaction tx) throws IOException {
        return this.getRoot(tx).getMaxLeafDepth(tx, 0);
    }

    public synchronized void printStructure(Transaction tx, PrintWriter out) throws IOException {
        this.getRoot(tx).printStructure(tx, out, "");
    }

    public synchronized void printStructure(Transaction tx, OutputStream out) throws IOException {
        PrintWriter pw = new PrintWriter(out, false);
        this.getRoot(tx).printStructure(tx, pw, "");
        pw.flush();
    }

    @Override
    public synchronized Iterator<Map.Entry<Key, Value>> iterator(Transaction tx) throws IOException {
        return this.getRoot(tx).iterator(tx);
    }

    public synchronized Iterator<Map.Entry<Key, Value>> iterator(Transaction tx, Key initialKey) throws IOException {
        return this.getRoot(tx).iterator(tx, initialKey);
    }

    public synchronized void visit(Transaction tx, BTreeVisitor<Key, Value> visitor) throws IOException {
        this.getRoot(tx).visit(tx, visitor);
    }

    public synchronized Map.Entry<Key, Value> getFirst(Transaction tx) throws IOException {
        return this.getRoot(tx).getFirst(tx);
    }

    public synchronized Map.Entry<Key, Value> getLast(Transaction tx) throws IOException {
        return this.getRoot(tx).getLast(tx);
    }

    private void assertLoaded() throws IllegalStateException {
        if (!this.loaded.get()) {
            throw new IllegalStateException("The BTreeIndex is not loaded");
        }
    }

    BTreeNode<Key, Value> loadNode(Transaction tx, long pageId, BTreeNode<Key, Value> parent) throws IOException {
        Page page = tx.load(pageId, this.marshaller);
        BTreeNode node = (BTreeNode)page.get();
        node.setPage(page);
        node.setParent(parent);
        return node;
    }

    BTreeNode<Key, Value> createNode(Transaction tx, BTreeNode<Key, Value> parent) throws IOException {
        Page p = tx.allocate();
        BTreeNode<Key, Value> node = new BTreeNode<Key, Value>(this);
        node.setPage(p);
        node.setParent(parent);
        node.setEmpty();
        p.set(node);
        return node;
    }

    BTreeNode<Key, Value> createNode(Page<BTreeNode<Key, Value>> p, BTreeNode<Key, Value> parent) throws IOException {
        BTreeNode<Key, Value> node = new BTreeNode<Key, Value>(this);
        node.setPage(p);
        node.setParent(parent);
        node.setEmpty();
        p.set(node);
        return node;
    }

    void storeNode(Transaction tx, BTreeNode<Key, Value> node, boolean overflow) throws IOException {
        tx.store(node.getPage(), this.marshaller, overflow);
    }

    public PageFile getPageFile() {
        return this.pageFile;
    }

    public long getPageId() {
        return this.pageId;
    }

    public Marshaller<Key> getKeyMarshaller() {
        return this.keyMarshaller;
    }

    @Override
    public void setKeyMarshaller(Marshaller<Key> keyMarshaller) {
        this.keyMarshaller = keyMarshaller;
    }

    public Marshaller<Value> getValueMarshaller() {
        return this.valueMarshaller;
    }

    @Override
    public void setValueMarshaller(Marshaller<Value> valueMarshaller) {
        this.valueMarshaller = valueMarshaller;
    }

    public Prefixer<Key> getPrefixer() {
        return this.prefixer;
    }

    public void setPrefixer(Prefixer<Key> prefixer) {
        this.prefixer = prefixer;
    }

    public void setPageFile(PageFile pageFile) {
        this.pageFile = pageFile;
    }

    public void setPageId(long pageId) {
        this.pageId = pageId;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StringPrefixer
    implements Prefixer<String> {
        @Override
        public String getSimplePrefix(String value1, String value2) {
            char[] c1 = value1.toCharArray();
            char[] c2 = value2.toCharArray();
            int n = Math.min(c1.length, c2.length);
            for (int i = 0; i < n; ++i) {
                if (c1[i] == c2[i]) continue;
                return value2.substring(0, i + 1);
            }
            if (n == c2.length) {
                return value2;
            }
            return value2.substring(0, n);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Prefixer<Key> {
        public Key getSimplePrefix(Key var1, Key var2);
    }
}

