/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.nio;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import javax.net.SocketFactory;
import org.apache.activemq.command.Command;
import org.apache.activemq.transport.nio.NIOInputStream;
import org.apache.activemq.transport.nio.NIOOutputStream;
import org.apache.activemq.transport.nio.SelectorManager;
import org.apache.activemq.transport.nio.SelectorSelection;
import org.apache.activemq.transport.tcp.TcpTransport;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.util.ServiceStopper;
import org.apache.activemq.wireformat.WireFormat;

public class NIOTransport
extends TcpTransport {
    private SocketChannel channel;
    private SelectorSelection selection;
    private ByteBuffer inputBuffer;
    private ByteBuffer currentBuffer;
    private int nextFrameSize;

    public NIOTransport(WireFormat wireFormat, SocketFactory socketFactory, URI remoteLocation, URI localLocation) throws UnknownHostException, IOException {
        super(wireFormat, socketFactory, remoteLocation, localLocation);
    }

    public NIOTransport(WireFormat wireFormat, Socket socket) throws IOException {
        super(wireFormat, socket);
    }

    protected void initializeStreams() throws IOException {
        this.channel = this.socket.getChannel();
        this.channel.configureBlocking(false);
        this.selection = SelectorManager.getInstance().register(this.channel, new SelectorManager.Listener(){

            public void onSelect(SelectorSelection selection) {
                NIOTransport.this.serviceRead();
            }

            public void onError(SelectorSelection selection, Throwable error) {
                if (error instanceof IOException) {
                    NIOTransport.this.onException((IOException)error);
                } else {
                    NIOTransport.this.onException(IOExceptionSupport.create(error));
                }
            }
        });
        this.currentBuffer = this.inputBuffer = ByteBuffer.allocate(8192);
        this.nextFrameSize = -1;
        this.currentBuffer.limit(4);
        this.dataOut = new DataOutputStream(new NIOOutputStream(this.channel, 16384));
    }

    private void serviceRead() {
        try {
            while (true) {
                int readSize;
                if ((readSize = this.channel.read(this.currentBuffer)) == -1) {
                    this.onException(new EOFException());
                    this.selection.close();
                } else if (readSize != 0) {
                    if (this.currentBuffer.hasRemaining()) continue;
                    if (this.nextFrameSize == -1) {
                        assert (this.inputBuffer == this.currentBuffer);
                        this.inputBuffer.flip();
                        this.nextFrameSize = this.inputBuffer.getInt() + 4;
                        if (this.nextFrameSize > this.inputBuffer.capacity()) {
                            this.currentBuffer = ByteBuffer.allocate(this.nextFrameSize);
                            this.currentBuffer.putInt(this.nextFrameSize);
                            continue;
                        }
                        this.inputBuffer.limit(this.nextFrameSize);
                        continue;
                    }
                    this.currentBuffer.flip();
                    Object command = this.wireFormat.unmarshal(new DataInputStream(new NIOInputStream(this.currentBuffer)));
                    this.doConsume((Command)command);
                    this.nextFrameSize = -1;
                    this.inputBuffer.clear();
                    this.inputBuffer.limit(4);
                    this.currentBuffer = this.inputBuffer;
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            this.onException(e);
        }
        catch (Throwable e) {
            this.onException(IOExceptionSupport.create(e));
        }
    }

    protected void doStart() throws Exception {
        this.connect();
        this.selection.setInterestOps(1);
        this.selection.enable();
    }

    protected void doStop(ServiceStopper stopper) throws Exception {
        this.selection.close();
        super.doStop(stopper);
    }
}

