/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.vm;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerFactoryHandler;
import org.apache.activemq.broker.BrokerRegistry;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.transport.MarshallingTransportFilter;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportFactory;
import org.apache.activemq.transport.TransportServer;
import org.apache.activemq.transport.vm.VMTransport;
import org.apache.activemq.transport.vm.VMTransportServer;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.util.IntrospectionSupport;
import org.apache.activemq.util.ServiceSupport;
import org.apache.activemq.util.URISupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VMTransportFactory
extends TransportFactory {
    public static final ConcurrentHashMap<String, BrokerService> BROKERS = new ConcurrentHashMap();
    public static final ConcurrentHashMap<String, TransportConnector> CONNECTORS = new ConcurrentHashMap();
    public static final ConcurrentHashMap<String, VMTransportServer> SERVERS = new ConcurrentHashMap();
    private static final Log LOG = LogFactory.getLog(VMTransportFactory.class);
    BrokerFactoryHandler brokerFactoryHandler;

    public Transport doConnect(URI location) throws Exception {
        return VMTransportServer.configure(this.doCompositeConnect(location));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transport doCompositeConnect(URI location) throws Exception {
        Map<String, String> options;
        String host;
        URI brokerURI;
        boolean create = true;
        int waitForStart = -1;
        URISupport.CompositeData data = URISupport.parseComposite(location);
        if (data.getComponents().length == 1 && "broker".equals(data.getComponents()[0].getScheme())) {
            brokerURI = data.getComponents()[0];
            URISupport.CompositeData brokerData = URISupport.parseComposite(brokerURI);
            host = brokerData.getParameters().get("brokerName");
            if (host == null) {
                host = "localhost";
            }
            if (brokerData.getPath() != null) {
                host = brokerData.getPath();
            }
            options = data.getParameters();
            location = new URI("vm://" + host);
        } else {
            try {
                String waitForStartString;
                host = location.getHost();
                options = URISupport.parseParamters(location);
                String config = options.remove("brokerConfig");
                if (config != null) {
                    brokerURI = new URI(config);
                } else {
                    Map<String, Object> brokerOptions = IntrospectionSupport.extractProperties(options, "broker.");
                    brokerURI = new URI("broker://()/" + host + "?" + URISupport.createQueryString(brokerOptions));
                }
                if ("false".equals(options.remove("create"))) {
                    create = false;
                }
                if ((waitForStartString = options.remove("waitForStart")) != null) {
                    waitForStart = Integer.parseInt(waitForStartString);
                }
            }
            catch (URISyntaxException e1) {
                throw IOExceptionSupport.create(e1);
            }
            location = new URI("vm://" + host);
        }
        if (host == null) {
            host = "localhost";
        }
        VMTransportServer server = SERVERS.get(host);
        if (!this.validateBroker(host) || server == null) {
            BrokerService broker = null;
            Object object = BrokerRegistry.getInstance().getRegistryMutext();
            synchronized (object) {
                broker = this.lookupBroker(BrokerRegistry.getInstance(), host, waitForStart);
                if (broker == null) {
                    if (!create) {
                        throw new IOException("Broker named '" + host + "' does not exist.");
                    }
                    try {
                        broker = this.brokerFactoryHandler != null ? this.brokerFactoryHandler.createBroker(brokerURI) : BrokerFactory.createBroker(brokerURI);
                        broker.start();
                    }
                    catch (URISyntaxException e) {
                        throw IOExceptionSupport.create(e);
                    }
                    BROKERS.put(host, broker);
                    BrokerRegistry.getInstance().getRegistryMutext().notifyAll();
                }
                if ((server = SERVERS.get(host)) == null) {
                    server = (VMTransportServer)this.bind(location, true);
                    TransportConnector connector = new TransportConnector(server);
                    connector.setBrokerService(broker);
                    connector.setUri(location);
                    connector.setTaskRunnerFactory(broker.getTaskRunnerFactory());
                    connector.start();
                    CONNECTORS.put(host, connector);
                }
            }
        }
        VMTransport vmtransport = server.connect();
        IntrospectionSupport.setProperties(vmtransport.peer, new HashMap<String, String>(options));
        IntrospectionSupport.setProperties(vmtransport, options);
        Transport transport = vmtransport;
        if (vmtransport.isMarshal()) {
            HashMap<String, String> optionsCopy = new HashMap<String, String>(options);
            transport = new MarshallingTransportFilter(transport, this.createWireFormat(options), this.createWireFormat(optionsCopy));
        }
        if (!options.isEmpty()) {
            throw new IllegalArgumentException("Invalid connect parameters: " + options);
        }
        return transport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BrokerService lookupBroker(BrokerRegistry registry, String brokerName, int waitForStart) {
        BrokerService broker = null;
        Object object = registry.getRegistryMutext();
        synchronized (object) {
            broker = registry.lookup(brokerName);
            if (broker == null && waitForStart > 0) {
                long expiry = System.currentTimeMillis() + (long)waitForStart;
                while (broker == null && expiry > System.currentTimeMillis()) {
                    long timeout = Math.max(0L, expiry - System.currentTimeMillis());
                    try {
                        LOG.debug("waiting for broker named: " + brokerName + " to start");
                        registry.getRegistryMutext().wait(timeout);
                    }
                    catch (InterruptedException ignored) {
                        // empty catch block
                    }
                    broker = registry.lookup(brokerName);
                }
            }
        }
        return broker;
    }

    public TransportServer doBind(URI location) throws IOException {
        return this.bind(location, false);
    }

    private TransportServer bind(URI location, boolean dispose) throws IOException {
        String host = location.getHost();
        LOG.debug("binding to broker: " + host);
        VMTransportServer server = new VMTransportServer(location, dispose);
        VMTransportServer currentBoundValue = SERVERS.get(host);
        if (currentBoundValue != null) {
            throw new IOException("VMTransportServer already bound at: " + location);
        }
        SERVERS.put(host, server);
        return server;
    }

    public static void stopped(VMTransportServer server) {
        String host = server.getBindURI().getHost();
        SERVERS.remove(host);
        TransportConnector connector = CONNECTORS.remove(host);
        if (connector != null) {
            LOG.debug("Shutting down VM connectors for broker: " + host);
            ServiceSupport.dispose(connector);
            BrokerService broker = BROKERS.remove(host);
            if (broker != null) {
                ServiceSupport.dispose(broker);
            }
        }
    }

    public static void stopped(String host) {
        SERVERS.remove(host);
        TransportConnector connector = CONNECTORS.remove(host);
        if (connector != null) {
            LOG.debug("Shutting down VM connectors for broker: " + host);
            ServiceSupport.dispose(connector);
            BrokerService broker = BROKERS.remove(host);
            if (broker != null) {
                ServiceSupport.dispose(broker);
            }
        }
    }

    public BrokerFactoryHandler getBrokerFactoryHandler() {
        return this.brokerFactoryHandler;
    }

    public void setBrokerFactoryHandler(BrokerFactoryHandler brokerFactoryHandler) {
        this.brokerFactoryHandler = brokerFactoryHandler;
    }

    private boolean validateBroker(String host) {
        boolean result = true;
        if (BROKERS.containsKey(host) || SERVERS.containsKey(host) || CONNECTORS.containsKey(host)) {
            TransportConnector connector = CONNECTORS.get(host);
            if (BrokerRegistry.getInstance().lookup(host) == null || connector != null && connector.getBroker().isStopped()) {
                result = false;
                BROKERS.remove(host);
                SERVERS.remove(host);
                if (connector != null) {
                    CONNECTORS.remove(host);
                    if (connector != null) {
                        ServiceSupport.dispose(connector);
                    }
                }
            }
        }
        return result;
    }
}

