/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.stomp;

import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import javax.net.SocketFactory;
import org.apache.activemq.command.Command;
import org.apache.activemq.transport.nio.NIOOutputStream;
import org.apache.activemq.transport.nio.SelectorManager;
import org.apache.activemq.transport.nio.SelectorSelection;
import org.apache.activemq.transport.tcp.TcpTransport;
import org.apache.activemq.util.ByteArrayOutputStream;
import org.apache.activemq.util.ByteSequence;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.util.ServiceStopper;
import org.apache.activemq.wireformat.WireFormat;

public class StompNIOTransport
extends TcpTransport {
    private SocketChannel channel;
    private SelectorSelection selection;
    private ByteBuffer inputBuffer;
    ByteArrayOutputStream currentCommand = new ByteArrayOutputStream();
    int previousByte = -1;

    public StompNIOTransport(WireFormat wireFormat, SocketFactory socketFactory, URI remoteLocation, URI localLocation) throws UnknownHostException, IOException {
        super(wireFormat, socketFactory, remoteLocation, localLocation);
    }

    public StompNIOTransport(WireFormat wireFormat, Socket socket) throws IOException {
        super(wireFormat, socket);
    }

    protected void initializeStreams() throws IOException {
        this.channel = this.socket.getChannel();
        this.channel.configureBlocking(false);
        this.selection = SelectorManager.getInstance().register(this.channel, new SelectorManager.Listener(){

            public void onSelect(SelectorSelection selection) {
                StompNIOTransport.this.serviceRead();
            }

            public void onError(SelectorSelection selection, Throwable error) {
                if (error instanceof IOException) {
                    StompNIOTransport.this.onException((IOException)error);
                } else {
                    StompNIOTransport.this.onException(IOExceptionSupport.create(error));
                }
            }
        });
        this.inputBuffer = ByteBuffer.allocate(8192);
        this.dataOut = new DataOutputStream(new NIOOutputStream(this.channel, 8192));
    }

    private void serviceRead() {
        try {
            while (true) {
                int readSize;
                if ((readSize = this.channel.read(this.inputBuffer)) == -1) {
                    this.onException(new EOFException());
                    this.selection.close();
                } else if (readSize != 0) {
                    this.inputBuffer.flip();
                    ByteArrayInputStream input = new ByteArrayInputStream(this.inputBuffer.array());
                    int i = 0;
                    while (i++ < readSize) {
                        int b = input.read();
                        if (this.previousByte == 0 && b == 0) continue;
                        this.currentCommand.write(b);
                        if (b == 0) {
                            Object command = this.wireFormat.unmarshal(new ByteSequence(this.currentCommand.toByteArray()));
                            this.doConsume((Command)command);
                            this.currentCommand.reset();
                        }
                        this.previousByte = b;
                    }
                    this.inputBuffer.clear();
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            this.onException(e);
        }
        catch (Throwable e) {
            this.onException(IOExceptionSupport.create(e));
        }
    }

    protected void doStart() throws Exception {
        this.connect();
        this.selection.setInterestOps(1);
        this.selection.enable();
    }

    protected void doStop(ServiceStopper stopper) throws Exception {
        try {
            this.selection.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.doStop(stopper);
    }
}

