/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.xbean;

import java.io.IOException;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.usage.SystemUsage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleException;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.osgi.context.support.OsgiBundleXmlApplicationContext;

public class XBeanBrokerService
extends BrokerService
implements ApplicationContextAware {
    private static final transient Log LOG = LogFactory.getLog(XBeanBrokerService.class);
    private boolean start = true;
    private ApplicationContext applicationContext = null;
    private boolean destroyApplicationContextOnShutdown = false;
    private boolean destroyApplicationContextOnStop = false;
    Runnable stopContextRunnable = new Runnable(){

        public void run() {
            if (XBeanBrokerService.this.applicationContext instanceof ConfigurableApplicationContext) {
                ((ConfigurableApplicationContext)XBeanBrokerService.this.applicationContext).close();
            }
            if (XBeanBrokerService.this.applicationContext instanceof OsgiBundleXmlApplicationContext) {
                try {
                    ((OsgiBundleXmlApplicationContext)XBeanBrokerService.this.applicationContext).getBundle().stop();
                }
                catch (BundleException e) {
                    LOG.info("Error stopping OSGi bundle " + (Object)((Object)e), e);
                }
            }
        }
    };

    @PostConstruct
    public void afterPropertiesSet() throws Exception {
        this.ensureSystemUsageHasStore();
        if (this.start) {
            this.start();
        }
        if (this.destroyApplicationContextOnShutdown) {
            this.addShutdownHook(this.stopContextRunnable);
        }
    }

    private void ensureSystemUsageHasStore() throws IOException {
        SystemUsage usage = this.getSystemUsage();
        if (usage.getStoreUsage().getStore() == null) {
            usage.getStoreUsage().setStore(this.getPersistenceAdapter());
        }
        if (usage.getTempUsage().getStore() == null) {
            usage.getTempUsage().setStore(this.getTempDataStore());
        }
    }

    @PreDestroy
    public void destroy() throws Exception {
        this.stop();
    }

    public void stop() throws Exception {
        if (this.destroyApplicationContextOnStop) {
            this.stopContextRunnable.run();
        }
        super.stop();
    }

    public void setStart(boolean start) {
        this.start = start;
    }

    public void setDestroyApplicationContextOnShutdown(boolean destroy) {
        this.destroyApplicationContextOnShutdown = destroy;
    }

    public void setDestroyApplicationContextOnStop(boolean destroy) {
        this.destroyApplicationContextOnStop = destroy;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }
}

