/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadb.plist;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.activemq.store.kahadb.plist.EntryLocation;
import org.apache.activemq.store.kahadb.plist.PListEntry;
import org.apache.activemq.store.kahadb.plist.PListStore;
import org.apache.kahadb.journal.Location;
import org.apache.kahadb.page.Page;
import org.apache.kahadb.page.Transaction;
import org.apache.kahadb.util.ByteSequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PList {
    final PListStore store;
    private String name;
    private long rootId = -1L;
    private long lastId = -1L;
    private final AtomicBoolean loaded = new AtomicBoolean();
    private int size = 0;
    Object indexLock;

    PList(PListStore store) {
        this.store = store;
        this.indexLock = store.getIndexLock();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public synchronized int size() {
        return this.size;
    }

    public synchronized boolean isEmpty() {
        return this.size == 0;
    }

    public long getRootId() {
        return this.rootId;
    }

    public void setRootId(long rootId) {
        this.rootId = rootId;
    }

    public long getLastId() {
        return this.lastId;
    }

    public void setLastId(long lastId) {
        this.lastId = lastId;
    }

    public boolean isLoaded() {
        return this.loaded.get();
    }

    void read(DataInput in) throws IOException {
        this.rootId = in.readLong();
        this.name = in.readUTF();
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(this.rootId);
        out.writeUTF(this.name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void destroy() throws IOException {
        Object object = this.indexLock;
        synchronized (object) {
            this.store.getPageFile().tx().execute(new Transaction.Closure<IOException>(){

                @Override
                public void execute(Transaction tx) throws IOException {
                    PList.this.destroy(tx);
                }
            });
        }
    }

    void destroy(Transaction tx) throws IOException {
        EntryLocation entry = this.getFirst(tx);
        while (entry != null) {
            EntryLocation toRemove = entry.copy();
            entry = this.getNext(tx, entry.getNext());
            this.doRemove(tx, toRemove);
        }
    }

    synchronized void load(Transaction tx) throws IOException {
        if (this.loaded.compareAndSet(false, true)) {
            Page<EntryLocation> p = tx.load(this.rootId, null);
            if (p.getType() == 0) {
                EntryLocation root = this.createEntry(p, "root", -1L, -1L);
                this.storeEntry(tx, root);
                this.lastId = root.getPage().getPageId();
            } else {
                long nextId = this.rootId;
                while (nextId != -1L) {
                    EntryLocation next = this.getNext(tx, nextId);
                    if (next == null) continue;
                    this.lastId = next.getPage().getPageId();
                    nextId = next.getNext();
                    ++this.size;
                }
            }
        }
    }

    public synchronized void unload() {
        if (this.loaded.compareAndSet(true, false)) {
            this.rootId = -1L;
            this.lastId = -1L;
            this.size = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addLast(final String id, final ByteSequence bs) throws IOException {
        final Location location = this.store.write(bs, false);
        Object object = this.indexLock;
        synchronized (object) {
            this.store.getPageFile().tx().execute(new Transaction.Closure<IOException>(){

                @Override
                public void execute(Transaction tx) throws IOException {
                    PList.this.addLast(tx, id, bs, location);
                }
            });
        }
    }

    private void addLast(Transaction tx, String id, ByteSequence bs, Location location) throws IOException {
        EntryLocation entry = this.createEntry(tx, id, this.lastId, -1L);
        entry.setLocation(location);
        this.storeEntry(tx, entry);
        this.store.incrementJournalCount(tx, location);
        EntryLocation last = this.loadEntry(tx, this.lastId);
        last.setNext(entry.getPage().getPageId());
        this.storeEntry(tx, last);
        this.lastId = entry.getPage().getPageId();
        ++this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addFirst(final String id, final ByteSequence bs) throws IOException {
        final Location location = this.store.write(bs, false);
        Object object = this.indexLock;
        synchronized (object) {
            this.store.getPageFile().tx().execute(new Transaction.Closure<IOException>(){

                @Override
                public void execute(Transaction tx) throws IOException {
                    PList.this.addFirst(tx, id, bs, location);
                }
            });
        }
    }

    private void addFirst(Transaction tx, String id, ByteSequence bs, Location location) throws IOException {
        EntryLocation entry = this.createEntry(tx, id, -1L, -1L);
        entry.setLocation(location);
        EntryLocation oldFirst = this.getFirst(tx);
        if (oldFirst != null) {
            oldFirst.setPrev(entry.getPage().getPageId());
            this.storeEntry(tx, oldFirst);
            entry.setNext(oldFirst.getPage().getPageId());
        }
        EntryLocation root = this.getRoot(tx);
        root.setNext(entry.getPage().getPageId());
        this.storeEntry(tx, root);
        this.storeEntry(tx, entry);
        this.store.incrementJournalCount(tx, location);
        ++this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean remove(final String id) throws IOException {
        final AtomicBoolean result = new AtomicBoolean();
        Object object = this.indexLock;
        synchronized (object) {
            this.store.getPageFile().tx().execute(new Transaction.Closure<IOException>(){

                @Override
                public void execute(Transaction tx) throws IOException {
                    result.set(PList.this.remove(tx, id));
                }
            });
        }
        return result.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean remove(final int position) throws IOException {
        final AtomicBoolean result = new AtomicBoolean();
        Object object = this.indexLock;
        synchronized (object) {
            this.store.getPageFile().tx().execute(new Transaction.Closure<IOException>(){

                @Override
                public void execute(Transaction tx) throws IOException {
                    result.set(PList.this.remove(tx, position));
                }
            });
        }
        return result.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean remove(final PListEntry entry) throws IOException {
        final AtomicBoolean result = new AtomicBoolean();
        Object object = this.indexLock;
        synchronized (object) {
            this.store.getPageFile().tx().execute(new Transaction.Closure<IOException>(){

                @Override
                public void execute(Transaction tx) throws IOException {
                    result.set(PList.this.doRemove(tx, entry.getEntry()));
                }
            });
        }
        return result.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized PListEntry get(final int position) throws IOException {
        PListEntry result = null;
        final AtomicReference ref = new AtomicReference();
        Object object = this.indexLock;
        synchronized (object) {
            this.store.getPageFile().tx().execute(new Transaction.Closure<IOException>(){

                @Override
                public void execute(Transaction tx) throws IOException {
                    ref.set(PList.this.get(tx, position));
                }
            });
        }
        if (ref.get() != null) {
            ByteSequence bs = this.store.getPayload(((EntryLocation)ref.get()).getLocation());
            result = new PListEntry((EntryLocation)ref.get(), bs);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized PListEntry getFirst() throws IOException {
        PListEntry result = null;
        final AtomicReference ref = new AtomicReference();
        Object object = this.indexLock;
        synchronized (object) {
            this.store.getPageFile().tx().execute(new Transaction.Closure<IOException>(){

                @Override
                public void execute(Transaction tx) throws IOException {
                    ref.set(PList.this.getFirst(tx));
                }
            });
            if (ref.get() != null) {
                ByteSequence bs = this.store.getPayload(((EntryLocation)ref.get()).getLocation());
                result = new PListEntry((EntryLocation)ref.get(), bs);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized PListEntry getLast() throws IOException {
        PListEntry result = null;
        final AtomicReference ref = new AtomicReference();
        Object object = this.indexLock;
        synchronized (object) {
            this.store.getPageFile().tx().execute(new Transaction.Closure<IOException>(){

                @Override
                public void execute(Transaction tx) throws IOException {
                    ref.set(PList.this.getLast(tx));
                }
            });
            if (ref.get() != null) {
                ByteSequence bs = this.store.getPayload(((EntryLocation)ref.get()).getLocation());
                result = new PListEntry((EntryLocation)ref.get(), bs);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized PListEntry getNext(PListEntry entry) throws IOException {
        long nextId;
        PListEntry result = null;
        long l = nextId = entry != null ? entry.getEntry().getNext() : this.rootId;
        if (nextId != -1L) {
            final AtomicReference ref = new AtomicReference();
            Object object = this.indexLock;
            synchronized (object) {
                this.store.getPageFile().tx().execute(new Transaction.Closure<IOException>(){

                    @Override
                    public void execute(Transaction tx) throws IOException {
                        ref.set(PList.this.getNext(tx, nextId));
                    }
                });
                if (ref.get() != null) {
                    ByteSequence bs = this.store.getPayload(((EntryLocation)ref.get()).getLocation());
                    result = new PListEntry((EntryLocation)ref.get(), bs);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized PListEntry refresh(final PListEntry entry) throws IOException {
        PListEntry result = null;
        final AtomicReference ref = new AtomicReference();
        Object object = this.indexLock;
        synchronized (object) {
            this.store.getPageFile().tx().execute(new Transaction.Closure<IOException>(){

                @Override
                public void execute(Transaction tx) throws IOException {
                    ref.set(PList.this.loadEntry(tx, entry.getEntry().getPage().getPageId()));
                }
            });
            if (ref.get() != null) {
                result = new PListEntry((EntryLocation)ref.get(), entry.getByteSequence());
            }
        }
        return result;
    }

    boolean remove(Transaction tx, String id) throws IOException {
        EntryLocation entry;
        boolean result = false;
        long nextId = this.rootId;
        while (nextId != -1L && (entry = this.getNext(tx, nextId)) != null) {
            if (entry.getId().equals(id)) {
                result = this.doRemove(tx, entry);
                break;
            }
            nextId = entry.getNext();
        }
        return result;
    }

    boolean remove(Transaction tx, int position) throws IOException {
        EntryLocation entry;
        boolean result = false;
        long nextId = this.rootId;
        int count = 0;
        while (nextId != -1L && (entry = this.getNext(tx, nextId)) != null) {
            if (count == position) {
                result = this.doRemove(tx, entry);
                break;
            }
            nextId = entry.getNext();
            ++count;
        }
        return result;
    }

    EntryLocation get(Transaction tx, int position) throws IOException {
        EntryLocation entry;
        EntryLocation result = null;
        long nextId = this.rootId;
        int count = -1;
        while (nextId != -1L && (entry = this.getNext(tx, nextId)) != null) {
            if (count == position) {
                result = entry;
                break;
            }
            nextId = entry.getNext();
            ++count;
        }
        return result;
    }

    EntryLocation getFirst(Transaction tx) throws IOException {
        long offset = this.getRoot(tx).getNext();
        if (offset != -1L) {
            return this.loadEntry(tx, offset);
        }
        return null;
    }

    EntryLocation getLast(Transaction tx) throws IOException {
        if (this.lastId != -1L) {
            return this.loadEntry(tx, this.lastId);
        }
        return null;
    }

    private boolean doRemove(Transaction tx, EntryLocation entry) throws IOException {
        boolean result = false;
        if (entry != null) {
            long nextId;
            EntryLocation prev = this.getPrevious(tx, entry.getPrev());
            EntryLocation next = this.getNext(tx, entry.getNext());
            long prevId = prev != null ? prev.getPage().getPageId() : this.rootId;
            long l = nextId = next != null ? next.getPage().getPageId() : -1L;
            if (next != null) {
                next.setPrev(prevId);
                this.storeEntry(tx, next);
            } else {
                this.lastId = prevId;
            }
            if (prev != null) {
                prev.setNext(nextId);
                this.storeEntry(tx, prev);
            }
            this.store.decrementJournalCount(tx, entry.getLocation());
            entry.reset();
            this.storeEntry(tx, entry);
            tx.free(entry.getPage().getPageId());
            result = true;
            --this.size;
        }
        return result;
    }

    private EntryLocation createEntry(Transaction tx, String id, long previous, long next) throws IOException {
        Page<EntryLocation> p = tx.allocate();
        EntryLocation result = new EntryLocation();
        result.setPage(p);
        p.set(result);
        result.setId(id);
        result.setPrev(previous);
        result.setNext(next);
        return result;
    }

    private EntryLocation createEntry(Page<EntryLocation> p, String id, long previous, long next) throws IOException {
        EntryLocation result = new EntryLocation();
        result.setPage(p);
        p.set(result);
        result.setId(id);
        result.setPrev(previous);
        result.setNext(next);
        return result;
    }

    EntryLocation loadEntry(Transaction tx, long pageId) throws IOException {
        Page<EntryLocation> page = tx.load(pageId, EntryLocation.EntryLocationMarshaller.INSTANCE);
        EntryLocation entry = page.get();
        if (entry != null) {
            entry.setPage(page);
        }
        return entry;
    }

    private void storeEntry(Transaction tx, EntryLocation entry) throws IOException {
        tx.store(entry.getPage(), EntryLocation.EntryLocationMarshaller.INSTANCE, true);
    }

    EntryLocation getNext(Transaction tx, long next) throws IOException {
        EntryLocation result = null;
        if (next != -1L) {
            result = this.loadEntry(tx, next);
        }
        return result;
    }

    private EntryLocation getPrevious(Transaction tx, long previous) throws IOException {
        EntryLocation result = null;
        if (previous != -1L) {
            result = this.loadEntry(tx, previous);
        }
        return result;
    }

    private EntryLocation getRoot(Transaction tx) throws IOException {
        EntryLocation result = this.loadEntry(tx, this.rootId);
        return result;
    }

    ByteSequence getPayload(EntryLocation entry) throws IOException {
        return this.store.getPayload(entry.getLocation());
    }
}

