/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.util;

import java.util.List;
import org.apache.activemq.Service;
import org.apache.activemq.util.Callback;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServiceStopper {
    private Throwable firstException;

    public void stop(Service service) {
        try {
            if (service != null) {
                service.stop();
            }
        }
        catch (Exception e) {
            this.onException(service, e);
        }
    }

    public void run(Callback stopClosure) {
        try {
            stopClosure.execute();
        }
        catch (Throwable e) {
            this.onException(stopClosure, e);
        }
    }

    public void stopServices(List services) {
        for (Service service : services) {
            this.stop(service);
        }
    }

    public void onException(Object owner, Throwable e) {
        this.logError(owner, e);
        if (this.firstException == null) {
            this.firstException = e;
        }
    }

    public void throwFirstException() throws Exception {
        if (this.firstException != null) {
            if (this.firstException instanceof Exception) {
                Exception e = (Exception)this.firstException;
                throw e;
            }
            if (this.firstException instanceof RuntimeException) {
                RuntimeException e = (RuntimeException)this.firstException;
                throw e;
            }
            throw new RuntimeException("Unknown type of exception: " + this.firstException, this.firstException);
        }
    }

    protected void logError(Object service, Throwable e) {
        Log log = LogFactory.getLog(service.getClass());
        log.error("Could not stop service: " + service + ". Reason: " + e, e);
    }
}

