/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadb.plist;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.kahadb.journal.Location;
import org.apache.kahadb.page.Page;
import org.apache.kahadb.util.VariableMarshaller;

class EntryLocation {
    static final long NOT_SET = -1L;
    private String id;
    private Page<EntryLocation> page;
    private long next;
    private long prev;
    private Location location;

    EntryLocation(Location location) {
        this.location = location;
    }

    EntryLocation() {
    }

    EntryLocation copy() {
        EntryLocation result = new EntryLocation();
        result.id = this.id;
        result.location = this.location;
        result.next = this.next;
        result.prev = this.prev;
        result.page = this.page;
        return result;
    }

    void reset() {
        this.id = "";
        this.next = -1L;
        this.prev = -1L;
    }

    public void readExternal(DataInput in) throws IOException {
        this.id = in.readUTF();
        this.prev = in.readLong();
        this.next = in.readLong();
        if (this.location == null) {
            this.location = new Location();
        }
        this.location.readExternal(in);
    }

    public void writeExternal(DataOutput out) throws IOException {
        out.writeUTF(this.id);
        out.writeLong(this.prev);
        out.writeLong(this.next);
        if (this.location == null) {
            this.location = new Location();
        }
        this.location.writeExternal(out);
    }

    String getId() {
        return this.id;
    }

    void setId(String id) {
        this.id = id;
    }

    Location getLocation() {
        return this.location;
    }

    void setLocation(Location location) {
        this.location = location;
    }

    long getNext() {
        return this.next;
    }

    void setNext(long next) {
        this.next = next;
    }

    long getPrev() {
        return this.prev;
    }

    void setPrev(long prev) {
        this.prev = prev;
    }

    Page<EntryLocation> getPage() {
        return this.page;
    }

    void setPage(Page<EntryLocation> page) {
        this.page = page;
    }

    static class EntryLocationMarshaller
    extends VariableMarshaller<EntryLocation> {
        static final EntryLocationMarshaller INSTANCE = new EntryLocationMarshaller();

        EntryLocationMarshaller() {
        }

        @Override
        public EntryLocation readPayload(DataInput dataIn) throws IOException {
            EntryLocation result = new EntryLocation();
            result.readExternal(dataIn);
            return result;
        }

        @Override
        public void writePayload(EntryLocation value, DataOutput dataOut) throws IOException {
            value.writeExternal(dataOut);
        }
    }
}

