/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha.impl.index.tree;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.activemq.kaha.Marshaller;
import org.apache.activemq.kaha.impl.index.tree.TreeEntry;
import org.apache.activemq.kaha.impl.index.tree.TreeIndex;
import org.apache.activemq.kaha.impl.index.tree.TreePageEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TreePage {
    static final int PAGE_HEADER_SIZE = 18;
    private static final transient Logger LOG = LoggerFactory.getLogger(TreePage.class);
    private TreeIndex tree;
    private int maximumEntries;
    private long id;
    private long parentId = -1L;
    private boolean leaf = true;
    private List<TreeEntry> treeEntries;
    private long nextFreePageId = -1L;
    private boolean active = true;

    TreePage(TreeIndex tree, long id, long parentId, int maximumEntries) {
        this(maximumEntries);
        this.tree = tree;
        this.id = id;
        this.parentId = parentId;
    }

    public TreePage(int maximumEntries) {
        this.maximumEntries = maximumEntries;
        this.treeEntries = new ArrayList<TreeEntry>(maximumEntries);
    }

    public String toString() {
        return "TreePage[" + this.getId() + "]parent=" + this.getParentId();
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (o instanceof TreePage) {
            TreePage other = (TreePage)o;
            result = other.id == this.id;
        }
        return result;
    }

    public int hashCode() {
        return (int)this.id;
    }

    boolean isActive() {
        return this.active;
    }

    void setActive(boolean active) {
        this.active = active;
    }

    long getNextFreePageId() {
        return this.nextFreePageId;
    }

    void setNextFreePageId(long nextPageId) {
        this.nextFreePageId = nextPageId;
    }

    long getId() {
        return this.id;
    }

    void setId(long id) {
        this.id = id;
    }

    void write(Marshaller keyMarshaller, DataOutput dataOut) throws IOException {
        this.writeHeader(dataOut);
        dataOut.writeInt(this.treeEntries.size());
        for (TreeEntry entry : this.treeEntries) {
            entry.write(keyMarshaller, dataOut);
        }
    }

    void read(Marshaller keyMarshaller, DataInput dataIn) throws IOException {
        this.readHeader(dataIn);
        int size2 = dataIn.readInt();
        this.treeEntries.clear();
        for (int i = 0; i < size2; ++i) {
            TreeEntry entry = new TreeEntry();
            entry.read(keyMarshaller, dataIn);
            this.treeEntries.add(entry);
        }
    }

    void readHeader(DataInput dataIn) throws IOException {
        this.active = dataIn.readBoolean();
        this.leaf = dataIn.readBoolean();
        this.setParentId(dataIn.readLong());
        this.nextFreePageId = dataIn.readLong();
    }

    void writeHeader(DataOutput dataOut) throws IOException {
        dataOut.writeBoolean(this.isActive());
        dataOut.writeBoolean(this.isLeaf());
        dataOut.writeLong(this.getParentId());
        dataOut.writeLong(this.nextFreePageId);
    }

    boolean isEmpty() {
        return this.treeEntries.isEmpty();
    }

    boolean isFull() {
        return this.treeEntries.size() >= this.maximumEntries;
    }

    boolean isRoot() {
        return this.getParentId() < 0L;
    }

    boolean isLeaf() {
        if (this.treeEntries.isEmpty()) {
            this.leaf = true;
        }
        return this.leaf;
    }

    boolean isUnderflowed() {
        return this.treeEntries.size() < this.maximumEntries / 2;
    }

    boolean isOverflowed() {
        return this.treeEntries.size() > this.maximumEntries;
    }

    void setLeaf(boolean newValue) {
        this.leaf = newValue;
    }

    TreePage getParent() throws IOException {
        return this.tree.lookupPage(this.parentId);
    }

    long getParentId() {
        return this.parentId;
    }

    void setParentId(long newId) throws IOException {
        if (newId == this.id) {
            throw new IllegalStateException("Cannot set page as a child of itself " + this + " trying to set parentId = " + newId);
        }
        this.parentId = newId;
        this.tree.writePage(this);
    }

    List<TreeEntry> getEntries() {
        return this.treeEntries;
    }

    void setEntries(List<TreeEntry> newEntries) {
        this.treeEntries = newEntries;
    }

    int getMaximumEntries() {
        return this.maximumEntries;
    }

    void setMaximumEntries(int maximumEntries) {
        this.maximumEntries = maximumEntries;
    }

    int size() {
        return this.treeEntries.size();
    }

    TreeIndex getTree() {
        return this.tree;
    }

    void setTree(TreeIndex tree) {
        this.tree = tree;
    }

    void reset() throws IOException {
        this.treeEntries.clear();
        this.setParentId(-1L);
        this.setNextFreePageId(-1L);
        this.setLeaf(true);
    }

    public TreeEntry find(TreeEntry key) throws IOException {
        int low = 0;
        int high = this.size() - 1;
        long pageId = -1L;
        while (low <= high) {
            int mid = low + high >> 1;
            TreeEntry te = this.getTreeEntry(mid);
            int cmp = te.compareTo(key);
            if (cmp == 0) {
                return te;
            }
            if (cmp < 0) {
                low = mid + 1;
                pageId = te.getNextPageId();
                continue;
            }
            high = mid - 1;
            pageId = te.getPrevPageId();
        }
        TreePage page = this.tree.lookupPage(pageId);
        if (page != null) {
            return page.find(key);
        }
        return null;
    }

    TreeEntry put(TreeEntry newEntry) throws IOException {
        TreeEntry result = null;
        if (this.isRoot()) {
            if (this.isEmpty()) {
                this.insertTreeEntry(0, newEntry);
            } else {
                result = this.doInsert(null, newEntry);
            }
        } else {
            throw new IllegalStateException("insert() should not be called on non root page - " + this);
        }
        return result;
    }

    TreeEntry remove(TreeEntry entry) throws IOException {
        TreeEntry result = null;
        if (this.isRoot()) {
            if (!this.isEmpty()) {
                result = this.doRemove(entry);
            }
        } else {
            throw new IllegalStateException("remove() should not be called on non root page");
        }
        return result;
    }

    private TreeEntry doInsert(Flavour flavour, TreeEntry newEntry) throws IOException {
        TreeEntry result = null;
        TreePageEntry closest = this.findClosestEntry(newEntry);
        if (closest != null) {
            TreeEntry closestEntry = closest.getTreeEntry();
            TreePage closestPage = closest.getTreePage();
            int cmp = closestEntry.compareTo(newEntry);
            if (cmp == 0) {
                long oldValue = closestEntry.getIndexOffset();
                closestEntry.setIndexOffset(newEntry.getIndexOffset());
                newEntry.setIndexOffset(oldValue);
                result = newEntry;
                this.save();
            } else if (closestPage != null) {
                result = closestPage.doInsert(closest.getFlavour(), newEntry);
            } else if (!this.isFull()) {
                this.insertTreeEntry(closest.getIndex(), newEntry);
                this.save();
            } else {
                this.doOverflow(flavour, newEntry);
            }
        } else if (!this.isFull()) {
            this.doInsertEntry(newEntry);
            this.save();
        } else {
            this.doOverflow(flavour, newEntry);
        }
        return result;
    }

    private TreePage doOverflow(Flavour flavour, TreeEntry newEntry) throws IOException {
        TreePage result = this;
        TreeEntry theEntry = newEntry;
        if (!this.isFull()) {
            this.doInsertEntry(newEntry);
            this.save();
        } else if (!this.isRoot() && flavour != null) {
            this.doInsertEntry(newEntry);
            if (flavour == Flavour.LESS) {
                theEntry = this.removeTreeEntry(0);
                theEntry.reset();
                theEntry.setNextPageId(this.getId());
            } else {
                theEntry = this.removeTreeEntry(this.size() - 1);
                theEntry.reset();
                theEntry.setPrevPageId(this.getId());
            }
            this.save();
            result = this.getParent().doOverflow(flavour, theEntry);
            if (!theEntry.equals(newEntry)) {
                result = this;
            }
        } else {
            this.doInsertEntry(newEntry);
            int midIndex = this.size() / 2;
            TreeEntry midEntry = this.removeTreeEntry(midIndex);
            List<TreeEntry> subList = this.getSubList(midIndex, this.size());
            this.removeAllTreeEntries(subList);
            TreePage newRoot = this.tree.createRoot();
            newRoot.setLeaf(false);
            this.setParentId(newRoot.getId());
            this.save();
            TreePage rightPage = this.tree.createPage(newRoot.getId());
            rightPage.setEntries(subList);
            rightPage.checkLeaf();
            this.resetParentId(rightPage.getId(), rightPage.getEntries());
            midEntry.setNextPageId(rightPage.getId());
            midEntry.setPrevPageId(this.getId());
            newRoot.insertTreeEntry(0, midEntry);
            this.resetParentId(newRoot.getId(), newRoot.getEntries());
            this.save();
            rightPage.save();
            newRoot.save();
        }
        return result;
    }

    private TreeEntry doRemove(TreeEntry entry) throws IOException {
        TreeEntry closestEntry;
        TreeEntry result = null;
        TreePageEntry closest = this.findClosestEntry(entry);
        if (closest != null && (closestEntry = closest.getTreeEntry()) != null) {
            TreePage closestPage = closest.getTreePage();
            int cmp = closestEntry.compareTo(entry);
            if (cmp == 0) {
                result = closest.getTreeEntry();
                int index = closest.getIndex();
                this.removeTreeEntry(index);
                this.save();
                this.doUnderflow(result, index);
            } else if (closestPage != null) {
                closestPage.doRemove(entry);
            }
        }
        return result;
    }

    private boolean doUnderflow() throws IOException {
        boolean result = false;
        boolean working = true;
        while (working && this.isUnderflowed() && !this.isEmpty() && !this.isLeaf()) {
            int lastIndex = this.size() - 1;
            TreeEntry entry = this.getTreeEntry(lastIndex);
            working = this.doUnderflow(entry, lastIndex);
        }
        if (this.isUnderflowed() && this.isLeaf()) {
            result = this.doUnderflowLeaf();
        }
        return result;
    }

    private boolean doUnderflow(TreeEntry entry, int index) throws IOException {
        TreePage page;
        boolean result = false;
        if (entry.getNextPageId() != -1L && (page = this.tree.lookupPage(entry.getNextPageId())) != null && !page.isEmpty()) {
            TreeEntry replacement = page.removeTreeEntry(0);
            TreeEntry copy = replacement.copy();
            this.checkParentIdForRemovedPageEntry(copy, page.getId(), this.getId());
            if (!page.isEmpty()) {
                copy.setNextPageId(page.getId());
                page.setParentId(this.id);
            } else {
                page.setLeaf(true);
            }
            int replacementIndex = this.doInsertEntry(copy);
            if (page.doUnderflow()) {
                this.resetPageReference(replacementIndex, copy.getNextPageId());
                copy.setNextPageId(-1L);
            } else {
                page.save();
            }
            this.save();
            result = true;
        }
        if (entry.getPrevPageId() != -1L) {
            TreePage page2;
            TreeEntry prevEntry;
            TreeEntry treeEntry = prevEntry = index > 0 ? this.getTreeEntry(index - 1) : null;
            if (!(prevEntry != null && prevEntry.getNextPageId() == entry.getPrevPageId() || (page2 = this.tree.lookupPage(entry.getPrevPageId())) == null || page2.isEmpty())) {
                TreePage parent;
                TreeEntry replacement = page2.removeTreeEntry(page2.getEntries().size() - 1);
                TreeEntry copy = replacement.copy();
                this.checkParentIdForRemovedPageEntry(copy, page2.getId(), this.getId());
                if (!page2.isEmpty()) {
                    copy.setPrevPageId(page2.getId());
                } else {
                    page2.setLeaf(true);
                }
                this.insertTreeEntry(index, copy);
                TreePage landed = null;
                TreeEntry removed = null;
                if (this.isOverflowed() && (parent = this.getParent()) != null) {
                    removed = this.getTreeEntry(0);
                    Flavour flavour = this.getFlavour(parent, removed);
                    if (flavour == Flavour.LESS) {
                        removed = this.removeTreeEntry(0);
                        landed = parent.doOverflow(flavour, removed);
                    } else {
                        removed = this.removeTreeEntry(this.size() - 1);
                        landed = parent.doOverflow(Flavour.MORE, removed);
                    }
                }
                if (page2.doUnderflow()) {
                    if (landed == null || landed.equals(this)) {
                        landed = this;
                    }
                    this.resetPageReference(copy.getNextPageId());
                    landed.resetPageReference(copy.getNextPageId());
                    copy.setPrevPageId(-1L);
                    landed.save();
                } else {
                    page2.save();
                }
                this.save();
                result = true;
            }
        }
        if (!result) {
            this.save();
        }
        this.save();
        return result |= this.doUnderflowLeaf();
    }

    private boolean doUnderflowLeaf() throws IOException {
        boolean result = false;
        if (this.isUnderflowed() && this.isLeaf()) {
            ArrayList<TreeEntry> list = new ArrayList<TreeEntry>(this.treeEntries);
            this.treeEntries.clear();
            for (TreeEntry entry : list) {
                TreePage parent = this.getParent();
                if (parent == null) continue;
                Flavour flavour = this.getFlavour(parent, entry);
                TreePage landedOn = parent.doOverflow(flavour, entry);
                this.checkParentIdForRemovedPageEntry(entry, this.getId(), landedOn.getId());
            }
            TreePage parent = this.getParent();
            if (parent != null) {
                parent.checkLeaf();
                parent.removePageId(this.getId());
                parent.doUnderflow();
                parent.save();
                this.tree.releasePage(this);
                result = true;
            }
        }
        return result;
    }

    private Flavour getFlavour(TreePage page, TreeEntry entry) {
        Flavour result = null;
        if (page != null && !page.getEntries().isEmpty()) {
            TreeEntry last = page.getEntries().get(page.getEntries().size() - 1);
            result = last.compareTo(entry) > 0 ? Flavour.MORE : Flavour.LESS;
        }
        return result;
    }

    private void checkLeaf() {
        boolean result = false;
        for (TreeEntry entry : this.treeEntries) {
            if (!entry.hasChildPagesReferences()) continue;
            result = true;
            break;
        }
        this.setLeaf(!result);
    }

    private void checkParentIdForRemovedPageEntry(TreeEntry entry, long oldPageId, long newPageId) throws IOException {
        TreePage page = this.tree.lookupPage(entry.getPrevPageId());
        if (page != null && page.getParentId() == oldPageId) {
            page.setParentId(newPageId);
            page.save();
        }
        if ((page = this.tree.lookupPage(entry.getNextPageId())) != null && page.getParentId() == oldPageId) {
            page.setParentId(newPageId);
            page.save();
        }
    }

    private void removePageId(long pageId) {
        for (TreeEntry entry : this.treeEntries) {
            if (entry.getNextPageId() == pageId) {
                entry.setNextPageId(-1L);
            }
            if (entry.getPrevPageId() != pageId) continue;
            entry.setPrevPageId(-1L);
        }
    }

    private TreePageEntry findClosestEntry(TreeEntry key) throws IOException {
        TreePageEntry result = null;
        TreeEntry treeEntry = null;
        Flavour flavour = null;
        long pageId = -1L;
        int low = 0;
        int high = this.size() - 1;
        int mid = low;
        while (low <= high) {
            mid = low + high >> 1;
            treeEntry = this.getTreeEntry(mid);
            int cmp = treeEntry.compareTo(key);
            if (cmp < 0) {
                low = mid + 1;
                pageId = treeEntry.getNextPageId();
                flavour = Flavour.LESS;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                pageId = treeEntry.getPrevPageId();
                flavour = Flavour.MORE;
                continue;
            }
            low = mid;
            break;
        }
        if (treeEntry != null) {
            TreePage treePage = this.tree.lookupPage(pageId);
            result = new TreePageEntry(treeEntry, treePage, flavour, low);
        }
        return result;
    }

    private int doInsertEntry(TreeEntry newEntry) throws IOException {
        int low = 0;
        int high = this.size() - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            TreeEntry midVal = this.getTreeEntry(mid);
            int cmp = midVal.compareTo(newEntry);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp <= 0) continue;
            high = mid - 1;
        }
        this.insertTreeEntry(low, newEntry);
        return low;
    }

    private void insertTreeEntry(int index, TreeEntry entry) throws IOException {
        TreeEntry nextEntry;
        int p = index - 1;
        int n = index;
        TreeEntry prevEntry = p >= 0 && p < this.treeEntries.size() ? this.treeEntries.get(p) : null;
        TreeEntry treeEntry = nextEntry = n >= 0 && n < this.treeEntries.size() ? this.treeEntries.get(n) : null;
        if (prevEntry != null) {
            if (prevEntry.getNextPageId() == entry.getNextPageId()) {
                prevEntry.setNextPageId(-1L);
            }
            if (entry.getPrevPageId() == -1L) {
                entry.setPrevPageId(prevEntry.getNextPageId());
            }
        }
        if (nextEntry != null) {
            if (nextEntry.getPrevPageId() == entry.getPrevPageId()) {
                nextEntry.setPrevPageId(-1L);
            }
            if (entry.getNextPageId() == -1L) {
                entry.setNextPageId(nextEntry.getPrevPageId());
            }
        }
        this.addTreeEntry(index, entry);
    }

    private void resetPageReference(int index, long pageId) {
        TreeEntry nextEntry;
        int p = index - 1;
        int n = index;
        TreeEntry prevEntry = p >= 0 && p < this.treeEntries.size() ? this.treeEntries.get(p) : null;
        TreeEntry treeEntry = nextEntry = n >= 0 && n < this.treeEntries.size() ? this.treeEntries.get(n) : null;
        if (prevEntry != null && prevEntry.getNextPageId() == pageId) {
            prevEntry.setNextPageId(-1L);
        }
        if (nextEntry != null && nextEntry.getPrevPageId() == pageId) {
            nextEntry.setPrevPageId(-1L);
        }
    }

    private boolean resetPageReference(long pageId) {
        boolean updated = false;
        for (TreeEntry entry : this.treeEntries) {
            if (entry.getPrevPageId() == pageId) {
                entry.setPrevPageId(-1L);
                updated = true;
            }
            if (entry.getNextPageId() != pageId) continue;
            entry.setNextPageId(-1L);
            updated = true;
        }
        return updated;
    }

    private void resetParentId(long newParentId, List<TreeEntry> entries) throws IOException {
        HashSet<Long> set = new HashSet<Long>();
        for (TreeEntry entry : entries) {
            if (entry == null) continue;
            set.add(entry.getPrevPageId());
            set.add(entry.getNextPageId());
        }
        for (Long pageId : set) {
            TreePage page = this.tree.lookupPage(pageId);
            if (page == null) continue;
            page.setParentId(newParentId);
        }
    }

    private void addTreeEntry(int index, TreeEntry entry) throws IOException {
        this.treeEntries.add(index, entry);
    }

    private TreeEntry removeTreeEntry(int index) throws IOException {
        TreeEntry result = this.treeEntries.remove(index);
        return result;
    }

    private void removeAllTreeEntries(List<TreeEntry> c) {
        this.treeEntries.removeAll(c);
    }

    private List<TreeEntry> getSubList(int from, int to) {
        return new ArrayList<TreeEntry>(this.treeEntries.subList(from, to));
    }

    private TreeEntry getTreeEntry(int index) {
        TreeEntry result = this.treeEntries.get(index);
        return result;
    }

    void saveHeader() throws IOException {
        this.tree.writePage(this);
    }

    void save() throws IOException {
        this.tree.writeFullPage(this);
    }

    protected void dump() throws IOException {
        LOG.info(this.toString());
        HashSet<Long> set = new HashSet<Long>();
        for (TreeEntry entry : this.treeEntries) {
            if (entry == null) continue;
            LOG.info(entry.toString());
            set.add(entry.getPrevPageId());
            set.add(entry.getNextPageId());
        }
        for (Long pageId : set) {
            TreePage page = this.tree.lookupPage(pageId);
            if (page == null) continue;
            page.dump();
        }
    }

    static enum Flavour {
        LESS,
        MORE;

    }
}

