/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.openwire.v3;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.activemq.command.ConsumerControl;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.DataStructure;
import org.apache.activemq.openwire.BooleanStream;
import org.apache.activemq.openwire.OpenWireFormat;
import org.apache.activemq.openwire.v3.BaseCommandMarshaller;

public class ConsumerControlMarshaller
extends BaseCommandMarshaller {
    @Override
    public byte getDataStructureType() {
        return 17;
    }

    @Override
    public DataStructure createObject() {
        return new ConsumerControl();
    }

    @Override
    public void tightUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn, BooleanStream bs) throws IOException {
        super.tightUnmarshal(wireFormat, o, dataIn, bs);
        ConsumerControl info2 = (ConsumerControl)o;
        info2.setClose(bs.readBoolean());
        info2.setConsumerId((ConsumerId)this.tightUnmarsalNestedObject(wireFormat, dataIn, bs));
        info2.setPrefetch(dataIn.readInt());
        info2.setFlush(bs.readBoolean());
        info2.setStart(bs.readBoolean());
        info2.setStop(bs.readBoolean());
    }

    @Override
    public int tightMarshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        ConsumerControl info2 = (ConsumerControl)o;
        int rc = super.tightMarshal1(wireFormat, o, bs);
        bs.writeBoolean(info2.isClose());
        bs.writeBoolean(info2.isFlush());
        bs.writeBoolean(info2.isStart());
        bs.writeBoolean(info2.isStop());
        return (rc += this.tightMarshalNestedObject1(wireFormat, info2.getConsumerId(), bs)) + 4;
    }

    @Override
    public void tightMarshal2(OpenWireFormat wireFormat, Object o, DataOutput dataOut, BooleanStream bs) throws IOException {
        super.tightMarshal2(wireFormat, o, dataOut, bs);
        ConsumerControl info2 = (ConsumerControl)o;
        bs.readBoolean();
        this.tightMarshalNestedObject2(wireFormat, info2.getConsumerId(), dataOut, bs);
        dataOut.writeInt(info2.getPrefetch());
        bs.readBoolean();
        bs.readBoolean();
        bs.readBoolean();
    }

    @Override
    public void looseUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn) throws IOException {
        super.looseUnmarshal(wireFormat, o, dataIn);
        ConsumerControl info2 = (ConsumerControl)o;
        info2.setClose(dataIn.readBoolean());
        info2.setConsumerId((ConsumerId)this.looseUnmarsalNestedObject(wireFormat, dataIn));
        info2.setPrefetch(dataIn.readInt());
        info2.setFlush(dataIn.readBoolean());
        info2.setStart(dataIn.readBoolean());
        info2.setStop(dataIn.readBoolean());
    }

    @Override
    public void looseMarshal(OpenWireFormat wireFormat, Object o, DataOutput dataOut) throws IOException {
        ConsumerControl info2 = (ConsumerControl)o;
        super.looseMarshal(wireFormat, o, dataOut);
        dataOut.writeBoolean(info2.isClose());
        this.looseMarshalNestedObject(wireFormat, info2.getConsumerId(), dataOut);
        dataOut.writeInt(info2.getPrefetch());
        dataOut.writeBoolean(info2.isFlush());
        dataOut.writeBoolean(info2.isStart());
        dataOut.writeBoolean(info2.isStop());
    }
}

