/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.openwire.v7;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.activemq.command.ConnectionControl;
import org.apache.activemq.command.DataStructure;
import org.apache.activemq.openwire.BooleanStream;
import org.apache.activemq.openwire.OpenWireFormat;
import org.apache.activemq.openwire.v7.BaseCommandMarshaller;

public class ConnectionControlMarshaller
extends BaseCommandMarshaller {
    @Override
    public byte getDataStructureType() {
        return 18;
    }

    @Override
    public DataStructure createObject() {
        return new ConnectionControl();
    }

    @Override
    public void tightUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn, BooleanStream bs) throws IOException {
        super.tightUnmarshal(wireFormat, o, dataIn, bs);
        ConnectionControl info2 = (ConnectionControl)o;
        info2.setClose(bs.readBoolean());
        info2.setExit(bs.readBoolean());
        info2.setFaultTolerant(bs.readBoolean());
        info2.setResume(bs.readBoolean());
        info2.setSuspend(bs.readBoolean());
        info2.setConnectedBrokers(this.tightUnmarshalString(dataIn, bs));
        info2.setReconnectTo(this.tightUnmarshalString(dataIn, bs));
        info2.setRebalanceConnection(bs.readBoolean());
    }

    @Override
    public int tightMarshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        ConnectionControl info2 = (ConnectionControl)o;
        int rc = super.tightMarshal1(wireFormat, o, bs);
        bs.writeBoolean(info2.isClose());
        bs.writeBoolean(info2.isExit());
        bs.writeBoolean(info2.isFaultTolerant());
        bs.writeBoolean(info2.isResume());
        bs.writeBoolean(info2.isSuspend());
        rc += this.tightMarshalString1(info2.getConnectedBrokers(), bs);
        bs.writeBoolean(info2.isRebalanceConnection());
        return (rc += this.tightMarshalString1(info2.getReconnectTo(), bs)) + 0;
    }

    @Override
    public void tightMarshal2(OpenWireFormat wireFormat, Object o, DataOutput dataOut, BooleanStream bs) throws IOException {
        super.tightMarshal2(wireFormat, o, dataOut, bs);
        ConnectionControl info2 = (ConnectionControl)o;
        bs.readBoolean();
        bs.readBoolean();
        bs.readBoolean();
        bs.readBoolean();
        bs.readBoolean();
        this.tightMarshalString2(info2.getConnectedBrokers(), dataOut, bs);
        this.tightMarshalString2(info2.getReconnectTo(), dataOut, bs);
        bs.readBoolean();
    }

    @Override
    public void looseUnmarshal(OpenWireFormat wireFormat, Object o, DataInput dataIn) throws IOException {
        super.looseUnmarshal(wireFormat, o, dataIn);
        ConnectionControl info2 = (ConnectionControl)o;
        info2.setClose(dataIn.readBoolean());
        info2.setExit(dataIn.readBoolean());
        info2.setFaultTolerant(dataIn.readBoolean());
        info2.setResume(dataIn.readBoolean());
        info2.setSuspend(dataIn.readBoolean());
        info2.setConnectedBrokers(this.looseUnmarshalString(dataIn));
        info2.setReconnectTo(this.looseUnmarshalString(dataIn));
        info2.setRebalanceConnection(dataIn.readBoolean());
    }

    @Override
    public void looseMarshal(OpenWireFormat wireFormat, Object o, DataOutput dataOut) throws IOException {
        ConnectionControl info2 = (ConnectionControl)o;
        super.looseMarshal(wireFormat, o, dataOut);
        dataOut.writeBoolean(info2.isClose());
        dataOut.writeBoolean(info2.isExit());
        dataOut.writeBoolean(info2.isFaultTolerant());
        dataOut.writeBoolean(info2.isResume());
        dataOut.writeBoolean(info2.isSuspend());
        this.looseMarshalString(info2.getConnectedBrokers(), dataOut);
        this.looseMarshalString(info2.getReconnectTo(), dataOut);
        dataOut.writeBoolean(info2.isRebalanceConnection());
    }
}

