/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadb.disk.page;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.Adler32;
import org.apache.activemq.store.kahadb.disk.page.Page;
import org.apache.activemq.store.kahadb.disk.page.Transaction;
import org.apache.activemq.store.kahadb.disk.util.Sequence;
import org.apache.activemq.store.kahadb.disk.util.SequenceSet;
import org.apache.activemq.util.DataByteArrayOutputStream;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.util.IOHelper;
import org.apache.activemq.util.IntrospectionSupport;
import org.apache.activemq.util.LFUCache;
import org.apache.activemq.util.LRUCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageFile {
    private static final String PAGEFILE_SUFFIX = ".data";
    private static final String RECOVERY_FILE_SUFFIX = ".redo";
    private static final String FREE_FILE_SUFFIX = ".free";
    public static final int DEFAULT_PAGE_SIZE = Integer.getInteger("defaultPageSize", 4096);
    public static final int DEFAULT_WRITE_BATCH_SIZE = Integer.getInteger("defaultWriteBatchSize", 1000);
    public static final int DEFAULT_PAGE_CACHE_SIZE = Integer.getInteger("defaultPageCacheSize", 100);
    private static final int RECOVERY_FILE_HEADER_SIZE = 4096;
    private static final int PAGE_FILE_HEADER_SIZE = 4096;
    private static final Logger LOG = LoggerFactory.getLogger(PageFile.class);
    private File directory;
    private final String name;
    private RandomAccessFile readFile;
    private RandomAccessFile writeFile;
    private RandomAccessFile recoveryFile;
    private int pageSize = DEFAULT_PAGE_SIZE;
    private int recoveryFileMinPageCount = 1000;
    private int recoveryFileMaxPageCount = 10000;
    private int recoveryPageCount;
    private AtomicBoolean loaded = new AtomicBoolean();
    int writeBatchSize = DEFAULT_WRITE_BATCH_SIZE;
    private Map<Long, Page> pageCache;
    private boolean enablePageCaching = true;
    private int pageCacheSize = DEFAULT_PAGE_CACHE_SIZE;
    private boolean enableRecoveryFile = true;
    private boolean enableDiskSyncs = true;
    private boolean enabledWriteThread = false;
    private AtomicBoolean stopWriter = new AtomicBoolean();
    private Thread writerThread;
    private CountDownLatch checkpointLatch;
    private TreeMap<Long, PageWrite> writes = new TreeMap();
    private final AtomicLong nextFreePageId = new AtomicLong();
    private SequenceSet freeList = new SequenceSet();
    private AtomicLong nextTxid = new AtomicLong();
    private MetaData metaData;
    private ArrayList<File> tmpFilesForRemoval = new ArrayList();
    private boolean useLFRUEviction = false;
    private float LFUEvictionFactor = 0.2f;

    public Transaction tx() {
        this.assertLoaded();
        return new Transaction(this);
    }

    public PageFile(File directory, String name) {
        this.directory = directory;
        this.name = name;
    }

    public void delete() throws IOException {
        if (this.loaded.get()) {
            throw new IllegalStateException("Cannot delete page file data when the page file is loaded");
        }
        this.delete(this.getMainPageFile());
        this.delete(this.getFreeFile());
        this.delete(this.getRecoveryFile());
    }

    public void archive() throws IOException {
        if (this.loaded.get()) {
            throw new IllegalStateException("Cannot delete page file data when the page file is loaded");
        }
        long timestamp = System.currentTimeMillis();
        this.archive(this.getMainPageFile(), String.valueOf(timestamp));
        this.archive(this.getFreeFile(), String.valueOf(timestamp));
        this.archive(this.getRecoveryFile(), String.valueOf(timestamp));
    }

    private void delete(File file) throws IOException {
        if (file.exists() && !file.delete()) {
            throw new IOException("Could not delete: " + file.getPath());
        }
    }

    private void archive(File file, String suffix) throws IOException {
        File archive;
        if (file.exists() && !file.renameTo(archive = new File(file.getPath() + "-" + suffix))) {
            throw new IOException("Could not archive: " + file.getPath() + " to " + file.getPath());
        }
    }

    public void load() throws IOException, IllegalStateException {
        if (this.loaded.compareAndSet(false, true)) {
            if (this.enablePageCaching) {
                this.pageCache = this.isUseLFRUEviction() ? Collections.synchronizedMap(new LFUCache(this.pageCacheSize, this.getLFUEvictionFactor())) : Collections.synchronizedMap(new LRUCache(this.pageCacheSize, this.pageCacheSize, 0.75f, true));
            }
            File file = this.getMainPageFile();
            IOHelper.mkdirs(file.getParentFile());
            this.writeFile = new RandomAccessFile(file, "rw");
            this.readFile = new RandomAccessFile(file, "r");
            if (this.readFile.length() > 0L) {
                this.loadMetaData();
                this.pageSize = this.metaData.getPageSize();
            } else {
                this.metaData = new MetaData();
                this.metaData.setFileType(PageFile.class.getName());
                this.metaData.setFileTypeVersion("1");
                this.metaData.setPageSize(this.getPageSize());
                this.metaData.setCleanShutdown(true);
                this.metaData.setFreePages(-1L);
                this.metaData.setLastTxId(0L);
                this.storeMetaData();
            }
            if (this.enableRecoveryFile) {
                this.recoveryFile = new RandomAccessFile(this.getRecoveryFile(), "rw");
            }
            if (this.metaData.isCleanShutdown()) {
                this.nextTxid.set(this.metaData.getLastTxId() + 1L);
                if (this.metaData.getFreePages() > 0L) {
                    this.loadFreeList();
                }
            } else {
                LOG.debug(this.toString() + ", Recovering page file...");
                this.nextTxid.set(this.redoRecoveryUpdates());
                this.freeList = new SequenceSet();
                Iterator<Page> i = this.tx().iterator(true);
                while (i.hasNext()) {
                    Page page = i.next();
                    if (page.getType() != 0) continue;
                    this.freeList.add(page.getPageId());
                }
            }
            this.metaData.setCleanShutdown(false);
            this.storeMetaData();
            this.getFreeFile().delete();
            if (this.writeFile.length() < 4096L) {
                this.writeFile.setLength(4096L);
            }
        } else {
            throw new IllegalStateException("Cannot load the page file when it is already loaded.");
        }
        this.nextFreePageId.set((this.writeFile.length() - 4096L) / (long)this.pageSize);
        this.startWriter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unload() throws IOException {
        if (this.loaded.compareAndSet(true, false)) {
            this.flush();
            try {
                this.stopWriter();
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException();
            }
            if (this.freeList.isEmpty()) {
                this.metaData.setFreePages(0L);
            } else {
                this.storeFreeList();
                this.metaData.setFreePages(this.freeList.size());
            }
            this.metaData.setLastTxId(this.nextTxid.get() - 1L);
            this.metaData.setCleanShutdown(true);
            this.storeMetaData();
            if (this.readFile != null) {
                this.readFile.close();
                this.readFile = null;
                this.writeFile.close();
                this.writeFile = null;
                if (this.enableRecoveryFile) {
                    this.recoveryFile.close();
                    this.recoveryFile = null;
                }
                this.freeList.clear();
                if (this.pageCache != null) {
                    this.pageCache = null;
                }
                TreeMap<Long, PageWrite> treeMap = this.writes;
                synchronized (treeMap) {
                    this.writes.clear();
                }
            }
        } else {
            throw new IllegalStateException("Cannot unload the page file when it is not loaded");
        }
    }

    public boolean isLoaded() {
        return this.loaded.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        CountDownLatch checkpointLatch;
        if (this.enabledWriteThread && this.stopWriter.get()) {
            throw new IOException("Page file already stopped: checkpointing is not allowed");
        }
        TreeMap<Long, PageWrite> treeMap = this.writes;
        synchronized (treeMap) {
            if (this.writes.isEmpty()) {
                return;
            }
            if (this.enabledWriteThread) {
                if (this.checkpointLatch == null) {
                    this.checkpointLatch = new CountDownLatch(1);
                }
            } else {
                this.writeBatch();
                return;
            }
            checkpointLatch = this.checkpointLatch;
            this.writes.notify();
        }
        try {
            checkpointLatch.await();
        }
        catch (InterruptedException e) {
            InterruptedIOException ioe = new InterruptedIOException();
            ioe.initCause(e);
            throw ioe;
        }
    }

    public String toString() {
        return "Page File: " + this.getMainPageFile();
    }

    private File getMainPageFile() {
        return new File(this.directory, IOHelper.toFileSystemSafeName(this.name) + PAGEFILE_SUFFIX);
    }

    public File getFreeFile() {
        return new File(this.directory, IOHelper.toFileSystemSafeName(this.name) + FREE_FILE_SUFFIX);
    }

    public File getRecoveryFile() {
        return new File(this.directory, IOHelper.toFileSystemSafeName(this.name) + RECOVERY_FILE_SUFFIX);
    }

    public long toOffset(long pageId) {
        return 4096L + pageId * (long)this.pageSize;
    }

    private void loadMetaData() throws IOException {
        ByteArrayInputStream is;
        byte[] d;
        Properties p;
        MetaData v1 = new MetaData();
        MetaData v2 = new MetaData();
        try {
            p = new Properties();
            d = new byte[2048];
            this.readFile.seek(0L);
            this.readFile.readFully(d);
            is = new ByteArrayInputStream(d);
            p.load(is);
            IntrospectionSupport.setProperties(v1, p);
        }
        catch (IOException e) {
            v1 = null;
        }
        try {
            p = new Properties();
            d = new byte[2048];
            this.readFile.seek(2048L);
            this.readFile.readFully(d);
            is = new ByteArrayInputStream(d);
            p.load(is);
            IntrospectionSupport.setProperties(v2, p);
        }
        catch (IOException e) {
            v2 = null;
        }
        if (v1 == null && v2 == null) {
            throw new IOException("Could not load page file meta data");
        }
        this.metaData = v1 == null || v1.metaDataTxId < 0L ? v2 : (v2 == null || v1.metaDataTxId < 0L ? v1 : (v1.metaDataTxId == v2.metaDataTxId ? v1 : v2));
    }

    private void storeMetaData() throws IOException {
        ++this.metaData.metaDataTxId;
        Properties p = new Properties();
        IntrospectionSupport.getProperties(this.metaData, p, null);
        ByteArrayOutputStream os = new ByteArrayOutputStream(4096);
        p.store(os, "");
        if (os.size() > 2048) {
            throw new IOException("Configuation is larger than: 2048");
        }
        byte[] filler = new byte[2048 - os.size()];
        Arrays.fill(filler, (byte)32);
        os.write(filler);
        os.flush();
        byte[] d = os.toByteArray();
        this.writeFile.seek(0L);
        this.writeFile.write(d);
        this.writeFile.getFD().sync();
        this.writeFile.seek(2048L);
        this.writeFile.write(d);
        this.writeFile.getFD().sync();
    }

    private void storeFreeList() throws IOException {
        FileOutputStream os = new FileOutputStream(this.getFreeFile());
        DataOutputStream dos = new DataOutputStream(os);
        SequenceSet.Marshaller.INSTANCE.writePayload(this.freeList, (DataOutput)dos);
        dos.close();
    }

    private void loadFreeList() throws IOException {
        this.freeList.clear();
        FileInputStream is = new FileInputStream(this.getFreeFile());
        DataInputStream dis = new DataInputStream(is);
        this.freeList = SequenceSet.Marshaller.INSTANCE.readPayload(dis);
        dis.close();
    }

    public boolean isEnableRecoveryFile() {
        return this.enableRecoveryFile;
    }

    public void setEnableRecoveryFile(boolean doubleBuffer) {
        this.assertNotLoaded();
        this.enableRecoveryFile = doubleBuffer;
    }

    public boolean isEnableDiskSyncs() {
        return this.enableDiskSyncs;
    }

    public void setEnableDiskSyncs(boolean syncWrites) {
        this.assertNotLoaded();
        this.enableDiskSyncs = syncWrites;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getPageContentSize() {
        return this.pageSize - 21;
    }

    public void setPageSize(int pageSize) throws IllegalStateException {
        this.assertNotLoaded();
        this.pageSize = pageSize;
    }

    public boolean isEnablePageCaching() {
        return this.enablePageCaching;
    }

    public void setEnablePageCaching(boolean enablePageCaching) {
        this.assertNotLoaded();
        this.enablePageCaching = enablePageCaching;
    }

    public int getPageCacheSize() {
        return this.pageCacheSize;
    }

    public void setPageCacheSize(int pageCacheSize) {
        this.assertNotLoaded();
        this.pageCacheSize = pageCacheSize;
    }

    public boolean isEnabledWriteThread() {
        return this.enabledWriteThread;
    }

    public void setEnableWriteThread(boolean enableAsyncWrites) {
        this.assertNotLoaded();
        this.enabledWriteThread = enableAsyncWrites;
    }

    public long getDiskSize() throws IOException {
        return this.toOffset(this.nextFreePageId.get());
    }

    public long getPageCount() {
        return this.nextFreePageId.get();
    }

    public int getRecoveryFileMinPageCount() {
        return this.recoveryFileMinPageCount;
    }

    public long getFreePageCount() {
        this.assertLoaded();
        return this.freeList.rangeSize();
    }

    public void setRecoveryFileMinPageCount(int recoveryFileMinPageCount) {
        this.assertNotLoaded();
        this.recoveryFileMinPageCount = recoveryFileMinPageCount;
    }

    public int getRecoveryFileMaxPageCount() {
        return this.recoveryFileMaxPageCount;
    }

    public void setRecoveryFileMaxPageCount(int recoveryFileMaxPageCount) {
        this.assertNotLoaded();
        this.recoveryFileMaxPageCount = recoveryFileMaxPageCount;
    }

    public int getWriteBatchSize() {
        return this.writeBatchSize;
    }

    public void setWriteBatchSize(int writeBatchSize) {
        this.writeBatchSize = writeBatchSize;
    }

    public float getLFUEvictionFactor() {
        return this.LFUEvictionFactor;
    }

    public void setLFUEvictionFactor(float LFUEvictionFactor) {
        this.LFUEvictionFactor = LFUEvictionFactor;
    }

    public boolean isUseLFRUEviction() {
        return this.useLFRUEviction;
    }

    public void setUseLFRUEviction(boolean useLFRUEviction) {
        this.useLFRUEviction = useLFRUEviction;
    }

    void assertLoaded() throws IllegalStateException {
        if (!this.loaded.get()) {
            throw new IllegalStateException("PageFile is not loaded");
        }
    }

    void assertNotLoaded() throws IllegalStateException {
        if (this.loaded.get()) {
            throw new IllegalStateException("PageFile is loaded");
        }
    }

    <T> Page<T> allocate(int count) throws IOException {
        this.assertLoaded();
        if (count <= 0) {
            throw new IllegalArgumentException("The allocation count must be larger than zero");
        }
        Sequence seq = this.freeList.removeFirstSequence(count);
        if (seq == null) {
            Page first = null;
            int c = count;
            long pageId = this.nextFreePageId.getAndAdd(count);
            long writeTxnId = this.nextTxid.getAndAdd(count);
            while (c-- > 0) {
                Page page = new Page(pageId++);
                page.makeFree(writeTxnId++);
                if (first == null) {
                    first = page;
                }
                this.addToCache(page);
                DataByteArrayOutputStream out = new DataByteArrayOutputStream(this.pageSize);
                page.write(out);
                this.write(page, out.getData());
            }
            return first;
        }
        Page page = new Page(seq.getFirst());
        page.makeFree(0L);
        return page;
    }

    long getNextWriteTransactionId() {
        return this.nextTxid.incrementAndGet();
    }

    synchronized void readPage(long pageId, byte[] data) throws IOException {
        this.readFile.seek(this.toOffset(pageId));
        this.readFile.readFully(data);
    }

    public void freePage(long pageId) {
        this.freeList.add(pageId);
        this.removeFromCache(pageId);
    }

    private <T> void write(Page<T> page, byte[] data) throws IOException {
        final PageWrite write2 = new PageWrite(page, data);
        Map.Entry<Long, PageWrite> entry = new Map.Entry<Long, PageWrite>(){

            @Override
            public Long getKey() {
                return write2.getPage().getPageId();
            }

            @Override
            public PageWrite getValue() {
                return write2;
            }

            @Override
            public PageWrite setValue(PageWrite value) {
                return null;
            }
        };
        Map.Entry[] entries = new Map.Entry[]{entry};
        this.write(Arrays.asList(entries));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(Collection<Map.Entry<Long, PageWrite>> updates) throws IOException {
        TreeMap<Long, PageWrite> treeMap = this.writes;
        synchronized (treeMap) {
            if (this.enabledWriteThread) {
                while (this.writes.size() >= this.writeBatchSize && !this.stopWriter.get()) {
                    try {
                        this.writes.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new InterruptedIOException();
                    }
                }
            }
            boolean longTx = false;
            for (Map.Entry<Long, PageWrite> entry : updates) {
                Long key = entry.getKey();
                PageWrite value = entry.getValue();
                PageWrite write2 = this.writes.get(key);
                if (write2 == null) {
                    this.writes.put(key, value);
                    continue;
                }
                if (value.currentLocation != -1L) {
                    write2.setCurrentLocation(value.page, value.currentLocation, value.length);
                    write2.tmpFile = value.tmpFile;
                    longTx = true;
                    continue;
                }
                write2.setCurrent(value.page, value.current);
            }
            if (longTx || this.canStartWriteBatch()) {
                if (this.enabledWriteThread) {
                    this.writes.notify();
                } else {
                    this.writeBatch();
                }
            }
        }
    }

    private boolean canStartWriteBatch() {
        int capacityUsed = this.writes.size() * 100 / this.writeBatchSize;
        if (this.enabledWriteThread) {
            return capacityUsed >= 10 || this.checkpointLatch != null;
        }
        return capacityUsed >= 80 || this.checkpointLatch != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> Page<T> getFromCache(long pageId) {
        TreeMap<Long, PageWrite> treeMap = this.writes;
        synchronized (treeMap) {
            PageWrite pageWrite = this.writes.get(pageId);
            if (pageWrite != null) {
                return pageWrite.page;
            }
        }
        Page result = null;
        if (this.enablePageCaching) {
            result = this.pageCache.get(pageId);
        }
        return result;
    }

    void addToCache(Page page) {
        if (this.enablePageCaching) {
            this.pageCache.put(page.getPageId(), page);
        }
    }

    void removeFromCache(long pageId) {
        if (this.enablePageCaching) {
            this.pageCache.remove(pageId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pollWrites() {
        try {
            while (!this.stopWriter.get()) {
                TreeMap<Long, PageWrite> treeMap = this.writes;
                synchronized (treeMap) {
                    this.writes.notifyAll();
                    while (this.writes.isEmpty() && this.checkpointLatch == null && !this.stopWriter.get()) {
                        this.writes.wait(100L);
                    }
                    if (this.writes.isEmpty()) {
                        this.releaseCheckpointWaiter();
                    }
                }
                this.writeBatch();
            }
        }
        catch (Throwable e) {
            LOG.info("An exception was raised while performing poll writes", e);
        }
        finally {
            this.releaseCheckpointWaiter();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeBatch() throws IOException {
        TreeMap<Long, PageWrite> treeMap;
        CountDownLatch checkpointLatch;
        ArrayList<PageWrite> batch;
        TreeMap<Long, PageWrite> treeMap2 = this.writes;
        synchronized (treeMap2) {
            batch = new ArrayList<PageWrite>(this.writes.size());
            for (PageWrite write2 : this.writes.values()) {
                batch.add(write2);
                write2.begin();
                if (write2.diskBound != null || write2.diskBoundLocation != -1L) continue;
                batch.remove(write2);
            }
            checkpointLatch = this.checkpointLatch;
            this.checkpointLatch = null;
        }
        Adler32 checksum = new Adler32();
        if (this.enableRecoveryFile) {
            this.recoveryFile.seek(4096L);
        }
        for (PageWrite w : batch) {
            if (this.enableRecoveryFile) {
                try {
                    checksum.update(w.getDiskBound(), 0, this.pageSize);
                }
                catch (Throwable t) {
                    throw IOExceptionSupport.create("Cannot create recovery file. Reason: " + t, t);
                }
                this.recoveryFile.writeLong(w.page.getPageId());
                this.recoveryFile.write(w.getDiskBound(), 0, this.pageSize);
            }
            this.writeFile.seek(this.toOffset(w.page.getPageId()));
            this.writeFile.write(w.getDiskBound(), 0, this.pageSize);
            w.done();
        }
        try {
            if (this.enableRecoveryFile) {
                if (this.recoveryPageCount > this.recoveryFileMaxPageCount) {
                    int t = Math.max(this.recoveryFileMinPageCount, batch.size());
                    this.recoveryFile.setLength(this.recoveryFileSizeForPages(t));
                }
                this.recoveryFile.seek(0L);
                this.recoveryFile.writeLong(this.nextTxid.get());
                this.recoveryFile.writeLong(checksum.getValue());
                this.recoveryFile.writeInt(batch.size());
            }
            if (this.enableDiskSyncs) {
                if (this.enableRecoveryFile) {
                    this.recoveryFile.getFD().sync();
                }
                this.writeFile.getFD().sync();
            }
            treeMap = this.writes;
        }
        catch (Throwable throwable) {
            TreeMap<Long, PageWrite> treeMap3 = this.writes;
            synchronized (treeMap3) {
                for (PageWrite w : batch) {
                    if (!w.isDone()) continue;
                    this.writes.remove(w.page.getPageId());
                    if (w.tmpFile == null || !this.tmpFilesForRemoval.contains(w.tmpFile)) continue;
                    if (!w.tmpFile.delete()) {
                        throw new IOException("Can't delete temporary KahaDB transaction file:" + w.tmpFile);
                    }
                    this.tmpFilesForRemoval.remove(w.tmpFile);
                }
            }
            if (checkpointLatch != null) {
                checkpointLatch.countDown();
            }
            throw throwable;
        }
        synchronized (treeMap) {
            for (PageWrite w : batch) {
                if (!w.isDone()) continue;
                this.writes.remove(w.page.getPageId());
                if (w.tmpFile == null || !this.tmpFilesForRemoval.contains(w.tmpFile)) continue;
                if (!w.tmpFile.delete()) {
                    throw new IOException("Can't delete temporary KahaDB transaction file:" + w.tmpFile);
                }
                this.tmpFilesForRemoval.remove(w.tmpFile);
            }
        }
        if (checkpointLatch != null) {
            checkpointLatch.countDown();
        }
    }

    public void removeTmpFile(File file) {
        this.tmpFilesForRemoval.add(file);
    }

    private long recoveryFileSizeForPages(int pageCount) {
        return 4096 + (this.pageSize + 8) * pageCount;
    }

    private void releaseCheckpointWaiter() {
        if (this.checkpointLatch != null) {
            this.checkpointLatch.countDown();
            this.checkpointLatch = null;
        }
    }

    private long redoRecoveryUpdates() throws IOException {
        if (!this.enableRecoveryFile) {
            return 0L;
        }
        this.recoveryPageCount = 0;
        if (this.recoveryFile.length() == 0L) {
            this.recoveryFile.write(new byte[4096]);
            this.recoveryFile.setLength(this.recoveryFileSizeForPages(this.recoveryFileMinPageCount));
            return 0L;
        }
        this.recoveryFile.seek(0L);
        long nextTxId = this.recoveryFile.readLong();
        long expectedChecksum = this.recoveryFile.readLong();
        int pageCounter = this.recoveryFile.readInt();
        this.recoveryFile.seek(4096L);
        Adler32 checksum = new Adler32();
        LinkedHashMap<Long, byte[]> batch = new LinkedHashMap<Long, byte[]>();
        try {
            for (int i = 0; i < pageCounter; ++i) {
                long offset = this.recoveryFile.readLong();
                byte[] data = new byte[this.pageSize];
                if (this.recoveryFile.read(data, 0, this.pageSize) != this.pageSize) {
                    return nextTxId;
                }
                checksum.update(data, 0, this.pageSize);
                batch.put(offset, data);
            }
        }
        catch (Exception e) {
            LOG.debug("Redo buffer was not fully intact: ", e);
            return nextTxId;
        }
        this.recoveryPageCount = pageCounter;
        if (checksum.getValue() != expectedChecksum) {
            return nextTxId;
        }
        for (Map.Entry e : batch.entrySet()) {
            this.writeFile.seek(this.toOffset((Long)e.getKey()));
            this.writeFile.write((byte[])e.getValue());
        }
        this.writeFile.getFD().sync();
        return nextTxId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startWriter() {
        TreeMap<Long, PageWrite> treeMap = this.writes;
        synchronized (treeMap) {
            if (this.enabledWriteThread) {
                this.stopWriter.set(false);
                this.writerThread = new Thread("KahaDB Page Writer"){

                    @Override
                    public void run() {
                        PageFile.this.pollWrites();
                    }
                };
                this.writerThread.setPriority(10);
                this.writerThread.setDaemon(true);
                this.writerThread.start();
            }
        }
    }

    private void stopWriter() throws InterruptedException {
        if (this.enabledWriteThread) {
            this.stopWriter.set(true);
            this.writerThread.join();
        }
    }

    public File getFile() {
        return this.getMainPageFile();
    }

    public File getDirectory() {
        return this.directory;
    }

    public static class MetaData {
        String fileType;
        String fileTypeVersion;
        long metaDataTxId = -1L;
        int pageSize;
        boolean cleanShutdown;
        long lastTxId;
        long freePages;

        public String getFileType() {
            return this.fileType;
        }

        public void setFileType(String fileType) {
            this.fileType = fileType;
        }

        public String getFileTypeVersion() {
            return this.fileTypeVersion;
        }

        public void setFileTypeVersion(String version) {
            this.fileTypeVersion = version;
        }

        public long getMetaDataTxId() {
            return this.metaDataTxId;
        }

        public void setMetaDataTxId(long metaDataTxId) {
            this.metaDataTxId = metaDataTxId;
        }

        public int getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(int pageSize) {
            this.pageSize = pageSize;
        }

        public boolean isCleanShutdown() {
            return this.cleanShutdown;
        }

        public void setCleanShutdown(boolean cleanShutdown) {
            this.cleanShutdown = cleanShutdown;
        }

        public long getLastTxId() {
            return this.lastTxId;
        }

        public void setLastTxId(long lastTxId) {
            this.lastTxId = lastTxId;
        }

        public long getFreePages() {
            return this.freePages;
        }

        public void setFreePages(long value) {
            this.freePages = value;
        }
    }

    static class PageWrite {
        Page page;
        byte[] current;
        byte[] diskBound;
        long currentLocation = -1L;
        long diskBoundLocation = -1L;
        File tmpFile;
        int length;

        public PageWrite(Page page, byte[] data) {
            this.page = page;
            this.current = data;
        }

        public PageWrite(Page page, long currentLocation, int length, File tmpFile) {
            this.page = page;
            this.currentLocation = currentLocation;
            this.tmpFile = tmpFile;
            this.length = length;
        }

        public void setCurrent(Page page, byte[] data) {
            this.page = page;
            this.current = data;
            this.currentLocation = -1L;
            this.diskBoundLocation = -1L;
        }

        public void setCurrentLocation(Page page, long location, int length) {
            this.page = page;
            this.currentLocation = location;
            this.length = length;
            this.current = null;
        }

        public String toString() {
            return "[PageWrite:" + this.page.getPageId() + "-" + this.page.getType() + "]";
        }

        public Page getPage() {
            return this.page;
        }

        public byte[] getDiskBound() throws IOException {
            if (this.diskBound == null && this.diskBoundLocation != -1L) {
                this.diskBound = new byte[this.length];
                RandomAccessFile file = new RandomAccessFile(this.tmpFile, "r");
                file.seek(this.diskBoundLocation);
                file.read(this.diskBound);
                file.close();
                this.diskBoundLocation = -1L;
            }
            return this.diskBound;
        }

        void begin() {
            if (this.currentLocation != -1L) {
                this.diskBoundLocation = this.currentLocation;
            } else {
                this.diskBound = this.current;
            }
            this.current = null;
            this.currentLocation = -1L;
        }

        boolean done() {
            this.diskBoundLocation = -1L;
            this.diskBound = null;
            return this.current == null || this.currentLocation == -1L;
        }

        boolean isDone() {
            return this.diskBound == null && this.diskBoundLocation == -1L && this.current == null && this.currentLocation == -1L;
        }
    }
}

