/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.amqp.message;

import java.util.Map;
import javax.jms.JMSException;
import org.apache.activemq.transport.amqp.AmqpProtocolException;
import org.apache.activemq.transport.amqp.message.AMQPMessageIdHelper;
import org.apache.activemq.transport.amqp.message.ActiveMQJMSVendor;
import org.apache.activemq.transport.amqp.message.EncodedMessage;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Decimal128;
import org.apache.qpid.proton.amqp.Decimal32;
import org.apache.qpid.proton.amqp.Decimal64;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnsignedByte;
import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.apache.qpid.proton.amqp.UnsignedLong;
import org.apache.qpid.proton.amqp.UnsignedShort;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.Footer;
import org.apache.qpid.proton.amqp.messaging.Header;
import org.apache.qpid.proton.amqp.messaging.MessageAnnotations;
import org.apache.qpid.proton.amqp.messaging.Properties;
import org.apache.qpid.proton.message.Message;

public abstract class InboundTransformer {
    protected final ActiveMQJMSVendor vendor;
    public static final String TRANSFORMER_NATIVE = "native";
    public static final String TRANSFORMER_RAW = "raw";
    public static final String TRANSFORMER_JMS = "jms";
    protected String prefixVendor = "JMS_AMQP_";
    protected String prefixDeliveryAnnotations = "DA_";
    protected String prefixMessageAnnotations = "MA_";
    protected String prefixFooter = "FT_";
    protected int defaultDeliveryMode = 1;
    protected int defaultPriority = 4;
    protected long defaultTtl = 0L;

    public InboundTransformer(ActiveMQJMSVendor vendor) {
        this.vendor = vendor;
    }

    public abstract String getTransformerName();

    public abstract InboundTransformer getFallbackTransformer();

    public final javax.jms.Message transform(EncodedMessage amqpMessage) throws Exception {
        javax.jms.Message message = null;
        for (InboundTransformer transformer = this; transformer != null; transformer = transformer.getFallbackTransformer()) {
            try {
                message = transformer.doTransform(amqpMessage);
                break;
            }
            catch (Exception e) {
                continue;
            }
        }
        if (message == null) {
            throw new AmqpProtocolException("Failed to transform incoming delivery, skipping.", false);
        }
        return message;
    }

    protected abstract javax.jms.Message doTransform(EncodedMessage var1) throws Exception;

    public int getDefaultDeliveryMode() {
        return this.defaultDeliveryMode;
    }

    public void setDefaultDeliveryMode(int defaultDeliveryMode) {
        this.defaultDeliveryMode = defaultDeliveryMode;
    }

    public int getDefaultPriority() {
        return this.defaultPriority;
    }

    public void setDefaultPriority(int defaultPriority) {
        this.defaultPriority = defaultPriority;
    }

    public long getDefaultTtl() {
        return this.defaultTtl;
    }

    public void setDefaultTtl(long defaultTtl) {
        this.defaultTtl = defaultTtl;
    }

    public String getPrefixVendor() {
        return this.prefixVendor;
    }

    public void setPrefixVendor(String prefixVendor) {
        this.prefixVendor = prefixVendor;
    }

    public ActiveMQJMSVendor getVendor() {
        return this.vendor;
    }

    protected void populateMessage(javax.jms.Message jms, Message amqp) throws Exception {
        Footer footer;
        Properties properties;
        ApplicationProperties ap;
        MessageAnnotations ma;
        Header header = amqp.getHeader();
        if (header == null) {
            header = new Header();
        }
        if (header.getDurable() != null) {
            jms.setJMSDeliveryMode(header.getDurable() != false ? 2 : 1);
        } else {
            jms.setJMSDeliveryMode(this.defaultDeliveryMode);
        }
        if (header.getPriority() != null) {
            jms.setJMSPriority(header.getPriority().intValue());
        } else {
            jms.setJMSPriority(this.defaultPriority);
        }
        if (header.getFirstAcquirer() != null) {
            jms.setBooleanProperty(this.prefixVendor + "FirstAcquirer", header.getFirstAcquirer().booleanValue());
        }
        if (header.getDeliveryCount() != null) {
            this.vendor.setJMSXDeliveryCount(jms, header.getDeliveryCount().longValue());
        }
        if ((ma = amqp.getMessageAnnotations()) != null) {
            for (Map.Entry entry : ma.getValue().entrySet()) {
                String cronEntry;
                String string = entry.getKey().toString();
                if ("x-opt-jms-type".equals(string) && entry.getValue() != null) {
                    jms.setJMSType(entry.getValue().toString());
                } else if ("x-opt-delivery-time".equals(string) && entry.getValue() != null) {
                    long deliveryTime = ((Number)entry.getValue()).longValue();
                    long delay = deliveryTime - System.currentTimeMillis();
                    if (delay > 0L) {
                        jms.setLongProperty("AMQ_SCHEDULED_DELAY", delay);
                    }
                } else if ("x-opt-delivery-delay".equals(string) && entry.getValue() != null) {
                    long delay = ((Number)entry.getValue()).longValue();
                    if (delay > 0L) {
                        jms.setLongProperty("AMQ_SCHEDULED_DELAY", delay);
                    }
                } else if ("x-opt-delivery-repeat".equals(string) && entry.getValue() != null) {
                    int repeat = ((Number)entry.getValue()).intValue();
                    if (repeat > 0) {
                        jms.setIntProperty("AMQ_SCHEDULED_REPEAT", repeat);
                    }
                } else if ("x-opt-delivery-period".equals(string) && entry.getValue() != null) {
                    long period = ((Number)entry.getValue()).longValue();
                    if (period > 0L) {
                        jms.setLongProperty("AMQ_SCHEDULED_PERIOD", period);
                    }
                } else if ("x-opt-delivery-cron".equals(string) && entry.getValue() != null && (cronEntry = (String)entry.getValue()) != null) {
                    jms.setStringProperty("AMQ_SCHEDULED_CRON", cronEntry);
                }
                this.setProperty(jms, this.prefixVendor + this.prefixMessageAnnotations + string, entry.getValue());
            }
        }
        if ((ap = amqp.getApplicationProperties()) != null) {
            for (Map.Entry entry : ap.getValue().entrySet()) {
                String key = entry.getKey().toString();
                if ("JMSXGroupID".equals(key)) {
                    this.vendor.setJMSXGroupID(jms, entry.getValue().toString());
                    continue;
                }
                if ("JMSXGroupSequence".equals(key)) {
                    this.vendor.setJMSXGroupSequence(jms, ((Number)entry.getValue()).intValue());
                    continue;
                }
                if ("JMSXUserID".equals(key)) {
                    this.vendor.setJMSXUserID(jms, entry.getValue().toString());
                    continue;
                }
                this.setProperty(jms, key, entry.getValue());
            }
        }
        if ((properties = amqp.getProperties()) != null) {
            Binary binary;
            if (properties.getMessageId() != null) {
                jms.setJMSMessageID(AMQPMessageIdHelper.INSTANCE.toBaseMessageIdString(properties.getMessageId()));
            }
            if ((binary = properties.getUserId()) != null) {
                this.vendor.setJMSXUserID(jms, new String(binary.getArray(), binary.getArrayOffset(), binary.getLength(), "UTF-8"));
            }
            if (properties.getTo() != null) {
                jms.setJMSDestination(this.vendor.createDestination(properties.getTo()));
            }
            if (properties.getSubject() != null) {
                jms.setJMSType(properties.getSubject());
            }
            if (properties.getReplyTo() != null) {
                jms.setJMSReplyTo(this.vendor.createDestination(properties.getReplyTo()));
            }
            if (properties.getCorrelationId() != null) {
                jms.setJMSCorrelationID(AMQPMessageIdHelper.INSTANCE.toBaseMessageIdString(properties.getCorrelationId()));
            }
            if (properties.getContentType() != null) {
                jms.setStringProperty(this.prefixVendor + "ContentType", properties.getContentType().toString());
            }
            if (properties.getContentEncoding() != null) {
                jms.setStringProperty(this.prefixVendor + "ContentEncoding", properties.getContentEncoding().toString());
            }
            if (properties.getCreationTime() != null) {
                jms.setJMSTimestamp(properties.getCreationTime().getTime());
            }
            if (properties.getGroupId() != null) {
                this.vendor.setJMSXGroupID(jms, properties.getGroupId());
            }
            if (properties.getGroupSequence() != null) {
                this.vendor.setJMSXGroupSequence(jms, properties.getGroupSequence().intValue());
            }
            if (properties.getReplyToGroupId() != null) {
                jms.setStringProperty(this.prefixVendor + "ReplyToGroupID", properties.getReplyToGroupId());
            }
            if (properties.getAbsoluteExpiryTime() != null) {
                jms.setJMSExpiration(properties.getAbsoluteExpiryTime().getTime());
            }
        }
        if (jms.getJMSExpiration() == 0L) {
            long l = this.defaultTtl;
            if (header.getTtl() != null) {
                l = header.getTtl().longValue();
            }
            if (l == 0L) {
                jms.setJMSExpiration(0L);
            } else {
                jms.setJMSExpiration(System.currentTimeMillis() + l);
            }
        }
        if ((footer = amqp.getFooter()) != null) {
            for (Map.Entry entry : footer.getValue().entrySet()) {
                String key = entry.getKey().toString();
                this.setProperty(jms, this.prefixVendor + this.prefixFooter + key, entry.getValue());
            }
        }
    }

    private void setProperty(javax.jms.Message msg, String key, Object value) throws JMSException {
        if (value instanceof UnsignedLong) {
            long v = ((UnsignedLong)value).longValue();
            msg.setLongProperty(key, v);
        } else if (value instanceof UnsignedInteger) {
            long v = ((UnsignedInteger)value).longValue();
            if (Integer.MIN_VALUE <= v && v <= Integer.MAX_VALUE) {
                msg.setIntProperty(key, (int)v);
            } else {
                msg.setLongProperty(key, v);
            }
        } else if (value instanceof UnsignedShort) {
            int v = ((UnsignedShort)value).intValue();
            if (Short.MIN_VALUE <= v && v <= Short.MAX_VALUE) {
                msg.setShortProperty(key, (short)v);
            } else {
                msg.setIntProperty(key, v);
            }
        } else if (value instanceof UnsignedByte) {
            short v = ((UnsignedByte)value).shortValue();
            if (-128 <= v && v <= 127) {
                msg.setByteProperty(key, (byte)v);
            } else {
                msg.setShortProperty(key, v);
            }
        } else if (value instanceof Symbol) {
            msg.setStringProperty(key, value.toString());
        } else if (value instanceof Decimal128) {
            msg.setDoubleProperty(key, ((Decimal128)value).doubleValue());
        } else if (value instanceof Decimal64) {
            msg.setDoubleProperty(key, ((Decimal64)value).doubleValue());
        } else if (value instanceof Decimal32) {
            msg.setFloatProperty(key, ((Decimal32)value).floatValue());
        } else if (value instanceof Binary) {
            msg.setStringProperty(key, value.toString());
        } else {
            msg.setObjectProperty(key, value);
        }
    }
}

