/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.amqp;

import java.io.IOException;
import java.net.Socket;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import javax.net.SocketFactory;
import org.apache.activemq.transport.amqp.AmqpHeader;
import org.apache.activemq.transport.amqp.AmqpSupport;
import org.apache.activemq.transport.nio.NIOSSLTransport;
import org.apache.activemq.wireformat.WireFormat;
import org.fusesource.hawtbuf.Buffer;

public class AmqpNioSslTransport
extends NIOSSLTransport {
    private final ByteBuffer magic = ByteBuffer.allocate(8);

    public AmqpNioSslTransport(WireFormat wireFormat, SocketFactory socketFactory, URI remoteLocation, URI localLocation) throws UnknownHostException, IOException {
        super(wireFormat, socketFactory, remoteLocation, localLocation);
    }

    public AmqpNioSslTransport(WireFormat wireFormat, Socket socket) throws IOException {
        super(wireFormat, socket);
    }

    protected void initializeStreams() throws IOException {
        super.initializeStreams();
        if (this.inputBuffer.position() != 0 && this.inputBuffer.hasRemaining()) {
            this.serviceRead();
        }
    }

    protected void processCommand(ByteBuffer plain) throws Exception {
        byte[] fill = new byte[plain.remaining()];
        plain.get(fill);
        ByteBuffer payload = ByteBuffer.wrap(fill);
        if (this.magic.position() != 8) {
            while (payload.hasRemaining() && this.magic.position() < 8) {
                this.magic.put(payload.get());
            }
            if (!this.magic.hasRemaining()) {
                this.magic.flip();
                this.doConsume(new AmqpHeader(new Buffer(this.magic)));
                this.magic.position(8);
            }
        }
        if (payload.hasRemaining()) {
            this.doConsume(AmqpSupport.toBuffer(payload));
        }
    }
}

