/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.security;

import java.security.Principal;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.apache.activemq.security.AuthenticationUser;
import org.apache.activemq.security.SimpleAuthenticationPlugin;
import org.junit.Assert;
import org.junit.Test;

public class SimpleAuthenticationPluginTest {
    @Test
    public void testSetUsers() {
        AuthenticationUser alice = new AuthenticationUser("alice", "password", "group1");
        AuthenticationUser bob = new AuthenticationUser("bob", "security", "group2");
        SimpleAuthenticationPlugin authenticationPlugin = new SimpleAuthenticationPlugin();
        authenticationPlugin.setUsers(Arrays.asList(alice, bob));
        Assert.assertFalse((boolean)authenticationPlugin.isAnonymousAccessAllowed());
        Map userPasswords = authenticationPlugin.getUserPasswords();
        Assert.assertEquals((long)2L, (long)userPasswords.size());
        Assert.assertEquals((Object)"password", userPasswords.get("alice"));
        Assert.assertEquals((Object)"security", userPasswords.get("bob"));
        Map userGroups = authenticationPlugin.getUserGroups();
        Assert.assertEquals((long)2L, (long)userGroups.size());
        Set aliceGroups = (Set)userGroups.get("alice");
        Assert.assertNotNull((Object)aliceGroups);
        Assert.assertEquals((long)1L, (long)aliceGroups.size());
        Assert.assertEquals((Object)"group1", (Object)((Principal)aliceGroups.iterator().next()).getName());
        Set bobGroups = (Set)userGroups.get("bob");
        Assert.assertNotNull((Object)bobGroups);
        Assert.assertEquals((long)1L, (long)bobGroups.size());
        Assert.assertEquals((Object)"group2", (Object)((Principal)bobGroups.iterator().next()).getName());
    }

    @Test
    public void testSetUsersNoGroups() {
        AuthenticationUser alice = new AuthenticationUser("alice", "password", null);
        AuthenticationUser bob = new AuthenticationUser("bob", "security", null);
        SimpleAuthenticationPlugin authenticationPlugin = new SimpleAuthenticationPlugin();
        authenticationPlugin.setUsers(Arrays.asList(alice, bob));
        Assert.assertFalse((boolean)authenticationPlugin.isAnonymousAccessAllowed());
        Map userPasswords = authenticationPlugin.getUserPasswords();
        Assert.assertEquals((long)2L, (long)userPasswords.size());
        Assert.assertEquals((Object)"password", userPasswords.get("alice"));
        Assert.assertEquals((Object)"security", userPasswords.get("bob"));
        Map userGroups = authenticationPlugin.getUserGroups();
        Assert.assertEquals((long)2L, (long)userGroups.size());
        Set aliceGroups = (Set)userGroups.get("alice");
        Assert.assertNotNull((Object)aliceGroups);
        Assert.assertTrue((boolean)aliceGroups.isEmpty());
        Set bobGroups = (Set)userGroups.get("bob");
        Assert.assertNotNull((Object)bobGroups);
        Assert.assertTrue((boolean)bobGroups.isEmpty());
    }
}

