/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.console.command;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.management.MBeanServerConnection;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.remote.JMXConnector;
import org.apache.activemq.console.command.AbstractJmxCommand;
import org.apache.activemq.console.formatter.GlobalWriter;
import org.apache.activemq.console.util.JmxMBeansUtil;

public class PurgeCommand
extends AbstractJmxCommand {
    private final List queryAddObjects = new ArrayList(10);
    private final List querySubObjects = new ArrayList(10);
    protected String[] helpFile = new String[]{"Task Usage: Main purge [browse-options] <destinations>", "Description: Delete selected destination's messages that matches the message selector.", "", "Browse Options:", "    --msgsel <msgsel1,msglsel2>   Add to the search list messages matched by the query similar to", "                                  the messages selector format.", "    --jmxurl <url>                Set the JMX URL to connect to.", "    --version                     Display the version information.", "    -h,-?,--help                  Display the browse broker help information.", "", "Examples:", "    Main purge FOO.BAR", "        - Delete all the messages in queue FOO.BAR", "    Main purge --msgsel JMSMessageID='*:10',JMSPriority>5 FOO.*", "        - Delete all the messages in the destinations that matches FOO.* and has a JMSMessageID in", "          the header field that matches the wildcard *:10, and has a JMSPriority field > 5 in the", "          queue FOO.BAR", "        * To use wildcard queries, the field must be a string and the query enclosed in ''", ""};

    protected void runTask(List tokens) throws Exception {
        try {
            if (tokens.isEmpty()) {
                tokens.add("*");
            }
            Iterator i = tokens.iterator();
            while (i.hasNext()) {
                List queueList = JmxMBeansUtil.queryMBeans(this.useJmxServiceUrl(), "Type=Queue,Destination=" + i.next() + ",*");
                Iterator j = queueList.iterator();
                while (j.hasNext()) {
                    ObjectName queueName = ((ObjectInstance)j.next()).getObjectName();
                    if (this.queryAddObjects.isEmpty()) {
                        this.purgeQueue(queueName);
                        continue;
                    }
                    List messages = JmxMBeansUtil.createMessageQueryFilter(this.useJmxServiceUrl(), queueName).query(this.queryAddObjects);
                    this.purgeMessages(queueName, messages);
                }
            }
        }
        catch (Exception e) {
            GlobalWriter.printException(new RuntimeException("Failed to execute purge task. Reason: " + e));
            throw new Exception(e);
        }
    }

    public void purgeQueue(ObjectName queue) throws Exception {
        JMXConnector conn = this.createJmxConnector();
        MBeanServerConnection server = conn.getMBeanServerConnection();
        GlobalWriter.printInfo("Purging all messages in queue: " + queue.getKeyProperty("Destination"));
        server.invoke(queue, "purge", new Object[0], new String[0]);
        conn.close();
    }

    public void purgeMessages(ObjectName queue, List messages) throws Exception {
        JMXConnector conn = this.createJmxConnector();
        MBeanServerConnection server = conn.getMBeanServerConnection();
        Object[] param = new Object[1];
        Iterator i = messages.iterator();
        while (i.hasNext()) {
            CompositeData msg = (CompositeData)i.next();
            param[0] = "" + msg.get("JMSMessageID");
            GlobalWriter.printInfo("Removing message: " + param[0] + " from queue: " + queue.getKeyProperty("Destination"));
            server.invoke(queue, "removeMessage", param, new String[]{"java.lang.String"});
        }
        conn.close();
    }

    protected void handleOption(String token, List tokens) throws Exception {
        if (token.startsWith("--msgsel")) {
            if (tokens.isEmpty() || ((String)tokens.get(0)).startsWith("-")) {
                GlobalWriter.printException(new IllegalArgumentException("Message selector not specified"));
                return;
            }
            StringTokenizer queryTokens = new StringTokenizer((String)tokens.remove(0), ",");
            while (queryTokens.hasMoreTokens()) {
                this.queryAddObjects.add(queryTokens.nextToken());
            }
        } else if (token.startsWith("--xmsgsel")) {
            if (tokens.isEmpty() || ((String)tokens.get(0)).startsWith("-")) {
                GlobalWriter.printException(new IllegalArgumentException("Message selector not specified"));
                return;
            }
            StringTokenizer queryTokens = new StringTokenizer((String)tokens.remove(0), ",");
            while (queryTokens.hasMoreTokens()) {
                this.querySubObjects.add(queryTokens.nextToken());
            }
        } else {
            super.handleOption(token, tokens);
        }
    }

    protected void printHelp() {
        GlobalWriter.printHelp(this.helpFile);
    }
}

