/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.jaas;

import java.io.IOException;
import java.security.Principal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.naming.AuthenticationException;
import javax.naming.CommunicationException;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.activemq.jaas.GroupPrincipal;
import org.apache.activemq.jaas.UserPrincipal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LDAPLoginModule
implements LoginModule {
    private static Log log = LogFactory.getLog((Class)LDAPLoginModule.class);
    private Subject subject;
    private CallbackHandler handler;
    private static final String INITIAL_CONTEXT_FACTORY = "initialContextFactory";
    private static final String CONNECTION_URL = "connectionURL";
    private static final String CONNECTION_USERNAME = "connectionUsername";
    private static final String CONNECTION_PASSWORD = "connectionPassword";
    private static final String CONNECTION_PROTOCOL = "connectionProtocol";
    private static final String AUTHENTICATION = "authentication";
    private static final String USER_BASE = "userBase";
    private static final String USER_SEARCH_MATCHING = "userSearchMatching";
    private static final String USER_SEARCH_SUBTREE = "userSearchSubtree";
    private static final String ROLE_BASE = "roleBase";
    private static final String ROLE_NAME = "roleName";
    private static final String ROLE_SEARCH_MATCHING = "roleSearchMatching";
    private static final String ROLE_SEARCH_SUBTREE = "roleSearchSubtree";
    private static final String USER_ROLE_NAME = "userRoleName";
    private String initialContextFactory;
    private String connectionURL;
    private String connectionUsername;
    private String connectionPassword;
    private String connectionProtocol;
    private String authentication;
    private String userBase;
    private String roleBase;
    private String roleName;
    private String userRoleName;
    private String username;
    protected DirContext context = null;
    private MessageFormat userSearchMatchingFormat;
    private MessageFormat roleSearchMatchingFormat;
    private boolean userSearchSubtreeBool = false;
    private boolean roleSearchSubtreeBool = false;
    Set groups = new HashSet();

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.handler = callbackHandler;
        this.initialContextFactory = (String)options.get(INITIAL_CONTEXT_FACTORY);
        this.connectionURL = (String)options.get(CONNECTION_URL);
        this.connectionUsername = (String)options.get(CONNECTION_USERNAME);
        this.connectionPassword = (String)options.get(CONNECTION_PASSWORD);
        this.connectionProtocol = (String)options.get(CONNECTION_PROTOCOL);
        this.authentication = (String)options.get(AUTHENTICATION);
        this.userBase = (String)options.get(USER_BASE);
        String userSearchMatching = (String)options.get(USER_SEARCH_MATCHING);
        String userSearchSubtree = (String)options.get(USER_SEARCH_SUBTREE);
        this.roleBase = (String)options.get(ROLE_BASE);
        this.roleName = (String)options.get(ROLE_NAME);
        String roleSearchMatching = (String)options.get(ROLE_SEARCH_MATCHING);
        String roleSearchSubtree = (String)options.get(ROLE_SEARCH_SUBTREE);
        this.userRoleName = (String)options.get(USER_ROLE_NAME);
        this.userSearchMatchingFormat = new MessageFormat(userSearchMatching);
        this.roleSearchMatchingFormat = new MessageFormat(roleSearchMatching);
        this.userSearchSubtreeBool = new Boolean(userSearchSubtree);
        this.roleSearchSubtreeBool = new Boolean(roleSearchSubtree);
    }

    public boolean login() throws LoginException {
        Callback[] callbacks = new Callback[]{new NameCallback("User name"), new PasswordCallback("Password", false)};
        try {
            this.handler.handle(callbacks);
        }
        catch (IOException ioe) {
            throw (LoginException)new LoginException().initCause(ioe);
        }
        catch (UnsupportedCallbackException uce) {
            throw (LoginException)new LoginException().initCause(uce);
        }
        this.username = ((NameCallback)callbacks[0]).getName();
        String password = new String(((PasswordCallback)callbacks[1]).getPassword());
        if (this.username == null || "".equals(this.username) || password == null || "".equals(password)) {
            return false;
        }
        try {
            boolean result = this.authenticate(this.username, password);
            if (!result) {
                throw new FailedLoginException();
            }
            return true;
        }
        catch (Exception e) {
            throw (LoginException)new LoginException("LDAP Error").initCause(e);
        }
    }

    public boolean logout() throws LoginException {
        this.username = null;
        return true;
    }

    public boolean commit() throws LoginException {
        Set<Principal> principals = this.subject.getPrincipals();
        principals.add(new UserPrincipal(this.username));
        Iterator iter = this.groups.iterator();
        while (iter.hasNext()) {
            principals.add((Principal)iter.next());
        }
        return true;
    }

    public boolean abort() throws LoginException {
        this.username = null;
        return true;
    }

    protected void close(DirContext context) {
        try {
            context.close();
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    protected boolean authenticate(String username, String password) throws Exception {
        block13: {
            DirContext context = null;
            context = this.open();
            try {
                String filter = this.userSearchMatchingFormat.format(new String[]{username});
                SearchControls constraints = new SearchControls();
                if (this.userSearchSubtreeBool) {
                    constraints.setSearchScope(2);
                } else {
                    constraints.setSearchScope(1);
                }
                ArrayList<String> list = new ArrayList<String>();
                if (this.userRoleName != null) {
                    list.add(this.userRoleName);
                }
                String[] attribs = new String[list.size()];
                list.toArray(attribs);
                constraints.setReturningAttributes(attribs);
                NamingEnumeration<SearchResult> results = context.search(this.userBase, filter, constraints);
                if (results == null || !results.hasMore()) {
                    return false;
                }
                SearchResult result = results.next();
                if (results.hasMore()) {
                    // empty if block
                }
                NameParser parser = context.getNameParser("");
                Name contextName = parser.parse(context.getNameInNamespace());
                Name baseName = parser.parse(this.userBase);
                Name entryName = parser.parse(result.getName());
                Name name = contextName.addAll(baseName);
                name = name.addAll(entryName);
                String dn = name.toString();
                Attributes attrs = result.getAttributes();
                if (attrs == null) {
                    return false;
                }
                ArrayList roles = null;
                if (this.userRoleName != null) {
                    roles = this.addAttributeValues(this.userRoleName, attrs, roles);
                }
                if (this.bindUser(context, dn, password)) {
                    roles = this.getRoles(context, dn, username, roles);
                    for (int i = 0; i < roles.size(); ++i) {
                        this.groups.add(new GroupPrincipal((String)roles.get(i)));
                    }
                    break block13;
                }
                return false;
            }
            catch (CommunicationException e) {
            }
            catch (NamingException e) {
                if (context != null) {
                    this.close(context);
                }
                return false;
            }
        }
        return true;
    }

    protected ArrayList getRoles(DirContext context, String dn, String username, ArrayList currentRoles) throws NamingException {
        ArrayList list = currentRoles;
        if (list == null) {
            list = new ArrayList();
        }
        if (this.roleName == null || "".equals(this.roleName)) {
            return list;
        }
        String filter = this.roleSearchMatchingFormat.format(new String[]{this.doRFC2254Encoding(dn), username});
        SearchControls constraints = new SearchControls();
        if (this.roleSearchSubtreeBool) {
            constraints.setSearchScope(2);
        } else {
            constraints.setSearchScope(1);
        }
        NamingEnumeration<SearchResult> results = context.search(this.roleBase, filter, constraints);
        while (results.hasMore()) {
            SearchResult result = results.next();
            Attributes attrs = result.getAttributes();
            if (attrs == null) continue;
            list = this.addAttributeValues(this.roleName, attrs, list);
        }
        return list;
    }

    protected String doRFC2254Encoding(String inputString) {
        StringBuffer buf = new StringBuffer(inputString.length());
        block7: for (int i = 0; i < inputString.length(); ++i) {
            char c = inputString.charAt(i);
            switch (c) {
                case '\\': {
                    buf.append("\\5c");
                    continue block7;
                }
                case '*': {
                    buf.append("\\2a");
                    continue block7;
                }
                case '(': {
                    buf.append("\\28");
                    continue block7;
                }
                case ')': {
                    buf.append("\\29");
                    continue block7;
                }
                case '\u0000': {
                    buf.append("\\00");
                    continue block7;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }

    protected boolean bindUser(DirContext context, String dn, String password) throws NamingException {
        boolean isValid = false;
        context.addToEnvironment("java.naming.security.principal", dn);
        context.addToEnvironment("java.naming.security.credentials", password);
        try {
            context.getAttributes("", null);
            isValid = true;
        }
        catch (AuthenticationException e) {
            isValid = false;
            log.debug((Object)("Authentication failed for dn=" + dn));
        }
        if (this.connectionUsername != null) {
            context.addToEnvironment("java.naming.security.principal", this.connectionUsername);
        } else {
            context.removeFromEnvironment("java.naming.security.principal");
        }
        if (this.connectionPassword != null) {
            context.addToEnvironment("java.naming.security.credentials", this.connectionPassword);
        } else {
            context.removeFromEnvironment("java.naming.security.credentials");
        }
        return isValid;
    }

    private ArrayList addAttributeValues(String attrId, Attributes attrs, ArrayList values) throws NamingException {
        Attribute attr;
        if (attrId == null || attrs == null) {
            return values;
        }
        if (values == null) {
            values = new ArrayList<String>();
        }
        if ((attr = attrs.get(attrId)) == null) {
            return values;
        }
        NamingEnumeration<?> e = attr.getAll();
        while (e.hasMore()) {
            String value = (String)e.next();
            values.add(value);
        }
        return values;
    }

    protected DirContext open() throws NamingException {
        if (this.context != null) {
            return this.context;
        }
        try {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", this.initialContextFactory);
            if (this.connectionUsername != null || !"".equals(this.connectionUsername)) {
                env.put("java.naming.security.principal", this.connectionUsername);
            }
            if (this.connectionPassword != null || !"".equals(this.connectionPassword)) {
                env.put("java.naming.security.credentials", this.connectionPassword);
            }
            env.put("java.naming.security.protocol", this.connectionProtocol);
            env.put("java.naming.provider.url", this.connectionURL);
            env.put("java.naming.security.authentication", this.authentication);
            this.context = new InitialDirContext(env);
        }
        catch (NamingException e) {
            log.error((Object)e);
            throw e;
        }
        return this.context;
    }
}

