/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadb;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.activemq.ActiveMQMessageAuditNoSync;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.BrokerServiceAware;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.protobuf.Buffer;
import org.apache.activemq.store.kahadb.JournalCommand;
import org.apache.activemq.store.kahadb.TransactionIdConversion;
import org.apache.activemq.store.kahadb.Visitor;
import org.apache.activemq.store.kahadb.data.KahaAckMessageFileMapCommand;
import org.apache.activemq.store.kahadb.data.KahaAddMessageCommand;
import org.apache.activemq.store.kahadb.data.KahaCommitCommand;
import org.apache.activemq.store.kahadb.data.KahaDestination;
import org.apache.activemq.store.kahadb.data.KahaEntryType;
import org.apache.activemq.store.kahadb.data.KahaPrepareCommand;
import org.apache.activemq.store.kahadb.data.KahaProducerAuditCommand;
import org.apache.activemq.store.kahadb.data.KahaRemoveDestinationCommand;
import org.apache.activemq.store.kahadb.data.KahaRemoveMessageCommand;
import org.apache.activemq.store.kahadb.data.KahaRollbackCommand;
import org.apache.activemq.store.kahadb.data.KahaSubscriptionCommand;
import org.apache.activemq.store.kahadb.data.KahaTraceCommand;
import org.apache.activemq.store.kahadb.data.KahaTransactionInfo;
import org.apache.activemq.store.kahadb.data.KahaUpdateMessageCommand;
import org.apache.activemq.store.kahadb.disk.index.BTreeIndex;
import org.apache.activemq.store.kahadb.disk.index.BTreeVisitor;
import org.apache.activemq.store.kahadb.disk.index.ListIndex;
import org.apache.activemq.store.kahadb.disk.journal.DataFile;
import org.apache.activemq.store.kahadb.disk.journal.Journal;
import org.apache.activemq.store.kahadb.disk.journal.Location;
import org.apache.activemq.store.kahadb.disk.page.Page;
import org.apache.activemq.store.kahadb.disk.page.PageFile;
import org.apache.activemq.store.kahadb.disk.page.Transaction;
import org.apache.activemq.store.kahadb.disk.util.LocationMarshaller;
import org.apache.activemq.store.kahadb.disk.util.LongMarshaller;
import org.apache.activemq.store.kahadb.disk.util.Marshaller;
import org.apache.activemq.store.kahadb.disk.util.Sequence;
import org.apache.activemq.store.kahadb.disk.util.SequenceSet;
import org.apache.activemq.store.kahadb.disk.util.StringMarshaller;
import org.apache.activemq.store.kahadb.disk.util.VariableMarshaller;
import org.apache.activemq.util.ByteSequence;
import org.apache.activemq.util.DataByteArrayInputStream;
import org.apache.activemq.util.DataByteArrayOutputStream;
import org.apache.activemq.util.IOHelper;
import org.apache.activemq.util.ServiceStopper;
import org.apache.activemq.util.ServiceSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MessageDatabase
extends ServiceSupport
implements BrokerServiceAware {
    protected BrokerService brokerService;
    public static final String PROPERTY_LOG_SLOW_ACCESS_TIME = "org.apache.activemq.store.kahadb.LOG_SLOW_ACCESS_TIME";
    public static final int LOG_SLOW_ACCESS_TIME = Integer.getInteger("org.apache.activemq.store.kahadb.LOG_SLOW_ACCESS_TIME", 0);
    public static final File DEFAULT_DIRECTORY = new File("KahaDB");
    protected static final Buffer UNMATCHED = new Buffer(new byte[0]);
    private static final Logger LOG = LoggerFactory.getLogger(MessageDatabase.class);
    static final int CLOSED_STATE = 1;
    static final int OPEN_STATE = 2;
    static final long NOT_ACKED = -1L;
    static final int VERSION = 5;
    protected PageFile pageFile;
    protected Journal journal;
    protected Metadata metadata = new Metadata();
    protected MetadataMarshaller metadataMarshaller = new MetadataMarshaller();
    protected boolean failIfDatabaseIsLocked;
    protected boolean deleteAllMessages;
    protected File directory = DEFAULT_DIRECTORY;
    protected File indexDirectory = null;
    protected Thread checkpointThread;
    protected boolean enableJournalDiskSyncs = true;
    protected boolean archiveDataLogs;
    protected File directoryArchive;
    protected AtomicLong journalSize = new AtomicLong(0L);
    long checkpointInterval = 5000L;
    long cleanupInterval = 30000L;
    int journalMaxFileLength = 0x2000000;
    int journalMaxWriteBatchSize = 0x400000;
    boolean enableIndexWriteAsync = false;
    int setIndexWriteBatchSize = PageFile.DEFAULT_WRITE_BATCH_SIZE;
    protected AtomicBoolean opened = new AtomicBoolean();
    private boolean ignoreMissingJournalfiles = false;
    private int indexCacheSize = 10000;
    private boolean checkForCorruptJournalFiles = false;
    private boolean checksumJournalFiles = true;
    protected boolean forceRecoverIndex = false;
    private final Object checkpointThreadLock = new Object();
    private boolean rewriteOnRedelivery = false;
    private boolean archiveCorruptedIndex = false;
    private boolean useIndexLFRUEviction = false;
    private float indexLFUEvictionFactor = 0.2f;
    private boolean enableIndexDiskSyncs = true;
    private boolean enableIndexRecoveryFile = true;
    private boolean enableIndexPageCaching = true;
    ReentrantReadWriteLock checkpointLock = new ReentrantReadWriteLock();
    private Location nextRecoveryPosition;
    private Location lastRecoveryPosition;
    protected final ReentrantReadWriteLock indexLock = new ReentrantReadWriteLock();
    private final HashSet<Integer> journalFilesBeingReplicated = new HashSet();
    final Runnable nullCompletionCallback = new Runnable(){

        @Override
        public void run() {
        }
    };
    protected final HashMap<String, StoredDestination> storedDestinations = new HashMap();
    private final LinkedHashMap<TransactionId, List<Operation>> inflightTransactions = new LinkedHashMap();
    protected final LinkedHashMap<TransactionId, List<Operation>> preparedTransactions = new LinkedHashMap();
    protected final Set<String> ackedAndPrepared = new HashSet<String>();
    protected final Set<String> rolledBackAcks = new HashSet<String>();

    public void doStart() throws Exception {
        this.load();
    }

    public void doStop(ServiceStopper stopper) throws Exception {
        this.unload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPageFile() throws IOException {
        this.indexLock.writeLock().lock();
        try {
            final PageFile pageFile = this.getPageFile();
            pageFile.load();
            pageFile.tx().execute(new Transaction.Closure<IOException>(){

                @Override
                public void execute(Transaction tx) throws IOException {
                    if (pageFile.getPageCount() == 0L) {
                        Page<Metadata> page = tx.allocate();
                        assert (page.getPageId() == 0L);
                        page.set(MessageDatabase.this.metadata);
                        MessageDatabase.this.metadata.page = page;
                        MessageDatabase.this.metadata.state = 1;
                        MessageDatabase.this.metadata.destinations = new BTreeIndex(pageFile, tx.allocate().getPageId());
                        tx.store(MessageDatabase.this.metadata.page, MessageDatabase.this.metadataMarshaller, true);
                    } else {
                        Page<Metadata> page = tx.load(0L, MessageDatabase.this.metadataMarshaller);
                        MessageDatabase.this.metadata = page.get();
                        MessageDatabase.this.metadata.page = page;
                    }
                    MessageDatabase.this.metadata.destinations.setKeyMarshaller(StringMarshaller.INSTANCE);
                    MessageDatabase.this.metadata.destinations.setValueMarshaller(new StoredDestinationMarshaller());
                    MessageDatabase.this.metadata.destinations.load(tx);
                }
            });
            this.storedDestinations.clear();
            pageFile.tx().execute(new Transaction.Closure<IOException>(){

                @Override
                public void execute(Transaction tx) throws IOException {
                    Iterator<Map.Entry<String, StoredDestination>> iterator = MessageDatabase.this.metadata.destinations.iterator(tx);
                    while (iterator.hasNext()) {
                        Map.Entry<String, StoredDestination> entry = iterator.next();
                        StoredDestination sd = MessageDatabase.this.loadStoredDestination(tx, entry.getKey(), entry.getValue().subscriptions != null);
                        MessageDatabase.this.storedDestinations.put(entry.getKey(), sd);
                        if (!MessageDatabase.this.checkForCorruptJournalFiles || entry.getValue().locationIndex.isEmpty(tx) || entry.getValue().orderIndex.nextMessageId > 0L) continue;
                        throw new IOException("Detected uninitialized orderIndex nextMessageId with pending messages for " + entry.getKey());
                    }
                }
            });
            pageFile.flush();
        }
        finally {
            this.indexLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startCheckpoint() {
        if (this.checkpointInterval == 0L && this.cleanupInterval == 0L) {
            LOG.info("periodic checkpoint/cleanup disabled, will ocurr on clean shutdown/restart");
            return;
        }
        Object object = this.checkpointThreadLock;
        synchronized (object) {
            boolean start = false;
            if (this.checkpointThread == null) {
                start = true;
            } else if (!this.checkpointThread.isAlive()) {
                start = true;
                LOG.info("KahaDB: Recovering checkpoint thread after death");
            }
            if (start) {
                this.checkpointThread = new Thread("ActiveMQ Journal Checkpoint Worker"){

                    @Override
                    public void run() {
                        try {
                            long lastCleanup = System.currentTimeMillis();
                            long lastCheckpoint = System.currentTimeMillis();
                            long sleepTime = Math.min(MessageDatabase.this.checkpointInterval > 0L ? MessageDatabase.this.checkpointInterval : MessageDatabase.this.cleanupInterval, 500L);
                            while (MessageDatabase.this.opened.get()) {
                                Thread.sleep(sleepTime);
                                long now = System.currentTimeMillis();
                                if (MessageDatabase.this.cleanupInterval > 0L && now - lastCleanup >= MessageDatabase.this.cleanupInterval) {
                                    MessageDatabase.this.checkpointCleanup(true);
                                    lastCleanup = now;
                                    lastCheckpoint = now;
                                    continue;
                                }
                                if (MessageDatabase.this.checkpointInterval <= 0L || now - lastCheckpoint < MessageDatabase.this.checkpointInterval) continue;
                                MessageDatabase.this.checkpointCleanup(false);
                                lastCheckpoint = now;
                            }
                        }
                        catch (InterruptedException e) {
                        }
                        catch (IOException ioe) {
                            LOG.error("Checkpoint failed", (Throwable)ioe);
                            MessageDatabase.this.brokerService.handleIOException(ioe);
                        }
                    }
                };
                this.checkpointThread.setDaemon(true);
                this.checkpointThread.start();
            }
        }
    }

    public void open() throws IOException {
        if (this.opened.compareAndSet(false, true)) {
            this.getJournal().start();
            try {
                this.loadPageFile();
            }
            catch (Throwable t) {
                LOG.warn("Index corrupted. Recovering the index through journal replay. Cause:" + t);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Index load failure", t);
                }
                try {
                    this.pageFile.unload();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.archiveCorruptedIndex) {
                    this.pageFile.archive();
                } else {
                    this.pageFile.delete();
                }
                this.metadata = this.createMetadata();
                this.pageFile = null;
                this.loadPageFile();
            }
            this.startCheckpoint();
            this.recover();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws IOException {
        this.indexLock.writeLock().lock();
        IOHelper.mkdirs((File)this.directory);
        try {
            if (this.deleteAllMessages) {
                this.getJournal().start();
                this.getJournal().delete();
                this.getJournal().close();
                this.journal = null;
                this.getPageFile().delete();
                LOG.info("Persistence store purged.");
                this.deleteAllMessages = false;
            }
            this.open();
            this.store((JournalCommand)new KahaTraceCommand().setMessage("LOADED " + new Date()));
        }
        finally {
            this.indexLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException, InterruptedException {
        if (this.opened.compareAndSet(true, false)) {
            this.checkpointLock.writeLock().lock();
            try {
                if (this.metadata.page != null) {
                    this.checkpointUpdate(true);
                }
                this.pageFile.unload();
                this.metadata = this.createMetadata();
            }
            finally {
                this.checkpointLock.writeLock().unlock();
            }
            this.journal.close();
            Object object = this.checkpointThreadLock;
            synchronized (object) {
                if (this.checkpointThread != null) {
                    this.checkpointThread.join();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unload() throws IOException, InterruptedException {
        this.indexLock.writeLock().lock();
        try {
            if (this.pageFile != null && this.pageFile.isLoaded()) {
                this.metadata.state = 1;
                this.metadata.firstInProgressTransactionLocation = this.getInProgressTxLocationRange()[0];
                if (this.metadata.page != null) {
                    this.pageFile.tx().execute(new Transaction.Closure<IOException>(){

                        @Override
                        public void execute(Transaction tx) throws IOException {
                            tx.store(MessageDatabase.this.metadata.page, MessageDatabase.this.metadataMarshaller, true);
                        }
                    });
                }
            }
        }
        finally {
            this.indexLock.writeLock().unlock();
        }
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Location[] getInProgressTxLocationRange() {
        Location[] range = new Location[]{null, null};
        LinkedHashMap<TransactionId, List<Operation>> linkedHashMap = this.inflightTransactions;
        synchronized (linkedHashMap) {
            if (!this.inflightTransactions.isEmpty()) {
                for (List<Operation> ops : this.inflightTransactions.values()) {
                    if (ops.isEmpty()) continue;
                    this.trackMaxAndMin(range, ops);
                }
            }
            if (!this.preparedTransactions.isEmpty()) {
                for (List<Operation> ops : this.preparedTransactions.values()) {
                    if (ops.isEmpty()) continue;
                    this.trackMaxAndMin(range, ops);
                }
            }
        }
        return range;
    }

    private void trackMaxAndMin(Location[] range, List<Operation> ops) {
        Location t = ops.get(0).getLocation();
        if (range[0] == null || t.compareTo(range[0]) <= 0) {
            range[0] = t;
        }
        t = ops.get(ops.size() - 1).getLocation();
        if (range[1] == null || t.compareTo(range[1]) >= 0) {
            range[1] = t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTransactions() {
        TranInfo info;
        ArrayList<TranInfo> infos = new ArrayList<TranInfo>();
        LinkedHashMap<TransactionId, List<Operation>> linkedHashMap = this.inflightTransactions;
        synchronized (linkedHashMap) {
            if (!this.inflightTransactions.isEmpty()) {
                for (Map.Entry<TransactionId, List<Operation>> entry : this.inflightTransactions.entrySet()) {
                    info = new TranInfo();
                    info.id = entry.getKey();
                    for (Operation operation : entry.getValue()) {
                        info.track(operation);
                    }
                    infos.add(info);
                }
            }
        }
        linkedHashMap = this.preparedTransactions;
        synchronized (linkedHashMap) {
            if (!this.preparedTransactions.isEmpty()) {
                for (Map.Entry<TransactionId, List<Operation>> entry : this.preparedTransactions.entrySet()) {
                    info = new TranInfo();
                    info.id = entry.getKey();
                    for (Operation operation : entry.getValue()) {
                        info.track(operation);
                    }
                    infos.add(info);
                }
            }
        }
        return infos.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recover() throws IllegalStateException, IOException {
        this.indexLock.writeLock().lock();
        try {
            long start = System.currentTimeMillis();
            Location producerAuditPosition = this.recoverProducerAudit();
            Location ackMessageFileLocation = this.recoverAckMessageFileMap();
            Location lastIndoubtPosition = this.getRecoveryPosition();
            Location recoveryPosition = this.minimum(producerAuditPosition, ackMessageFileLocation);
            recoveryPosition = this.minimum(recoveryPosition, lastIndoubtPosition);
            if (recoveryPosition != null) {
                int redoCounter = 0;
                LOG.info("Recovering from the journal ...");
                while (recoveryPosition != null) {
                    JournalCommand<?> message = this.load(recoveryPosition);
                    this.metadata.lastUpdate = recoveryPosition;
                    this.process(message, recoveryPosition, lastIndoubtPosition);
                    recoveryPosition = this.journal.getNextLocation(recoveryPosition);
                    if (!LOG.isInfoEnabled() || ++redoCounter % 100000 != 0) continue;
                    LOG.info("@" + recoveryPosition + ", " + redoCounter + " entries recovered ..");
                }
                if (LOG.isInfoEnabled()) {
                    long end = System.currentTimeMillis();
                    LOG.info("Recovery replayed " + redoCounter + " operations from the journal in " + (float)(end - start) / 1000.0f + " seconds.");
                }
            }
            this.pageFile.tx().execute(new Transaction.Closure<IOException>(){

                @Override
                public void execute(Transaction tx) throws IOException {
                    MessageDatabase.this.recoverIndex(tx);
                }
            });
            HashSet<TransactionId> toRollback = new HashSet<TransactionId>();
            HashSet<TransactionId> toDiscard = new HashSet<TransactionId>();
            LinkedHashMap<TransactionId, List<Operation>> linkedHashMap = this.inflightTransactions;
            synchronized (linkedHashMap) {
                for (TransactionId id : this.inflightTransactions.keySet()) {
                    if (id.isLocalTransaction()) {
                        toRollback.add(id);
                        continue;
                    }
                    toDiscard.add(id);
                }
                for (TransactionId tx : toRollback) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("rolling back recovered indoubt local transaction " + tx);
                    }
                    this.store((JournalCommand)new KahaRollbackCommand().setTransactionInfo(TransactionIdConversion.convertToLocal(tx)), false, null, null);
                }
                for (TransactionId tx : toDiscard) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("discarding recovered in-flight XA transaction " + tx);
                    }
                    this.inflightTransactions.remove(tx);
                }
            }
            linkedHashMap = this.preparedTransactions;
            synchronized (linkedHashMap) {
                for (TransactionId txId : this.preparedTransactions.keySet()) {
                    LOG.warn("Recovered prepared XA TX: [{}]", (Object)txId);
                }
            }
        }
        finally {
            this.indexLock.writeLock().unlock();
        }
    }

    private KahaTransactionInfo createLocalTransactionInfo(TransactionId tx) {
        return TransactionIdConversion.convertToLocal(tx);
    }

    private Location minimum(Location producerAuditPosition, Location lastIndoubtPosition) {
        Location min = null;
        if (producerAuditPosition != null) {
            min = producerAuditPosition;
            if (lastIndoubtPosition != null && lastIndoubtPosition.compareTo(producerAuditPosition) < 0) {
                min = lastIndoubtPosition;
            }
        } else {
            min = lastIndoubtPosition;
        }
        return min;
    }

    private Location recoverProducerAudit() throws IOException {
        if (this.metadata.producerSequenceIdTrackerLocation != null) {
            KahaProducerAuditCommand audit = (KahaProducerAuditCommand)this.load(this.metadata.producerSequenceIdTrackerLocation);
            try {
                ObjectInputStream objectIn = new ObjectInputStream((InputStream)audit.getAudit().newInput());
                int maxNumProducers = this.getMaxFailoverProducersToTrack();
                int maxAuditDepth = this.getFailoverProducersAuditDepth();
                this.metadata.producerSequenceIdTracker = (ActiveMQMessageAuditNoSync)objectIn.readObject();
                this.metadata.producerSequenceIdTracker.setAuditDepth(maxAuditDepth);
                this.metadata.producerSequenceIdTracker.setMaximumNumberOfProducersToTrack(maxNumProducers);
                return this.journal.getNextLocation(this.metadata.producerSequenceIdTrackerLocation);
            }
            catch (Exception e) {
                LOG.warn("Cannot recover message audit", (Throwable)e);
                return this.journal.getNextLocation(null);
            }
        }
        return this.journal.getNextLocation(null);
    }

    private Location recoverAckMessageFileMap() throws IOException {
        if (this.metadata.ackMessageFileMapLocation != null) {
            KahaAckMessageFileMapCommand audit = (KahaAckMessageFileMapCommand)this.load(this.metadata.ackMessageFileMapLocation);
            try {
                ObjectInputStream objectIn = new ObjectInputStream((InputStream)audit.getAckMessageFileMap().newInput());
                this.metadata.ackMessageFileMap = (Map)objectIn.readObject();
                return this.journal.getNextLocation(this.metadata.ackMessageFileMapLocation);
            }
            catch (Exception e) {
                LOG.warn("Cannot recover ackMessageFileMap", (Throwable)e);
                return this.journal.getNextLocation(null);
            }
        }
        return this.journal.getNextLocation(null);
    }

    protected void recoverIndex(Transaction tx) throws IOException {
        long start = System.currentTimeMillis();
        Location lastAppendLocation = this.journal.getLastAppendLocation();
        long undoCounter = 0L;
        for (StoredDestination sd : this.storedDestinations.values()) {
            final ArrayList matches = new ArrayList();
            sd.locationIndex.visit(tx, (BTreeVisitor<Location, Long>)new BTreeVisitor.GTEVisitor<Location, Long>(lastAppendLocation){

                @Override
                protected void matched(Location key, Long value) {
                    matches.add(value);
                }
            });
            for (Long sequenceId : matches) {
                MessageKeys keys = sd.orderIndex.remove(tx, sequenceId);
                sd.locationIndex.remove(tx, keys.location);
                sd.messageIdIndex.remove(tx, keys.messageId);
                this.metadata.producerSequenceIdTracker.rollback(keys.messageId);
                ++undoCounter;
            }
        }
        if (undoCounter > 0L && LOG.isInfoEnabled()) {
            long end = System.currentTimeMillis();
            LOG.info("Rolled back " + undoCounter + " messages from the index in " + (float)(end - start) / 1000.0f + " seconds.");
        }
        undoCounter = 0L;
        start = System.currentTimeMillis();
        final SequenceSet ss = new SequenceSet();
        for (StoredDestination sd : this.storedDestinations.values()) {
            sd.locationIndex.visit(tx, new BTreeVisitor<Location, Long>(){
                int last = -1;

                @Override
                public boolean isInterestedInKeysBetween(Location first, Location second) {
                    if (first == null) {
                        return !ss.contains(0, second.getDataFileId());
                    }
                    if (second == null) {
                        return true;
                    }
                    return !ss.contains(first.getDataFileId(), second.getDataFileId());
                }

                @Override
                public void visit(List<Location> keys, List<Long> values) {
                    for (Location l : keys) {
                        int fileId = l.getDataFileId();
                        if (this.last == fileId) continue;
                        ss.add(fileId);
                        this.last = fileId;
                    }
                }
            });
        }
        HashSet<Integer> missingJournalFiles = new HashSet<Integer>();
        while (!ss.isEmpty()) {
            missingJournalFiles.add((int)ss.removeFirst());
        }
        missingJournalFiles.removeAll(this.journal.getFileMap().keySet());
        if (!missingJournalFiles.isEmpty() && LOG.isInfoEnabled()) {
            LOG.info("Some journal files are missing: " + missingJournalFiles);
        }
        ArrayList missingPredicates = new ArrayList();
        for (Integer missing : missingJournalFiles) {
            missingPredicates.add(new BTreeVisitor.BetweenVisitor(new Location(missing, 0), new Location(missing + 1, 0)));
        }
        if (this.checkForCorruptJournalFiles) {
            Collection<DataFile> dataFiles = this.journal.getFileMap().values();
            for (DataFile dataFile : dataFiles) {
                int id = dataFile.getDataFileId();
                missingPredicates.add(new BTreeVisitor.BetweenVisitor(new Location(id, dataFile.getLength()), new Location(id + 1, 0)));
                for (Sequence seq = (Sequence)dataFile.getCorruptedBlocks().getHead(); seq != null; seq = (Sequence)seq.getNext()) {
                    missingPredicates.add(new BTreeVisitor.BetweenVisitor(new Location(id, (int)seq.getFirst()), new Location(id, (int)seq.getLast() + 1)));
                }
            }
        }
        if (!missingPredicates.isEmpty()) {
            for (StoredDestination sd : this.storedDestinations.values()) {
                final ArrayList matches = new ArrayList();
                sd.locationIndex.visit(tx, (BTreeVisitor<Location, Long>)new BTreeVisitor.OrVisitor<Location, Long>(missingPredicates){

                    @Override
                    protected void matched(Location key, Long value) {
                        matches.add(value);
                    }
                });
                if (matches.isEmpty()) continue;
                if (this.ignoreMissingJournalfiles) {
                    for (Long sequenceId : matches) {
                        MessageKeys keys = sd.orderIndex.remove(tx, sequenceId);
                        sd.locationIndex.remove(tx, keys.location);
                        sd.messageIdIndex.remove(tx, keys.messageId);
                        ++undoCounter;
                    }
                    continue;
                }
                throw new IOException("Detected missing/corrupt journal files. " + matches.size() + " messages affected.");
            }
        }
        if (undoCounter > 0L && LOG.isInfoEnabled()) {
            long end = System.currentTimeMillis();
            LOG.info("Detected missing/corrupt journal files.  Dropped " + undoCounter + " messages from the index in " + (float)(end - start) / 1000.0f + " seconds.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementalRecover() throws IOException {
        this.indexLock.writeLock().lock();
        try {
            if (this.nextRecoveryPosition == null) {
                this.nextRecoveryPosition = this.lastRecoveryPosition == null ? this.getRecoveryPosition() : this.journal.getNextLocation(this.lastRecoveryPosition);
            }
            while (this.nextRecoveryPosition != null) {
                this.metadata.lastUpdate = this.lastRecoveryPosition = this.nextRecoveryPosition;
                JournalCommand<?> message = this.load(this.lastRecoveryPosition);
                this.process(message, this.lastRecoveryPosition, (IndexAware)null);
                this.nextRecoveryPosition = this.journal.getNextLocation(this.lastRecoveryPosition);
            }
        }
        finally {
            this.indexLock.writeLock().unlock();
        }
    }

    public Location getLastUpdatePosition() throws IOException {
        return this.metadata.lastUpdate;
    }

    private Location getRecoveryPosition() throws IOException {
        if (!this.forceRecoverIndex) {
            if (this.metadata.firstInProgressTransactionLocation != null) {
                return this.metadata.firstInProgressTransactionLocation;
            }
            if (this.metadata.lastUpdate != null) {
                return this.journal.getNextLocation(this.metadata.lastUpdate);
            }
        }
        return this.journal.getNextLocation(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkpointCleanup(boolean cleanup) throws IOException {
        long start;
        this.indexLock.writeLock().lock();
        try {
            start = System.currentTimeMillis();
            if (!this.opened.get()) {
                return;
            }
        }
        finally {
            this.indexLock.writeLock().unlock();
        }
        this.checkpointUpdate(cleanup);
        long end = System.currentTimeMillis();
        if (LOG_SLOW_ACCESS_TIME > 0 && end - start > (long)LOG_SLOW_ACCESS_TIME && LOG.isInfoEnabled()) {
            LOG.info("Slow KahaDB access: cleanup took " + (end - start));
        }
    }

    public ByteSequence toByteSequence(JournalCommand<?> data) throws IOException {
        int size = data.serializedSizeFramed();
        DataByteArrayOutputStream os = new DataByteArrayOutputStream(size + 1);
        os.writeByte(data.type().getNumber());
        data.writeFramed((OutputStream)os);
        return os.toByteSequence();
    }

    public Location store(JournalCommand<?> data) throws IOException {
        return this.store(data, false, null, null);
    }

    public Location store(JournalCommand<?> data, Runnable onJournalStoreComplete) throws IOException {
        return this.store(data, false, null, null, onJournalStoreComplete);
    }

    public Location store(JournalCommand<?> data, boolean sync, IndexAware before, Runnable after) throws IOException {
        return this.store(data, sync, before, after, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Location store(JournalCommand<?> data, boolean sync, IndexAware before, Runnable after, Runnable onJournalStoreComplete) throws IOException {
        try {
            Location location;
            ByteSequence sequence = this.toByteSequence(data);
            this.checkpointLock.readLock().lock();
            try {
                long start = System.currentTimeMillis();
                location = onJournalStoreComplete == null ? this.journal.write(sequence, sync) : this.journal.write(sequence, onJournalStoreComplete);
                long start2 = System.currentTimeMillis();
                this.process(data, location, before);
                long end = System.currentTimeMillis();
                if (LOG_SLOW_ACCESS_TIME > 0 && end - start > (long)LOG_SLOW_ACCESS_TIME && LOG.isInfoEnabled()) {
                    LOG.info("Slow KahaDB access: Journal append took: " + (start2 - start) + " ms, Index update took " + (end - start2) + " ms");
                }
            }
            finally {
                this.checkpointLock.readLock().unlock();
            }
            if (after != null) {
                after.run();
            }
            if (this.checkpointThread != null && !this.checkpointThread.isAlive() && this.opened.get()) {
                this.startCheckpoint();
            }
            return location;
        }
        catch (IOException ioe) {
            LOG.error("KahaDB failed to store to Journal", (Throwable)ioe);
            this.brokerService.handleIOException(ioe);
            throw ioe;
        }
    }

    public JournalCommand<?> load(Location location) throws IOException {
        DataByteArrayInputStream is;
        byte readByte;
        KahaEntryType type;
        long start = System.currentTimeMillis();
        ByteSequence data = this.journal.read(location);
        long end = System.currentTimeMillis();
        if (LOG_SLOW_ACCESS_TIME > 0 && end - start > (long)LOG_SLOW_ACCESS_TIME && LOG.isInfoEnabled()) {
            LOG.info("Slow KahaDB access: Journal read took: " + (end - start) + " ms");
        }
        if ((type = KahaEntryType.valueOf(readByte = (is = new DataByteArrayInputStream(data)).readByte())) == null) {
            try {
                is.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            throw new IOException("Could not load journal record. Invalid location: " + location);
        }
        JournalCommand message = (JournalCommand)type.createMessage();
        message.mergeFramed((InputStream)is);
        return message;
    }

    void process(JournalCommand<?> data, Location location, Location inDoubtlocation) throws IOException {
        if (inDoubtlocation != null && location.compareTo(inDoubtlocation) >= 0) {
            KahaSubscriptionCommand kahaSubscriptionCommand;
            if (data instanceof KahaSubscriptionCommand && (kahaSubscriptionCommand = (KahaSubscriptionCommand)data).hasSubscriptionInfo()) {
                LOG.debug("ignoring add sub command during recovery replay:" + data);
                return;
            }
            this.process(data, location, (IndexAware)null);
        } else {
            data.visit(new Visitor(){

                @Override
                public void visit(KahaAddMessageCommand command) throws IOException {
                    MessageDatabase.this.metadata.producerSequenceIdTracker.isDuplicate(command.getMessageId());
                }
            });
        }
    }

    void process(JournalCommand<?> data, final Location location, final IndexAware onSequenceAssignedCallback) throws IOException {
        data.visit(new Visitor(){

            @Override
            public void visit(KahaAddMessageCommand command) throws IOException {
                MessageDatabase.this.process(command, location, onSequenceAssignedCallback);
            }

            @Override
            public void visit(KahaRemoveMessageCommand command) throws IOException {
                MessageDatabase.this.process(command, location);
            }

            @Override
            public void visit(KahaPrepareCommand command) throws IOException {
                MessageDatabase.this.process(command, location);
            }

            @Override
            public void visit(KahaCommitCommand command) throws IOException {
                MessageDatabase.this.process(command, location, onSequenceAssignedCallback);
            }

            @Override
            public void visit(KahaRollbackCommand command) throws IOException {
                MessageDatabase.this.process(command, location);
            }

            @Override
            public void visit(KahaRemoveDestinationCommand command) throws IOException {
                MessageDatabase.this.process(command, location);
            }

            @Override
            public void visit(KahaSubscriptionCommand command) throws IOException {
                MessageDatabase.this.process(command, location);
            }

            @Override
            public void visit(KahaProducerAuditCommand command) throws IOException {
                MessageDatabase.this.processLocation(location);
            }

            @Override
            public void visit(KahaAckMessageFileMapCommand command) throws IOException {
                MessageDatabase.this.processLocation(location);
            }

            @Override
            public void visit(KahaTraceCommand command) {
                MessageDatabase.this.processLocation(location);
            }

            @Override
            public void visit(KahaUpdateMessageCommand command) throws IOException {
                MessageDatabase.this.process(command, location);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(final KahaAddMessageCommand command, final Location location, final IndexAware runWithIndexLock) throws IOException {
        if (command.hasTransactionInfo()) {
            List<Operation> inflightTx = this.getInflightTx(command.getTransactionInfo());
            inflightTx.add(new AddOperation(command, location, runWithIndexLock));
        } else {
            this.indexLock.writeLock().lock();
            try {
                this.pageFile.tx().execute(new Transaction.Closure<IOException>(){

                    @Override
                    public void execute(Transaction tx) throws IOException {
                        long assignedIndex = MessageDatabase.this.updateIndex(tx, command, location);
                        if (runWithIndexLock != null) {
                            runWithIndexLock.sequenceAssignedWithIndexLocked(assignedIndex);
                        }
                    }
                });
            }
            finally {
                this.indexLock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(final KahaUpdateMessageCommand command, final Location location) throws IOException {
        this.indexLock.writeLock().lock();
        try {
            this.pageFile.tx().execute(new Transaction.Closure<IOException>(){

                @Override
                public void execute(Transaction tx) throws IOException {
                    MessageDatabase.this.updateIndex(tx, command, location);
                }
            });
        }
        finally {
            this.indexLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(final KahaRemoveMessageCommand command, final Location location) throws IOException {
        if (command.hasTransactionInfo()) {
            List<Operation> inflightTx = this.getInflightTx(command.getTransactionInfo());
            inflightTx.add(new RemoveOperation(command, location));
        } else {
            this.indexLock.writeLock().lock();
            try {
                this.pageFile.tx().execute(new Transaction.Closure<IOException>(){

                    @Override
                    public void execute(Transaction tx) throws IOException {
                        MessageDatabase.this.updateIndex(tx, command, location);
                    }
                });
            }
            finally {
                this.indexLock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(final KahaRemoveDestinationCommand command, final Location location) throws IOException {
        this.indexLock.writeLock().lock();
        try {
            this.pageFile.tx().execute(new Transaction.Closure<IOException>(){

                @Override
                public void execute(Transaction tx) throws IOException {
                    MessageDatabase.this.updateIndex(tx, command, location);
                }
            });
        }
        finally {
            this.indexLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(final KahaSubscriptionCommand command, final Location location) throws IOException {
        this.indexLock.writeLock().lock();
        try {
            this.pageFile.tx().execute(new Transaction.Closure<IOException>(){

                @Override
                public void execute(Transaction tx) throws IOException {
                    MessageDatabase.this.updateIndex(tx, command, location);
                }
            });
        }
        finally {
            this.indexLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processLocation(Location location) {
        this.indexLock.writeLock().lock();
        try {
            this.metadata.lastUpdate = location;
        }
        finally {
            this.indexLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(KahaCommitCommand command, Location location, IndexAware before) throws IOException {
        List inflightTx;
        TransactionId key = TransactionIdConversion.convert(command.getTransactionInfo());
        LinkedHashMap<TransactionId, List<Operation>> linkedHashMap = this.inflightTransactions;
        synchronized (linkedHashMap) {
            inflightTx = (List)this.inflightTransactions.remove(key);
            if (inflightTx == null) {
                inflightTx = (List)this.preparedTransactions.remove(key);
            }
        }
        if (inflightTx == null) {
            if (before != null) {
                before.sequenceAssignedWithIndexLocked(-1L);
            }
            return;
        }
        final List messagingTx = inflightTx;
        this.indexLock.writeLock().lock();
        try {
            this.pageFile.tx().execute(new Transaction.Closure<IOException>(){

                @Override
                public void execute(Transaction tx) throws IOException {
                    for (Operation op : messagingTx) {
                        op.execute(tx);
                    }
                }
            });
            this.metadata.lastUpdate = location;
        }
        finally {
            this.indexLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(KahaPrepareCommand command, Location location) {
        TransactionId key = TransactionIdConversion.convert(command.getTransactionInfo());
        LinkedHashMap<TransactionId, List<Operation>> linkedHashMap = this.inflightTransactions;
        synchronized (linkedHashMap) {
            List tx = (List)this.inflightTransactions.remove(key);
            if (tx != null) {
                this.preparedTransactions.put(key, tx);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(KahaRollbackCommand command, Location location) throws IOException {
        TransactionId key = TransactionIdConversion.convert(command.getTransactionInfo());
        List updates = null;
        LinkedHashMap<TransactionId, List<Operation>> linkedHashMap = this.inflightTransactions;
        synchronized (linkedHashMap) {
            updates = (List)this.inflightTransactions.remove(key);
            if (updates == null) {
                updates = (List)this.preparedTransactions.remove(key);
            }
        }
    }

    long updateIndex(Transaction tx, KahaAddMessageCommand command, Location location) throws IOException {
        StoredDestination sd = this.getStoredDestination(command.getDestination(), tx);
        if (sd.subscriptions != null && sd.subscriptions.isEmpty(tx)) {
            return -1L;
        }
        int priority = command.getPrioritySupported() ? command.getPriority() : 4;
        long id = sd.orderIndex.getNextMessageId(priority);
        Long previous = sd.locationIndex.put(tx, location, id);
        if (previous == null) {
            previous = sd.messageIdIndex.put(tx, command.getMessageId(), id);
            if (previous == null) {
                sd.orderIndex.put(tx, priority, id, new MessageKeys(command.getMessageId(), location));
                if (sd.subscriptions != null && !sd.subscriptions.isEmpty(tx)) {
                    this.addAckLocationForNewMessage(tx, sd, id);
                }
                this.metadata.lastUpdate = location;
            } else {
                LOG.warn("Duplicate message add attempt rejected. Destination: {}://{}, Message id: {}", new Object[]{command.getDestination().getType(), command.getDestination().getName(), command.getMessageId()});
                sd.messageIdIndex.put(tx, command.getMessageId(), previous);
                sd.locationIndex.remove(tx, location);
                id = -1L;
            }
        } else {
            sd.locationIndex.put(tx, location, previous);
            this.metadata.lastUpdate = location;
        }
        this.metadata.producerSequenceIdTracker.isDuplicate(command.getMessageId());
        return id;
    }

    void trackPendingAdd(KahaDestination destination, Long seq) {
        StoredDestination sd = this.storedDestinations.get(this.key(destination));
        if (sd != null) {
            sd.trackPendingAdd(seq);
        }
    }

    void trackPendingAddComplete(KahaDestination destination, Long seq) {
        StoredDestination sd = this.storedDestinations.get(this.key(destination));
        if (sd != null) {
            sd.trackPendingAddComplete(seq);
        }
    }

    void updateIndex(Transaction tx, KahaUpdateMessageCommand updateMessageCommand, Location location) throws IOException {
        KahaAddMessageCommand command = updateMessageCommand.getMessage();
        StoredDestination sd = this.getStoredDestination(command.getDestination(), tx);
        Long id = sd.messageIdIndex.get(tx, command.getMessageId());
        if (id != null) {
            MessageKeys previousKeys = sd.orderIndex.put(tx, command.getPrioritySupported() ? command.getPriority() : 4, id, new MessageKeys(command.getMessageId(), location));
            sd.locationIndex.put(tx, location, id);
            if (previousKeys != null) {
                sd.locationIndex.remove(tx, previousKeys.location);
            }
            this.metadata.lastUpdate = location;
        } else {
            LOG.warn("Non existent message update attempt rejected. Destination: {}://{}, Message id: {}", new Object[]{command.getDestination().getType(), command.getDestination().getName(), command.getMessageId()});
        }
    }

    void updateIndex(Transaction tx, KahaRemoveMessageCommand command, Location ackLocation) throws IOException {
        StoredDestination sd = this.getStoredDestination(command.getDestination(), tx);
        if (!command.hasSubscriptionKey()) {
            Long sequenceId = sd.messageIdIndex.remove(tx, command.getMessageId());
            if (sequenceId != null) {
                MessageKeys keys = sd.orderIndex.remove(tx, sequenceId);
                if (keys != null) {
                    sd.locationIndex.remove(tx, keys.location);
                    this.recordAckMessageReferenceLocation(ackLocation, keys.location);
                    this.metadata.lastUpdate = ackLocation;
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug("message not found in order index: " + sequenceId + " for: " + command.getMessageId());
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("message not found in sequence id index: " + command.getMessageId());
            }
        } else {
            Long sequence = sd.messageIdIndex.get(tx, command.getMessageId());
            if (sequence != null) {
                MessageKeys keys;
                String subscriptionKey = command.getSubscriptionKey();
                if (command.getAck() != UNMATCHED) {
                    sd.orderIndex.get(tx, sequence);
                    byte priority = sd.orderIndex.lastGetPriority();
                    sd.subscriptionAcks.put(tx, subscriptionKey, new LastAck(sequence, priority));
                }
                if ((keys = sd.orderIndex.get(tx, sequence)) != null) {
                    this.recordAckMessageReferenceLocation(ackLocation, keys.location);
                }
                this.removeAckLocation(tx, sd, subscriptionKey, sequence);
                this.metadata.lastUpdate = ackLocation;
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("no message sequence exists for id: " + command.getMessageId() + " and sub: " + command.getSubscriptionKey());
            }
        }
    }

    private void recordAckMessageReferenceLocation(Location ackLocation, Location messageLocation) {
        Set<Integer> referenceFileIds = this.metadata.ackMessageFileMap.get(ackLocation.getDataFileId());
        if (referenceFileIds == null) {
            referenceFileIds = new HashSet<Integer>();
            referenceFileIds.add(messageLocation.getDataFileId());
            this.metadata.ackMessageFileMap.put(ackLocation.getDataFileId(), referenceFileIds);
        } else {
            Integer id = messageLocation.getDataFileId();
            if (!referenceFileIds.contains(id)) {
                referenceFileIds.add(id);
            }
        }
    }

    void updateIndex(Transaction tx, KahaRemoveDestinationCommand command, Location location) throws IOException {
        StoredDestination sd = this.getStoredDestination(command.getDestination(), tx);
        sd.orderIndex.remove(tx);
        sd.locationIndex.clear(tx);
        sd.locationIndex.unload(tx);
        tx.free(sd.locationIndex.getPageId());
        sd.messageIdIndex.clear(tx);
        sd.messageIdIndex.unload(tx);
        tx.free(sd.messageIdIndex.getPageId());
        if (sd.subscriptions != null) {
            sd.subscriptions.clear(tx);
            sd.subscriptions.unload(tx);
            tx.free(sd.subscriptions.getPageId());
            sd.subscriptionAcks.clear(tx);
            sd.subscriptionAcks.unload(tx);
            tx.free(sd.subscriptionAcks.getPageId());
            sd.ackPositions.clear(tx);
            sd.ackPositions.unload(tx);
            tx.free(sd.ackPositions.getHeadPageId());
            sd.subLocations.clear(tx);
            sd.subLocations.unload(tx);
            tx.free(sd.subLocations.getHeadPageId());
        }
        String key = this.key(command.getDestination());
        this.storedDestinations.remove(key);
        this.metadata.destinations.remove(tx, key);
    }

    void updateIndex(Transaction tx, KahaSubscriptionCommand command, Location location) throws IOException {
        StoredDestination sd = this.getStoredDestination(command.getDestination(), tx);
        String subscriptionKey = command.getSubscriptionKey();
        if (command.hasSubscriptionInfo()) {
            sd.subscriptions.put(tx, subscriptionKey, command);
            sd.subLocations.put(tx, subscriptionKey, location);
            long ackLocation = -1L;
            if (!command.getRetroactive()) {
                ackLocation = sd.orderIndex.nextMessageId - 1L;
            } else {
                this.addAckLocationForRetroactiveSub(tx, sd, subscriptionKey);
            }
            sd.subscriptionAcks.put(tx, subscriptionKey, new LastAck(ackLocation));
            sd.subscriptionCache.add(subscriptionKey);
        } else {
            sd.subscriptions.remove(tx, subscriptionKey);
            sd.subLocations.remove(tx, subscriptionKey);
            sd.subscriptionAcks.remove(tx, subscriptionKey);
            sd.subscriptionCache.remove(subscriptionKey);
            this.removeAckLocationsForSub(tx, sd, subscriptionKey);
            if (sd.subscriptions.isEmpty(tx)) {
                sd.messageIdIndex.clear(tx);
                sd.locationIndex.clear(tx);
                sd.orderIndex.clear(tx);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkpointUpdate(final boolean cleanup) throws IOException {
        this.checkpointLock.writeLock().lock();
        try {
            this.indexLock.writeLock().lock();
            try {
                this.pageFile.tx().execute(new Transaction.Closure<IOException>(){

                    @Override
                    public void execute(Transaction tx) throws IOException {
                        MessageDatabase.this.checkpointUpdate(tx, cleanup);
                    }
                });
            }
            finally {
                this.indexLock.writeLock().unlock();
            }
        }
        finally {
            this.checkpointLock.writeLock().unlock();
        }
    }

    void checkpointUpdate(Transaction tx, boolean cleanup) throws IOException {
        LOG.debug("Checkpoint started.");
        Location lastUpdate = this.metadata.lastUpdate;
        this.metadata.state = 2;
        this.metadata.producerSequenceIdTrackerLocation = this.checkpointProducerAudit();
        this.metadata.ackMessageFileMapLocation = this.checkpointAckMessageFileMap();
        Location[] inProgressTxRange = this.getInProgressTxLocationRange();
        this.metadata.firstInProgressTransactionLocation = inProgressTxRange[0];
        tx.store(this.metadata.page, this.metadataMarshaller, true);
        this.pageFile.flush();
        if (cleanup) {
            int dataFileId;
            TreeSet<Integer> completeFileSet = new TreeSet<Integer>(this.journal.getFileMap().keySet());
            final TreeSet<Integer> gcCandidateSet = new TreeSet<Integer>((SortedSet<Integer>)completeFileSet);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Last update: " + lastUpdate + ", full gc candidates set: " + gcCandidateSet);
            }
            if (lastUpdate != null) {
                gcCandidateSet.remove(lastUpdate.getDataFileId());
            }
            if (this.journalFilesBeingReplicated != null) {
                gcCandidateSet.removeAll(this.journalFilesBeingReplicated);
            }
            if (this.metadata.producerSequenceIdTrackerLocation != null) {
                dataFileId = this.metadata.producerSequenceIdTrackerLocation.getDataFileId();
                if (gcCandidateSet.contains(dataFileId) && gcCandidateSet.first() == dataFileId) {
                    this.metadata.producerSequenceIdTracker.setModified(true);
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("rewriting producerSequenceIdTracker:" + this.metadata.producerSequenceIdTrackerLocation);
                    }
                }
                gcCandidateSet.remove(dataFileId);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("gc candidates after producerSequenceIdTrackerLocation:" + dataFileId + ", " + gcCandidateSet);
                }
            }
            if (this.metadata.ackMessageFileMapLocation != null) {
                dataFileId = this.metadata.ackMessageFileMapLocation.getDataFileId();
                gcCandidateSet.remove(dataFileId);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("gc candidates after ackMessageFileMapLocation:" + dataFileId + ", " + gcCandidateSet);
                }
            }
            if (inProgressTxRange[0] != null) {
                for (int pendingTx = inProgressTxRange[0].getDataFileId(); pendingTx <= inProgressTxRange[1].getDataFileId(); ++pendingTx) {
                    gcCandidateSet.remove(pendingTx);
                }
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("gc candidates after tx range:" + Arrays.asList(inProgressTxRange) + ", " + gcCandidateSet);
            }
            for (Map.Entry<String, StoredDestination> entry : this.storedDestinations.entrySet()) {
                if (gcCandidateSet.isEmpty()) break;
                entry.getValue().locationIndex.visit(tx, new BTreeVisitor<Location, Long>(){
                    int last = -1;

                    @Override
                    public boolean isInterestedInKeysBetween(Location first, Location second) {
                        if (first == null) {
                            SortedSet<Integer> subset = gcCandidateSet.headSet(second.getDataFileId() + 1);
                            if (!subset.isEmpty() && subset.last().intValue() == second.getDataFileId()) {
                                subset.remove(second.getDataFileId());
                            }
                            return !subset.isEmpty();
                        }
                        if (second == null) {
                            SortedSet<Integer> subset = gcCandidateSet.tailSet(first.getDataFileId());
                            if (!subset.isEmpty() && subset.first().intValue() == first.getDataFileId()) {
                                subset.remove(first.getDataFileId());
                            }
                            return !subset.isEmpty();
                        }
                        SortedSet<Integer> subset = gcCandidateSet.subSet(first.getDataFileId(), second.getDataFileId() + 1);
                        if (!subset.isEmpty() && subset.first().intValue() == first.getDataFileId()) {
                            subset.remove(first.getDataFileId());
                        }
                        if (!subset.isEmpty() && subset.last().intValue() == second.getDataFileId()) {
                            subset.remove(second.getDataFileId());
                        }
                        return !subset.isEmpty();
                    }

                    @Override
                    public void visit(List<Location> keys, List<Long> values) {
                        for (Location l : keys) {
                            int fileId = l.getDataFileId();
                            if (this.last == fileId) continue;
                            gcCandidateSet.remove(fileId);
                            this.last = fileId;
                        }
                    }
                });
                if (entry.getValue().subLocations != null) {
                    Iterator<Map.Entry<String, Location>> iter = entry.getValue().subLocations.iterator(tx);
                    while (iter.hasNext()) {
                        Map.Entry<String, Location> subscription = iter.next();
                        int dataFileId2 = subscription.getValue().getDataFileId();
                        if (!gcCandidateSet.isEmpty() && gcCandidateSet.first() == dataFileId2) {
                            StoredDestination destination = entry.getValue();
                            String subscriptionKey = subscription.getKey();
                            SequenceSet pendingAcks = destination.ackPositions.get(tx, subscriptionKey);
                            if (pendingAcks == null || pendingAcks.size() <= 1) {
                                if (LOG.isTraceEnabled()) {
                                    LOG.trace("Found candidate for rewrite: {} from file {}", (Object)entry.getKey(), (Object)dataFileId2);
                                }
                                KahaSubscriptionCommand kahaSub = destination.subscriptions.get(tx, subscriptionKey);
                                destination.subLocations.put(tx, subscriptionKey, this.checkpointSubscriptionCommand(kahaSub));
                                continue;
                            }
                        }
                        gcCandidateSet.remove(dataFileId2);
                    }
                }
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace("gc candidates after dest:" + entry.getKey() + ", " + gcCandidateSet);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("gc candidates: " + gcCandidateSet);
            }
            TreeSet<Integer> gcCandidates = new TreeSet<Integer>((SortedSet<Integer>)gcCandidateSet);
            Iterator<Integer> candidates = gcCandidateSet.iterator();
            while (candidates.hasNext()) {
                Integer candidate = candidates.next();
                Set<Integer> referencedFileIds = this.metadata.ackMessageFileMap.get(candidate);
                if (referencedFileIds == null) continue;
                for (Integer referencedFileId : referencedFileIds) {
                    if (!completeFileSet.contains(referencedFileId) || gcCandidates.contains(referencedFileId)) continue;
                    candidates.remove();
                    break;
                }
                if (gcCandidateSet.contains(candidate)) {
                    this.metadata.ackMessageFileMap.remove(candidate);
                    continue;
                }
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace("not removing data file: " + candidate + " as contained ack(s) refer to referenced file: " + referencedFileIds);
            }
            if (!gcCandidateSet.isEmpty()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Cleanup removing the data files: " + gcCandidateSet);
                }
                this.journal.removeDataFiles(gcCandidateSet);
            }
        }
        LOG.debug("Checkpoint done.");
    }

    private Location checkpointProducerAudit() throws IOException {
        if (this.metadata.producerSequenceIdTracker == null || this.metadata.producerSequenceIdTracker.modified()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oout = new ObjectOutputStream(baos);
            oout.writeObject(this.metadata.producerSequenceIdTracker);
            oout.flush();
            oout.close();
            Location location = this.store((JournalCommand)new KahaProducerAuditCommand().setAudit(new Buffer(baos.toByteArray())), this.nullCompletionCallback);
            try {
                location.getLatch().await();
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException(e.toString());
            }
            return location;
        }
        return this.metadata.producerSequenceIdTrackerLocation;
    }

    private Location checkpointAckMessageFileMap() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oout = new ObjectOutputStream(baos);
        oout.writeObject(this.metadata.ackMessageFileMap);
        oout.flush();
        oout.close();
        Location location = this.store((JournalCommand)new KahaAckMessageFileMapCommand().setAckMessageFileMap(new Buffer(baos.toByteArray())), this.nullCompletionCallback);
        try {
            location.getLatch().await();
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException(e.toString());
        }
        return location;
    }

    private Location checkpointSubscriptionCommand(KahaSubscriptionCommand subscription) throws IOException {
        ByteSequence sequence = this.toByteSequence(subscription);
        Location location = this.journal.write(sequence, this.nullCompletionCallback);
        try {
            location.getLatch().await();
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException(e.toString());
        }
        return location;
    }

    public HashSet<Integer> getJournalFilesBeingReplicated() {
        return this.journalFilesBeingReplicated;
    }

    protected StoredDestination getStoredDestination(KahaDestination destination, Transaction tx) throws IOException {
        String key = this.key(destination);
        StoredDestination rc = this.storedDestinations.get(key);
        if (rc == null) {
            boolean topic = destination.getType() == KahaDestination.DestinationType.TOPIC || destination.getType() == KahaDestination.DestinationType.TEMP_TOPIC;
            rc = this.loadStoredDestination(tx, key, topic);
            this.storedDestinations.put(key, rc);
        }
        return rc;
    }

    protected StoredDestination getExistingStoredDestination(KahaDestination destination, Transaction tx) throws IOException {
        String key = this.key(destination);
        StoredDestination rc = this.storedDestinations.get(key);
        if (rc == null && this.metadata.destinations.containsKey(tx, key)) {
            rc = this.getStoredDestination(destination, tx);
        }
        return rc;
    }

    private StoredDestination loadStoredDestination(Transaction tx, String key, boolean topic) throws IOException {
        StoredDestination rc = this.metadata.destinations.get(tx, key);
        if (rc == null) {
            rc = new StoredDestination();
            rc.orderIndex.allocate(tx);
            rc.locationIndex = new BTreeIndex(this.pageFile, tx.allocate());
            rc.messageIdIndex = new BTreeIndex(this.pageFile, tx.allocate());
            if (topic) {
                rc.subscriptions = new BTreeIndex(this.pageFile, tx.allocate());
                rc.subscriptionAcks = new BTreeIndex(this.pageFile, tx.allocate());
                rc.ackPositions = new ListIndex(this.pageFile, tx.allocate());
                rc.subLocations = new ListIndex(this.pageFile, tx.allocate());
            }
            this.metadata.destinations.put(tx, key, rc);
        }
        rc.orderIndex.load(tx);
        rc.orderIndex.configureLast(tx);
        rc.locationIndex.setKeyMarshaller(LocationMarshaller.INSTANCE);
        rc.locationIndex.setValueMarshaller(LongMarshaller.INSTANCE);
        rc.locationIndex.load(tx);
        rc.messageIdIndex.setKeyMarshaller(StringMarshaller.INSTANCE);
        rc.messageIdIndex.setValueMarshaller(LongMarshaller.INSTANCE);
        rc.messageIdIndex.load(tx);
        if (topic) {
            Map.Entry<String, LastAck> entry;
            rc.subscriptions.setKeyMarshaller(StringMarshaller.INSTANCE);
            rc.subscriptions.setValueMarshaller(KahaSubscriptionCommandMarshaller.INSTANCE);
            rc.subscriptions.load(tx);
            rc.subscriptionAcks.setKeyMarshaller(StringMarshaller.INSTANCE);
            rc.subscriptionAcks.setValueMarshaller(new LastAckMarshaller());
            rc.subscriptionAcks.load(tx);
            rc.ackPositions.setKeyMarshaller(StringMarshaller.INSTANCE);
            rc.ackPositions.setValueMarshaller(SequenceSet.Marshaller.INSTANCE);
            rc.ackPositions.load(tx);
            rc.subLocations.setKeyMarshaller(StringMarshaller.INSTANCE);
            rc.subLocations.setValueMarshaller(LocationMarshaller.INSTANCE);
            rc.subLocations.load(tx);
            rc.subscriptionCursors = new HashMap();
            if (this.metadata.version < 3) {
                Iterator<Map.Entry<String, LastAck>> iterator = rc.subscriptionAcks.iterator(tx);
                while (iterator.hasNext()) {
                    Map.Entry<String, LastAck> entry2 = iterator.next();
                    Iterator<Map.Entry<Long, MessageKeys>> orderIterator = rc.orderIndex.iterator(tx, new MessageOrderCursor(entry2.getValue().lastAckedSequence));
                    while (orderIterator.hasNext()) {
                        Long sequence = orderIterator.next().getKey();
                        this.addAckLocation(tx, rc, sequence, entry2.getKey());
                    }
                    rc.subscriptionAcks.put(tx, entry2.getKey(), entry2.getValue());
                }
            }
            Iterator<Map.Entry<String, SequenceSet>> subscriptions = rc.ackPositions.iterator(tx);
            while (subscriptions.hasNext()) {
                Map.Entry<String, SequenceSet> subscription = subscriptions.next();
                SequenceSet pendingAcks = subscription.getValue();
                if (pendingAcks == null || pendingAcks.isEmpty()) continue;
                Long lastPendingAck = ((Sequence)pendingAcks.getTail()).getLast();
                for (Long sequenceId : pendingAcks) {
                    Long current = rc.messageReferences.get(sequenceId);
                    if (current == null) {
                        current = new Long(0L);
                    }
                    if (!sequenceId.equals(lastPendingAck)) {
                        current = current + 1L;
                    }
                    rc.messageReferences.put(sequenceId, current);
                }
            }
            Iterator<Map.Entry<String, LastAck>> iterator = rc.subscriptionAcks.iterator(tx);
            while (iterator.hasNext()) {
                entry = iterator.next();
                rc.subscriptionCache.add(entry.getKey());
            }
            if (rc.orderIndex.nextMessageId == 0L) {
                if (!rc.subscriptionAcks.isEmpty(tx)) {
                    iterator = rc.subscriptionAcks.iterator(tx);
                    while (iterator.hasNext()) {
                        entry = iterator.next();
                        rc.orderIndex.nextMessageId = Math.max(rc.orderIndex.nextMessageId, entry.getValue().lastAckedSequence + 1L);
                    }
                }
            } else if (!rc.messageReferences.isEmpty()) {
                Long nextMessageId = (Long)rc.messageReferences.keySet().toArray()[rc.messageReferences.size() - 1];
                rc.orderIndex.nextMessageId = Math.max(rc.orderIndex.nextMessageId, nextMessageId);
            }
        }
        if (this.metadata.version < 5) {
            this.metadata.destinations.put(tx, key, rc);
        }
        return rc;
    }

    private void addAckLocation(Transaction tx, StoredDestination sd, Long messageSequence, String subscriptionKey) throws IOException {
        SequenceSet sequences = sd.ackPositions.get(tx, subscriptionKey);
        if (sequences == null) {
            sequences = new SequenceSet();
            sequences.add(messageSequence);
            sd.ackPositions.add(tx, subscriptionKey, sequences);
        } else {
            sequences.add(messageSequence);
            sd.ackPositions.put(tx, subscriptionKey, sequences);
        }
        Long count = sd.messageReferences.get(messageSequence);
        if (count == null) {
            count = 0L;
        }
        count = count + 1L;
        sd.messageReferences.put(messageSequence, count);
    }

    private void addAckLocationForRetroactiveSub(Transaction tx, StoredDestination sd, String subscriptionKey) throws IOException {
        SequenceSet allOutstanding = new SequenceSet();
        Iterator<Map.Entry<String, SequenceSet>> iterator = sd.ackPositions.iterator(tx);
        while (iterator.hasNext()) {
            SequenceSet set = iterator.next().getValue();
            for (Long entry : set) {
                allOutstanding.add(entry);
            }
        }
        sd.ackPositions.put(tx, subscriptionKey, allOutstanding);
        for (Long ackPosition : allOutstanding) {
            Long count = sd.messageReferences.get(ackPosition);
            count = count + 1L;
            sd.messageReferences.put(ackPosition, count);
        }
    }

    private void addAckLocationForNewMessage(Transaction tx, StoredDestination sd, Long messageSequence) throws IOException {
        for (String subscriptionKey : sd.subscriptionCache) {
            SequenceSet sequences = sd.ackPositions.get(tx, subscriptionKey);
            if (sequences == null) {
                sequences = new SequenceSet();
                sequences.add(new Sequence(messageSequence, messageSequence + 1L));
                sd.ackPositions.add(tx, subscriptionKey, sequences);
            } else {
                sequences.add(new Sequence(messageSequence, messageSequence + 1L));
                sd.ackPositions.put(tx, subscriptionKey, sequences);
            }
            Long count = sd.messageReferences.get(messageSequence);
            if (count == null) {
                count = 0L;
            }
            count = count + 1L;
            sd.messageReferences.put(messageSequence, count);
            sd.messageReferences.put(messageSequence + 1L, 0L);
        }
    }

    private void removeAckLocationsForSub(Transaction tx, StoredDestination sd, String subscriptionKey) throws IOException {
        if (!sd.ackPositions.isEmpty(tx)) {
            SequenceSet sequences = sd.ackPositions.remove(tx, subscriptionKey);
            if (sequences == null || sequences.isEmpty()) {
                return;
            }
            ArrayList<Long> unreferenced = new ArrayList<Long>();
            for (Long sequenceId : sequences) {
                Long references = sd.messageReferences.get(sequenceId);
                if (references == null) continue;
                if ((references = Long.valueOf(references - 1L)) > 0L) {
                    sd.messageReferences.put(sequenceId, references);
                    continue;
                }
                sd.messageReferences.remove(sequenceId);
                unreferenced.add(sequenceId);
            }
            for (Long sequenceId : unreferenced) {
                ArrayList<Map.Entry<Long, MessageKeys>> deletes = new ArrayList<Map.Entry<Long, MessageKeys>>();
                sd.orderIndex.getDeleteList(tx, deletes, sequenceId);
                for (Map.Entry<Long, MessageKeys> entry : deletes) {
                    sd.locationIndex.remove(tx, entry.getValue().location);
                    sd.messageIdIndex.remove(tx, entry.getValue().messageId);
                    sd.orderIndex.remove(tx, entry.getKey());
                }
            }
        }
    }

    private void removeAckLocation(Transaction tx, StoredDestination sd, String subscriptionKey, Long messageSequence) throws IOException {
        SequenceSet range;
        if (messageSequence != null && (range = sd.ackPositions.get(tx, subscriptionKey)) != null && !range.isEmpty()) {
            range.remove(messageSequence);
            if (!range.isEmpty()) {
                sd.ackPositions.put(tx, subscriptionKey, range);
            } else {
                sd.ackPositions.remove(tx, subscriptionKey);
            }
            Long count = sd.messageReferences.get(messageSequence);
            if (count != null) {
                long references = count - 1L;
                if (references > 0L) {
                    sd.messageReferences.put(messageSequence, references);
                    return;
                }
                sd.messageReferences.remove(messageSequence);
            }
            ArrayList<Map.Entry<Long, MessageKeys>> deletes = new ArrayList<Map.Entry<Long, MessageKeys>>();
            sd.orderIndex.getDeleteList(tx, deletes, messageSequence);
            for (Map.Entry<Long, MessageKeys> entry : deletes) {
                sd.locationIndex.remove(tx, entry.getValue().location);
                sd.messageIdIndex.remove(tx, entry.getValue().messageId);
                sd.orderIndex.remove(tx, entry.getKey());
            }
        }
    }

    public LastAck getLastAck(Transaction tx, StoredDestination sd, String subscriptionKey) throws IOException {
        return sd.subscriptionAcks.get(tx, subscriptionKey);
    }

    public long getStoredMessageCount(Transaction tx, StoredDestination sd, String subscriptionKey) throws IOException {
        SequenceSet messageSequences = sd.ackPositions.get(tx, subscriptionKey);
        if (messageSequences != null) {
            long result = messageSequences.rangeSize();
            return result > 0L ? result - 1L : 0L;
        }
        return 0L;
    }

    protected String key(KahaDestination destination) {
        return destination.getType().getNumber() + ":" + destination.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trackRecoveredAcks(ArrayList<MessageAck> acks) {
        this.indexLock.writeLock().lock();
        try {
            for (MessageAck ack : acks) {
                this.ackedAndPrepared.add(ack.getLastMessageId().toProducerKey());
            }
        }
        finally {
            this.indexLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forgetRecoveredAcks(ArrayList<MessageAck> acks, boolean rollback) throws IOException {
        if (acks != null) {
            this.indexLock.writeLock().lock();
            try {
                for (MessageAck ack : acks) {
                    String id = ack.getLastMessageId().toProducerKey();
                    this.ackedAndPrepared.remove(id);
                    if (!rollback) continue;
                    this.rolledBackAcks.add(id);
                }
            }
            finally {
                this.indexLock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Operation> getInflightTx(KahaTransactionInfo info) {
        List<Operation<Object>> tx;
        TransactionId key = TransactionIdConversion.convert(info);
        LinkedHashMap<TransactionId, List<Operation>> linkedHashMap = this.inflightTransactions;
        synchronized (linkedHashMap) {
            tx = this.inflightTransactions.get(key);
            if (tx == null) {
                tx = Collections.synchronizedList(new ArrayList());
                this.inflightTransactions.put(key, tx);
            }
        }
        return tx;
    }

    private TransactionId key(KahaTransactionInfo transactionInfo) {
        return TransactionIdConversion.convert(transactionInfo);
    }

    private PageFile createPageFile() throws IOException {
        if (this.indexDirectory == null) {
            this.indexDirectory = this.directory;
        }
        IOHelper.mkdirs((File)this.indexDirectory);
        PageFile index = new PageFile(this.indexDirectory, "db");
        index.setEnableWriteThread(this.isEnableIndexWriteAsync());
        index.setWriteBatchSize(this.getIndexWriteBatchSize());
        index.setPageCacheSize(this.indexCacheSize);
        index.setUseLFRUEviction(this.isUseIndexLFRUEviction());
        index.setLFUEvictionFactor(this.getIndexLFUEvictionFactor());
        index.setEnableDiskSyncs(this.isEnableIndexDiskSyncs());
        index.setEnableRecoveryFile(this.isEnableIndexRecoveryFile());
        index.setEnablePageCaching(this.isEnableIndexPageCaching());
        return index;
    }

    private Journal createJournal() throws IOException {
        Journal manager = new Journal();
        manager.setDirectory(this.directory);
        manager.setMaxFileLength(this.getJournalMaxFileLength());
        manager.setCheckForCorruptionOnStartup(this.checkForCorruptJournalFiles);
        manager.setChecksum(this.checksumJournalFiles || this.checkForCorruptJournalFiles);
        manager.setWriteBatchSize(this.getJournalMaxWriteBatchSize());
        manager.setArchiveDataLogs(this.isArchiveDataLogs());
        manager.setSizeAccumulator(this.journalSize);
        manager.setEnableAsyncDiskSync(this.isEnableJournalDiskSyncs());
        if (this.getDirectoryArchive() != null) {
            IOHelper.mkdirs((File)this.getDirectoryArchive());
            manager.setDirectoryArchive(this.getDirectoryArchive());
        }
        return manager;
    }

    private Metadata createMetadata() {
        Metadata md = new Metadata();
        md.producerSequenceIdTracker.setAuditDepth(this.getFailoverProducersAuditDepth());
        md.producerSequenceIdTracker.setMaximumNumberOfProducersToTrack(this.getMaxFailoverProducersToTrack());
        return md;
    }

    public int getJournalMaxWriteBatchSize() {
        return this.journalMaxWriteBatchSize;
    }

    public void setJournalMaxWriteBatchSize(int journalMaxWriteBatchSize) {
        this.journalMaxWriteBatchSize = journalMaxWriteBatchSize;
    }

    public File getDirectory() {
        return this.directory;
    }

    public void setDirectory(File directory) {
        this.directory = directory;
    }

    public boolean isDeleteAllMessages() {
        return this.deleteAllMessages;
    }

    public void setDeleteAllMessages(boolean deleteAllMessages) {
        this.deleteAllMessages = deleteAllMessages;
    }

    public void setIndexWriteBatchSize(int setIndexWriteBatchSize) {
        this.setIndexWriteBatchSize = setIndexWriteBatchSize;
    }

    public int getIndexWriteBatchSize() {
        return this.setIndexWriteBatchSize;
    }

    public void setEnableIndexWriteAsync(boolean enableIndexWriteAsync) {
        this.enableIndexWriteAsync = enableIndexWriteAsync;
    }

    boolean isEnableIndexWriteAsync() {
        return this.enableIndexWriteAsync;
    }

    public boolean isEnableJournalDiskSyncs() {
        return this.enableJournalDiskSyncs;
    }

    public void setEnableJournalDiskSyncs(boolean syncWrites) {
        this.enableJournalDiskSyncs = syncWrites;
    }

    public long getCheckpointInterval() {
        return this.checkpointInterval;
    }

    public void setCheckpointInterval(long checkpointInterval) {
        this.checkpointInterval = checkpointInterval;
    }

    public long getCleanupInterval() {
        return this.cleanupInterval;
    }

    public void setCleanupInterval(long cleanupInterval) {
        this.cleanupInterval = cleanupInterval;
    }

    public void setJournalMaxFileLength(int journalMaxFileLength) {
        this.journalMaxFileLength = journalMaxFileLength;
    }

    public int getJournalMaxFileLength() {
        return this.journalMaxFileLength;
    }

    public void setMaxFailoverProducersToTrack(int maxFailoverProducersToTrack) {
        this.metadata.producerSequenceIdTracker.setMaximumNumberOfProducersToTrack(maxFailoverProducersToTrack);
    }

    public int getMaxFailoverProducersToTrack() {
        return this.metadata.producerSequenceIdTracker.getMaximumNumberOfProducersToTrack();
    }

    public void setFailoverProducersAuditDepth(int failoverProducersAuditDepth) {
        this.metadata.producerSequenceIdTracker.setAuditDepth(failoverProducersAuditDepth);
    }

    public int getFailoverProducersAuditDepth() {
        return this.metadata.producerSequenceIdTracker.getAuditDepth();
    }

    public PageFile getPageFile() throws IOException {
        if (this.pageFile == null) {
            this.pageFile = this.createPageFile();
        }
        return this.pageFile;
    }

    public Journal getJournal() throws IOException {
        if (this.journal == null) {
            this.journal = this.createJournal();
        }
        return this.journal;
    }

    public boolean isFailIfDatabaseIsLocked() {
        return this.failIfDatabaseIsLocked;
    }

    public void setFailIfDatabaseIsLocked(boolean failIfDatabaseIsLocked) {
        this.failIfDatabaseIsLocked = failIfDatabaseIsLocked;
    }

    public boolean isIgnoreMissingJournalfiles() {
        return this.ignoreMissingJournalfiles;
    }

    public void setIgnoreMissingJournalfiles(boolean ignoreMissingJournalfiles) {
        this.ignoreMissingJournalfiles = ignoreMissingJournalfiles;
    }

    public int getIndexCacheSize() {
        return this.indexCacheSize;
    }

    public void setIndexCacheSize(int indexCacheSize) {
        this.indexCacheSize = indexCacheSize;
    }

    public boolean isCheckForCorruptJournalFiles() {
        return this.checkForCorruptJournalFiles;
    }

    public void setCheckForCorruptJournalFiles(boolean checkForCorruptJournalFiles) {
        this.checkForCorruptJournalFiles = checkForCorruptJournalFiles;
    }

    public boolean isChecksumJournalFiles() {
        return this.checksumJournalFiles;
    }

    public void setChecksumJournalFiles(boolean checksumJournalFiles) {
        this.checksumJournalFiles = checksumJournalFiles;
    }

    public void setBrokerService(BrokerService brokerService) {
        this.brokerService = brokerService;
    }

    public boolean isArchiveDataLogs() {
        return this.archiveDataLogs;
    }

    public void setArchiveDataLogs(boolean archiveDataLogs) {
        this.archiveDataLogs = archiveDataLogs;
    }

    public File getDirectoryArchive() {
        return this.directoryArchive;
    }

    public void setDirectoryArchive(File directoryArchive) {
        this.directoryArchive = directoryArchive;
    }

    public boolean isArchiveCorruptedIndex() {
        return this.archiveCorruptedIndex;
    }

    public void setArchiveCorruptedIndex(boolean archiveCorruptedIndex) {
        this.archiveCorruptedIndex = archiveCorruptedIndex;
    }

    public float getIndexLFUEvictionFactor() {
        return this.indexLFUEvictionFactor;
    }

    public void setIndexLFUEvictionFactor(float indexLFUEvictionFactor) {
        this.indexLFUEvictionFactor = indexLFUEvictionFactor;
    }

    public boolean isUseIndexLFRUEviction() {
        return this.useIndexLFRUEviction;
    }

    public void setUseIndexLFRUEviction(boolean useIndexLFRUEviction) {
        this.useIndexLFRUEviction = useIndexLFRUEviction;
    }

    public void setEnableIndexDiskSyncs(boolean enableIndexDiskSyncs) {
        this.enableIndexDiskSyncs = enableIndexDiskSyncs;
    }

    public void setEnableIndexRecoveryFile(boolean enableIndexRecoveryFile) {
        this.enableIndexRecoveryFile = enableIndexRecoveryFile;
    }

    public void setEnableIndexPageCaching(boolean enableIndexPageCaching) {
        this.enableIndexPageCaching = enableIndexPageCaching;
    }

    public boolean isEnableIndexDiskSyncs() {
        return this.enableIndexDiskSyncs;
    }

    public boolean isEnableIndexRecoveryFile() {
        return this.enableIndexRecoveryFile;
    }

    public boolean isEnableIndexPageCaching() {
        return this.enableIndexPageCaching;
    }

    public File getIndexDirectory() {
        return this.indexDirectory;
    }

    public void setIndexDirectory(File indexDirectory) {
        this.indexDirectory = indexDirectory;
    }

    static interface IndexAware {
        public void sequenceAssignedWithIndexLocked(long var1);
    }

    private static class HashSetStringMarshaller
    extends VariableMarshaller<HashSet<String>> {
        static final HashSetStringMarshaller INSTANCE = new HashSetStringMarshaller();

        private HashSetStringMarshaller() {
        }

        @Override
        public void writePayload(HashSet<String> object, DataOutput dataOut) throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oout = new ObjectOutputStream(baos);
            oout.writeObject(object);
            oout.flush();
            oout.close();
            byte[] data = baos.toByteArray();
            dataOut.writeInt(data.length);
            dataOut.write(data);
        }

        @Override
        public HashSet<String> readPayload(DataInput dataIn) throws IOException {
            int dataLen = dataIn.readInt();
            byte[] data = new byte[dataLen];
            dataIn.readFully(data);
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            ObjectInputStream oin = new ObjectInputStream(bais);
            try {
                return (HashSet)oin.readObject();
            }
            catch (ClassNotFoundException cfe) {
                IOException ioe = new IOException("Failed to read HashSet<String>: " + cfe);
                ioe.initCause(cfe);
                throw ioe;
            }
        }
    }

    class MessageOrderIndex {
        static final byte HI = 9;
        static final byte LO = 0;
        static final byte DEF = 4;
        long nextMessageId;
        BTreeIndex<Long, MessageKeys> defaultPriorityIndex;
        BTreeIndex<Long, MessageKeys> lowPriorityIndex;
        BTreeIndex<Long, MessageKeys> highPriorityIndex;
        final MessageOrderCursor cursor;
        Long lastDefaultKey;
        Long lastHighKey;
        Long lastLowKey;
        byte lastGetPriority;
        final List<Long> pendingAdditions;

        MessageOrderIndex() {
            this.cursor = new MessageOrderCursor();
            this.pendingAdditions = new LinkedList<Long>();
        }

        MessageKeys remove(Transaction tx, Long key) throws IOException {
            MessageKeys result = this.defaultPriorityIndex.remove(tx, key);
            if (result == null && this.highPriorityIndex != null && (result = this.highPriorityIndex.remove(tx, key)) == null && this.lowPriorityIndex != null) {
                result = this.lowPriorityIndex.remove(tx, key);
            }
            return result;
        }

        void load(Transaction tx) throws IOException {
            this.defaultPriorityIndex.setKeyMarshaller(LongMarshaller.INSTANCE);
            this.defaultPriorityIndex.setValueMarshaller(MessageKeysMarshaller.INSTANCE);
            this.defaultPriorityIndex.load(tx);
            this.lowPriorityIndex.setKeyMarshaller(LongMarshaller.INSTANCE);
            this.lowPriorityIndex.setValueMarshaller(MessageKeysMarshaller.INSTANCE);
            this.lowPriorityIndex.load(tx);
            this.highPriorityIndex.setKeyMarshaller(LongMarshaller.INSTANCE);
            this.highPriorityIndex.setValueMarshaller(MessageKeysMarshaller.INSTANCE);
            this.highPriorityIndex.load(tx);
        }

        void allocate(Transaction tx) throws IOException {
            this.defaultPriorityIndex = new BTreeIndex(MessageDatabase.this.pageFile, tx.allocate());
            if (MessageDatabase.this.metadata.version >= 2) {
                this.lowPriorityIndex = new BTreeIndex(MessageDatabase.this.pageFile, tx.allocate());
                this.highPriorityIndex = new BTreeIndex(MessageDatabase.this.pageFile, tx.allocate());
            }
        }

        void configureLast(Transaction tx) throws IOException {
            if (this.highPriorityIndex != null) {
                Map.Entry<Long, MessageKeys> lastEntry = this.highPriorityIndex.getLast(tx);
                if (lastEntry != null) {
                    this.nextMessageId = lastEntry.getKey() + 1L;
                } else {
                    lastEntry = this.defaultPriorityIndex.getLast(tx);
                    if (lastEntry != null) {
                        this.nextMessageId = lastEntry.getKey() + 1L;
                    } else {
                        lastEntry = this.lowPriorityIndex.getLast(tx);
                        if (lastEntry != null) {
                            this.nextMessageId = lastEntry.getKey() + 1L;
                        }
                    }
                }
            } else {
                Map.Entry<Long, MessageKeys> lastEntry = this.defaultPriorityIndex.getLast(tx);
                if (lastEntry != null) {
                    this.nextMessageId = lastEntry.getKey() + 1L;
                }
            }
        }

        void clear(Transaction tx) throws IOException {
            this.remove(tx);
            this.resetCursorPosition();
            this.allocate(tx);
            this.load(tx);
            this.configureLast(tx);
        }

        void remove(Transaction tx) throws IOException {
            this.defaultPriorityIndex.clear(tx);
            this.defaultPriorityIndex.unload(tx);
            tx.free(this.defaultPriorityIndex.getPageId());
            if (this.lowPriorityIndex != null) {
                this.lowPriorityIndex.clear(tx);
                this.lowPriorityIndex.unload(tx);
                tx.free(this.lowPriorityIndex.getPageId());
            }
            if (this.highPriorityIndex != null) {
                this.highPriorityIndex.clear(tx);
                this.highPriorityIndex.unload(tx);
                tx.free(this.highPriorityIndex.getPageId());
            }
        }

        void resetCursorPosition() {
            this.cursor.reset();
            this.lastDefaultKey = null;
            this.lastHighKey = null;
            this.lastLowKey = null;
        }

        void setBatch(Transaction tx, Long sequence) throws IOException {
            if (sequence != null) {
                Long nextPosition = new Long(sequence + 1L);
                if (this.defaultPriorityIndex.containsKey(tx, sequence)) {
                    this.lastDefaultKey = sequence;
                    this.cursor.defaultCursorPosition = nextPosition;
                } else if (this.highPriorityIndex != null && this.highPriorityIndex.containsKey(tx, sequence)) {
                    this.lastHighKey = sequence;
                    this.cursor.highPriorityCursorPosition = nextPosition;
                } else if (this.lowPriorityIndex.containsKey(tx, sequence)) {
                    this.lastLowKey = sequence;
                    this.cursor.lowPriorityCursorPosition = nextPosition;
                } else {
                    this.lastDefaultKey = sequence;
                    this.cursor.defaultCursorPosition = nextPosition;
                }
            }
        }

        void setBatch(Transaction tx, LastAck last) throws IOException {
            this.setBatch(tx, last.lastAckedSequence);
            if (this.cursor.defaultCursorPosition == 0L && this.cursor.highPriorityCursorPosition == 0L && this.cursor.lowPriorityCursorPosition == 0L) {
                long next = last.lastAckedSequence + 1L;
                switch (last.priority) {
                    case 4: {
                        this.cursor.defaultCursorPosition = next;
                        this.cursor.highPriorityCursorPosition = next;
                        break;
                    }
                    case 9: {
                        this.cursor.highPriorityCursorPosition = next;
                        break;
                    }
                    case 0: {
                        this.cursor.lowPriorityCursorPosition = next;
                        this.cursor.defaultCursorPosition = next;
                        this.cursor.highPriorityCursorPosition = next;
                    }
                }
            }
        }

        void stoppedIterating() {
            if (this.lastDefaultKey != null) {
                this.cursor.defaultCursorPosition = this.lastDefaultKey + 1L;
            }
            if (this.lastHighKey != null) {
                this.cursor.highPriorityCursorPosition = this.lastHighKey + 1L;
            }
            if (this.lastLowKey != null) {
                this.cursor.lowPriorityCursorPosition = this.lastLowKey + 1L;
            }
            this.lastDefaultKey = null;
            this.lastHighKey = null;
            this.lastLowKey = null;
        }

        void getDeleteList(Transaction tx, ArrayList<Map.Entry<Long, MessageKeys>> deletes, Long sequenceId) throws IOException {
            if (this.defaultPriorityIndex.containsKey(tx, sequenceId)) {
                this.getDeleteList(tx, deletes, this.defaultPriorityIndex, sequenceId);
            } else if (this.highPriorityIndex != null && this.highPriorityIndex.containsKey(tx, sequenceId)) {
                this.getDeleteList(tx, deletes, this.highPriorityIndex, sequenceId);
            } else if (this.lowPriorityIndex != null && this.lowPriorityIndex.containsKey(tx, sequenceId)) {
                this.getDeleteList(tx, deletes, this.lowPriorityIndex, sequenceId);
            }
        }

        void getDeleteList(Transaction tx, ArrayList<Map.Entry<Long, MessageKeys>> deletes, BTreeIndex<Long, MessageKeys> index, Long sequenceId) throws IOException {
            Iterator<Map.Entry<Object, MessageKeys>> iterator = index.iterator(tx, sequenceId, null);
            deletes.add(iterator.next());
        }

        long getNextMessageId(int priority) {
            return this.nextMessageId++;
        }

        MessageKeys get(Transaction tx, Long key) throws IOException {
            MessageKeys result = this.defaultPriorityIndex.get(tx, key);
            if (result == null) {
                result = this.highPriorityIndex.get(tx, key);
                if (result == null) {
                    result = this.lowPriorityIndex.get(tx, key);
                    this.lastGetPriority = 0;
                } else {
                    this.lastGetPriority = (byte)9;
                }
            } else {
                this.lastGetPriority = (byte)4;
            }
            return result;
        }

        MessageKeys put(Transaction tx, int priority, Long key, MessageKeys value) throws IOException {
            if (priority == 4) {
                return this.defaultPriorityIndex.put(tx, key, value);
            }
            if (priority > 4) {
                return this.highPriorityIndex.put(tx, key, value);
            }
            return this.lowPriorityIndex.put(tx, key, value);
        }

        Iterator<Map.Entry<Long, MessageKeys>> iterator(Transaction tx) throws IOException {
            return new MessageOrderIterator(tx, this.cursor, this);
        }

        Iterator<Map.Entry<Long, MessageKeys>> iterator(Transaction tx, MessageOrderCursor m) throws IOException {
            return new MessageOrderIterator(tx, m, this);
        }

        public byte lastGetPriority() {
            return this.lastGetPriority;
        }

        public boolean alreadyDispatched(Long sequence) {
            return this.cursor.highPriorityCursorPosition > 0L && this.cursor.highPriorityCursorPosition >= sequence || this.cursor.defaultCursorPosition > 0L && this.cursor.defaultCursorPosition >= sequence || this.cursor.lowPriorityCursorPosition > 0L && this.cursor.lowPriorityCursorPosition >= sequence;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void trackPendingAdd(Long seq) {
            List<Long> list = this.pendingAdditions;
            synchronized (list) {
                this.pendingAdditions.add(seq);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void trackPendingAddComplete(Long seq) {
            List<Long> list = this.pendingAdditions;
            synchronized (list) {
                this.pendingAdditions.remove(seq);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Long minPendingAdd() {
            List<Long> list = this.pendingAdditions;
            synchronized (list) {
                if (!this.pendingAdditions.isEmpty()) {
                    return this.pendingAdditions.get(0);
                }
                return null;
            }
        }

        class MessageOrderIterator
        implements Iterator<Map.Entry<Long, MessageKeys>> {
            Iterator<Map.Entry<Long, MessageKeys>> currentIterator;
            final Iterator<Map.Entry<Long, MessageKeys>> highIterator;
            final Iterator<Map.Entry<Long, MessageKeys>> defaultIterator;
            final Iterator<Map.Entry<Long, MessageKeys>> lowIterator;

            MessageOrderIterator(Transaction tx, MessageOrderCursor m, MessageOrderIndex messageOrderIndex2) throws IOException {
                Long pendingAddLimiter = messageOrderIndex2.minPendingAdd();
                this.defaultIterator = MessageOrderIndex.this.defaultPriorityIndex.iterator(tx, m.defaultCursorPosition, pendingAddLimiter);
                this.highIterator = MessageOrderIndex.this.highPriorityIndex != null ? MessageOrderIndex.this.highPriorityIndex.iterator(tx, m.highPriorityCursorPosition, pendingAddLimiter) : null;
                this.lowIterator = MessageOrderIndex.this.lowPriorityIndex != null ? MessageOrderIndex.this.lowPriorityIndex.iterator(tx, m.lowPriorityCursorPosition, pendingAddLimiter) : null;
            }

            @Override
            public boolean hasNext() {
                if (this.currentIterator == null) {
                    if (this.highIterator != null) {
                        if (this.highIterator.hasNext()) {
                            this.currentIterator = this.highIterator;
                            return this.currentIterator.hasNext();
                        }
                        if (this.defaultIterator.hasNext()) {
                            this.currentIterator = this.defaultIterator;
                            return this.currentIterator.hasNext();
                        }
                        if (this.lowIterator.hasNext()) {
                            this.currentIterator = this.lowIterator;
                            return this.currentIterator.hasNext();
                        }
                        return false;
                    }
                    this.currentIterator = this.defaultIterator;
                    return this.currentIterator.hasNext();
                }
                if (this.highIterator != null) {
                    if (this.currentIterator.hasNext()) {
                        return true;
                    }
                    if (this.currentIterator == this.highIterator) {
                        if (this.defaultIterator.hasNext()) {
                            this.currentIterator = this.defaultIterator;
                            return this.currentIterator.hasNext();
                        }
                        if (this.lowIterator.hasNext()) {
                            this.currentIterator = this.lowIterator;
                            return this.currentIterator.hasNext();
                        }
                        return false;
                    }
                    if (this.currentIterator == this.defaultIterator) {
                        if (this.lowIterator.hasNext()) {
                            this.currentIterator = this.lowIterator;
                            return this.currentIterator.hasNext();
                        }
                        return false;
                    }
                }
                return this.currentIterator.hasNext();
            }

            @Override
            public Map.Entry<Long, MessageKeys> next() {
                Map.Entry<Long, MessageKeys> result = this.currentIterator.next();
                if (result != null) {
                    Long key = result.getKey();
                    if (this.highIterator != null) {
                        if (this.currentIterator == this.defaultIterator) {
                            MessageOrderIndex.this.lastDefaultKey = key;
                        } else if (this.currentIterator == this.highIterator) {
                            MessageOrderIndex.this.lastHighKey = key;
                        } else {
                            MessageOrderIndex.this.lastLowKey = key;
                        }
                    } else {
                        MessageOrderIndex.this.lastDefaultKey = key;
                    }
                }
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    class MessageOrderCursor {
        long defaultCursorPosition;
        long lowPriorityCursorPosition;
        long highPriorityCursorPosition;

        MessageOrderCursor() {
        }

        MessageOrderCursor(long position) {
            this.defaultCursorPosition = position;
            this.lowPriorityCursorPosition = position;
            this.highPriorityCursorPosition = position;
        }

        MessageOrderCursor(MessageOrderCursor other) {
            this.defaultCursorPosition = other.defaultCursorPosition;
            this.lowPriorityCursorPosition = other.lowPriorityCursorPosition;
            this.highPriorityCursorPosition = other.highPriorityCursorPosition;
        }

        MessageOrderCursor copy() {
            return new MessageOrderCursor(this);
        }

        void reset() {
            this.defaultCursorPosition = 0L;
            this.highPriorityCursorPosition = 0L;
            this.lowPriorityCursorPosition = 0L;
        }

        void increment() {
            if (this.defaultCursorPosition != 0L) {
                ++this.defaultCursorPosition;
            }
            if (this.highPriorityCursorPosition != 0L) {
                ++this.highPriorityCursorPosition;
            }
            if (this.lowPriorityCursorPosition != 0L) {
                ++this.lowPriorityCursorPosition;
            }
        }

        public String toString() {
            return "MessageOrderCursor:[def:" + this.defaultCursorPosition + ", low:" + this.lowPriorityCursorPosition + ", high:" + this.highPriorityCursorPosition + "]";
        }

        public void sync(MessageOrderCursor other) {
            this.defaultCursorPosition = other.defaultCursorPosition;
            this.lowPriorityCursorPosition = other.lowPriorityCursorPosition;
            this.highPriorityCursorPosition = other.highPriorityCursorPosition;
        }
    }

    class RemoveOperation
    extends Operation<KahaRemoveMessageCommand> {
        public RemoveOperation(KahaRemoveMessageCommand command, Location location) {
            super(MessageDatabase.this, (JournalCommand)command, location);
        }

        @Override
        public void execute(Transaction tx) throws IOException {
            MessageDatabase.this.updateIndex(tx, (KahaRemoveMessageCommand)this.command, this.location);
        }
    }

    class AddOperation
    extends Operation<KahaAddMessageCommand> {
        final IndexAware runWithIndexLock;

        public AddOperation(KahaAddMessageCommand command, Location location, IndexAware runWithIndexLock) {
            super(MessageDatabase.this, (JournalCommand)command, location);
            this.runWithIndexLock = runWithIndexLock;
        }

        @Override
        public void execute(Transaction tx) throws IOException {
            long seq = MessageDatabase.this.updateIndex(tx, (KahaAddMessageCommand)this.command, this.location);
            if (this.runWithIndexLock != null) {
                this.runWithIndexLock.sequenceAssignedWithIndexLocked(seq);
            }
        }
    }

    static abstract class Operation<T extends JournalCommand<T>> {
        final T command;
        final Location location;
        final /* synthetic */ MessageDatabase this$0;

        public Operation(T command, Location location) {
            this.this$0 = var1_1;
            this.command = command;
            this.location = location;
        }

        public Location getLocation() {
            return this.location;
        }

        public T getCommand() {
            return this.command;
        }

        public abstract void execute(Transaction var1) throws IOException;
    }

    static class KahaSubscriptionCommandMarshaller
    extends VariableMarshaller<KahaSubscriptionCommand> {
        static final KahaSubscriptionCommandMarshaller INSTANCE = new KahaSubscriptionCommandMarshaller();

        KahaSubscriptionCommandMarshaller() {
        }

        @Override
        public KahaSubscriptionCommand readPayload(DataInput dataIn) throws IOException {
            KahaSubscriptionCommand rc = new KahaSubscriptionCommand();
            rc.mergeFramed((InputStream)((Object)dataIn));
            return rc;
        }

        @Override
        public void writePayload(KahaSubscriptionCommand object, DataOutput dataOut) throws IOException {
            object.writeFramed((OutputStream)((Object)dataOut));
        }
    }

    protected class StoredDestinationMarshaller
    extends VariableMarshaller<StoredDestination> {
        protected StoredDestinationMarshaller() {
        }

        @Override
        public StoredDestination readPayload(final DataInput dataIn) throws IOException {
            final StoredDestination value = new StoredDestination();
            value.orderIndex.defaultPriorityIndex = new BTreeIndex(MessageDatabase.this.pageFile, dataIn.readLong());
            value.locationIndex = new BTreeIndex(MessageDatabase.this.pageFile, dataIn.readLong());
            value.messageIdIndex = new BTreeIndex(MessageDatabase.this.pageFile, dataIn.readLong());
            if (dataIn.readBoolean()) {
                value.subscriptions = new BTreeIndex(MessageDatabase.this.pageFile, dataIn.readLong());
                value.subscriptionAcks = new BTreeIndex(MessageDatabase.this.pageFile, dataIn.readLong());
                if (MessageDatabase.this.metadata.version >= 4) {
                    value.ackPositions = new ListIndex(MessageDatabase.this.pageFile, dataIn.readLong());
                } else {
                    MessageDatabase.this.pageFile.tx().execute(new Transaction.Closure<IOException>(){

                        @Override
                        public void execute(Transaction tx) throws IOException {
                            LinkedHashMap<String, SequenceSet> temp = new LinkedHashMap<String, SequenceSet>();
                            if (MessageDatabase.this.metadata.version >= 3) {
                                BTreeIndex<Long, HashSet<String>> oldAckPositions = new BTreeIndex<Long, HashSet<String>>(MessageDatabase.this.pageFile, dataIn.readLong());
                                oldAckPositions.setKeyMarshaller(LongMarshaller.INSTANCE);
                                oldAckPositions.setValueMarshaller(HashSetStringMarshaller.INSTANCE);
                                oldAckPositions.load(tx);
                                Iterator iterator = oldAckPositions.iterator(tx);
                                while (iterator.hasNext()) {
                                    Map.Entry entry = iterator.next();
                                    for (String subKey : (HashSet)entry.getValue()) {
                                        SequenceSet pendingAcks = (SequenceSet)temp.get(subKey);
                                        if (pendingAcks == null) {
                                            pendingAcks = new SequenceSet();
                                            temp.put(subKey, pendingAcks);
                                        }
                                        pendingAcks.add((Long)entry.getKey());
                                    }
                                }
                            }
                            value.ackPositions = new ListIndex(MessageDatabase.this.pageFile, tx.allocate());
                            value.ackPositions.setKeyMarshaller(StringMarshaller.INSTANCE);
                            value.ackPositions.setValueMarshaller(SequenceSet.Marshaller.INSTANCE);
                            value.ackPositions.load(tx);
                            for (String subscriptionKey : temp.keySet()) {
                                value.ackPositions.put(tx, subscriptionKey, (SequenceSet)temp.get(subscriptionKey));
                            }
                        }
                    });
                }
                if (MessageDatabase.this.metadata.version >= 5) {
                    value.subLocations = new ListIndex(MessageDatabase.this.pageFile, dataIn.readLong());
                } else {
                    MessageDatabase.this.pageFile.tx().execute(new Transaction.Closure<IOException>(){

                        @Override
                        public void execute(Transaction tx) throws IOException {
                            value.subLocations = new ListIndex(MessageDatabase.this.pageFile, tx.allocate());
                            value.subLocations.setKeyMarshaller(StringMarshaller.INSTANCE);
                            value.subLocations.setValueMarshaller(LocationMarshaller.INSTANCE);
                            value.subLocations.load(tx);
                        }
                    });
                }
            }
            if (MessageDatabase.this.metadata.version >= 2) {
                value.orderIndex.lowPriorityIndex = new BTreeIndex(MessageDatabase.this.pageFile, dataIn.readLong());
                value.orderIndex.highPriorityIndex = new BTreeIndex(MessageDatabase.this.pageFile, dataIn.readLong());
            } else {
                MessageDatabase.this.pageFile.tx().execute(new Transaction.Closure<IOException>(){

                    @Override
                    public void execute(Transaction tx) throws IOException {
                        value.orderIndex.lowPriorityIndex = new BTreeIndex(MessageDatabase.this.pageFile, tx.allocate());
                        value.orderIndex.lowPriorityIndex.setKeyMarshaller(LongMarshaller.INSTANCE);
                        value.orderIndex.lowPriorityIndex.setValueMarshaller(MessageKeysMarshaller.INSTANCE);
                        value.orderIndex.lowPriorityIndex.load(tx);
                        value.orderIndex.highPriorityIndex = new BTreeIndex(MessageDatabase.this.pageFile, tx.allocate());
                        value.orderIndex.highPriorityIndex.setKeyMarshaller(LongMarshaller.INSTANCE);
                        value.orderIndex.highPriorityIndex.setValueMarshaller(MessageKeysMarshaller.INSTANCE);
                        value.orderIndex.highPriorityIndex.load(tx);
                    }
                });
            }
            return value;
        }

        @Override
        public void writePayload(StoredDestination value, DataOutput dataOut) throws IOException {
            dataOut.writeLong(value.orderIndex.defaultPriorityIndex.getPageId());
            dataOut.writeLong(value.locationIndex.getPageId());
            dataOut.writeLong(value.messageIdIndex.getPageId());
            if (value.subscriptions != null) {
                dataOut.writeBoolean(true);
                dataOut.writeLong(value.subscriptions.getPageId());
                dataOut.writeLong(value.subscriptionAcks.getPageId());
                dataOut.writeLong(value.ackPositions.getHeadPageId());
                dataOut.writeLong(value.subLocations.getHeadPageId());
            } else {
                dataOut.writeBoolean(false);
            }
            dataOut.writeLong(value.orderIndex.lowPriorityIndex.getPageId());
            dataOut.writeLong(value.orderIndex.highPriorityIndex.getPageId());
        }
    }

    class StoredDestination {
        MessageOrderIndex orderIndex;
        BTreeIndex<Location, Long> locationIndex;
        BTreeIndex<String, Long> messageIdIndex;
        BTreeIndex<String, KahaSubscriptionCommand> subscriptions;
        BTreeIndex<String, LastAck> subscriptionAcks;
        HashMap<String, MessageOrderCursor> subscriptionCursors;
        ListIndex<String, SequenceSet> ackPositions;
        ListIndex<String, Location> subLocations;
        final TreeMap<Long, Long> messageReferences;
        final HashSet<String> subscriptionCache;

        StoredDestination() {
            this.orderIndex = new MessageOrderIndex();
            this.messageReferences = new TreeMap();
            this.subscriptionCache = new LinkedHashSet<String>();
        }

        public void trackPendingAdd(Long seq) {
            this.orderIndex.trackPendingAdd(seq);
        }

        public void trackPendingAddComplete(Long seq) {
            this.orderIndex.trackPendingAddComplete(seq);
        }

        public String toString() {
            return "nextSeq:" + this.orderIndex.nextMessageId + ",lastRet:" + this.orderIndex.cursor + ",pending:" + this.orderIndex.pendingAdditions.size();
        }
    }

    protected class LastAckMarshaller
    implements Marshaller<LastAck> {
        protected LastAckMarshaller() {
        }

        @Override
        public void writePayload(LastAck object, DataOutput dataOut) throws IOException {
            dataOut.writeLong(object.lastAckedSequence);
            dataOut.writeByte(object.priority);
        }

        @Override
        public LastAck readPayload(DataInput dataIn) throws IOException {
            LastAck lastAcked = new LastAck();
            lastAcked.lastAckedSequence = dataIn.readLong();
            if (MessageDatabase.this.metadata.version >= 3) {
                lastAcked.priority = dataIn.readByte();
            }
            return lastAcked;
        }

        @Override
        public int getFixedSize() {
            return 9;
        }

        @Override
        public LastAck deepCopy(LastAck source) {
            return new LastAck(source);
        }

        @Override
        public boolean isDeepCopySupported() {
            return true;
        }
    }

    class LastAck {
        long lastAckedSequence;
        byte priority;

        public LastAck(LastAck source) {
            this.lastAckedSequence = source.lastAckedSequence;
            this.priority = source.priority;
        }

        public LastAck() {
            this.priority = (byte)9;
        }

        public LastAck(long ackLocation) {
            this.lastAckedSequence = ackLocation;
            this.priority = 0;
        }

        public LastAck(long ackLocation, byte priority) {
            this.lastAckedSequence = ackLocation;
            this.priority = priority;
        }

        public String toString() {
            return "[" + this.lastAckedSequence + ":" + this.priority + "]";
        }
    }

    protected static class MessageKeysMarshaller
    extends VariableMarshaller<MessageKeys> {
        static final MessageKeysMarshaller INSTANCE = new MessageKeysMarshaller();

        protected MessageKeysMarshaller() {
        }

        @Override
        public MessageKeys readPayload(DataInput dataIn) throws IOException {
            return new MessageKeys(dataIn.readUTF(), LocationMarshaller.INSTANCE.readPayload(dataIn));
        }

        @Override
        public void writePayload(MessageKeys object, DataOutput dataOut) throws IOException {
            dataOut.writeUTF(object.messageId);
            LocationMarshaller.INSTANCE.writePayload(object.location, dataOut);
        }
    }

    static class MessageKeys {
        final String messageId;
        final Location location;

        public MessageKeys(String messageId, Location location) {
            this.messageId = messageId;
            this.location = location;
        }

        public String toString() {
            return "[" + this.messageId + "," + this.location + "]";
        }
    }

    class TranInfo {
        TransactionId id;
        Location location;
        HashMap<KahaDestination, opCount> destinationOpCount = new HashMap();

        TranInfo() {
        }

        public void track(Operation operation) {
            KahaDestination destination;
            if (this.location == null) {
                this.location = operation.getLocation();
            }
            boolean isAdd = false;
            if (operation instanceof AddOperation) {
                AddOperation add = (AddOperation)operation;
                destination = ((KahaAddMessageCommand)add.getCommand()).getDestination();
                isAdd = true;
            } else {
                RemoveOperation removeOpperation = (RemoveOperation)operation;
                destination = ((KahaRemoveMessageCommand)removeOpperation.getCommand()).getDestination();
            }
            opCount opCount2 = this.destinationOpCount.get((Object)destination);
            if (opCount2 == null) {
                opCount2 = new opCount();
                this.destinationOpCount.put(destination, opCount2);
            }
            if (isAdd) {
                ++opCount2.add;
            } else {
                ++opCount2.remove;
            }
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.location).append(";").append(this.id).append(";\n");
            for (Map.Entry<KahaDestination, opCount> op : this.destinationOpCount.entrySet()) {
                buffer.append((Object)op.getKey()).append('+').append(op.getValue().add).append(',').append('-').append(op.getValue().remove).append(';');
            }
            return buffer.toString();
        }

        class opCount {
            int add;
            int remove;

            opCount() {
            }
        }
    }

    class MetadataMarshaller
    extends VariableMarshaller<Metadata> {
        MetadataMarshaller() {
        }

        @Override
        public Metadata readPayload(DataInput dataIn) throws IOException {
            Metadata rc = MessageDatabase.this.createMetadata();
            rc.read(dataIn);
            return rc;
        }

        @Override
        public void writePayload(Metadata object, DataOutput dataOut) throws IOException {
            object.write(dataOut);
        }
    }

    protected class Metadata {
        protected Page<Metadata> page;
        protected int state;
        protected BTreeIndex<String, StoredDestination> destinations;
        protected Location lastUpdate;
        protected Location firstInProgressTransactionLocation;
        protected Location producerSequenceIdTrackerLocation = null;
        protected Location ackMessageFileMapLocation = null;
        protected transient ActiveMQMessageAuditNoSync producerSequenceIdTracker = new ActiveMQMessageAuditNoSync();
        protected transient Map<Integer, Set<Integer>> ackMessageFileMap = new HashMap<Integer, Set<Integer>>();
        protected int version = 5;
        protected int openwireVersion = 6;

        protected Metadata() {
        }

        public void read(DataInput is) throws IOException {
            this.state = is.readInt();
            this.destinations = new BTreeIndex(MessageDatabase.this.pageFile, is.readLong());
            this.lastUpdate = is.readBoolean() ? LocationMarshaller.INSTANCE.readPayload(is) : null;
            this.firstInProgressTransactionLocation = is.readBoolean() ? LocationMarshaller.INSTANCE.readPayload(is) : null;
            try {
                this.producerSequenceIdTrackerLocation = is.readBoolean() ? LocationMarshaller.INSTANCE.readPayload(is) : null;
            }
            catch (EOFException expectedOnUpgrade) {
                // empty catch block
            }
            try {
                this.version = is.readInt();
            }
            catch (EOFException expectedOnUpgrade) {
                this.version = 1;
            }
            this.ackMessageFileMapLocation = this.version >= 5 && is.readBoolean() ? LocationMarshaller.INSTANCE.readPayload(is) : null;
            try {
                this.openwireVersion = is.readInt();
            }
            catch (EOFException expectedOnUpgrade) {
                this.openwireVersion = 6;
            }
            LOG.info("KahaDB is version " + this.version);
        }

        public void write(DataOutput os) throws IOException {
            os.writeInt(this.state);
            os.writeLong(this.destinations.getPageId());
            if (this.lastUpdate != null) {
                os.writeBoolean(true);
                LocationMarshaller.INSTANCE.writePayload(this.lastUpdate, os);
            } else {
                os.writeBoolean(false);
            }
            if (this.firstInProgressTransactionLocation != null) {
                os.writeBoolean(true);
                LocationMarshaller.INSTANCE.writePayload(this.firstInProgressTransactionLocation, os);
            } else {
                os.writeBoolean(false);
            }
            if (this.producerSequenceIdTrackerLocation != null) {
                os.writeBoolean(true);
                LocationMarshaller.INSTANCE.writePayload(this.producerSequenceIdTrackerLocation, os);
            } else {
                os.writeBoolean(false);
            }
            os.writeInt(5);
            if (this.ackMessageFileMapLocation != null) {
                os.writeBoolean(true);
                LocationMarshaller.INSTANCE.writePayload(this.ackMessageFileMapLocation, os);
            } else {
                os.writeBoolean(false);
            }
            os.writeInt(this.openwireVersion);
        }
    }
}

