/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadb.scheduler;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.MessageFormatException;
import org.apache.activemq.broker.scheduler.CronParser;
import org.apache.activemq.broker.scheduler.Job;
import org.apache.activemq.broker.scheduler.JobListener;
import org.apache.activemq.broker.scheduler.JobScheduler;
import org.apache.activemq.store.kahadb.disk.index.BTreeIndex;
import org.apache.activemq.store.kahadb.disk.journal.Location;
import org.apache.activemq.store.kahadb.disk.page.Transaction;
import org.apache.activemq.store.kahadb.disk.util.LongMarshaller;
import org.apache.activemq.store.kahadb.disk.util.VariableMarshaller;
import org.apache.activemq.store.kahadb.scheduler.JobImpl;
import org.apache.activemq.store.kahadb.scheduler.JobLocation;
import org.apache.activemq.store.kahadb.scheduler.JobSchedulerStoreImpl;
import org.apache.activemq.util.ByteSequence;
import org.apache.activemq.util.IdGenerator;
import org.apache.activemq.util.ServiceStopper;
import org.apache.activemq.util.ServiceSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JobSchedulerImpl
extends ServiceSupport
implements Runnable,
JobScheduler {
    private static final Logger LOG = LoggerFactory.getLogger(JobSchedulerImpl.class);
    final JobSchedulerStoreImpl store;
    private final AtomicBoolean running = new AtomicBoolean();
    private String name;
    BTreeIndex<Long, List<JobLocation>> index;
    private Thread thread;
    private final List<JobListener> jobListeners = new CopyOnWriteArrayList<JobListener>();
    private static final IdGenerator ID_GENERATOR = new IdGenerator();
    private final ScheduleTime scheduleTime = new ScheduleTime();

    JobSchedulerImpl(JobSchedulerStoreImpl store) {
        this.store = store;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void addListener(JobListener l) {
        this.jobListeners.add(l);
    }

    public void removeListener(JobListener l) {
        this.jobListeners.remove(l);
    }

    public synchronized void schedule(final String jobId, final ByteSequence payload, final long delay) throws IOException {
        this.store.getPageFile().tx().execute(new Transaction.Closure<IOException>(){

            @Override
            public void execute(Transaction tx) throws IOException {
                JobSchedulerImpl.this.schedule(tx, jobId, payload, "", 0L, delay, 0);
            }
        });
    }

    public synchronized void schedule(final String jobId, final ByteSequence payload, final String cronEntry) throws Exception {
        this.store.getPageFile().tx().execute(new Transaction.Closure<IOException>(){

            @Override
            public void execute(Transaction tx) throws IOException {
                JobSchedulerImpl.this.schedule(tx, jobId, payload, cronEntry, 0L, 0L, 0);
            }
        });
    }

    public synchronized void schedule(final String jobId, final ByteSequence payload, final String cronEntry, final long delay, final long period, final int repeat) throws IOException {
        this.store.getPageFile().tx().execute(new Transaction.Closure<IOException>(){

            @Override
            public void execute(Transaction tx) throws IOException {
                JobSchedulerImpl.this.schedule(tx, jobId, payload, cronEntry, delay, period, repeat);
            }
        });
    }

    public synchronized void remove(final long time) throws IOException {
        this.store.getPageFile().tx().execute(new Transaction.Closure<IOException>(){

            @Override
            public void execute(Transaction tx) throws IOException {
                JobSchedulerImpl.this.remove(tx, time);
            }
        });
    }

    synchronized void removeFromIndex(final long time, final String jobId) throws IOException {
        this.store.getPageFile().tx().execute(new Transaction.Closure<IOException>(){

            @Override
            public void execute(Transaction tx) throws IOException {
                JobSchedulerImpl.this.removeFromIndex(tx, time, jobId);
            }
        });
    }

    public synchronized void remove(final long time, final String jobId) throws IOException {
        this.store.getPageFile().tx().execute(new Transaction.Closure<IOException>(){

            @Override
            public void execute(Transaction tx) throws IOException {
                JobSchedulerImpl.this.remove(tx, time, jobId);
            }
        });
    }

    public synchronized void remove(final String jobId) throws IOException {
        this.store.getPageFile().tx().execute(new Transaction.Closure<IOException>(){

            @Override
            public void execute(Transaction tx) throws IOException {
                JobSchedulerImpl.this.remove(tx, jobId);
            }
        });
    }

    public synchronized long getNextScheduleTime() throws IOException {
        Map.Entry<Long, List<JobLocation>> first = this.index.getFirst(this.store.getPageFile().tx());
        return first != null ? first.getKey() : -1L;
    }

    public synchronized List<Job> getNextScheduleJobs() throws IOException {
        final ArrayList<Job> result = new ArrayList<Job>();
        this.store.getPageFile().tx().execute(new Transaction.Closure<IOException>(){

            @Override
            public void execute(Transaction tx) throws IOException {
                Map.Entry<Long, List<JobLocation>> first = JobSchedulerImpl.this.index.getFirst(JobSchedulerImpl.this.store.getPageFile().tx());
                if (first != null) {
                    for (JobLocation jl : first.getValue()) {
                        ByteSequence bs = JobSchedulerImpl.this.getPayload(jl.getLocation());
                        JobImpl job = new JobImpl(jl, bs);
                        result.add(job);
                    }
                }
            }
        });
        return result;
    }

    public synchronized List<Job> getAllJobs() throws IOException {
        final ArrayList<Job> result = new ArrayList<Job>();
        this.store.getPageFile().tx().execute(new Transaction.Closure<IOException>(){

            @Override
            public void execute(Transaction tx) throws IOException {
                Map.Entry<Long, List<JobLocation>> next;
                Iterator<Map.Entry<Long, List<JobLocation>>> iter = JobSchedulerImpl.this.index.iterator(JobSchedulerImpl.this.store.getPageFile().tx());
                while (iter.hasNext() && (next = iter.next()) != null) {
                    for (JobLocation jl : next.getValue()) {
                        ByteSequence bs = JobSchedulerImpl.this.getPayload(jl.getLocation());
                        JobImpl job = new JobImpl(jl, bs);
                        result.add(job);
                    }
                }
            }
        });
        return result;
    }

    public synchronized List<Job> getAllJobs(final long start, final long finish) throws IOException {
        final ArrayList<Job> result = new ArrayList<Job>();
        this.store.getPageFile().tx().execute(new Transaction.Closure<IOException>(){

            @Override
            public void execute(Transaction tx) throws IOException {
                Map.Entry<Long, List<JobLocation>> next;
                Iterator<Map.Entry<Long, List<JobLocation>>> iter = JobSchedulerImpl.this.index.iterator(JobSchedulerImpl.this.store.getPageFile().tx(), start);
                while (iter.hasNext() && (next = iter.next()) != null && next.getKey() <= finish) {
                    for (JobLocation jl : next.getValue()) {
                        ByteSequence bs = JobSchedulerImpl.this.getPayload(jl.getLocation());
                        JobImpl job = new JobImpl(jl, bs);
                        result.add(job);
                    }
                }
            }
        });
        return result;
    }

    public synchronized void removeAllJobs() throws IOException {
        this.store.getPageFile().tx().execute(new Transaction.Closure<IOException>(){

            @Override
            public void execute(Transaction tx) throws IOException {
                JobSchedulerImpl.this.destroy(tx);
            }
        });
    }

    public synchronized void removeAllJobs(final long start, final long finish) throws IOException {
        this.store.getPageFile().tx().execute(new Transaction.Closure<IOException>(){

            @Override
            public void execute(Transaction tx) throws IOException {
                JobSchedulerImpl.this.destroy(tx, start, finish);
            }
        });
    }

    ByteSequence getPayload(Location location) throws IllegalStateException, IOException {
        return this.store.getPayload(location);
    }

    void schedule(Transaction tx, String jobId, ByteSequence payload, String cronEntry, long delay, long period, int repeat) throws IOException {
        long startTime = System.currentTimeMillis();
        startTime = startTime / 1000L * 1000L;
        long time = 0L;
        if (cronEntry != null && cronEntry.length() > 0) {
            try {
                time = CronParser.getNextScheduledTime((String)cronEntry, (long)startTime);
            }
            catch (MessageFormatException e) {
                throw new IOException(e.getMessage());
            }
        }
        if (time == 0L) {
            time = startTime;
        }
        time = delay > 0L ? (time += delay) : (time += period);
        Location location = this.store.write(payload, false);
        JobLocation jobLocation = new JobLocation(location);
        this.store.incrementJournalCount(tx, location);
        jobLocation.setJobId(jobId);
        jobLocation.setStartTime(startTime);
        jobLocation.setCronEntry(cronEntry);
        jobLocation.setDelay(delay);
        jobLocation.setPeriod(period);
        jobLocation.setRepeat(repeat);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Scheduling " + jobLocation);
        }
        this.storeJob(tx, jobLocation, time);
        this.scheduleTime.newJob();
    }

    synchronized void storeJob(final JobLocation jobLocation, final long nextExecutionTime) throws IOException {
        this.store.getPageFile().tx().execute(new Transaction.Closure<IOException>(){

            @Override
            public void execute(Transaction tx) throws IOException {
                JobSchedulerImpl.this.storeJob(tx, jobLocation, nextExecutionTime);
            }
        });
    }

    void storeJob(Transaction tx, JobLocation jobLocation, long nextExecutionTime) throws IOException {
        List<JobLocation> values = null;
        jobLocation.setNextTime(nextExecutionTime);
        if (this.index.containsKey(tx, nextExecutionTime)) {
            values = this.index.remove(tx, nextExecutionTime);
        }
        if (values == null) {
            values = new ArrayList<JobLocation>();
        }
        values.add(jobLocation);
        this.index.put(tx, nextExecutionTime, values);
    }

    void remove(Transaction tx, long time, String jobId) throws IOException {
        JobLocation result = this.removeFromIndex(tx, time, jobId);
        if (result != null) {
            this.store.decrementJournalCount(tx, result.getLocation());
        }
    }

    JobLocation removeFromIndex(Transaction tx, long time, String jobId) throws IOException {
        JobLocation result = null;
        List<JobLocation> values = this.index.remove(tx, time);
        if (values != null) {
            for (int i = 0; i < values.size(); ++i) {
                JobLocation jl = values.get(i);
                if (!jl.getJobId().equals(jobId)) continue;
                values.remove(i);
                if (!values.isEmpty()) {
                    this.index.put(tx, time, values);
                }
                result = jl;
                break;
            }
        }
        return result;
    }

    void remove(Transaction tx, long time) throws IOException {
        List<JobLocation> values = this.index.remove(tx, time);
        if (values != null) {
            for (JobLocation jl : values) {
                this.store.decrementJournalCount(tx, jl.getLocation());
            }
        }
    }

    void remove(Transaction tx, String id) throws IOException {
        Iterator<Map.Entry<Long, List<JobLocation>>> i = this.index.iterator(tx);
        while (i.hasNext()) {
            Map.Entry<Long, List<JobLocation>> entry = i.next();
            List<JobLocation> values = entry.getValue();
            if (values == null) continue;
            for (JobLocation jl : values) {
                if (!jl.getJobId().equals(id)) continue;
                this.remove(tx, entry.getKey(), id);
                return;
            }
        }
    }

    synchronized void destroy(Transaction tx) throws IOException {
        ArrayList<Long> keys = new ArrayList<Long>();
        Iterator<Map.Entry<Long, List<JobLocation>>> i = this.index.iterator(tx);
        while (i.hasNext()) {
            Map.Entry<Long, List<JobLocation>> entry = i.next();
            keys.add(entry.getKey());
            List<JobLocation> values = entry.getValue();
            if (values == null) continue;
            for (JobLocation jl : values) {
                this.store.decrementJournalCount(tx, jl.getLocation());
            }
        }
        for (Long l : keys) {
            this.index.remove(tx, l);
        }
    }

    synchronized void destroy(Transaction tx, long start, long finish) throws IOException {
        Map.Entry<Long, List<JobLocation>> entry;
        ArrayList<Long> keys = new ArrayList<Long>();
        Iterator<Map.Entry<Long, List<JobLocation>>> i = this.index.iterator(tx, start);
        while (i.hasNext() && (entry = i.next()).getKey() <= finish) {
            keys.add(entry.getKey());
            List<JobLocation> values = entry.getValue();
            if (values == null) continue;
            for (JobLocation jl : values) {
                this.store.decrementJournalCount(tx, jl.getLocation());
            }
        }
        for (Long l : keys) {
            this.index.remove(tx, l);
        }
    }

    private synchronized Map.Entry<Long, List<JobLocation>> getNextToSchedule() throws IOException {
        if (!this.store.isStopped() && !this.store.isStopping()) {
            Map.Entry<Long, List<JobLocation>> first = this.index.getFirst(this.store.getPageFile().tx());
            return first;
        }
        return null;
    }

    void fireJob(JobLocation job) throws IllegalStateException, IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Firing " + job);
        }
        ByteSequence bs = this.store.getPayload(job.getLocation());
        for (JobListener l : this.jobListeners) {
            l.scheduledJob(job.getJobId(), bs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.mainLoop();
        }
        catch (Throwable e) {
            if (this.running.get() && this.isStarted()) {
                LOG.error(this + " Caught exception in mainloop", e);
            }
        }
        finally {
            if (this.running.get()) {
                try {
                    this.stop();
                }
                catch (Exception e) {
                    LOG.error("Failed to stop " + this);
                }
            }
        }
    }

    public String toString() {
        return "JobScheduler:" + this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mainLoop() {
        while (this.running.get()) {
            this.scheduleTime.clearNewJob();
            try {
                long currentTime = System.currentTimeMillis();
                JobSchedulerImpl jobSchedulerImpl = this;
                synchronized (jobSchedulerImpl) {
                    Map.Entry<Long, List<JobLocation>> first = this.getNextToSchedule();
                    if (first != null) {
                        ArrayList list = new ArrayList(first.getValue());
                        long executionTime = first.getKey();
                        long nextExecutionTime = 0L;
                        if (executionTime <= currentTime) {
                            long timeUntilNextScheduled;
                            for (JobLocation job : list) {
                                int repeat = job.getRepeat();
                                nextExecutionTime = this.calculateNextExecutionTime(job, currentTime, repeat);
                                long waitTime = nextExecutionTime - currentTime;
                                this.scheduleTime.setWaitTime(waitTime);
                                if (!job.isCron()) {
                                    this.fireJob(job);
                                    if (repeat == 0) continue;
                                    job.setRepeat(--repeat);
                                    this.removeFromIndex(executionTime, job.getJobId());
                                    this.storeJob(job, nextExecutionTime);
                                    continue;
                                }
                                if (repeat == 0) {
                                    this.fireJob(job);
                                }
                                if (nextExecutionTime <= currentTime) continue;
                                this.removeFromIndex(executionTime, job.getJobId());
                                this.storeJob(job, nextExecutionTime);
                                if (repeat == 0) continue;
                                String jobId = ID_GENERATOR.generateId();
                                ByteSequence payload = this.getPayload(job.getLocation());
                                this.schedule(jobId, payload, "", job.getDelay(), job.getPeriod(), job.getRepeat());
                                waitTime = job.getDelay() != 0L ? job.getDelay() : job.getPeriod();
                                this.scheduleTime.setWaitTime(waitTime);
                            }
                            this.remove(executionTime);
                            Map.Entry<Long, List<JobLocation>> nextUp = this.getNextToSchedule();
                            if (nextUp != null && (timeUntilNextScheduled = nextUp.getKey() - currentTime) < this.scheduleTime.getWaitTime()) {
                                this.scheduleTime.setWaitTime(timeUntilNextScheduled);
                            }
                        } else {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Not yet time to execute the job, waiting " + (executionTime - currentTime) + " ms");
                            }
                            this.scheduleTime.setWaitTime(executionTime - currentTime);
                        }
                    }
                }
                this.scheduleTime.pause();
            }
            catch (Exception ioe) {
                LOG.error(this.name + " Failed to schedule job", (Throwable)ioe);
                try {
                    this.store.stop();
                }
                catch (Exception e) {
                    LOG.error(this.name + " Failed to shutdown JobSchedulerStore", (Throwable)e);
                }
            }
        }
    }

    protected void doStart() throws Exception {
        this.running.set(true);
        this.thread = new Thread((Runnable)this, "JobScheduler:" + this.name);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    protected void doStop(ServiceStopper stopper) throws Exception {
        this.running.set(false);
        this.scheduleTime.wakeup();
        Thread t = this.thread;
        if (t != null) {
            t.join(1000L);
        }
    }

    long calculateNextExecutionTime(JobLocation job, long currentTime, int repeat) throws MessageFormatException {
        long result = currentTime;
        String cron = job.getCronEntry();
        if (cron != null && cron.length() > 0) {
            result = CronParser.getNextScheduledTime((String)cron, (long)result);
        } else if (job.getRepeat() != 0) {
            result += job.getPeriod();
        }
        return result;
    }

    void createIndexes(Transaction tx) throws IOException {
        this.index = new BTreeIndex(this.store.getPageFile(), tx.allocate().getPageId());
    }

    void load(Transaction tx) throws IOException {
        this.index.setKeyMarshaller(LongMarshaller.INSTANCE);
        this.index.setValueMarshaller(ValueMarshaller.INSTANCE);
        this.index.load(tx);
    }

    void read(DataInput in) throws IOException {
        this.name = in.readUTF();
        this.index = new BTreeIndex(this.store.getPageFile(), in.readLong());
        this.index.setKeyMarshaller(LongMarshaller.INSTANCE);
        this.index.setValueMarshaller(ValueMarshaller.INSTANCE);
    }

    public void write(DataOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeLong(this.index.getPageId());
    }

    static class ScheduleTime {
        private final int DEFAULT_WAIT = 500;
        private final int DEFAULT_NEW_JOB_WAIT = 100;
        private boolean newJob;
        private long waitTime = 500L;
        private final Object mutex = new Object();

        ScheduleTime() {
        }

        long getWaitTime() {
            return this.waitTime;
        }

        void setWaitTime(long waitTime) {
            if (!this.newJob) {
                this.waitTime = waitTime > 0L ? waitTime : 500L;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void pause() {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    this.mutex.wait(this.waitTime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        void newJob() {
            this.newJob = true;
            this.waitTime = 100L;
            this.wakeup();
        }

        void clearNewJob() {
            this.newJob = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void wakeup() {
            Object object = this.mutex;
            synchronized (object) {
                this.mutex.notifyAll();
            }
        }
    }

    static class ValueMarshaller
    extends VariableMarshaller<List<JobLocation>> {
        static ValueMarshaller INSTANCE = new ValueMarshaller();

        ValueMarshaller() {
        }

        @Override
        public List<JobLocation> readPayload(DataInput dataIn) throws IOException {
            ArrayList<JobLocation> result = new ArrayList<JobLocation>();
            int size = dataIn.readInt();
            for (int i = 0; i < size; ++i) {
                JobLocation jobLocation = new JobLocation();
                jobLocation.readExternal(dataIn);
                result.add(jobLocation);
            }
            return result;
        }

        @Override
        public void writePayload(List<JobLocation> value, DataOutput dataOut) throws IOException {
            dataOut.writeInt(value.size());
            for (JobLocation jobLocation : value) {
                jobLocation.writeExternal(dataOut);
            }
        }
    }
}

