/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.mqtt;

import java.util.HashMap;
import java.util.Map;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.BrokerServiceAware;
import org.apache.activemq.transport.MutexTransport;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.mqtt.MQTTInactivityMonitor;
import org.apache.activemq.transport.mqtt.MQTTTransportFilter;
import org.apache.activemq.transport.tcp.SslTransportFactory;
import org.apache.activemq.util.IntrospectionSupport;
import org.apache.activemq.wireformat.WireFormat;

public class MQTTSslTransportFactory
extends SslTransportFactory
implements BrokerServiceAware {
    private BrokerService brokerService = null;

    protected String getDefaultWireFormatType() {
        return "mqtt";
    }

    public Transport compositeConfigure(Transport transport, WireFormat format, Map options) {
        transport = new MQTTTransportFilter((Transport)transport, format, this.brokerService);
        IntrospectionSupport.setProperties((Object)transport, (Map)options);
        return super.compositeConfigure(transport, format, options);
    }

    public Transport serverConfigure(Transport transport, WireFormat format, HashMap options) throws Exception {
        MutexTransport mutex = (MutexTransport)(transport = super.serverConfigure(transport, format, options)).narrow(MutexTransport.class);
        if (mutex != null) {
            mutex.setSyncOnCommand(true);
        }
        return transport;
    }

    public void setBrokerService(BrokerService brokerService) {
        this.brokerService = brokerService;
    }

    protected Transport createInactivityMonitor(Transport transport, WireFormat format) {
        MQTTInactivityMonitor monitor = new MQTTInactivityMonitor(transport, format);
        MQTTTransportFilter filter = (MQTTTransportFilter)transport.narrow(MQTTTransportFilter.class);
        filter.setInactivityMonitor(monitor);
        return monitor;
    }
}

