/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.mqtt;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.activemq.util.ByteArrayInputStream;
import org.apache.activemq.util.ByteArrayOutputStream;
import org.apache.activemq.util.ByteSequence;
import org.apache.activemq.wireformat.WireFormat;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.mqtt.codec.MQTTFrame;

public class MQTTWireFormat
implements WireFormat {
    static final int MAX_MESSAGE_LENGTH = 0x10000000;
    static final long DEFAULT_CONNECTION_TIMEOUT = 30000L;
    private int version = 1;

    public ByteSequence marshal(Object command) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream((OutputStream)baos);
        this.marshal(command, dos);
        dos.close();
        return baos.toByteSequence();
    }

    public Object unmarshal(ByteSequence packet) throws IOException {
        ByteArrayInputStream stream = new ByteArrayInputStream(packet);
        DataInputStream dis = new DataInputStream((InputStream)stream);
        return this.unmarshal(dis);
    }

    public void marshal(Object command, DataOutput dataOut) throws IOException {
        MQTTFrame frame = (MQTTFrame)command;
        dataOut.write(frame.header());
        int remaining = 0;
        for (Buffer buffer : frame.buffers) {
            remaining += buffer.length;
        }
        do {
            byte digit = (byte)(remaining & 0x7F);
            if ((remaining >>>= 7) > 0) {
                digit = (byte)(digit | 0x80);
            }
            dataOut.write(digit);
        } while (remaining > 0);
        for (Buffer buffer : frame.buffers) {
            dataOut.write(buffer.data, buffer.offset, buffer.length);
        }
    }

    public Object unmarshal(DataInput dataIn) throws IOException {
        byte digit;
        byte header = dataIn.readByte();
        int multiplier = 1;
        int length = 0;
        do {
            digit = dataIn.readByte();
            length += (digit & 0x7F) * multiplier;
            multiplier <<= 7;
        } while ((digit & 0x80) != 0);
        if (length >= 0) {
            if (length > 0x10000000) {
                throw new IOException("The maximum message length was exceeded");
            }
            if (length > 0) {
                byte[] data = new byte[length];
                dataIn.readFully(data);
                Buffer body = new Buffer(data);
                return new MQTTFrame(body).header(header);
            }
            return new MQTTFrame().header(header);
        }
        return null;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getVersion() {
        return this.version;
    }
}

