/**
 *
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.activemq.openwire.tool;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.List;

import org.codehaus.jam.JClass;
import org.codehaus.jam.JProperty;

/**
 *
 * @version $Revision: 383749 $
 */
public class CSharpClassesGenerator extends MultiSourceGenerator {
	
	protected String targetDir="./src/main/csharp";

    public Object run() {
        filePostFix = ".cs";
        if (destDir == null) {
            destDir = new File(targetDir+"/ActiveMQ/Commands");
        }        
        return super.run();
    }
    
    public String makeHashCodeBody() throws Exception {
        if (simpleName.endsWith("Id")) {
            StringWriter buffer = new StringWriter();
            PrintWriter out = new PrintWriter(buffer);
            out.println("            int answer = 0;");
            Iterator iter = getProperties().iterator();
            while (iter.hasNext()) {
                JProperty property = (JProperty) iter.next();
                out.println("            answer = (answer * 37) + HashCode(" + property.getSimpleName() + ");");
            }
            out.println("            return answer;");
            return buffer.toString();
        }
        return null;
    }

    public String makeEqualsBody() throws Exception {
        if (simpleName.endsWith("Id")) {
            StringWriter buffer = new StringWriter();
            PrintWriter out = new PrintWriter(buffer);
            
            Iterator iter = getProperties().iterator();
            while (iter.hasNext()) {
                JProperty property = (JProperty) iter.next();
                String name = property.getSimpleName();
                out.println("            if (! Equals(this." + name + ", that." + name + ")) return false;");
            }
            out.println("            return true;");
            return buffer.toString();
        }
        return null;
    }
    
    public String makeToStringBody() throws Exception {
            StringWriter buffer = new StringWriter();
            PrintWriter out = new PrintWriter(buffer);
            out.println("            return GetType().Name + \"[\"");
            Iterator iter = getProperties().iterator();
            while (iter.hasNext()) {
                JProperty property = (JProperty) iter.next();
                String name = property.getSimpleName();
                out.println("                + \" " + name + "=\" + " + name);
            }
            out.println("                + \" ]\";");
            return buffer.toString();
    }

	private void generateLicence(PrintWriter out) {
out.println("/*");
out.println(" * Licensed to the Apache Software Foundation (ASF) under one or more");
out.println(" * contributor license agreements.  See the NOTICE file distributed with");
out.println(" * this work for additional information regarding copyright ownership.");
out.println(" * The ASF licenses this file to You under the Apache License, Version 2.0");
out.println(" * (the \"License\"); you may not use this file except in compliance with");
out.println(" * the License.  You may obtain a copy of the License at");
out.println(" *");
out.println(" * http://www.apache.org/licenses/LICENSE-2.0");
out.println(" *");
out.println(" * Unless required by applicable law or agreed to in writing, software");
out.println(" * distributed under the License is distributed on an \"AS IS\" BASIS,");
out.println(" * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.");
out.println(" * See the License for the specific language governing permissions and");
out.println(" * limitations under the License.");
out.println(" */");
	}


	protected void generateFile(PrintWriter out) throws Exception {
		generateLicence(out);

out.println("//");
out.println("//  NOTE!: This file is autogenerated - do not modify!");
out.println("//         if you need to make a change, please see the Groovy scripts in the");
out.println("//         activemq-core module");
out.println("//");
out.println("");
out.println("using System;");
out.println("using System.Collections;");
out.println("");
out.println("using ActiveMQ.OpenWire;");
out.println("using ActiveMQ.Commands;");
out.println("");
out.println("namespace ActiveMQ.Commands");
out.println("{");
out.println("    /// <summary>");
out.println("    ///  The ActiveMQ "+jclass.getSimpleName()+" Command");
out.println("    /// </summary>");
  out.print("    public class "+jclass.getSimpleName()+" : "+baseClass);


  	for (int i = 0; i < jclass.getInterfaces().length; i++) {
		JClass intf = jclass.getInterfaces()[i];
		out.print(", "+intf.getSimpleName());
	}
    
out.println("");
out.println("    {");
out.println("        public const byte ID_"+jclass.getSimpleName()+" = "+getOpenWireOpCode(jclass)+";");
out.println("    			");

		List properties = getProperties();
		String type;
		Object name;
		for (Iterator iter = properties.iterator(); iter.hasNext();) {
			JProperty property = (JProperty) iter.next();
	        type = toCSharpType(property.getType());
	        name = decapitalize(property.getSimpleName());
out.println("        "+type+" "+name+";");
    }

	String text = makeHashCodeBody();
	if (text != null) {
out.println("");
out.println("		public override int GetHashCode() {");
out.println(""+text+"");
out.println("		}");
	}

	text = makeEqualsBody();
	if (text != null) {
out.println("");
out.println("		public override bool Equals(object that) {");
out.println("	    	if (that is "+className+") {");
out.println("	    	    return Equals(("+className+") that);");
out.println("			}");
out.println("			return false;");
out.println("    	}");
out.println("");    
out.println("		public virtual bool Equals("+className+" that) {");
out.println(""+text+"");
out.println("		}");
	}
	    
	text = makeToStringBody();
	if (text != null) {
out.println("");	
out.println("		public override string ToString() {");
out.println(""+text+"");
out.println("		}");
	}
	    
out.println("");
out.println("        public override byte GetDataStructureType() {");
out.println("            return ID_"+jclass.getSimpleName()+";");
out.println("        }");
out.println("");
out.println("");
out.println("        // Properties");

				for (Iterator iter = properties.iterator(); iter.hasNext();) {
					JProperty property = (JProperty) iter.next();
                    type = toCSharpType(property.getType());
                    name = decapitalize(property.getSimpleName());
                    String propertyName = property.getSimpleName();
                    String getter = capitalize(property.getGetter().getSimpleName());
                    String setter = capitalize(property.getSetter().getSimpleName());

out.println("");
out.println("        public "+type+" "+propertyName+"");
out.println("        {");
out.println("            get { return "+name+"; }");
out.println("            set { this."+name+" = value; }            ");
out.println("        }");
                }

out.println("");
out.println("    }");
out.println("}");
	}

	public String getTargetDir() {
		return targetDir;
	}

	public void setTargetDir(String targetDir) {
		this.targetDir = targetDir;
	}
}
