/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.openwire.tool;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.List;
import org.apache.activemq.openwire.tool.MultiSourceGenerator;
import org.codehaus.jam.JClass;
import org.codehaus.jam.JProperty;

public class CSharpClassesGenerator
extends MultiSourceGenerator {
    protected String targetDir = "./src/main/csharp";

    public Object run() {
        this.filePostFix = ".cs";
        if (this.destDir == null) {
            this.destDir = new File(this.targetDir + "/ActiveMQ/Commands");
        }
        return super.run();
    }

    public String makeHashCodeBody() throws Exception {
        if (this.simpleName.endsWith("Id")) {
            StringWriter buffer = new StringWriter();
            PrintWriter out = new PrintWriter(buffer);
            out.println("            int answer = 0;");
            Iterator iter = this.getProperties().iterator();
            while (iter.hasNext()) {
                JProperty property = (JProperty)iter.next();
                out.println("            answer = (answer * 37) + HashCode(" + property.getSimpleName() + ");");
            }
            out.println("            return answer;");
            return buffer.toString();
        }
        return null;
    }

    public String makeEqualsBody() throws Exception {
        if (this.simpleName.endsWith("Id")) {
            StringWriter buffer = new StringWriter();
            PrintWriter out = new PrintWriter(buffer);
            Iterator iter = this.getProperties().iterator();
            while (iter.hasNext()) {
                JProperty property = (JProperty)iter.next();
                String name = property.getSimpleName();
                out.println("            if (! Equals(this." + name + ", that." + name + ")) return false;");
            }
            out.println("            return true;");
            return buffer.toString();
        }
        return null;
    }

    public String makeToStringBody() throws Exception {
        StringWriter buffer = new StringWriter();
        PrintWriter out = new PrintWriter(buffer);
        out.println("            return GetType().Name + \"[\"");
        Iterator iter = this.getProperties().iterator();
        while (iter.hasNext()) {
            JProperty property = (JProperty)iter.next();
            String name = property.getSimpleName();
            out.println("                + \" " + name + "=\" + " + name);
        }
        out.println("                + \" ]\";");
        return buffer.toString();
    }

    private void generateLicence(PrintWriter out) {
        out.println("/*");
        out.println(" * Licensed to the Apache Software Foundation (ASF) under one or more");
        out.println(" * contributor license agreements.  See the NOTICE file distributed with");
        out.println(" * this work for additional information regarding copyright ownership.");
        out.println(" * The ASF licenses this file to You under the Apache License, Version 2.0");
        out.println(" * (the \"License\"); you may not use this file except in compliance with");
        out.println(" * the License.  You may obtain a copy of the License at");
        out.println(" *");
        out.println(" * http://www.apache.org/licenses/LICENSE-2.0");
        out.println(" *");
        out.println(" * Unless required by applicable law or agreed to in writing, software");
        out.println(" * distributed under the License is distributed on an \"AS IS\" BASIS,");
        out.println(" * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.");
        out.println(" * See the License for the specific language governing permissions and");
        out.println(" * limitations under the License.");
        out.println(" */");
    }

    protected void generateFile(PrintWriter out) throws Exception {
        String name;
        String type;
        this.generateLicence(out);
        out.println("//");
        out.println("//  NOTE!: This file is autogenerated - do not modify!");
        out.println("//         if you need to make a change, please see the Groovy scripts in the");
        out.println("//         activemq-core module");
        out.println("//");
        out.println("");
        out.println("using System;");
        out.println("using System.Collections;");
        out.println("");
        out.println("using ActiveMQ.OpenWire;");
        out.println("using ActiveMQ.Commands;");
        out.println("");
        out.println("namespace ActiveMQ.Commands");
        out.println("{");
        out.println("    /// <summary>");
        out.println("    ///  The ActiveMQ " + this.jclass.getSimpleName() + " Command");
        out.println("    /// </summary>");
        out.print("    public class " + this.jclass.getSimpleName() + " : " + this.baseClass);
        for (int i = 0; i < this.jclass.getInterfaces().length; ++i) {
            JClass intf = this.jclass.getInterfaces()[i];
            out.print(", " + intf.getSimpleName());
        }
        out.println("");
        out.println("    {");
        out.println("        public const byte ID_" + this.jclass.getSimpleName() + " = " + this.getOpenWireOpCode(this.jclass) + ";");
        out.println("    \t\t\t");
        List properties = this.getProperties();
        Iterator iter = properties.iterator();
        while (iter.hasNext()) {
            JProperty property = (JProperty)iter.next();
            type = this.toCSharpType(property.getType());
            name = this.decapitalize(property.getSimpleName());
            out.println("        " + type + " " + name + ";");
        }
        String text = this.makeHashCodeBody();
        if (text != null) {
            out.println("");
            out.println("\t\tpublic override int GetHashCode() {");
            out.println("" + text + "");
            out.println("\t\t}");
        }
        if ((text = this.makeEqualsBody()) != null) {
            out.println("");
            out.println("\t\tpublic override bool Equals(object that) {");
            out.println("\t    \tif (that is " + this.className + ") {");
            out.println("\t    \t    return Equals((" + this.className + ") that);");
            out.println("\t\t\t}");
            out.println("\t\t\treturn false;");
            out.println("    \t}");
            out.println("");
            out.println("\t\tpublic virtual bool Equals(" + this.className + " that) {");
            out.println("" + text + "");
            out.println("\t\t}");
        }
        if ((text = this.makeToStringBody()) != null) {
            out.println("");
            out.println("\t\tpublic override string ToString() {");
            out.println("" + text + "");
            out.println("\t\t}");
        }
        out.println("");
        out.println("        public override byte GetDataStructureType() {");
        out.println("            return ID_" + this.jclass.getSimpleName() + ";");
        out.println("        }");
        out.println("");
        out.println("");
        out.println("        // Properties");
        Iterator iter2 = properties.iterator();
        while (iter2.hasNext()) {
            JProperty property = (JProperty)iter2.next();
            type = this.toCSharpType(property.getType());
            name = this.decapitalize(property.getSimpleName());
            String propertyName = property.getSimpleName();
            String getter = this.capitalize(property.getGetter().getSimpleName());
            String setter = this.capitalize(property.getSetter().getSimpleName());
            out.println("");
            out.println("        public " + type + " " + propertyName + "");
            out.println("        {");
            out.println("            get { return " + name + "; }");
            out.println("            set { this." + name + " = value; }            ");
            out.println("        }");
        }
        out.println("");
        out.println("    }");
        out.println("}");
    }

    public String getTargetDir() {
        return this.targetDir;
    }

    public void setTargetDir(String targetDir) {
        this.targetDir = targetDir;
    }
}

