/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdispatch.internal.util;

import java.util.concurrent.atomic.AtomicInteger;
import org.fusesource.hawtdispatch.DispatchQueue;
import org.fusesource.hawtdispatch.Task;
import org.fusesource.hawtdispatch.TaskWrapper;

public class RunnableSupport {
    private static Task NO_OP = new Task(){

        public void run() {
        }

        public String toString() {
            return "{}";
        }
    };

    public static Task runNoop() {
        return NO_OP;
    }

    public static Task runOnceAfter(Runnable runnable, int count) {
        return RunnableSupport.runOnceAfter(new TaskWrapper(runnable), count);
    }

    public static Task runOnceAfter(final Task runnable, int count) {
        if (runnable == null) {
            return NO_OP;
        }
        if (count == 0) {
            runnable.run();
            return NO_OP;
        }
        if (count == 1) {
            return runnable;
        }
        final AtomicInteger counter = new AtomicInteger(count);
        return new Task(){

            public void run() {
                if (counter.decrementAndGet() == 0) {
                    runnable.run();
                }
            }

            public String toString() {
                return "{" + runnable + "}";
            }
        };
    }

    public static Task runAfter(Runnable runnable, int count) {
        return RunnableSupport.runAfter(new TaskWrapper(runnable), count);
    }

    public static Task runAfter(final Task runnable, int count) {
        if (count <= 0 || runnable == null) {
            return NO_OP;
        }
        if (count == 1) {
            return runnable;
        }
        final AtomicInteger counter = new AtomicInteger(count);
        return new Task(){

            public void run() {
                if (counter.decrementAndGet() <= 0) {
                    runnable.run();
                }
            }

            public String toString() {
                return "{" + runnable + "}";
            }
        };
    }

    public static Task runOnceAfter(DispatchQueue queue2, Runnable runnable, int count) {
        return RunnableSupport.runOnceAfter(queue2, new TaskWrapper(runnable), count);
    }

    public static Task runOnceAfter(final DispatchQueue queue2, final Task task2, int count) {
        if (count <= 0 || task2 == null) {
            return NO_OP;
        }
        final AtomicInteger counter = new AtomicInteger(count);
        return new Task(){

            public void run() {
                if (counter.decrementAndGet() == 0) {
                    queue2.execute(task2);
                }
            }

            public String toString() {
                return "{" + task2 + "}";
            }
        };
    }

    public static Task runAfter(DispatchQueue queue2, Runnable runnable, int count) {
        return RunnableSupport.runAfter(queue2, new TaskWrapper(runnable), count);
    }

    public static Task runAfter(final DispatchQueue queue2, final Task task2, int count) {
        if (count <= 0 || task2 == null) {
            return NO_OP;
        }
        final AtomicInteger counter = new AtomicInteger(count);
        return new Task(){

            public void run() {
                if (counter.decrementAndGet() <= 0) {
                    queue2.execute(task2);
                }
            }

            public String toString() {
                return "{" + task2.toString() + "}";
            }
        };
    }
}

