/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec;

import java.util.Collection;
import java.util.Collections;
import org.apache.qpid.proton.codec.AbstractPrimitiveType;
import org.apache.qpid.proton.codec.DecoderImpl;
import org.apache.qpid.proton.codec.EncoderImpl;
import org.apache.qpid.proton.codec.FixedSizePrimitiveTypeEncoding;
import org.apache.qpid.proton.codec.TypeEncoding;

public class DoubleType
extends AbstractPrimitiveType<Double> {
    private DoubleEncoding _doubleEncoding;

    DoubleType(EncoderImpl encoder, DecoderImpl decoder) {
        this._doubleEncoding = new DoubleEncoding(encoder, decoder);
        encoder.register(Double.class, this);
        decoder.register(this);
    }

    @Override
    public Class<Double> getTypeClass() {
        return Double.class;
    }

    public DoubleEncoding getEncoding(Double val) {
        return this._doubleEncoding;
    }

    @Override
    public DoubleEncoding getCanonicalEncoding() {
        return this._doubleEncoding;
    }

    @Override
    public Collection<DoubleEncoding> getAllEncodings() {
        return Collections.singleton(this._doubleEncoding);
    }

    @Override
    public void write(double d) {
        this._doubleEncoding.write(d);
    }

    public class DoubleEncoding
    extends FixedSizePrimitiveTypeEncoding<Double> {
        public DoubleEncoding(EncoderImpl encoder, DecoderImpl decoder) {
            super(encoder, decoder);
        }

        @Override
        protected int getFixedSize() {
            return 8;
        }

        @Override
        public byte getEncodingCode() {
            return -126;
        }

        @Override
        public DoubleType getType() {
            return DoubleType.this;
        }

        @Override
        public void writeValue(Double val) {
            this.getEncoder().writeRaw(val);
        }

        @Override
        public void writeValue(double val) {
            this.getEncoder().writeRaw(val);
        }

        public void write(double d) {
            this.writeConstructor();
            this.getEncoder().writeRaw(d);
        }

        @Override
        public boolean encodesSuperset(TypeEncoding<Double> encoding) {
            return this.getType() == encoding.getType();
        }

        @Override
        public Double readValue() {
            return this.readPrimitiveValue();
        }

        public double readPrimitiveValue() {
            return this.getDecoder().readRawDouble();
        }

        @Override
        public boolean encodesJavaPrimitive() {
            return true;
        }
    }
}

