/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.pool;

import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.naming.NamingException;
import javax.naming.Reference;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.Service;
import org.apache.activemq.jms.pool.ConnectionPool;
import org.apache.activemq.jndi.JNDIReferenceFactory;
import org.apache.activemq.jndi.JNDIStorableInterface;
import org.apache.activemq.pool.PooledConnection;
import org.apache.activemq.transport.TransportListener;
import org.apache.activemq.util.IntrospectionSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PooledConnectionFactory
extends org.apache.activemq.jms.pool.PooledConnectionFactory
implements JNDIStorableInterface,
Service {
    public static final String POOL_PROPS_PREFIX = "pool";
    private static final transient Logger LOG = LoggerFactory.getLogger(org.apache.activemq.jms.pool.PooledConnectionFactory.class);

    public PooledConnectionFactory() {
    }

    public PooledConnectionFactory(ActiveMQConnectionFactory activeMQConnectionFactory) {
        this.setConnectionFactory((ConnectionFactory)activeMQConnectionFactory);
    }

    public PooledConnectionFactory(String brokerURL) {
        this.setConnectionFactory((ConnectionFactory)new ActiveMQConnectionFactory(brokerURL));
    }

    protected void buildFromProperties(Properties props) {
        ActiveMQConnectionFactory activeMQConnectionFactory = new ActiveMQConnectionFactory();
        activeMQConnectionFactory.buildFromProperties(props);
        this.setConnectionFactory((ConnectionFactory)activeMQConnectionFactory);
        IntrospectionSupport.setProperties((Object)((Object)this), new HashMap<Object, Object>(props), (String)POOL_PROPS_PREFIX);
    }

    protected void populateProperties(Properties props) {
        ((ActiveMQConnectionFactory)this.getConnectionFactory()).populateProperties(props);
        super.populateProperties(props);
    }

    public void setProperties(Properties properties) {
        this.buildFromProperties(properties);
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        this.populateProperties(properties);
        return properties;
    }

    public Reference getReference() throws NamingException {
        return JNDIReferenceFactory.createReference((String)((Object)((Object)this)).getClass().getName(), (JNDIStorableInterface)this);
    }

    protected Connection newPooledConnection(ConnectionPool connection) {
        return new PooledConnection(connection);
    }

    protected ConnectionPool createConnectionPool(Connection connection) {
        return new ConnectionPool(connection){

            protected Connection wrap(final Connection connection) {
                ((ActiveMQConnection)connection).addTransportListener(new TransportListener(){

                    public void onCommand(Object command) {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onException(IOException error) {
                        1 var2_2 = this;
                        synchronized (var2_2) {
                            this.setHasExpired(true);
                            if (!PooledConnectionFactory.this.stopped.get()) {
                                LOG.info("Expiring connection " + connection + " on IOException: " + error.getMessage());
                                LOG.debug("Expiring connection " + connection + " on IOException: ", (Throwable)error);
                            }
                        }
                    }

                    public void transportInterupted() {
                    }

                    public void transportResumed() {
                    }
                });
                this.setHasExpired(((ActiveMQConnection)connection).isTransportFailed());
                return connection;
            }

            protected void unWrap(Connection connection) {
                if (connection != null) {
                    ((ActiveMQConnection)connection).cleanUpTempDestinations();
                }
            }
        };
    }
}

