
package org.apache.activemq.schema.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyAttribute;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementRefs;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.namespace.QName;
import org.jvnet.jaxb2_commons.lang.Equals2;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy2;
import org.jvnet.jaxb2_commons.lang.HashCode2;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy2;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString2;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;


/**
 * <p>Classe Java pour anonymous complex type.
 * 
 * <p>Le fragment de schéma suivant indique le contenu attendu figurant dans cette classe.
 * 
 * <pre>
 * &lt;complexType&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;choice maxOccurs="unbounded" minOccurs="0"&gt;
 *         &lt;choice&gt;
 *           &lt;element name="broker" minOccurs="0"&gt;
 *             &lt;complexType&gt;
 *               &lt;complexContent&gt;
 *                 &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *                   &lt;choice minOccurs="0"&gt;
 *                     &lt;element ref="{http://activemq.apache.org/schema/core}destinationPathSeparatorPlugin"/&gt;
 *                     &lt;element ref="{http://activemq.apache.org/schema/core}destinationsPlugin"/&gt;
 *                     &lt;element ref="{http://activemq.apache.org/schema/core}forcePersistencyModeBroker"/&gt;
 *                     &lt;element ref="{http://activemq.apache.org/schema/core}loggingBrokerPlugin"/&gt;
 *                     &lt;element ref="{http://activemq.apache.org/schema/core}multicastTraceBrokerPlugin"/&gt;
 *                     &lt;element ref="{http://activemq.apache.org/schema/core}redeliveryPlugin"/&gt;
 *                     &lt;element ref="{http://activemq.apache.org/schema/core}timeStampingBrokerPlugin"/&gt;
 *                     &lt;element ref="{http://activemq.apache.org/schema/core}traceBrokerPathPlugin"/&gt;
 *                     &lt;element ref="{http://activemq.apache.org/schema/core}udpTraceBrokerPlugin"/&gt;
 *                     &lt;any namespace='##other'/&gt;
 *                   &lt;/choice&gt;
 *                 &lt;/restriction&gt;
 *               &lt;/complexContent&gt;
 *             &lt;/complexType&gt;
 *           &lt;/element&gt;
 *           &lt;element name="wrapped" minOccurs="0"&gt;
 *             &lt;complexType&gt;
 *               &lt;complexContent&gt;
 *                 &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *                   &lt;choice minOccurs="0"&gt;
 *                     &lt;element ref="{http://activemq.apache.org/schema/core}fixedCountSubscriptionRecoveryPolicy"/&gt;
 *                     &lt;element ref="{http://activemq.apache.org/schema/core}fixedSizedSubscriptionRecoveryPolicy"/&gt;
 *                     &lt;element ref="{http://activemq.apache.org/schema/core}lastImageSubscriptionRecoveryPolicy"/&gt;
 *                     &lt;element ref="{http://activemq.apache.org/schema/core}noSubscriptionRecoveryPolicy"/&gt;
 *                     &lt;element ref="{http://activemq.apache.org/schema/core}queryBasedSubscriptionRecoveryPolicy"/&gt;
 *                     &lt;element ref="{http://activemq.apache.org/schema/core}retainedMessageSubscriptionRecoveryPolicy"/&gt;
 *                     &lt;element ref="{http://activemq.apache.org/schema/core}timedSubscriptionRecoveryPolicy"/&gt;
 *                     &lt;any namespace='##other'/&gt;
 *                   &lt;/choice&gt;
 *                 &lt;/restriction&gt;
 *               &lt;/complexContent&gt;
 *             &lt;/complexType&gt;
 *           &lt;/element&gt;
 *           &lt;any namespace='##other' maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;/choice&gt;
 *       &lt;/choice&gt;
 *       &lt;attribute name="broker" type="{http://www.w3.org/2001/XMLSchema}string" /&gt;
 *       &lt;attribute name="wrapped" type="{http://www.w3.org/2001/XMLSchema}string" /&gt;
 *       &lt;attribute name="id" type="{http://www.w3.org/2001/XMLSchema}ID" /&gt;
 *       &lt;anyAttribute processContents='lax' namespace='##other'/&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "brokerOrWrappedOrAny"
})
@XmlRootElement(name = "retainedMessageSubscriptionRecoveryPolicy")
public class DtoRetainedMessageSubscriptionRecoveryPolicy implements Equals2, HashCode2, ToString2
{

    @XmlElementRefs({
        @XmlElementRef(name = "broker", namespace = "http://activemq.apache.org/schema/core", type = JAXBElement.class, required = false),
        @XmlElementRef(name = "wrapped", namespace = "http://activemq.apache.org/schema/core", type = JAXBElement.class, required = false)
    })
    @XmlAnyElement(lax = true)
    protected List<Object> brokerOrWrappedOrAny;
    @XmlAttribute(name = "broker")
    protected String broker;
    @XmlAttribute(name = "wrapped")
    protected String wrapped;
    @XmlAttribute(name = "id")
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    @XmlID
    @XmlSchemaType(name = "ID")
    protected String id;
    @XmlAnyAttribute
    private Map<QName, String> otherAttributes = new HashMap<QName, String>();

    /**
     * Gets the value of the brokerOrWrappedOrAny property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the brokerOrWrappedOrAny property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getBrokerOrWrappedOrAny().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Object }
     * {@link JAXBElement }{@code <}{@link DtoRetainedMessageSubscriptionRecoveryPolicy.Broker }{@code >}
     * {@link JAXBElement }{@code <}{@link DtoRetainedMessageSubscriptionRecoveryPolicy.Wrapped }{@code >}
     * 
     * 
     */
    public List<Object> getBrokerOrWrappedOrAny() {
        if (brokerOrWrappedOrAny == null) {
            brokerOrWrappedOrAny = new ArrayList<Object>();
        }
        return this.brokerOrWrappedOrAny;
    }

    /**
     * Obtient la valeur de la propriété broker.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getBroker() {
        return broker;
    }

    /**
     * Définit la valeur de la propriété broker.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setBroker(String value) {
        this.broker = value;
    }

    /**
     * Obtient la valeur de la propriété wrapped.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getWrapped() {
        return wrapped;
    }

    /**
     * Définit la valeur de la propriété wrapped.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setWrapped(String value) {
        this.wrapped = value;
    }

    /**
     * Obtient la valeur de la propriété id.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getId() {
        return id;
    }

    /**
     * Définit la valeur de la propriété id.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setId(String value) {
        this.id = value;
    }

    /**
     * Gets a map that contains attributes that aren't bound to any typed property on this class.
     * 
     * <p>
     * the map is keyed by the name of the attribute and 
     * the value is the string value of the attribute.
     * 
     * the map returned by this method is live, and you can add new attribute
     * by updating the map directly. Because of this design, there's no setter.
     * 
     * 
     * @return
     *     always non-null
     */
    public Map<QName, String> getOtherAttributes() {
        return otherAttributes;
    }

    public String toString() {
        final ToStringStrategy2 strategy = JAXBToStringStrategy.INSTANCE2;
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
        {
            List<Object> theBrokerOrWrappedOrAny;
            theBrokerOrWrappedOrAny = (((this.brokerOrWrappedOrAny!= null)&&(!this.brokerOrWrappedOrAny.isEmpty()))?this.getBrokerOrWrappedOrAny():null);
            strategy.appendField(locator, this, "brokerOrWrappedOrAny", buffer, theBrokerOrWrappedOrAny, ((this.brokerOrWrappedOrAny!= null)&&(!this.brokerOrWrappedOrAny.isEmpty())));
        }
        {
            String theBroker;
            theBroker = this.getBroker();
            strategy.appendField(locator, this, "broker", buffer, theBroker, (this.broker!= null));
        }
        {
            String theWrapped;
            theWrapped = this.getWrapped();
            strategy.appendField(locator, this, "wrapped", buffer, theWrapped, (this.wrapped!= null));
        }
        {
            String theId;
            theId = this.getId();
            strategy.appendField(locator, this, "id", buffer, theId, (this.id!= null));
        }
        return buffer;
    }

    public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
        int currentHashCode = 1;
        {
            List<Object> theBrokerOrWrappedOrAny;
            theBrokerOrWrappedOrAny = (((this.brokerOrWrappedOrAny!= null)&&(!this.brokerOrWrappedOrAny.isEmpty()))?this.getBrokerOrWrappedOrAny():null);
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "brokerOrWrappedOrAny", theBrokerOrWrappedOrAny), currentHashCode, theBrokerOrWrappedOrAny, ((this.brokerOrWrappedOrAny!= null)&&(!this.brokerOrWrappedOrAny.isEmpty())));
        }
        {
            String theBroker;
            theBroker = this.getBroker();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "broker", theBroker), currentHashCode, theBroker, (this.broker!= null));
        }
        {
            String theWrapped;
            theWrapped = this.getWrapped();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "wrapped", theWrapped), currentHashCode, theWrapped, (this.wrapped!= null));
        }
        {
            String theId;
            theId = this.getId();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "id", theId), currentHashCode, theId, (this.id!= null));
        }
        return currentHashCode;
    }

    public int hashCode() {
        final HashCodeStrategy2 strategy = JAXBHashCodeStrategy.INSTANCE2;
        return this.hashCode(null, strategy);
    }

    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final DtoRetainedMessageSubscriptionRecoveryPolicy that = ((DtoRetainedMessageSubscriptionRecoveryPolicy) object);
        {
            List<Object> lhsBrokerOrWrappedOrAny;
            lhsBrokerOrWrappedOrAny = (((this.brokerOrWrappedOrAny!= null)&&(!this.brokerOrWrappedOrAny.isEmpty()))?this.getBrokerOrWrappedOrAny():null);
            List<Object> rhsBrokerOrWrappedOrAny;
            rhsBrokerOrWrappedOrAny = (((that.brokerOrWrappedOrAny!= null)&&(!that.brokerOrWrappedOrAny.isEmpty()))?that.getBrokerOrWrappedOrAny():null);
            if (!strategy.equals(LocatorUtils.property(thisLocator, "brokerOrWrappedOrAny", lhsBrokerOrWrappedOrAny), LocatorUtils.property(thatLocator, "brokerOrWrappedOrAny", rhsBrokerOrWrappedOrAny), lhsBrokerOrWrappedOrAny, rhsBrokerOrWrappedOrAny, ((this.brokerOrWrappedOrAny!= null)&&(!this.brokerOrWrappedOrAny.isEmpty())), ((that.brokerOrWrappedOrAny!= null)&&(!that.brokerOrWrappedOrAny.isEmpty())))) {
                return false;
            }
        }
        {
            String lhsBroker;
            lhsBroker = this.getBroker();
            String rhsBroker;
            rhsBroker = that.getBroker();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "broker", lhsBroker), LocatorUtils.property(thatLocator, "broker", rhsBroker), lhsBroker, rhsBroker, (this.broker!= null), (that.broker!= null))) {
                return false;
            }
        }
        {
            String lhsWrapped;
            lhsWrapped = this.getWrapped();
            String rhsWrapped;
            rhsWrapped = that.getWrapped();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "wrapped", lhsWrapped), LocatorUtils.property(thatLocator, "wrapped", rhsWrapped), lhsWrapped, rhsWrapped, (this.wrapped!= null), (that.wrapped!= null))) {
                return false;
            }
        }
        {
            String lhsId;
            lhsId = this.getId();
            String rhsId;
            rhsId = that.getId();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "id", lhsId), LocatorUtils.property(thatLocator, "id", rhsId), lhsId, rhsId, (this.id!= null), (that.id!= null))) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object object) {
        final EqualsStrategy2 strategy = new org.apache.activemq.plugin.jaxb2_commons.ElementAwareEqualsStrategy();
        return equals(null, null, object, strategy);
    }


    /**
     * <p>Classe Java pour anonymous complex type.
     * 
     * <p>Le fragment de schéma suivant indique le contenu attendu figurant dans cette classe.
     * 
     * <pre>
     * &lt;complexType&gt;
     *   &lt;complexContent&gt;
     *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
     *       &lt;choice minOccurs="0"&gt;
     *         &lt;element ref="{http://activemq.apache.org/schema/core}destinationPathSeparatorPlugin"/&gt;
     *         &lt;element ref="{http://activemq.apache.org/schema/core}destinationsPlugin"/&gt;
     *         &lt;element ref="{http://activemq.apache.org/schema/core}forcePersistencyModeBroker"/&gt;
     *         &lt;element ref="{http://activemq.apache.org/schema/core}loggingBrokerPlugin"/&gt;
     *         &lt;element ref="{http://activemq.apache.org/schema/core}multicastTraceBrokerPlugin"/&gt;
     *         &lt;element ref="{http://activemq.apache.org/schema/core}redeliveryPlugin"/&gt;
     *         &lt;element ref="{http://activemq.apache.org/schema/core}timeStampingBrokerPlugin"/&gt;
     *         &lt;element ref="{http://activemq.apache.org/schema/core}traceBrokerPathPlugin"/&gt;
     *         &lt;element ref="{http://activemq.apache.org/schema/core}udpTraceBrokerPlugin"/&gt;
     *         &lt;any namespace='##other'/&gt;
     *       &lt;/choice&gt;
     *     &lt;/restriction&gt;
     *   &lt;/complexContent&gt;
     * &lt;/complexType&gt;
     * </pre>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "destinationPathSeparatorPlugin",
        "destinationsPlugin",
        "forcePersistencyModeBroker",
        "loggingBrokerPlugin",
        "multicastTraceBrokerPlugin",
        "redeliveryPlugin",
        "timeStampingBrokerPlugin",
        "traceBrokerPathPlugin",
        "udpTraceBrokerPlugin",
        "any"
    })
    public static class Broker implements Equals2, HashCode2, ToString2
    {

        protected DtoDestinationPathSeparatorPlugin destinationPathSeparatorPlugin;
        protected DtoDestinationsPlugin destinationsPlugin;
        protected DtoForcePersistencyModeBroker forcePersistencyModeBroker;
        protected DtoLoggingBrokerPlugin loggingBrokerPlugin;
        protected DtoMulticastTraceBrokerPlugin multicastTraceBrokerPlugin;
        protected DtoRedeliveryPlugin redeliveryPlugin;
        protected DtoTimeStampingBrokerPlugin timeStampingBrokerPlugin;
        protected DtoTraceBrokerPathPlugin traceBrokerPathPlugin;
        protected DtoUdpTraceBrokerPlugin udpTraceBrokerPlugin;
        @XmlAnyElement(lax = true)
        protected Object any;

        /**
         * Obtient la valeur de la propriété destinationPathSeparatorPlugin.
         * 
         * @return
         *     possible object is
         *     {@link DtoDestinationPathSeparatorPlugin }
         *     
         */
        public DtoDestinationPathSeparatorPlugin getDestinationPathSeparatorPlugin() {
            return destinationPathSeparatorPlugin;
        }

        /**
         * Définit la valeur de la propriété destinationPathSeparatorPlugin.
         * 
         * @param value
         *     allowed object is
         *     {@link DtoDestinationPathSeparatorPlugin }
         *     
         */
        public void setDestinationPathSeparatorPlugin(DtoDestinationPathSeparatorPlugin value) {
            this.destinationPathSeparatorPlugin = value;
        }

        /**
         * Obtient la valeur de la propriété destinationsPlugin.
         * 
         * @return
         *     possible object is
         *     {@link DtoDestinationsPlugin }
         *     
         */
        public DtoDestinationsPlugin getDestinationsPlugin() {
            return destinationsPlugin;
        }

        /**
         * Définit la valeur de la propriété destinationsPlugin.
         * 
         * @param value
         *     allowed object is
         *     {@link DtoDestinationsPlugin }
         *     
         */
        public void setDestinationsPlugin(DtoDestinationsPlugin value) {
            this.destinationsPlugin = value;
        }

        /**
         * Obtient la valeur de la propriété forcePersistencyModeBroker.
         * 
         * @return
         *     possible object is
         *     {@link DtoForcePersistencyModeBroker }
         *     
         */
        public DtoForcePersistencyModeBroker getForcePersistencyModeBroker() {
            return forcePersistencyModeBroker;
        }

        /**
         * Définit la valeur de la propriété forcePersistencyModeBroker.
         * 
         * @param value
         *     allowed object is
         *     {@link DtoForcePersistencyModeBroker }
         *     
         */
        public void setForcePersistencyModeBroker(DtoForcePersistencyModeBroker value) {
            this.forcePersistencyModeBroker = value;
        }

        /**
         * Obtient la valeur de la propriété loggingBrokerPlugin.
         * 
         * @return
         *     possible object is
         *     {@link DtoLoggingBrokerPlugin }
         *     
         */
        public DtoLoggingBrokerPlugin getLoggingBrokerPlugin() {
            return loggingBrokerPlugin;
        }

        /**
         * Définit la valeur de la propriété loggingBrokerPlugin.
         * 
         * @param value
         *     allowed object is
         *     {@link DtoLoggingBrokerPlugin }
         *     
         */
        public void setLoggingBrokerPlugin(DtoLoggingBrokerPlugin value) {
            this.loggingBrokerPlugin = value;
        }

        /**
         * Obtient la valeur de la propriété multicastTraceBrokerPlugin.
         * 
         * @return
         *     possible object is
         *     {@link DtoMulticastTraceBrokerPlugin }
         *     
         */
        public DtoMulticastTraceBrokerPlugin getMulticastTraceBrokerPlugin() {
            return multicastTraceBrokerPlugin;
        }

        /**
         * Définit la valeur de la propriété multicastTraceBrokerPlugin.
         * 
         * @param value
         *     allowed object is
         *     {@link DtoMulticastTraceBrokerPlugin }
         *     
         */
        public void setMulticastTraceBrokerPlugin(DtoMulticastTraceBrokerPlugin value) {
            this.multicastTraceBrokerPlugin = value;
        }

        /**
         * Obtient la valeur de la propriété redeliveryPlugin.
         * 
         * @return
         *     possible object is
         *     {@link DtoRedeliveryPlugin }
         *     
         */
        public DtoRedeliveryPlugin getRedeliveryPlugin() {
            return redeliveryPlugin;
        }

        /**
         * Définit la valeur de la propriété redeliveryPlugin.
         * 
         * @param value
         *     allowed object is
         *     {@link DtoRedeliveryPlugin }
         *     
         */
        public void setRedeliveryPlugin(DtoRedeliveryPlugin value) {
            this.redeliveryPlugin = value;
        }

        /**
         * Obtient la valeur de la propriété timeStampingBrokerPlugin.
         * 
         * @return
         *     possible object is
         *     {@link DtoTimeStampingBrokerPlugin }
         *     
         */
        public DtoTimeStampingBrokerPlugin getTimeStampingBrokerPlugin() {
            return timeStampingBrokerPlugin;
        }

        /**
         * Définit la valeur de la propriété timeStampingBrokerPlugin.
         * 
         * @param value
         *     allowed object is
         *     {@link DtoTimeStampingBrokerPlugin }
         *     
         */
        public void setTimeStampingBrokerPlugin(DtoTimeStampingBrokerPlugin value) {
            this.timeStampingBrokerPlugin = value;
        }

        /**
         * Obtient la valeur de la propriété traceBrokerPathPlugin.
         * 
         * @return
         *     possible object is
         *     {@link DtoTraceBrokerPathPlugin }
         *     
         */
        public DtoTraceBrokerPathPlugin getTraceBrokerPathPlugin() {
            return traceBrokerPathPlugin;
        }

        /**
         * Définit la valeur de la propriété traceBrokerPathPlugin.
         * 
         * @param value
         *     allowed object is
         *     {@link DtoTraceBrokerPathPlugin }
         *     
         */
        public void setTraceBrokerPathPlugin(DtoTraceBrokerPathPlugin value) {
            this.traceBrokerPathPlugin = value;
        }

        /**
         * Obtient la valeur de la propriété udpTraceBrokerPlugin.
         * 
         * @return
         *     possible object is
         *     {@link DtoUdpTraceBrokerPlugin }
         *     
         */
        public DtoUdpTraceBrokerPlugin getUdpTraceBrokerPlugin() {
            return udpTraceBrokerPlugin;
        }

        /**
         * Définit la valeur de la propriété udpTraceBrokerPlugin.
         * 
         * @param value
         *     allowed object is
         *     {@link DtoUdpTraceBrokerPlugin }
         *     
         */
        public void setUdpTraceBrokerPlugin(DtoUdpTraceBrokerPlugin value) {
            this.udpTraceBrokerPlugin = value;
        }

        /**
         * Obtient la valeur de la propriété any.
         * 
         * @return
         *     possible object is
         *     {@link Object }
         *     
         */
        public Object getAny() {
            return any;
        }

        /**
         * Définit la valeur de la propriété any.
         * 
         * @param value
         *     allowed object is
         *     {@link Object }
         *     
         */
        public void setAny(Object value) {
            this.any = value;
        }

        public String toString() {
            final ToStringStrategy2 strategy = JAXBToStringStrategy.INSTANCE2;
            final StringBuilder buffer = new StringBuilder();
            append(null, buffer, strategy);
            return buffer.toString();
        }

        public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
            strategy.appendStart(locator, this, buffer);
            appendFields(locator, buffer, strategy);
            strategy.appendEnd(locator, this, buffer);
            return buffer;
        }

        public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
            {
                DtoDestinationPathSeparatorPlugin theDestinationPathSeparatorPlugin;
                theDestinationPathSeparatorPlugin = this.getDestinationPathSeparatorPlugin();
                strategy.appendField(locator, this, "destinationPathSeparatorPlugin", buffer, theDestinationPathSeparatorPlugin, (this.destinationPathSeparatorPlugin!= null));
            }
            {
                DtoDestinationsPlugin theDestinationsPlugin;
                theDestinationsPlugin = this.getDestinationsPlugin();
                strategy.appendField(locator, this, "destinationsPlugin", buffer, theDestinationsPlugin, (this.destinationsPlugin!= null));
            }
            {
                DtoForcePersistencyModeBroker theForcePersistencyModeBroker;
                theForcePersistencyModeBroker = this.getForcePersistencyModeBroker();
                strategy.appendField(locator, this, "forcePersistencyModeBroker", buffer, theForcePersistencyModeBroker, (this.forcePersistencyModeBroker!= null));
            }
            {
                DtoLoggingBrokerPlugin theLoggingBrokerPlugin;
                theLoggingBrokerPlugin = this.getLoggingBrokerPlugin();
                strategy.appendField(locator, this, "loggingBrokerPlugin", buffer, theLoggingBrokerPlugin, (this.loggingBrokerPlugin!= null));
            }
            {
                DtoMulticastTraceBrokerPlugin theMulticastTraceBrokerPlugin;
                theMulticastTraceBrokerPlugin = this.getMulticastTraceBrokerPlugin();
                strategy.appendField(locator, this, "multicastTraceBrokerPlugin", buffer, theMulticastTraceBrokerPlugin, (this.multicastTraceBrokerPlugin!= null));
            }
            {
                DtoRedeliveryPlugin theRedeliveryPlugin;
                theRedeliveryPlugin = this.getRedeliveryPlugin();
                strategy.appendField(locator, this, "redeliveryPlugin", buffer, theRedeliveryPlugin, (this.redeliveryPlugin!= null));
            }
            {
                DtoTimeStampingBrokerPlugin theTimeStampingBrokerPlugin;
                theTimeStampingBrokerPlugin = this.getTimeStampingBrokerPlugin();
                strategy.appendField(locator, this, "timeStampingBrokerPlugin", buffer, theTimeStampingBrokerPlugin, (this.timeStampingBrokerPlugin!= null));
            }
            {
                DtoTraceBrokerPathPlugin theTraceBrokerPathPlugin;
                theTraceBrokerPathPlugin = this.getTraceBrokerPathPlugin();
                strategy.appendField(locator, this, "traceBrokerPathPlugin", buffer, theTraceBrokerPathPlugin, (this.traceBrokerPathPlugin!= null));
            }
            {
                DtoUdpTraceBrokerPlugin theUdpTraceBrokerPlugin;
                theUdpTraceBrokerPlugin = this.getUdpTraceBrokerPlugin();
                strategy.appendField(locator, this, "udpTraceBrokerPlugin", buffer, theUdpTraceBrokerPlugin, (this.udpTraceBrokerPlugin!= null));
            }
            {
                Object theAny;
                theAny = this.getAny();
                strategy.appendField(locator, this, "any", buffer, theAny, (this.any!= null));
            }
            return buffer;
        }

        public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
            int currentHashCode = 1;
            {
                DtoDestinationPathSeparatorPlugin theDestinationPathSeparatorPlugin;
                theDestinationPathSeparatorPlugin = this.getDestinationPathSeparatorPlugin();
                currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "destinationPathSeparatorPlugin", theDestinationPathSeparatorPlugin), currentHashCode, theDestinationPathSeparatorPlugin, (this.destinationPathSeparatorPlugin!= null));
            }
            {
                DtoDestinationsPlugin theDestinationsPlugin;
                theDestinationsPlugin = this.getDestinationsPlugin();
                currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "destinationsPlugin", theDestinationsPlugin), currentHashCode, theDestinationsPlugin, (this.destinationsPlugin!= null));
            }
            {
                DtoForcePersistencyModeBroker theForcePersistencyModeBroker;
                theForcePersistencyModeBroker = this.getForcePersistencyModeBroker();
                currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "forcePersistencyModeBroker", theForcePersistencyModeBroker), currentHashCode, theForcePersistencyModeBroker, (this.forcePersistencyModeBroker!= null));
            }
            {
                DtoLoggingBrokerPlugin theLoggingBrokerPlugin;
                theLoggingBrokerPlugin = this.getLoggingBrokerPlugin();
                currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "loggingBrokerPlugin", theLoggingBrokerPlugin), currentHashCode, theLoggingBrokerPlugin, (this.loggingBrokerPlugin!= null));
            }
            {
                DtoMulticastTraceBrokerPlugin theMulticastTraceBrokerPlugin;
                theMulticastTraceBrokerPlugin = this.getMulticastTraceBrokerPlugin();
                currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "multicastTraceBrokerPlugin", theMulticastTraceBrokerPlugin), currentHashCode, theMulticastTraceBrokerPlugin, (this.multicastTraceBrokerPlugin!= null));
            }
            {
                DtoRedeliveryPlugin theRedeliveryPlugin;
                theRedeliveryPlugin = this.getRedeliveryPlugin();
                currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "redeliveryPlugin", theRedeliveryPlugin), currentHashCode, theRedeliveryPlugin, (this.redeliveryPlugin!= null));
            }
            {
                DtoTimeStampingBrokerPlugin theTimeStampingBrokerPlugin;
                theTimeStampingBrokerPlugin = this.getTimeStampingBrokerPlugin();
                currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "timeStampingBrokerPlugin", theTimeStampingBrokerPlugin), currentHashCode, theTimeStampingBrokerPlugin, (this.timeStampingBrokerPlugin!= null));
            }
            {
                DtoTraceBrokerPathPlugin theTraceBrokerPathPlugin;
                theTraceBrokerPathPlugin = this.getTraceBrokerPathPlugin();
                currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "traceBrokerPathPlugin", theTraceBrokerPathPlugin), currentHashCode, theTraceBrokerPathPlugin, (this.traceBrokerPathPlugin!= null));
            }
            {
                DtoUdpTraceBrokerPlugin theUdpTraceBrokerPlugin;
                theUdpTraceBrokerPlugin = this.getUdpTraceBrokerPlugin();
                currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "udpTraceBrokerPlugin", theUdpTraceBrokerPlugin), currentHashCode, theUdpTraceBrokerPlugin, (this.udpTraceBrokerPlugin!= null));
            }
            {
                Object theAny;
                theAny = this.getAny();
                currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "any", theAny), currentHashCode, theAny, (this.any!= null));
            }
            return currentHashCode;
        }

        public int hashCode() {
            final HashCodeStrategy2 strategy = JAXBHashCodeStrategy.INSTANCE2;
            return this.hashCode(null, strategy);
        }

        public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
            if ((object == null)||(this.getClass()!= object.getClass())) {
                return false;
            }
            if (this == object) {
                return true;
            }
            final DtoRetainedMessageSubscriptionRecoveryPolicy.Broker that = ((DtoRetainedMessageSubscriptionRecoveryPolicy.Broker) object);
            {
                DtoDestinationPathSeparatorPlugin lhsDestinationPathSeparatorPlugin;
                lhsDestinationPathSeparatorPlugin = this.getDestinationPathSeparatorPlugin();
                DtoDestinationPathSeparatorPlugin rhsDestinationPathSeparatorPlugin;
                rhsDestinationPathSeparatorPlugin = that.getDestinationPathSeparatorPlugin();
                if (!strategy.equals(LocatorUtils.property(thisLocator, "destinationPathSeparatorPlugin", lhsDestinationPathSeparatorPlugin), LocatorUtils.property(thatLocator, "destinationPathSeparatorPlugin", rhsDestinationPathSeparatorPlugin), lhsDestinationPathSeparatorPlugin, rhsDestinationPathSeparatorPlugin, (this.destinationPathSeparatorPlugin!= null), (that.destinationPathSeparatorPlugin!= null))) {
                    return false;
                }
            }
            {
                DtoDestinationsPlugin lhsDestinationsPlugin;
                lhsDestinationsPlugin = this.getDestinationsPlugin();
                DtoDestinationsPlugin rhsDestinationsPlugin;
                rhsDestinationsPlugin = that.getDestinationsPlugin();
                if (!strategy.equals(LocatorUtils.property(thisLocator, "destinationsPlugin", lhsDestinationsPlugin), LocatorUtils.property(thatLocator, "destinationsPlugin", rhsDestinationsPlugin), lhsDestinationsPlugin, rhsDestinationsPlugin, (this.destinationsPlugin!= null), (that.destinationsPlugin!= null))) {
                    return false;
                }
            }
            {
                DtoForcePersistencyModeBroker lhsForcePersistencyModeBroker;
                lhsForcePersistencyModeBroker = this.getForcePersistencyModeBroker();
                DtoForcePersistencyModeBroker rhsForcePersistencyModeBroker;
                rhsForcePersistencyModeBroker = that.getForcePersistencyModeBroker();
                if (!strategy.equals(LocatorUtils.property(thisLocator, "forcePersistencyModeBroker", lhsForcePersistencyModeBroker), LocatorUtils.property(thatLocator, "forcePersistencyModeBroker", rhsForcePersistencyModeBroker), lhsForcePersistencyModeBroker, rhsForcePersistencyModeBroker, (this.forcePersistencyModeBroker!= null), (that.forcePersistencyModeBroker!= null))) {
                    return false;
                }
            }
            {
                DtoLoggingBrokerPlugin lhsLoggingBrokerPlugin;
                lhsLoggingBrokerPlugin = this.getLoggingBrokerPlugin();
                DtoLoggingBrokerPlugin rhsLoggingBrokerPlugin;
                rhsLoggingBrokerPlugin = that.getLoggingBrokerPlugin();
                if (!strategy.equals(LocatorUtils.property(thisLocator, "loggingBrokerPlugin", lhsLoggingBrokerPlugin), LocatorUtils.property(thatLocator, "loggingBrokerPlugin", rhsLoggingBrokerPlugin), lhsLoggingBrokerPlugin, rhsLoggingBrokerPlugin, (this.loggingBrokerPlugin!= null), (that.loggingBrokerPlugin!= null))) {
                    return false;
                }
            }
            {
                DtoMulticastTraceBrokerPlugin lhsMulticastTraceBrokerPlugin;
                lhsMulticastTraceBrokerPlugin = this.getMulticastTraceBrokerPlugin();
                DtoMulticastTraceBrokerPlugin rhsMulticastTraceBrokerPlugin;
                rhsMulticastTraceBrokerPlugin = that.getMulticastTraceBrokerPlugin();
                if (!strategy.equals(LocatorUtils.property(thisLocator, "multicastTraceBrokerPlugin", lhsMulticastTraceBrokerPlugin), LocatorUtils.property(thatLocator, "multicastTraceBrokerPlugin", rhsMulticastTraceBrokerPlugin), lhsMulticastTraceBrokerPlugin, rhsMulticastTraceBrokerPlugin, (this.multicastTraceBrokerPlugin!= null), (that.multicastTraceBrokerPlugin!= null))) {
                    return false;
                }
            }
            {
                DtoRedeliveryPlugin lhsRedeliveryPlugin;
                lhsRedeliveryPlugin = this.getRedeliveryPlugin();
                DtoRedeliveryPlugin rhsRedeliveryPlugin;
                rhsRedeliveryPlugin = that.getRedeliveryPlugin();
                if (!strategy.equals(LocatorUtils.property(thisLocator, "redeliveryPlugin", lhsRedeliveryPlugin), LocatorUtils.property(thatLocator, "redeliveryPlugin", rhsRedeliveryPlugin), lhsRedeliveryPlugin, rhsRedeliveryPlugin, (this.redeliveryPlugin!= null), (that.redeliveryPlugin!= null))) {
                    return false;
                }
            }
            {
                DtoTimeStampingBrokerPlugin lhsTimeStampingBrokerPlugin;
                lhsTimeStampingBrokerPlugin = this.getTimeStampingBrokerPlugin();
                DtoTimeStampingBrokerPlugin rhsTimeStampingBrokerPlugin;
                rhsTimeStampingBrokerPlugin = that.getTimeStampingBrokerPlugin();
                if (!strategy.equals(LocatorUtils.property(thisLocator, "timeStampingBrokerPlugin", lhsTimeStampingBrokerPlugin), LocatorUtils.property(thatLocator, "timeStampingBrokerPlugin", rhsTimeStampingBrokerPlugin), lhsTimeStampingBrokerPlugin, rhsTimeStampingBrokerPlugin, (this.timeStampingBrokerPlugin!= null), (that.timeStampingBrokerPlugin!= null))) {
                    return false;
                }
            }
            {
                DtoTraceBrokerPathPlugin lhsTraceBrokerPathPlugin;
                lhsTraceBrokerPathPlugin = this.getTraceBrokerPathPlugin();
                DtoTraceBrokerPathPlugin rhsTraceBrokerPathPlugin;
                rhsTraceBrokerPathPlugin = that.getTraceBrokerPathPlugin();
                if (!strategy.equals(LocatorUtils.property(thisLocator, "traceBrokerPathPlugin", lhsTraceBrokerPathPlugin), LocatorUtils.property(thatLocator, "traceBrokerPathPlugin", rhsTraceBrokerPathPlugin), lhsTraceBrokerPathPlugin, rhsTraceBrokerPathPlugin, (this.traceBrokerPathPlugin!= null), (that.traceBrokerPathPlugin!= null))) {
                    return false;
                }
            }
            {
                DtoUdpTraceBrokerPlugin lhsUdpTraceBrokerPlugin;
                lhsUdpTraceBrokerPlugin = this.getUdpTraceBrokerPlugin();
                DtoUdpTraceBrokerPlugin rhsUdpTraceBrokerPlugin;
                rhsUdpTraceBrokerPlugin = that.getUdpTraceBrokerPlugin();
                if (!strategy.equals(LocatorUtils.property(thisLocator, "udpTraceBrokerPlugin", lhsUdpTraceBrokerPlugin), LocatorUtils.property(thatLocator, "udpTraceBrokerPlugin", rhsUdpTraceBrokerPlugin), lhsUdpTraceBrokerPlugin, rhsUdpTraceBrokerPlugin, (this.udpTraceBrokerPlugin!= null), (that.udpTraceBrokerPlugin!= null))) {
                    return false;
                }
            }
            {
                Object lhsAny;
                lhsAny = this.getAny();
                Object rhsAny;
                rhsAny = that.getAny();
                if (!strategy.equals(LocatorUtils.property(thisLocator, "any", lhsAny), LocatorUtils.property(thatLocator, "any", rhsAny), lhsAny, rhsAny, (this.any!= null), (that.any!= null))) {
                    return false;
                }
            }
            return true;
        }

        public boolean equals(Object object) {
            final EqualsStrategy2 strategy = new org.apache.activemq.plugin.jaxb2_commons.ElementAwareEqualsStrategy();
            return equals(null, null, object, strategy);
        }

    }


    /**
     * <p>Classe Java pour anonymous complex type.
     * 
     * <p>Le fragment de schéma suivant indique le contenu attendu figurant dans cette classe.
     * 
     * <pre>
     * &lt;complexType&gt;
     *   &lt;complexContent&gt;
     *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
     *       &lt;choice minOccurs="0"&gt;
     *         &lt;element ref="{http://activemq.apache.org/schema/core}fixedCountSubscriptionRecoveryPolicy"/&gt;
     *         &lt;element ref="{http://activemq.apache.org/schema/core}fixedSizedSubscriptionRecoveryPolicy"/&gt;
     *         &lt;element ref="{http://activemq.apache.org/schema/core}lastImageSubscriptionRecoveryPolicy"/&gt;
     *         &lt;element ref="{http://activemq.apache.org/schema/core}noSubscriptionRecoveryPolicy"/&gt;
     *         &lt;element ref="{http://activemq.apache.org/schema/core}queryBasedSubscriptionRecoveryPolicy"/&gt;
     *         &lt;element ref="{http://activemq.apache.org/schema/core}retainedMessageSubscriptionRecoveryPolicy"/&gt;
     *         &lt;element ref="{http://activemq.apache.org/schema/core}timedSubscriptionRecoveryPolicy"/&gt;
     *         &lt;any namespace='##other'/&gt;
     *       &lt;/choice&gt;
     *     &lt;/restriction&gt;
     *   &lt;/complexContent&gt;
     * &lt;/complexType&gt;
     * </pre>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "fixedCountSubscriptionRecoveryPolicy",
        "fixedSizedSubscriptionRecoveryPolicy",
        "lastImageSubscriptionRecoveryPolicy",
        "noSubscriptionRecoveryPolicy",
        "queryBasedSubscriptionRecoveryPolicy",
        "retainedMessageSubscriptionRecoveryPolicy",
        "timedSubscriptionRecoveryPolicy",
        "any"
    })
    public static class Wrapped implements Equals2, HashCode2, ToString2
    {

        protected DtoFixedCountSubscriptionRecoveryPolicy fixedCountSubscriptionRecoveryPolicy;
        protected DtoFixedSizedSubscriptionRecoveryPolicy fixedSizedSubscriptionRecoveryPolicy;
        protected DtoLastImageSubscriptionRecoveryPolicy lastImageSubscriptionRecoveryPolicy;
        protected DtoNoSubscriptionRecoveryPolicy noSubscriptionRecoveryPolicy;
        protected DtoQueryBasedSubscriptionRecoveryPolicy queryBasedSubscriptionRecoveryPolicy;
        protected DtoRetainedMessageSubscriptionRecoveryPolicy retainedMessageSubscriptionRecoveryPolicy;
        protected DtoTimedSubscriptionRecoveryPolicy timedSubscriptionRecoveryPolicy;
        @XmlAnyElement(lax = true)
        protected Object any;

        /**
         * Obtient la valeur de la propriété fixedCountSubscriptionRecoveryPolicy.
         * 
         * @return
         *     possible object is
         *     {@link DtoFixedCountSubscriptionRecoveryPolicy }
         *     
         */
        public DtoFixedCountSubscriptionRecoveryPolicy getFixedCountSubscriptionRecoveryPolicy() {
            return fixedCountSubscriptionRecoveryPolicy;
        }

        /**
         * Définit la valeur de la propriété fixedCountSubscriptionRecoveryPolicy.
         * 
         * @param value
         *     allowed object is
         *     {@link DtoFixedCountSubscriptionRecoveryPolicy }
         *     
         */
        public void setFixedCountSubscriptionRecoveryPolicy(DtoFixedCountSubscriptionRecoveryPolicy value) {
            this.fixedCountSubscriptionRecoveryPolicy = value;
        }

        /**
         * Obtient la valeur de la propriété fixedSizedSubscriptionRecoveryPolicy.
         * 
         * @return
         *     possible object is
         *     {@link DtoFixedSizedSubscriptionRecoveryPolicy }
         *     
         */
        public DtoFixedSizedSubscriptionRecoveryPolicy getFixedSizedSubscriptionRecoveryPolicy() {
            return fixedSizedSubscriptionRecoveryPolicy;
        }

        /**
         * Définit la valeur de la propriété fixedSizedSubscriptionRecoveryPolicy.
         * 
         * @param value
         *     allowed object is
         *     {@link DtoFixedSizedSubscriptionRecoveryPolicy }
         *     
         */
        public void setFixedSizedSubscriptionRecoveryPolicy(DtoFixedSizedSubscriptionRecoveryPolicy value) {
            this.fixedSizedSubscriptionRecoveryPolicy = value;
        }

        /**
         * Obtient la valeur de la propriété lastImageSubscriptionRecoveryPolicy.
         * 
         * @return
         *     possible object is
         *     {@link DtoLastImageSubscriptionRecoveryPolicy }
         *     
         */
        public DtoLastImageSubscriptionRecoveryPolicy getLastImageSubscriptionRecoveryPolicy() {
            return lastImageSubscriptionRecoveryPolicy;
        }

        /**
         * Définit la valeur de la propriété lastImageSubscriptionRecoveryPolicy.
         * 
         * @param value
         *     allowed object is
         *     {@link DtoLastImageSubscriptionRecoveryPolicy }
         *     
         */
        public void setLastImageSubscriptionRecoveryPolicy(DtoLastImageSubscriptionRecoveryPolicy value) {
            this.lastImageSubscriptionRecoveryPolicy = value;
        }

        /**
         * Obtient la valeur de la propriété noSubscriptionRecoveryPolicy.
         * 
         * @return
         *     possible object is
         *     {@link DtoNoSubscriptionRecoveryPolicy }
         *     
         */
        public DtoNoSubscriptionRecoveryPolicy getNoSubscriptionRecoveryPolicy() {
            return noSubscriptionRecoveryPolicy;
        }

        /**
         * Définit la valeur de la propriété noSubscriptionRecoveryPolicy.
         * 
         * @param value
         *     allowed object is
         *     {@link DtoNoSubscriptionRecoveryPolicy }
         *     
         */
        public void setNoSubscriptionRecoveryPolicy(DtoNoSubscriptionRecoveryPolicy value) {
            this.noSubscriptionRecoveryPolicy = value;
        }

        /**
         * Obtient la valeur de la propriété queryBasedSubscriptionRecoveryPolicy.
         * 
         * @return
         *     possible object is
         *     {@link DtoQueryBasedSubscriptionRecoveryPolicy }
         *     
         */
        public DtoQueryBasedSubscriptionRecoveryPolicy getQueryBasedSubscriptionRecoveryPolicy() {
            return queryBasedSubscriptionRecoveryPolicy;
        }

        /**
         * Définit la valeur de la propriété queryBasedSubscriptionRecoveryPolicy.
         * 
         * @param value
         *     allowed object is
         *     {@link DtoQueryBasedSubscriptionRecoveryPolicy }
         *     
         */
        public void setQueryBasedSubscriptionRecoveryPolicy(DtoQueryBasedSubscriptionRecoveryPolicy value) {
            this.queryBasedSubscriptionRecoveryPolicy = value;
        }

        /**
         * Obtient la valeur de la propriété retainedMessageSubscriptionRecoveryPolicy.
         * 
         * @return
         *     possible object is
         *     {@link DtoRetainedMessageSubscriptionRecoveryPolicy }
         *     
         */
        public DtoRetainedMessageSubscriptionRecoveryPolicy getRetainedMessageSubscriptionRecoveryPolicy() {
            return retainedMessageSubscriptionRecoveryPolicy;
        }

        /**
         * Définit la valeur de la propriété retainedMessageSubscriptionRecoveryPolicy.
         * 
         * @param value
         *     allowed object is
         *     {@link DtoRetainedMessageSubscriptionRecoveryPolicy }
         *     
         */
        public void setRetainedMessageSubscriptionRecoveryPolicy(DtoRetainedMessageSubscriptionRecoveryPolicy value) {
            this.retainedMessageSubscriptionRecoveryPolicy = value;
        }

        /**
         * Obtient la valeur de la propriété timedSubscriptionRecoveryPolicy.
         * 
         * @return
         *     possible object is
         *     {@link DtoTimedSubscriptionRecoveryPolicy }
         *     
         */
        public DtoTimedSubscriptionRecoveryPolicy getTimedSubscriptionRecoveryPolicy() {
            return timedSubscriptionRecoveryPolicy;
        }

        /**
         * Définit la valeur de la propriété timedSubscriptionRecoveryPolicy.
         * 
         * @param value
         *     allowed object is
         *     {@link DtoTimedSubscriptionRecoveryPolicy }
         *     
         */
        public void setTimedSubscriptionRecoveryPolicy(DtoTimedSubscriptionRecoveryPolicy value) {
            this.timedSubscriptionRecoveryPolicy = value;
        }

        /**
         * Obtient la valeur de la propriété any.
         * 
         * @return
         *     possible object is
         *     {@link Object }
         *     
         */
        public Object getAny() {
            return any;
        }

        /**
         * Définit la valeur de la propriété any.
         * 
         * @param value
         *     allowed object is
         *     {@link Object }
         *     
         */
        public void setAny(Object value) {
            this.any = value;
        }

        public String toString() {
            final ToStringStrategy2 strategy = JAXBToStringStrategy.INSTANCE2;
            final StringBuilder buffer = new StringBuilder();
            append(null, buffer, strategy);
            return buffer.toString();
        }

        public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
            strategy.appendStart(locator, this, buffer);
            appendFields(locator, buffer, strategy);
            strategy.appendEnd(locator, this, buffer);
            return buffer;
        }

        public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy2 strategy) {
            {
                DtoFixedCountSubscriptionRecoveryPolicy theFixedCountSubscriptionRecoveryPolicy;
                theFixedCountSubscriptionRecoveryPolicy = this.getFixedCountSubscriptionRecoveryPolicy();
                strategy.appendField(locator, this, "fixedCountSubscriptionRecoveryPolicy", buffer, theFixedCountSubscriptionRecoveryPolicy, (this.fixedCountSubscriptionRecoveryPolicy!= null));
            }
            {
                DtoFixedSizedSubscriptionRecoveryPolicy theFixedSizedSubscriptionRecoveryPolicy;
                theFixedSizedSubscriptionRecoveryPolicy = this.getFixedSizedSubscriptionRecoveryPolicy();
                strategy.appendField(locator, this, "fixedSizedSubscriptionRecoveryPolicy", buffer, theFixedSizedSubscriptionRecoveryPolicy, (this.fixedSizedSubscriptionRecoveryPolicy!= null));
            }
            {
                DtoLastImageSubscriptionRecoveryPolicy theLastImageSubscriptionRecoveryPolicy;
                theLastImageSubscriptionRecoveryPolicy = this.getLastImageSubscriptionRecoveryPolicy();
                strategy.appendField(locator, this, "lastImageSubscriptionRecoveryPolicy", buffer, theLastImageSubscriptionRecoveryPolicy, (this.lastImageSubscriptionRecoveryPolicy!= null));
            }
            {
                DtoNoSubscriptionRecoveryPolicy theNoSubscriptionRecoveryPolicy;
                theNoSubscriptionRecoveryPolicy = this.getNoSubscriptionRecoveryPolicy();
                strategy.appendField(locator, this, "noSubscriptionRecoveryPolicy", buffer, theNoSubscriptionRecoveryPolicy, (this.noSubscriptionRecoveryPolicy!= null));
            }
            {
                DtoQueryBasedSubscriptionRecoveryPolicy theQueryBasedSubscriptionRecoveryPolicy;
                theQueryBasedSubscriptionRecoveryPolicy = this.getQueryBasedSubscriptionRecoveryPolicy();
                strategy.appendField(locator, this, "queryBasedSubscriptionRecoveryPolicy", buffer, theQueryBasedSubscriptionRecoveryPolicy, (this.queryBasedSubscriptionRecoveryPolicy!= null));
            }
            {
                DtoRetainedMessageSubscriptionRecoveryPolicy theRetainedMessageSubscriptionRecoveryPolicy;
                theRetainedMessageSubscriptionRecoveryPolicy = this.getRetainedMessageSubscriptionRecoveryPolicy();
                strategy.appendField(locator, this, "retainedMessageSubscriptionRecoveryPolicy", buffer, theRetainedMessageSubscriptionRecoveryPolicy, (this.retainedMessageSubscriptionRecoveryPolicy!= null));
            }
            {
                DtoTimedSubscriptionRecoveryPolicy theTimedSubscriptionRecoveryPolicy;
                theTimedSubscriptionRecoveryPolicy = this.getTimedSubscriptionRecoveryPolicy();
                strategy.appendField(locator, this, "timedSubscriptionRecoveryPolicy", buffer, theTimedSubscriptionRecoveryPolicy, (this.timedSubscriptionRecoveryPolicy!= null));
            }
            {
                Object theAny;
                theAny = this.getAny();
                strategy.appendField(locator, this, "any", buffer, theAny, (this.any!= null));
            }
            return buffer;
        }

        public int hashCode(ObjectLocator locator, HashCodeStrategy2 strategy) {
            int currentHashCode = 1;
            {
                DtoFixedCountSubscriptionRecoveryPolicy theFixedCountSubscriptionRecoveryPolicy;
                theFixedCountSubscriptionRecoveryPolicy = this.getFixedCountSubscriptionRecoveryPolicy();
                currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "fixedCountSubscriptionRecoveryPolicy", theFixedCountSubscriptionRecoveryPolicy), currentHashCode, theFixedCountSubscriptionRecoveryPolicy, (this.fixedCountSubscriptionRecoveryPolicy!= null));
            }
            {
                DtoFixedSizedSubscriptionRecoveryPolicy theFixedSizedSubscriptionRecoveryPolicy;
                theFixedSizedSubscriptionRecoveryPolicy = this.getFixedSizedSubscriptionRecoveryPolicy();
                currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "fixedSizedSubscriptionRecoveryPolicy", theFixedSizedSubscriptionRecoveryPolicy), currentHashCode, theFixedSizedSubscriptionRecoveryPolicy, (this.fixedSizedSubscriptionRecoveryPolicy!= null));
            }
            {
                DtoLastImageSubscriptionRecoveryPolicy theLastImageSubscriptionRecoveryPolicy;
                theLastImageSubscriptionRecoveryPolicy = this.getLastImageSubscriptionRecoveryPolicy();
                currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "lastImageSubscriptionRecoveryPolicy", theLastImageSubscriptionRecoveryPolicy), currentHashCode, theLastImageSubscriptionRecoveryPolicy, (this.lastImageSubscriptionRecoveryPolicy!= null));
            }
            {
                DtoNoSubscriptionRecoveryPolicy theNoSubscriptionRecoveryPolicy;
                theNoSubscriptionRecoveryPolicy = this.getNoSubscriptionRecoveryPolicy();
                currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "noSubscriptionRecoveryPolicy", theNoSubscriptionRecoveryPolicy), currentHashCode, theNoSubscriptionRecoveryPolicy, (this.noSubscriptionRecoveryPolicy!= null));
            }
            {
                DtoQueryBasedSubscriptionRecoveryPolicy theQueryBasedSubscriptionRecoveryPolicy;
                theQueryBasedSubscriptionRecoveryPolicy = this.getQueryBasedSubscriptionRecoveryPolicy();
                currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "queryBasedSubscriptionRecoveryPolicy", theQueryBasedSubscriptionRecoveryPolicy), currentHashCode, theQueryBasedSubscriptionRecoveryPolicy, (this.queryBasedSubscriptionRecoveryPolicy!= null));
            }
            {
                DtoRetainedMessageSubscriptionRecoveryPolicy theRetainedMessageSubscriptionRecoveryPolicy;
                theRetainedMessageSubscriptionRecoveryPolicy = this.getRetainedMessageSubscriptionRecoveryPolicy();
                currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "retainedMessageSubscriptionRecoveryPolicy", theRetainedMessageSubscriptionRecoveryPolicy), currentHashCode, theRetainedMessageSubscriptionRecoveryPolicy, (this.retainedMessageSubscriptionRecoveryPolicy!= null));
            }
            {
                DtoTimedSubscriptionRecoveryPolicy theTimedSubscriptionRecoveryPolicy;
                theTimedSubscriptionRecoveryPolicy = this.getTimedSubscriptionRecoveryPolicy();
                currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "timedSubscriptionRecoveryPolicy", theTimedSubscriptionRecoveryPolicy), currentHashCode, theTimedSubscriptionRecoveryPolicy, (this.timedSubscriptionRecoveryPolicy!= null));
            }
            {
                Object theAny;
                theAny = this.getAny();
                currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "any", theAny), currentHashCode, theAny, (this.any!= null));
            }
            return currentHashCode;
        }

        public int hashCode() {
            final HashCodeStrategy2 strategy = JAXBHashCodeStrategy.INSTANCE2;
            return this.hashCode(null, strategy);
        }

        public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy2 strategy) {
            if ((object == null)||(this.getClass()!= object.getClass())) {
                return false;
            }
            if (this == object) {
                return true;
            }
            final DtoRetainedMessageSubscriptionRecoveryPolicy.Wrapped that = ((DtoRetainedMessageSubscriptionRecoveryPolicy.Wrapped) object);
            {
                DtoFixedCountSubscriptionRecoveryPolicy lhsFixedCountSubscriptionRecoveryPolicy;
                lhsFixedCountSubscriptionRecoveryPolicy = this.getFixedCountSubscriptionRecoveryPolicy();
                DtoFixedCountSubscriptionRecoveryPolicy rhsFixedCountSubscriptionRecoveryPolicy;
                rhsFixedCountSubscriptionRecoveryPolicy = that.getFixedCountSubscriptionRecoveryPolicy();
                if (!strategy.equals(LocatorUtils.property(thisLocator, "fixedCountSubscriptionRecoveryPolicy", lhsFixedCountSubscriptionRecoveryPolicy), LocatorUtils.property(thatLocator, "fixedCountSubscriptionRecoveryPolicy", rhsFixedCountSubscriptionRecoveryPolicy), lhsFixedCountSubscriptionRecoveryPolicy, rhsFixedCountSubscriptionRecoveryPolicy, (this.fixedCountSubscriptionRecoveryPolicy!= null), (that.fixedCountSubscriptionRecoveryPolicy!= null))) {
                    return false;
                }
            }
            {
                DtoFixedSizedSubscriptionRecoveryPolicy lhsFixedSizedSubscriptionRecoveryPolicy;
                lhsFixedSizedSubscriptionRecoveryPolicy = this.getFixedSizedSubscriptionRecoveryPolicy();
                DtoFixedSizedSubscriptionRecoveryPolicy rhsFixedSizedSubscriptionRecoveryPolicy;
                rhsFixedSizedSubscriptionRecoveryPolicy = that.getFixedSizedSubscriptionRecoveryPolicy();
                if (!strategy.equals(LocatorUtils.property(thisLocator, "fixedSizedSubscriptionRecoveryPolicy", lhsFixedSizedSubscriptionRecoveryPolicy), LocatorUtils.property(thatLocator, "fixedSizedSubscriptionRecoveryPolicy", rhsFixedSizedSubscriptionRecoveryPolicy), lhsFixedSizedSubscriptionRecoveryPolicy, rhsFixedSizedSubscriptionRecoveryPolicy, (this.fixedSizedSubscriptionRecoveryPolicy!= null), (that.fixedSizedSubscriptionRecoveryPolicy!= null))) {
                    return false;
                }
            }
            {
                DtoLastImageSubscriptionRecoveryPolicy lhsLastImageSubscriptionRecoveryPolicy;
                lhsLastImageSubscriptionRecoveryPolicy = this.getLastImageSubscriptionRecoveryPolicy();
                DtoLastImageSubscriptionRecoveryPolicy rhsLastImageSubscriptionRecoveryPolicy;
                rhsLastImageSubscriptionRecoveryPolicy = that.getLastImageSubscriptionRecoveryPolicy();
                if (!strategy.equals(LocatorUtils.property(thisLocator, "lastImageSubscriptionRecoveryPolicy", lhsLastImageSubscriptionRecoveryPolicy), LocatorUtils.property(thatLocator, "lastImageSubscriptionRecoveryPolicy", rhsLastImageSubscriptionRecoveryPolicy), lhsLastImageSubscriptionRecoveryPolicy, rhsLastImageSubscriptionRecoveryPolicy, (this.lastImageSubscriptionRecoveryPolicy!= null), (that.lastImageSubscriptionRecoveryPolicy!= null))) {
                    return false;
                }
            }
            {
                DtoNoSubscriptionRecoveryPolicy lhsNoSubscriptionRecoveryPolicy;
                lhsNoSubscriptionRecoveryPolicy = this.getNoSubscriptionRecoveryPolicy();
                DtoNoSubscriptionRecoveryPolicy rhsNoSubscriptionRecoveryPolicy;
                rhsNoSubscriptionRecoveryPolicy = that.getNoSubscriptionRecoveryPolicy();
                if (!strategy.equals(LocatorUtils.property(thisLocator, "noSubscriptionRecoveryPolicy", lhsNoSubscriptionRecoveryPolicy), LocatorUtils.property(thatLocator, "noSubscriptionRecoveryPolicy", rhsNoSubscriptionRecoveryPolicy), lhsNoSubscriptionRecoveryPolicy, rhsNoSubscriptionRecoveryPolicy, (this.noSubscriptionRecoveryPolicy!= null), (that.noSubscriptionRecoveryPolicy!= null))) {
                    return false;
                }
            }
            {
                DtoQueryBasedSubscriptionRecoveryPolicy lhsQueryBasedSubscriptionRecoveryPolicy;
                lhsQueryBasedSubscriptionRecoveryPolicy = this.getQueryBasedSubscriptionRecoveryPolicy();
                DtoQueryBasedSubscriptionRecoveryPolicy rhsQueryBasedSubscriptionRecoveryPolicy;
                rhsQueryBasedSubscriptionRecoveryPolicy = that.getQueryBasedSubscriptionRecoveryPolicy();
                if (!strategy.equals(LocatorUtils.property(thisLocator, "queryBasedSubscriptionRecoveryPolicy", lhsQueryBasedSubscriptionRecoveryPolicy), LocatorUtils.property(thatLocator, "queryBasedSubscriptionRecoveryPolicy", rhsQueryBasedSubscriptionRecoveryPolicy), lhsQueryBasedSubscriptionRecoveryPolicy, rhsQueryBasedSubscriptionRecoveryPolicy, (this.queryBasedSubscriptionRecoveryPolicy!= null), (that.queryBasedSubscriptionRecoveryPolicy!= null))) {
                    return false;
                }
            }
            {
                DtoRetainedMessageSubscriptionRecoveryPolicy lhsRetainedMessageSubscriptionRecoveryPolicy;
                lhsRetainedMessageSubscriptionRecoveryPolicy = this.getRetainedMessageSubscriptionRecoveryPolicy();
                DtoRetainedMessageSubscriptionRecoveryPolicy rhsRetainedMessageSubscriptionRecoveryPolicy;
                rhsRetainedMessageSubscriptionRecoveryPolicy = that.getRetainedMessageSubscriptionRecoveryPolicy();
                if (!strategy.equals(LocatorUtils.property(thisLocator, "retainedMessageSubscriptionRecoveryPolicy", lhsRetainedMessageSubscriptionRecoveryPolicy), LocatorUtils.property(thatLocator, "retainedMessageSubscriptionRecoveryPolicy", rhsRetainedMessageSubscriptionRecoveryPolicy), lhsRetainedMessageSubscriptionRecoveryPolicy, rhsRetainedMessageSubscriptionRecoveryPolicy, (this.retainedMessageSubscriptionRecoveryPolicy!= null), (that.retainedMessageSubscriptionRecoveryPolicy!= null))) {
                    return false;
                }
            }
            {
                DtoTimedSubscriptionRecoveryPolicy lhsTimedSubscriptionRecoveryPolicy;
                lhsTimedSubscriptionRecoveryPolicy = this.getTimedSubscriptionRecoveryPolicy();
                DtoTimedSubscriptionRecoveryPolicy rhsTimedSubscriptionRecoveryPolicy;
                rhsTimedSubscriptionRecoveryPolicy = that.getTimedSubscriptionRecoveryPolicy();
                if (!strategy.equals(LocatorUtils.property(thisLocator, "timedSubscriptionRecoveryPolicy", lhsTimedSubscriptionRecoveryPolicy), LocatorUtils.property(thatLocator, "timedSubscriptionRecoveryPolicy", rhsTimedSubscriptionRecoveryPolicy), lhsTimedSubscriptionRecoveryPolicy, rhsTimedSubscriptionRecoveryPolicy, (this.timedSubscriptionRecoveryPolicy!= null), (that.timedSubscriptionRecoveryPolicy!= null))) {
                    return false;
                }
            }
            {
                Object lhsAny;
                lhsAny = this.getAny();
                Object rhsAny;
                rhsAny = that.getAny();
                if (!strategy.equals(LocatorUtils.property(thisLocator, "any", lhsAny), LocatorUtils.property(thatLocator, "any", rhsAny), lhsAny, rhsAny, (this.any!= null), (that.any!= null))) {
                    return false;
                }
            }
            return true;
        }

        public boolean equals(Object object) {
            final EqualsStrategy2 strategy = new org.apache.activemq.plugin.jaxb2_commons.ElementAwareEqualsStrategy();
            return equals(null, null, object, strategy);
        }

    }

}
