/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.stomp;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.jms.JMSException;
import org.apache.activemq.command.ActiveMQBytesMessage;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageDispatch;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.transport.stomp.ProtocolConverter;
import org.apache.activemq.transport.stomp.ProtocolException;
import org.apache.activemq.transport.stomp.StompFrame;

public class StompSubscription {
    public static final String AUTO_ACK = "auto";
    public static final String CLIENT_ACK = "client";
    public static final String INDIVIDUAL_ACK = "client-individual";
    protected final ProtocolConverter protocolConverter;
    protected final String subscriptionId;
    protected final ConsumerInfo consumerInfo;
    protected final LinkedHashMap<MessageId, MessageDispatch> dispatchedMessage = new LinkedHashMap();
    protected final LinkedList<MessageDispatch> unconsumedMessage = new LinkedList();
    protected String ackMode = "auto";
    protected ActiveMQDestination destination;
    protected String transformation;

    public StompSubscription(ProtocolConverter stompTransport, String subscriptionId, ConsumerInfo consumerInfo, String transformation) {
        this.protocolConverter = stompTransport;
        this.subscriptionId = subscriptionId;
        this.consumerInfo = consumerInfo;
        this.transformation = transformation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onMessageDispatch(MessageDispatch md, String ackId) throws IOException, JMSException {
        ActiveMQMessage message = (ActiveMQMessage)md.getMessage();
        if (this.ackMode.equals(CLIENT_ACK) || this.ackMode.equals(INDIVIDUAL_ACK)) {
            StompSubscription stompSubscription = this;
            synchronized (stompSubscription) {
                this.dispatchedMessage.put(message.getMessageId(), md);
            }
        } else if (this.ackMode.equals(AUTO_ACK)) {
            MessageAck ack = new MessageAck(md, 2, 1);
            this.protocolConverter.getStompTransport().sendToActiveMQ((Command)ack);
        }
        boolean ignoreTransformation = false;
        if (this.transformation != null && !(message instanceof ActiveMQBytesMessage)) {
            message.setReadOnlyProperties(false);
            message.setStringProperty("transformation", this.transformation);
        } else if (message.getStringProperty("transformation") != null) {
            ignoreTransformation = true;
        }
        StompFrame command = this.protocolConverter.convertMessage(message, ignoreTransformation);
        command.setAction("MESSAGE");
        if (this.subscriptionId != null) {
            command.getHeaders().put("subscription", this.subscriptionId);
        }
        if (ackId != null) {
            command.getHeaders().put("ack", ackId);
        }
        this.protocolConverter.getStompTransport().sendToStomp(command);
    }

    synchronized void onStompAbort(TransactionId transactionId) {
        this.unconsumedMessage.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onStompCommit(TransactionId transactionId) {
        MessageAck ack = null;
        StompSubscription stompSubscription = this;
        synchronized (stompSubscription) {
            Iterator<Map.Entry<MessageId, MessageDispatch>> iter = this.dispatchedMessage.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<MessageId, MessageDispatch> entry = iter.next();
                MessageDispatch msg = entry.getValue();
                if (!this.unconsumedMessage.contains(msg)) continue;
                iter.remove();
            }
            if (!this.unconsumedMessage.isEmpty()) {
                ack = new MessageAck(this.unconsumedMessage.getLast(), 2, this.unconsumedMessage.size());
                this.unconsumedMessage.clear();
            }
        }
        if (ack != null) {
            this.protocolConverter.getStompTransport().sendToActiveMQ((Command)ack);
        }
    }

    synchronized MessageAck onStompMessageAck(String messageId, TransactionId transactionId) {
        MessageId msgId = new MessageId(messageId);
        if (!this.dispatchedMessage.containsKey(msgId)) {
            return null;
        }
        MessageAck ack = new MessageAck();
        ack.setDestination(this.consumerInfo.getDestination());
        ack.setConsumerId(this.consumerInfo.getConsumerId());
        if (this.ackMode == CLIENT_ACK) {
            if (transactionId == null) {
                ack.setAckType((byte)2);
            } else {
                ack.setAckType((byte)0);
            }
            int count = 0;
            Iterator<Map.Entry<MessageId, MessageDispatch>> iter = this.dispatchedMessage.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<MessageId, MessageDispatch> entry = iter.next();
                MessageId id = entry.getKey();
                MessageDispatch msg = entry.getValue();
                if (transactionId != null) {
                    if (!this.unconsumedMessage.contains(msg)) {
                        this.unconsumedMessage.add(msg);
                        ++count;
                    }
                } else {
                    iter.remove();
                    ++count;
                }
                if (!id.equals((Object)msgId)) continue;
                ack.setLastMessageId(id);
                break;
            }
            ack.setMessageCount(count);
            if (transactionId != null) {
                ack.setTransactionId(transactionId);
            }
        } else if (this.ackMode == INDIVIDUAL_ACK) {
            ack.setAckType((byte)4);
            ack.setMessageID(msgId);
            ack.setMessageCount(1);
            if (transactionId != null) {
                this.unconsumedMessage.add(this.dispatchedMessage.get(msgId));
                ack.setTransactionId(transactionId);
            } else {
                this.dispatchedMessage.remove(msgId);
            }
        }
        return ack;
    }

    public MessageAck onStompMessageNack(String messageId, TransactionId transactionId) throws ProtocolException {
        MessageId msgId = new MessageId(messageId);
        if (!this.dispatchedMessage.containsKey(msgId)) {
            return null;
        }
        MessageAck ack = new MessageAck();
        ack.setDestination(this.consumerInfo.getDestination());
        ack.setConsumerId(this.consumerInfo.getConsumerId());
        ack.setAckType((byte)1);
        ack.setMessageID(msgId);
        if (transactionId != null) {
            this.unconsumedMessage.add(this.dispatchedMessage.get(msgId));
            ack.setTransactionId(transactionId);
        }
        this.dispatchedMessage.remove(msgId);
        return ack;
    }

    public String getAckMode() {
        return this.ackMode;
    }

    public void setAckMode(String ackMode) {
        this.ackMode = ackMode;
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public void setDestination(ActiveMQDestination destination) {
        this.destination = destination;
    }

    public ActiveMQDestination getDestination() {
        return this.destination;
    }

    public ConsumerInfo getConsumerInfo() {
        return this.consumerInfo;
    }
}

