/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.ft;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TransactionRolledBackException;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.ft.JDBCQueueMasterSlaveTest;
import org.apache.activemq.broker.ft.SyncCreateDataSource;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.MessageId;
import org.apache.derby.jdbc.EmbeddedDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbRestartJDBCQueueMasterSlaveTest
extends JDBCQueueMasterSlaveTest {
    private static final transient Logger LOG = LoggerFactory.getLogger(DbRestartJDBCQueueMasterSlaveTest.class);

    @Override
    protected void messageSent() throws Exception {
        this.verifyExpectedBroker(this.inflightMessageCount);
        if (++this.inflightMessageCount == this.failureCount) {
            LOG.info("STOPPING DB!@!!!!");
            final EmbeddedDataSource ds = ((SyncCreateDataSource)this.getExistingDataSource()).getDelegate();
            ds.setShutdownDatabase("shutdown");
            ds.setCreateDatabase("not_any_more");
            LOG.info("DB STOPPED!@!!!!");
            Thread dbRestartThread = new Thread("db-re-start-thread"){

                @Override
                public void run() {
                    DbRestartJDBCQueueMasterSlaveTest.this.delayTillRestartRequired();
                    ds.setShutdownDatabase("false");
                    LOG.info("DB RESTARTED!@!!!!");
                }
            };
            dbRestartThread.start();
        }
        this.verifyExpectedBroker(this.inflightMessageCount);
    }

    protected void verifyExpectedBroker(int inflightMessageCount) {
        if (inflightMessageCount == 0) {
            DbRestartJDBCQueueMasterSlaveTest.assertEquals((String)"connected to master", (String)this.master.getBrokerName(), (String)((ActiveMQConnection)this.sendConnection).getBrokerName());
        } else if (inflightMessageCount == this.failureCount + 10) {
            DbRestartJDBCQueueMasterSlaveTest.assertEquals((String)("connected to slave, count:" + inflightMessageCount), (String)((BrokerService)this.slave.get()).getBrokerName(), (String)((ActiveMQConnection)this.sendConnection).getBrokerName());
        }
    }

    protected void delayTillRestartRequired() {
        LOG.info("Waiting for master broker to Stop");
        this.master.waitUntilStopped();
    }

    @Override
    protected void sendToProducer(MessageProducer producer, Destination producerDestination, Message message) throws JMSException {
        producer.send(producerDestination, message);
    }

    @Override
    protected Session createReceiveSession(Connection receiveConnection) throws Exception {
        return receiveConnection.createSession(true, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void consumeMessage(Message message, List<Message> messageList) {
        block17: {
            try {
                this.receiveSession.commit();
                super.consumeMessage(message, messageList);
            }
            catch (JMSException e) {
                TransactionRolledBackException transactionRolledBackException;
                LOG.info("Failed to commit message receipt: " + message, (Throwable)e);
                try {
                    this.receiveSession.rollback();
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
                if (!(e instanceof TransactionRolledBackException) || (transactionRolledBackException = (TransactionRolledBackException)e).getMessage().indexOf("in doubt") == -1) break block17;
                java.sql.Connection dbConnection = null;
                try {
                    ActiveMQMessage mqMessage = (ActiveMQMessage)message;
                    MessageId id = mqMessage.getMessageId();
                    dbConnection = this.sharedDs.getConnection();
                    PreparedStatement s = dbConnection.prepareStatement(this.findStatement);
                    s.setString(1, id.getProducerId().toString());
                    s.setLong(2, id.getProducerSequenceId());
                    ResultSet rs = s.executeQuery();
                    if (!rs.next()) {
                        LOG.info("On TransactionRolledBackException we know that the ack/commit got there b/c message is gone so we count it: " + mqMessage);
                        super.consumeMessage(message, messageList);
                    } else {
                        LOG.info("On TransactionRolledBackException we know that the ack/commit was lost so we expect a replay of: " + mqMessage);
                    }
                }
                catch (Exception dbe) {
                    dbe.printStackTrace();
                }
                finally {
                    try {
                        dbConnection.close();
                    }
                    catch (SQLException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }
    }
}

