/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.jmx;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import junit.framework.Test;
import junit.textui.TestRunner;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.jmx.BrokerViewMBean;
import org.apache.activemq.broker.jmx.QueueViewMBean;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.kahadb.KahaDBPersistenceAdapter;
import org.apache.activemq.store.memory.MemoryPersistenceAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PurgeTest
extends EmbeddedBrokerTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(PurgeTest.class);
    protected MBeanServer mbeanServer;
    protected String domain = "org.apache.activemq";
    protected String clientID = "foo";
    protected Connection connection;
    protected boolean transacted;
    protected int authMode = 1;
    protected int messageCount = 10;
    public PersistenceAdapter persistenceAdapter;

    public static void main(String[] args) {
        TestRunner.run(PurgeTest.class);
    }

    public static Test suite() {
        return PurgeTest.suite(PurgeTest.class);
    }

    public void testPurge() throws Exception {
        this.connection = this.connectionFactory.createConnection();
        this.connection.setClientID(this.clientID);
        this.connection.start();
        Session session = this.connection.createSession(this.transacted, this.authMode);
        this.destination = this.createDestination();
        MessageProducer producer = session.createProducer((Destination)this.destination);
        for (int i = 0; i < this.messageCount; ++i) {
            TextMessage message = session.createTextMessage("Message: " + i);
            producer.send((Message)message);
        }
        String objectNameStr = this.broker.getBrokerObjectName().toString();
        objectNameStr = objectNameStr + ",destinationType=Queue,destinationName=" + this.getDestinationString();
        ObjectName queueViewMBeanName = this.assertRegisteredObjectName(objectNameStr);
        QueueViewMBean proxy = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, queueViewMBeanName, QueueViewMBean.class, true);
        long count = proxy.getQueueSize();
        PurgeTest.assertEquals((String)"Queue size", (long)count, (long)this.messageCount);
        PurgeTest.assertEquals((String)"Browse size", (int)this.messageCount, (int)proxy.browseMessages().size());
        proxy.purge();
        count = proxy.getQueueSize();
        PurgeTest.assertEquals((String)"Queue size", (long)count, (long)0L);
        PurgeTest.assertEquals((String)"Browse size", (int)proxy.browseMessages().size(), (int)0);
        this.messageCount += 1000;
        for (int i = 0; i < this.messageCount; ++i) {
            TextMessage message = session.createTextMessage("Message: " + i);
            producer.send((Message)message);
        }
        count = proxy.getQueueSize();
        PurgeTest.assertEquals((String)"Queue size", (long)count, (long)this.messageCount);
        proxy.purge();
        count = proxy.getQueueSize();
        PurgeTest.assertEquals((String)"Queue size", (long)count, (long)0L);
        PurgeTest.assertEquals((String)"Browse size", (int)proxy.browseMessages().size(), (int)0);
        producer.close();
    }

    public void initCombosForTestDelete() {
        this.addCombinationValues("persistenceAdapter", new Object[]{new MemoryPersistenceAdapter(), new KahaDBPersistenceAdapter()});
    }

    public void testDeleteSameProducer() throws Exception {
        this.connection = this.connectionFactory.createConnection();
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        this.destination = this.createDestination();
        MessageProducer producer = session.createProducer((Destination)this.destination);
        TextMessage message = session.createTextMessage("Test Message");
        producer.send((Message)message);
        MessageConsumer consumer = session.createConsumer((Destination)this.destination);
        Message received = consumer.receive(1000L);
        PurgeTest.assertEquals((Object)message, (Object)received);
        ObjectName brokerViewMBeanName = this.assertRegisteredObjectName(this.domain + ":type=Broker,brokerName=localhost");
        BrokerViewMBean brokerProxy = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, brokerViewMBeanName, BrokerViewMBean.class, true);
        brokerProxy.removeQueue(this.getDestinationString());
        producer.send((Message)message);
        received = consumer.receive(1000L);
        PurgeTest.assertNotNull((String)"Message not received", (Object)received);
        PurgeTest.assertEquals((Object)message, (Object)received);
    }

    public void testDelete() throws Exception {
        this.connection = this.connectionFactory.createConnection();
        this.connection.setClientID(this.clientID);
        this.connection.start();
        Session session = this.connection.createSession(this.transacted, this.authMode);
        this.destination = this.createDestination();
        this.sendMessages(session, this.messageCount);
        ObjectName queueViewMBeanName = this.assertRegisteredObjectName(this.domain + ":type=Broker,brokerName=localhost,destinationType=Queue,destinationName=" + this.getDestinationString());
        QueueViewMBean queueProxy = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, queueViewMBeanName, QueueViewMBean.class, true);
        ObjectName brokerViewMBeanName = this.assertRegisteredObjectName(this.domain + ":type=Broker,brokerName=localhost");
        BrokerViewMBean brokerProxy = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, brokerViewMBeanName, BrokerViewMBean.class, true);
        long count = queueProxy.getQueueSize();
        PurgeTest.assertEquals((String)"Queue size", (long)count, (long)this.messageCount);
        brokerProxy.removeQueue(this.getDestinationString());
        this.sendMessages(session, this.messageCount);
        queueViewMBeanName = this.assertRegisteredObjectName(this.domain + ":type=Broker,brokerName=localhost,destinationType=Queue,destinationName=" + this.getDestinationString());
        queueProxy = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, queueViewMBeanName, QueueViewMBean.class, true);
        count = queueProxy.getQueueSize();
        PurgeTest.assertEquals((String)"Queue size", (long)count, (long)this.messageCount);
        queueProxy.purge();
        this.messageCount += 1000;
        this.sendMessages(session, this.messageCount);
        count = queueProxy.getQueueSize();
        PurgeTest.assertEquals((String)"Queue size", (long)count, (long)this.messageCount);
        brokerProxy.removeQueue(this.getDestinationString());
        this.sendMessages(session, this.messageCount);
        queueViewMBeanName = this.assertRegisteredObjectName(this.domain + ":type=Broker,brokerName=localhost,destinationType=Queue,destinationName=" + this.getDestinationString());
        queueProxy = MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, queueViewMBeanName, QueueViewMBean.class, true);
        count = queueProxy.getQueueSize();
        PurgeTest.assertEquals((String)"Queue size", (long)count, (long)this.messageCount);
    }

    private void sendMessages(Session session, int count) throws Exception {
        MessageProducer producer = session.createProducer((Destination)this.destination);
        for (int i = 0; i < this.messageCount; ++i) {
            TextMessage message = session.createTextMessage("Message: " + i);
            producer.send((Message)message);
        }
    }

    protected ObjectName assertRegisteredObjectName(String name) throws MalformedObjectNameException, NullPointerException {
        ObjectName objectName = new ObjectName(name);
        if (this.mbeanServer.isRegistered(objectName)) {
            this.echo("Bean Registered: " + objectName);
        } else {
            PurgeTest.fail((String)("Could not find MBean!: " + objectName));
        }
        return objectName;
    }

    @Override
    protected void setUp() throws Exception {
        this.bindAddress = "tcp://localhost:0";
        this.useTopic = false;
        super.setUp();
        this.mbeanServer = this.broker.getManagementContext().getMBeanServer();
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
        super.tearDown();
    }

    @Override
    protected BrokerService createBroker() throws Exception {
        BrokerService answer = new BrokerService();
        answer.setUseJmx(true);
        answer.setEnableStatistics(true);
        answer.addConnector(this.bindAddress);
        answer.setPersistenceAdapter(this.persistenceAdapter);
        answer.deleteAllMessages();
        return answer;
    }

    @Override
    protected ConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory(((TransportConnector)this.broker.getTransportConnectors().get(0)).getPublishableConnectString());
    }

    protected void echo(String text) {
        LOG.info(text);
    }

    @Override
    protected String getDestinationString() {
        return ((Object)((Object)this)).getClass().getName() + "." + this.getName(true);
    }
}

