/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.util;

import org.apache.activemq.broker.BrokerPlugin;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.jmx.BrokerView;
import org.apache.activemq.broker.util.DestinationsPlugin;
import org.apache.activemq.command.ActiveMQDestination;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DestinationsPluginTest {
    BrokerService broker;

    @Before
    public void setUp() throws Exception {
        this.broker = this.createBroker();
        this.broker.start();
        this.broker.waitUntilStarted();
    }

    @After
    public void shutdown() throws Exception {
        this.broker.stop();
        this.broker.waitUntilStopped();
    }

    protected BrokerService createBroker() {
        BrokerService broker = new BrokerService();
        broker.setPersistent(false);
        broker.setUseJmx(true);
        broker.setPlugins(new BrokerPlugin[]{new DestinationsPlugin()});
        broker.setDataDirectory("target/test");
        return broker;
    }

    @Test
    public void testDestinationSave() throws Exception {
        ActiveMQDestination[] destinations;
        BrokerView brokerView = this.broker.getAdminView();
        brokerView.addQueue("test-queue");
        this.broker.stop();
        this.broker.waitUntilStopped();
        this.broker = this.createBroker();
        this.broker.start();
        this.broker.waitUntilStarted();
        for (ActiveMQDestination destination : destinations = this.broker.getRegionBroker().getDestinations()) {
            if (!destination.isQueue()) continue;
            Assert.assertEquals((Object)"test-queue", (Object)destination.getPhysicalName());
        }
    }
}

