/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.virtual;

import java.util.Arrays;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQPrefetchPolicy;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.DestinationInterceptor;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.broker.region.virtual.VirtualDestination;
import org.apache.activemq.broker.region.virtual.VirtualDestinationInterceptor;
import org.apache.activemq.broker.region.virtual.VirtualTopic;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.util.Wait;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class VirtualTopicFlowControlDiscardTest {
    private static final Logger LOG = LoggerFactory.getLogger(VirtualTopicFlowControlDiscardTest.class);
    final String payload = new String(new byte[155]);
    int numConsumers = 2;
    int total = 500;
    @Parameterized.Parameter(value=0)
    public boolean concurrentSend;
    @Parameterized.Parameter(value=1)
    public boolean transactedSend;
    @Parameterized.Parameter(value=2)
    public boolean sendFailGlobal;
    @Parameterized.Parameter(value=3)
    public boolean persistentBroker;
    BrokerService brokerService;
    ConnectionFactory connectionFactory;

    @Before
    public void createBroker() throws Exception {
        this.brokerService = new BrokerService();
        this.brokerService.setPersistent(this.persistentBroker);
        this.brokerService.setDeleteAllMessagesOnStartup(true);
        PolicyMap policyMap = new PolicyMap();
        PolicyEntry restrictedUsage = new PolicyEntry();
        restrictedUsage.setCursorMemoryHighWaterMark(50);
        restrictedUsage.setMemoryLimit(5000L);
        restrictedUsage.setCursorMemoryHighWaterMark(110);
        if (this.sendFailGlobal) {
            this.brokerService.getSystemUsage().setSendFailIfNoSpace(true);
        } else {
            restrictedUsage.setSendFailIfNoSpace(true);
            restrictedUsage.setSendFailIfNoSpaceAfterTimeout(0L);
        }
        policyMap.put((ActiveMQDestination)new ActiveMQQueue("Consumer.0.VirtualTopic.TEST"), (Object)restrictedUsage);
        this.brokerService.setDestinationPolicy(policyMap);
        this.brokerService.start();
        for (DestinationInterceptor destinationInterceptor : this.brokerService.getDestinationInterceptors()) {
            for (VirtualDestination virtualDestination : ((VirtualDestinationInterceptor)destinationInterceptor).getVirtualDestinations()) {
                if (!(virtualDestination instanceof VirtualTopic)) continue;
                ((VirtualTopic)virtualDestination).setConcurrentSend(this.concurrentSend);
                ((VirtualTopic)virtualDestination).setTransactedSend(this.transactedSend);
                ((VirtualTopic)virtualDestination).setDropOnResourceLimit(true);
            }
        }
        ActiveMQConnectionFactory activeMQConnectionFactory = new ActiveMQConnectionFactory("vm://localhost");
        ActiveMQPrefetchPolicy zeroPrefetch = new ActiveMQPrefetchPolicy();
        zeroPrefetch.setAll(0);
        activeMQConnectionFactory.setPrefetchPolicy(zeroPrefetch);
        this.connectionFactory = activeMQConnectionFactory;
    }

    @After
    public void stopBroker() throws Exception {
        this.brokerService.stop();
    }

    @Parameterized.Parameters(name="cS=#{0},tS=#{1},g=#{2},persist=#{3}")
    public static Iterable<Object[]> parameters() {
        return Arrays.asList({Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE}, {Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, Boolean.FALSE}, {Boolean.FALSE, Boolean.TRUE, Boolean.TRUE, Boolean.FALSE}, {Boolean.TRUE, Boolean.FALSE, Boolean.TRUE, Boolean.FALSE}, {Boolean.FALSE, Boolean.FALSE, Boolean.TRUE, Boolean.FALSE}, {Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE}, {Boolean.TRUE, Boolean.TRUE, Boolean.FALSE, Boolean.FALSE}, {Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, Boolean.TRUE});
    }

    @Test
    public void testFanoutWithResourceException() throws Exception {
        Connection connection1 = this.connectionFactory.createConnection();
        connection1.start();
        Session session = connection1.createSession(false, 1);
        for (int i = 0; i < this.numConsumers; ++i) {
            session.createConsumer((Destination)new ActiveMQQueue("Consumer." + i + ".VirtualTopic.TEST"));
        }
        Connection connection2 = this.connectionFactory.createConnection();
        connection2.start();
        Session producerSession = connection2.createSession(false, 1);
        MessageProducer producer = producerSession.createProducer((Destination)new ActiveMQTopic("VirtualTopic.TEST"));
        long start = System.currentTimeMillis();
        LOG.info("Starting producer: " + start);
        for (int i = 0; i < this.total; ++i) {
            producer.send((Message)producerSession.createTextMessage(this.payload));
        }
        LOG.info("Done producer, duration: " + (System.currentTimeMillis() - start));
        org.apache.activemq.broker.region.Destination destination = this.brokerService.getDestination((ActiveMQDestination)new ActiveMQQueue("Consumer.0.VirtualTopic.TEST"));
        LOG.info("Dest 0 size: " + destination.getDestinationStatistics().getEnqueues().getCount());
        Assert.assertTrue((String)"did not get all", (destination.getDestinationStatistics().getEnqueues().getCount() < (long)this.total ? 1 : 0) != 0);
        Assert.assertTrue((String)"got all", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                org.apache.activemq.broker.region.Destination dest = VirtualTopicFlowControlDiscardTest.this.brokerService.getDestination((ActiveMQDestination)new ActiveMQQueue("Consumer.1.VirtualTopic.TEST"));
                LOG.info("Dest 1 size: " + dest.getDestinationStatistics().getEnqueues().getCount());
                return (long)VirtualTopicFlowControlDiscardTest.this.total == dest.getDestinationStatistics().getEnqueues().getCount();
            }
        }));
        try {
            connection1.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            connection2.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

