/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.Connection;
import javax.jms.JMSException;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.TransportConnection;
import org.apache.activemq.bugs.AMQ2580Test;
import org.apache.activemq.transport.TransportDisposedIOException;
import org.apache.activemq.util.DefaultTestAppender;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQ2902Test
extends TestCase {
    private static final Logger LOG = LoggerFactory.getLogger(AMQ2580Test.class);
    final AtomicBoolean gotExceptionInLog = new AtomicBoolean(Boolean.FALSE);
    final AtomicBoolean failedToFindMDC = new AtomicBoolean(Boolean.FALSE);
    Appender appender = new DefaultTestAppender(){

        public void doAppend(LoggingEvent event) {
            if (event.getThrowableInformation() != null && event.getThrowableInformation().getThrowable() instanceof TransportDisposedIOException) {
                if (AMQ2902Test.this.gotExceptionInLog.get()) {
                    return;
                }
                AMQ2902Test.this.gotExceptionInLog.set(Boolean.TRUE);
                LOG.error("got event: " + event + ", ex:" + event.getThrowableInformation().getThrowable(), event.getThrowableInformation().getThrowable());
                LOG.error("Event source: ", new Throwable("Here"));
            }
            if (!((String)event.getMessage()).startsWith("Loaded the Bouncy Castle security provider at position") && event.getMDC("activemq.broker") == null) {
                AMQ2902Test.this.failedToFindMDC.set(Boolean.TRUE);
            }
        }
    };

    public void testNoExceptionOnClosewithStartStop() throws JMSException {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("vm://localhost?broker.persistent=false");
        Connection connection = connectionFactory.createConnection();
        connection.start();
        connection.stop();
        connection.close();
    }

    public void testNoExceptionOnClose() throws JMSException {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("vm://localhost?broker.persistent=false");
        Connection connection = connectionFactory.createConnection();
        connection.close();
    }

    public void setUp() throws Exception {
        this.gotExceptionInLog.set(Boolean.FALSE);
        this.failedToFindMDC.set(Boolean.FALSE);
        org.apache.log4j.Logger.getRootLogger().addAppender(this.appender);
        org.apache.log4j.Logger.getLogger((String)(TransportConnection.class.getName() + ".Transport")).setLevel(Level.DEBUG);
        org.apache.log4j.Logger.getLogger((String)TransportConnection.class.getName()).setLevel(Level.DEBUG);
    }

    public void tearDown() throws Exception {
        org.apache.log4j.Logger.getRootLogger().removeAppender(this.appender);
        AMQ2902Test.assertFalse((String)"got unexpected ex in log on graceful close", (boolean)this.gotExceptionInLog.get());
        AMQ2902Test.assertFalse((String)"MDC is there", (boolean)this.failedToFindMDC.get());
    }
}

