/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.util.IOHelper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AMQ3140Test {
    private static final int MESSAGES_PER_THREAD = 100;
    private static final int THREAD_COUNT = 10;
    private BrokerService broker;
    private static final String QUEUE_NAME = "test";

    @Before
    public void setup() throws Exception {
        File schedulerDirectory = new File("target/test/ScheduledDB");
        IOHelper.mkdirs((File)schedulerDirectory);
        IOHelper.deleteChildren((File)schedulerDirectory);
        this.broker = new BrokerService();
        this.broker.setSchedulerSupport(true);
        this.broker.setPersistent(true);
        this.broker.setDeleteAllMessagesOnStartup(true);
        this.broker.setDataDirectory("target");
        this.broker.setSchedulerDirectoryFile(schedulerDirectory);
        this.broker.setUseJmx(false);
        this.broker.addConnector("vm://localhost");
        this.broker.start();
        this.broker.waitUntilStarted();
    }

    @After
    public void tearDown() throws Exception {
        this.broker.stop();
    }

    @Test
    public void noMessageLostOnConcurrentScheduling() throws JMSException, InterruptedException {
        final AtomicLong receiveCounter = new AtomicLong();
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("vm://localhost");
        Connection connection = cf.createConnection();
        connection.start();
        Session session = connection.createSession(false, 1);
        MessageConsumer consumer = session.createConsumer((Destination)session.createQueue(QUEUE_NAME));
        consumer.setMessageListener(new MessageListener(){

            public void onMessage(Message message) {
                receiveCounter.incrementAndGet();
            }
        });
        ArrayList<Sender> senderThreads = new ArrayList<Sender>();
        for (int i = 0; i < 10; ++i) {
            Sender sender = new Sender();
            senderThreads.add(sender);
        }
        for (Sender sender : senderThreads) {
            sender.start();
        }
        for (Sender sender : senderThreads) {
            sender.join();
        }
        TimeUnit.MINUTES.sleep(2L);
        session.close();
        connection.close();
        Assert.assertEquals((long)1000L, (long)receiveCounter.get());
    }

    private static class Sender
    extends Thread {
        private static final int DELAY = 3000;

        private Sender() {
        }

        @Override
        public void run() {
            try {
                ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("vm://localhost");
                Connection connection = cf.createConnection();
                connection.start();
                Session session = connection.createSession(false, 1);
                MessageProducer producer = session.createProducer((Destination)session.createQueue(AMQ3140Test.QUEUE_NAME));
                TextMessage message = session.createTextMessage(AMQ3140Test.QUEUE_NAME);
                for (int i = 0; i < 100; ++i) {
                    message.setLongProperty("AMQ_SCHEDULED_DELAY", 3000L);
                    producer.send((Message)message);
                }
                session.close();
                connection.close();
            }
            catch (JMSException e) {
                Assert.fail((String)e.getMessage());
            }
        }
    }
}

