/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.jmx.QueueViewMBean;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQ3145Test {
    private static final Logger LOG = LoggerFactory.getLogger(AMQ3145Test.class);
    private final String MESSAGE_TEXT = new String(new byte[1024]);
    BrokerService broker;
    ConnectionFactory factory;
    Connection connection;
    Session session;
    Queue queue;
    MessageConsumer consumer;

    @Before
    public void createBroker() throws Exception {
        this.createBroker(true);
    }

    public void createBroker(boolean deleteAll) throws Exception {
        this.broker = new BrokerService();
        this.broker.setDeleteAllMessagesOnStartup(deleteAll);
        this.broker.setDataDirectory("target/AMQ3145Test");
        this.broker.setUseJmx(true);
        this.broker.getManagementContext().setCreateConnector(false);
        this.broker.addConnector("tcp://localhost:0");
        this.broker.start();
        this.broker.waitUntilStarted();
        this.factory = new ActiveMQConnectionFactory(((TransportConnector)this.broker.getTransportConnectors().get(0)).getConnectUri().toString());
        this.connection = this.factory.createConnection();
        this.connection.start();
        this.session = this.connection.createSession(false, 2);
    }

    @After
    public void tearDown() throws Exception {
        if (this.consumer != null) {
            this.consumer.close();
        }
        this.session.close();
        this.connection.stop();
        this.connection.close();
        this.broker.stop();
    }

    @Test
    public void testCacheDisableReEnable() throws Exception {
        this.createProducerAndSendMessages(1);
        QueueViewMBean proxy = this.getProxyToQueueViewMBean();
        Assert.assertTrue((String)"cache is enabled", (boolean)proxy.isCacheEnabled());
        this.tearDown();
        this.createBroker(false);
        proxy = this.getProxyToQueueViewMBean();
        Assert.assertEquals((String)"one pending message", (long)1L, (long)proxy.getQueueSize());
        Assert.assertTrue((String)"cache is disabled when there is a pending message", (!proxy.isCacheEnabled() ? 1 : 0) != 0);
        this.createConsumer(1);
        this.createProducerAndSendMessages(1);
        Assert.assertTrue((String)"cache is enabled again on next send when there are no messages", (boolean)proxy.isCacheEnabled());
    }

    private QueueViewMBean getProxyToQueueViewMBean() throws MalformedObjectNameException, JMSException {
        ObjectName queueViewMBeanName = new ObjectName("org.apache.activemq:destinationType=Queue,destinationName=" + this.queue.getQueueName() + ",type=Broker,brokerName=localhost");
        QueueViewMBean proxy = (QueueViewMBean)this.broker.getManagementContext().newProxyInstance(queueViewMBeanName, QueueViewMBean.class, true);
        return proxy;
    }

    private void createProducerAndSendMessages(int numToSend) throws Exception {
        this.queue = this.session.createQueue("test1");
        MessageProducer producer = this.session.createProducer((Destination)this.queue);
        for (int i = 0; i < numToSend; ++i) {
            TextMessage message = this.session.createTextMessage(this.MESSAGE_TEXT + i);
            if (i != 0 && i % 50000 == 0) {
                LOG.info("sent: " + i);
            }
            producer.send((Message)message);
        }
        producer.close();
    }

    private void createConsumer(int numToConsume) throws Exception {
        this.consumer = this.session.createConsumer((Destination)this.queue);
        for (int i = 0; i < numToConsume; ++i) {
            Message message = this.consumer.receive(2000L);
            message.acknowledge();
        }
        this.consumer.close();
    }
}

