/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.kahadb.FilteredKahaDBPersistenceAdapter;
import org.apache.activemq.store.kahadb.KahaDBPersistenceAdapter;
import org.apache.activemq.store.kahadb.MultiKahaDBPersistenceAdapter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQ5450Test {
    static final Logger LOG = LoggerFactory.getLogger(AMQ5450Test.class);
    private static final int maxFileLength = 0x2000000;
    private static final String POSTFIX_DESTINATION_NAME = ".dlq";
    private static final String DESTINATION_NAME = "test.dlq";
    private static final String DESTINATION_NAME_2 = "2.test.dlq";
    private static final String DESTINATION_NAME_3 = "3.2.test.dlq";
    private static final String[] DESTS = new String[]{"test.dlq", "2.test.dlq", "3.2.test.dlq", "test.dlq", "test.dlq"};
    BrokerService broker;
    private HashMap<Object, PersistenceAdapter> adapters = new HashMap();

    @After
    public void tearDown() throws Exception {
        this.broker.stop();
    }

    protected BrokerService createAndStartBroker(PersistenceAdapter persistenceAdapter) throws Exception {
        BrokerService broker = new BrokerService();
        broker.setUseJmx(false);
        broker.setBrokerName("localhost");
        broker.setPersistenceAdapter(persistenceAdapter);
        broker.setDeleteAllMessagesOnStartup(true);
        broker.start();
        broker.waitUntilStarted();
        return broker;
    }

    @Test
    public void testPostFixMatch() throws Exception {
        this.doTestPostFixMatch(false);
    }

    @Test
    public void testPostFixCompositeMatch() throws Exception {
        this.doTestPostFixMatch(true);
    }

    private void doTestPostFixMatch(boolean useComposite) throws Exception {
        this.prepareBrokerWithMultiStore(useComposite);
        this.sendMessage(DESTINATION_NAME, "test 1");
        this.sendMessage(DESTINATION_NAME_2, "test 1");
        this.sendMessage(DESTINATION_NAME_3, "test 1");
        Assert.assertNotNull((Object)this.broker.getDestination((ActiveMQDestination)new ActiveMQQueue(DESTINATION_NAME)));
        Assert.assertNotNull((Object)this.broker.getDestination((ActiveMQDestination)new ActiveMQQueue(DESTINATION_NAME_2)));
        Assert.assertNotNull((Object)this.broker.getDestination((ActiveMQDestination)new ActiveMQQueue(DESTINATION_NAME_3)));
        for (String dest : DESTS) {
            org.apache.activemq.broker.region.Destination destination2 = this.broker.getDestination((ActiveMQDestination)new ActiveMQQueue(dest));
            Assert.assertNotNull((Object)destination2);
            Assert.assertEquals((long)1L, (long)destination2.getMessageStore().getMessageCount());
        }
        HashMap<Integer, PersistenceAdapter> numDests = new HashMap<Integer, PersistenceAdapter>();
        for (PersistenceAdapter pa : this.adapters.values()) {
            numDests.put(pa.getDestinations().size(), pa);
        }
        Assert.assertTrue((String)"0 in wildcard matcher", (boolean)this.adapters.get(null).getDestinations().isEmpty());
        Assert.assertEquals((String)"only two values", (long)2L, (long)numDests.size());
        Assert.assertTrue((String)"0 in others", (boolean)numDests.containsKey(0));
        if (useComposite) {
            Assert.assertTrue((String)"3 in one", (boolean)numDests.containsKey(3));
        } else {
            Assert.assertTrue((String)"1 in some", (boolean)numDests.containsKey(1));
        }
    }

    protected KahaDBPersistenceAdapter createStore(boolean delete) throws IOException {
        KahaDBPersistenceAdapter kaha = new KahaDBPersistenceAdapter();
        kaha.setJournalMaxFileLength(0x2000000);
        kaha.setCleanupInterval(5000L);
        if (delete) {
            kaha.deleteAllMessages();
        }
        return kaha;
    }

    public void prepareBrokerWithMultiStore(boolean compositeMatch) throws Exception {
        MultiKahaDBPersistenceAdapter multiKahaDBPersistenceAdapter = new MultiKahaDBPersistenceAdapter();
        multiKahaDBPersistenceAdapter.deleteAllMessages();
        ArrayList<FilteredKahaDBPersistenceAdapter> adapters = new ArrayList<FilteredKahaDBPersistenceAdapter>();
        if (compositeMatch) {
            StringBuffer compositeDestBuf = new StringBuffer();
            for (int i = 1; i <= DESTS.length; ++i) {
                for (int j = 0; j < i; ++j) {
                    compositeDestBuf.append("*");
                    if (j + 1 == i) {
                        compositeDestBuf.append(POSTFIX_DESTINATION_NAME);
                        continue;
                    }
                    compositeDestBuf.append(".");
                }
                if (i + 1 > DESTS.length) continue;
                compositeDestBuf.append(",");
            }
            adapters.add(this.createFilteredKahaDBByDestinationPrefix(compositeDestBuf.toString(), true));
        } else {
            adapters.add(this.createFilteredKahaDBByDestinationPrefix("*.dlq", true));
            adapters.add(this.createFilteredKahaDBByDestinationPrefix("*.*.dlq", true));
            adapters.add(this.createFilteredKahaDBByDestinationPrefix("*.*.*.dlq", true));
            adapters.add(this.createFilteredKahaDBByDestinationPrefix("*.*.*.*.dlq", true));
        }
        adapters.add(this.createFilteredKahaDBByDestinationPrefix(null, true));
        multiKahaDBPersistenceAdapter.setFilteredPersistenceAdapters(adapters);
        this.broker = this.createAndStartBroker((PersistenceAdapter)multiKahaDBPersistenceAdapter);
    }

    private FilteredKahaDBPersistenceAdapter createFilteredKahaDBByDestinationPrefix(String destinationPrefix, boolean deleteAllMessages) throws IOException {
        FilteredKahaDBPersistenceAdapter template = new FilteredKahaDBPersistenceAdapter();
        template.setPersistenceAdapter((PersistenceAdapter)this.createStore(deleteAllMessages));
        if (destinationPrefix != null) {
            template.setQueue(destinationPrefix);
        }
        this.adapters.put(destinationPrefix, template.getPersistenceAdapter());
        return template;
    }

    private void sendMessage(String destinationName, String message) throws JMSException {
        ActiveMQConnectionFactory f = new ActiveMQConnectionFactory("vm://localhost");
        f.setAlwaysSyncSend(true);
        Connection c = f.createConnection();
        c.start();
        Session s = c.createSession(false, 1);
        MessageProducer producer = s.createProducer((Destination)new ActiveMQQueue(destinationName));
        producer.send((Message)s.createTextMessage(message));
        producer.close();
        s.close();
        c.stop();
    }
}

