/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.JmsTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.region.policy.PendingQueueMessageStoragePolicy;
import org.apache.activemq.broker.region.policy.PendingSubscriberMessageStoragePolicy;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.broker.region.policy.VMPendingQueueMessageStoragePolicy;
import org.apache.activemq.broker.region.policy.VMPendingSubscriberMessageStoragePolicy;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.util.DefaultTestAppender;
import org.apache.activemq.util.IOHelper;
import org.apache.activemq.util.Wait;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQ6463Test
extends JmsTestSupport {
    static final Logger LOG = LoggerFactory.getLogger(AMQ6463Test.class);
    ActiveMQQueue queueA = new ActiveMQQueue("QUEUE.A");
    protected TransportConnector connector;
    protected ActiveMQConnection connection;
    protected DefaultTestAppender appender;
    final AtomicInteger errors = new AtomicInteger(0);
    final AtomicBoolean gotUsageBlocked = new AtomicBoolean();

    public void testBlockedSechedulerSendNoError() throws Exception {
        ActiveMQConnectionFactory factory = (ActiveMQConnectionFactory)this.createConnectionFactory();
        this.connection = (ActiveMQConnection)factory.createConnection();
        this.connections.add(this.connection);
        this.connection.start();
        Session session = this.connection.createSession(false, 2);
        MessageProducer producer = session.createProducer((Destination)this.queueA);
        TextMessage message = session.createTextMessage("test msg");
        int numMessages = 20;
        message.setLongProperty("AMQ_SCHEDULED_DELAY", 0L);
        message.setLongProperty("AMQ_SCHEDULED_PERIOD", 0L);
        message.setIntProperty("AMQ_SCHEDULED_REPEAT", 19);
        producer.send((Message)message);
        producer.close();
        AMQ6463Test.assertTrue((String)"got blocked event", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return AMQ6463Test.this.gotUsageBlocked.get();
            }
        }, (long)60000L));
        MessageConsumer consumer = session.createConsumer((Destination)this.queueA);
        for (int idx = 0; idx < 20; ++idx) {
            TextMessage msg = (TextMessage)consumer.receive(10000L);
            AMQ6463Test.assertNotNull((String)("received: " + idx), (Object)msg);
            msg.acknowledge();
        }
        AMQ6463Test.assertTrue((String)"no errors in the log", (this.errors.get() == 0 ? 1 : 0) != 0);
        AMQ6463Test.assertTrue((String)"got blocked message", (boolean)this.gotUsageBlocked.get());
    }

    @Override
    protected BrokerService createBroker() throws Exception {
        BrokerService service = new BrokerService();
        service.setPersistent(true);
        service.setUseJmx(false);
        service.setSchedulerSupport(true);
        service.setDeleteAllMessagesOnStartup(true);
        IOHelper.deleteChildren((File)service.getSchedulerDirectoryFile());
        service.getSystemUsage().getMemoryUsage().setLimit(512L);
        PolicyMap policyMap = new PolicyMap();
        PolicyEntry policy = new PolicyEntry();
        policy.setExpireMessagesPeriod(0L);
        policy.setMemoryLimit(1L);
        policy.setPendingSubscriberPolicy((PendingSubscriberMessageStoragePolicy)new VMPendingSubscriberMessageStoragePolicy());
        policy.setPendingQueuePolicy((PendingQueueMessageStoragePolicy)new VMPendingQueueMessageStoragePolicy());
        policy.setProducerFlowControl(true);
        policyMap.setDefaultEntry(policy);
        service.setDestinationPolicy(policyMap);
        this.connector = service.addConnector("tcp://localhost:0");
        return service;
    }

    @Override
    public void setUp() throws Exception {
        this.setAutoFail(true);
        this.appender = new DefaultTestAppender(){

            public void doAppend(LoggingEvent event) {
                if (event.getLevel().equals((Object)Level.ERROR)) {
                    AMQ6463Test.this.errors.incrementAndGet();
                } else if (event.getLevel().equals((Object)Level.WARN) && event.getRenderedMessage().contains("Usage Manager Memory Limit")) {
                    AMQ6463Test.this.gotUsageBlocked.set(true);
                }
            }
        };
        org.apache.log4j.Logger rootLogger = org.apache.log4j.Logger.getRootLogger();
        rootLogger.addAppender((Appender)this.appender);
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        org.apache.log4j.Logger rootLogger = org.apache.log4j.Logger.getRootLogger();
        rootLogger.removeAppender((Appender)this.appender);
        if (this.connection != null) {
            this.connection.close();
        }
        super.tearDown();
    }

    @Override
    protected ConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory(this.connector.getConnectUri());
    }
}

