/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs.embedded;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class ThreadExplorer {
    static Logger logger = Logger.getLogger(ThreadExplorer.class);

    public static Thread[] listThreads() {
        int nThreads = Thread.activeCount();
        Thread[] ret = new Thread[nThreads];
        Thread.enumerate(ret);
        return ret;
    }

    public static Thread fetchThread(String name) {
        Thread[] threadArray = ThreadExplorer.listThreads();
        for (int i = 0; i < threadArray.length; ++i) {
            Thread t = threadArray[i];
            if (!t.getName().equalsIgnoreCase(name)) continue;
            return t;
        }
        return null;
    }

    public static int kill(String threadName, boolean isStarredExp, String motivation) {
        String me = "ThreadExplorer.kill: ";
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Entering " + me + " with " + threadName + " isStarred: " + isStarredExp));
        }
        int ret = 0;
        Pattern mypattern = null;
        if (isStarredExp) {
            String realreg = threadName.toLowerCase().replaceAll("\\*", "\\.\\*");
            mypattern = Pattern.compile(realreg);
        }
        Thread[] threads = ThreadExplorer.listThreads();
        for (int i = 0; i < threads.length; ++i) {
            Thread thread = threads[i];
            if (thread == null) continue;
            boolean matches = false;
            if (isStarredExp) {
                Matcher matcher = mypattern.matcher(thread.getName().toLowerCase());
                matches = matcher.matches();
            } else {
                matches = thread.getName().equalsIgnoreCase(threadName);
            }
            if (!matches || Thread.currentThread() == thread || thread.getName().equals("main")) continue;
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Killing thread named [" + thread.getName() + "]"));
            }
            ++ret;
            try {
                thread.stop();
                continue;
            }
            catch (ThreadDeath e) {
                logger.warn((Object)"Thread already death.", (Throwable)e);
            }
        }
        return ret;
    }

    public static String show(String title) {
        StringBuffer out = new StringBuffer();
        Thread[] threadArray = ThreadExplorer.listThreads();
        out.append(title + "\n");
        for (int i = 0; i < threadArray.length; ++i) {
            Thread thread = threadArray[i];
            if (thread != null) {
                out.append("* [" + thread.getName() + "] " + (thread.isDaemon() ? "(Daemon)" : "") + " Group: " + (thread.getThreadGroup() != null ? thread.getThreadGroup().getName() : "") + "\n");
                continue;
            }
            out.append("* ThreadDeath: " + thread + "\n");
        }
        return out.toString();
    }

    public static int active() {
        int count = 0;
        Thread[] threadArray = ThreadExplorer.listThreads();
        for (int i = 0; i < threadArray.length; ++i) {
            Thread thread = threadArray[i];
            if (thread == null) continue;
            ++count;
        }
        return count;
    }
}

