/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.config;

import java.io.File;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.jdbc.JDBCPersistenceAdapter;
import org.apache.activemq.wireformat.ObjectStreamWireFormat;
import org.apache.activemq.xbean.BrokerFactoryBean;
import org.apache.derby.jdbc.EmbeddedDataSource;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class JDBCConfigTest {
    protected static final String JOURNAL_ROOT = "target/test-data/";
    protected static final String DERBY_ROOT = "target/test-data/";
    protected static final String CONF_ROOT = "src/test/resources/org/apache/activemq/config/sample-conf/";
    private static final Logger LOG = LoggerFactory.getLogger(JDBCConfigTest.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJdbcConfig() throws Exception {
        File journalFile = new File("target/test-data/testJDBCConfig/journal");
        JDBCConfigTest.recursiveDelete(journalFile);
        File derbyFile = new File("target/test-data/testJDBCConfig/derbydb");
        JDBCConfigTest.recursiveDelete(derbyFile);
        BrokerService broker = this.createBroker((Resource)new FileSystemResource("src/test/resources/org/apache/activemq/config/sample-conf/jdbc-example.xml"));
        try {
            Assert.assertEquals((String)"Broker Config Error (brokerName)", (Object)"brokerJdbcConfigTest", (Object)broker.getBrokerName());
            PersistenceAdapter adapter = broker.getPersistenceAdapter();
            Assert.assertTrue((String)"Should have created a jdbc persistence adapter", (boolean)(adapter instanceof JDBCPersistenceAdapter));
            Assert.assertEquals((String)"JDBC Adapter Config Error (cleanupPeriod)", (long)60000L, (long)((JDBCPersistenceAdapter)adapter).getCleanupPeriod());
            Assert.assertTrue((String)"Should have created an EmbeddedDataSource", (boolean)(((JDBCPersistenceAdapter)adapter).getDataSource() instanceof EmbeddedDataSource));
            Assert.assertTrue((String)"Should have created a DefaultWireFormat", (boolean)(((JDBCPersistenceAdapter)adapter).getWireFormat() instanceof ObjectStreamWireFormat));
            LOG.info("Success");
        }
        finally {
            if (broker != null) {
                broker.stop();
            }
        }
    }

    protected static void recursiveDelete(File file) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                JDBCConfigTest.recursiveDelete(files[i]);
            }
        }
        file.delete();
    }

    protected BrokerService createBroker(String resource) throws Exception {
        return this.createBroker((Resource)new ClassPathResource(resource));
    }

    protected BrokerService createBroker(Resource resource) throws Exception {
        BrokerFactoryBean factory = new BrokerFactoryBean(resource);
        factory.afterPropertiesSet();
        BrokerService broker = factory.getBroker();
        Assert.assertTrue((String)"Should have a broker!", (broker != null ? 1 : 0) != 0);
        return broker;
    }
}

