/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.memory;

import junit.framework.TestCase;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryPropertyTest
extends TestCase {
    private static final transient Logger LOG = LoggerFactory.getLogger(MemoryPropertyTest.class);
    BrokerService broker;

    protected void setUp() throws Exception {
        LOG.info("Creating broker... ");
        this.broker = this.createBroker("xbean:org/apache/activemq/memory/activemq.xml");
        LOG.info("Success");
        super.setUp();
    }

    protected BrokerService createBroker(String resource) throws Exception {
        return BrokerFactory.createBroker((String)resource);
    }

    protected void tearDown() throws Exception {
        LOG.info("Closing Broker");
        if (this.broker != null) {
            this.broker.stop();
        }
        LOG.info("Broker closed...");
    }

    public void testBrokerInitialized() {
        MemoryPropertyTest.assertTrue((String)"We should have a broker", (this.broker != null ? 1 : 0) != 0);
        MemoryPropertyTest.assertEquals((String)"test-broker", (String)this.broker.getBrokerName());
        MemoryPropertyTest.assertEquals((long)1024L, (long)this.broker.getSystemUsage().getMemoryUsage().getLimit());
        MemoryPropertyTest.assertEquals((int)34, (int)this.broker.getSystemUsage().getMemoryUsage().getPercentUsageMinDelta());
        MemoryPropertyTest.assertNotNull((Object)this.broker.getSystemUsage().getStoreUsage().getStore());
        MemoryPropertyTest.assertNull((Object)this.broker.getSystemUsage().getTempUsage().getStore());
    }
}

