/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.network;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.network.NetworkConnector;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkConnectionsTest
extends TestCase {
    private static final Logger LOG = LoggerFactory.getLogger(NetworkConnectionsTest.class);
    private static final String LOCAL_BROKER_TRANSPORT_URI = "tcp://localhost:61616";
    private static final String REMOTE_BROKER_TRANSPORT_URI = "tcp://localhost:61617";
    private static final String DESTINATION_NAME = "TEST.RECONNECT";
    private BrokerService localBroker;
    private BrokerService remoteBroker;

    @Test
    public void testIsStarted() throws Exception {
        LOG.info("testIsStarted is starting...");
        LOG.info("Adding network connector...");
        NetworkConnector nc = this.localBroker.addNetworkConnector("static:(tcp://localhost:61617)");
        nc.setName("NC1");
        LOG.info("Starting network connector...");
        nc.start();
        NetworkConnectionsTest.assertTrue((boolean)nc.isStarted());
        LOG.info("Stopping network connector...");
        nc.stop();
        while (nc.isStopping()) {
            LOG.info("... still stopping ...");
            Thread.sleep(100L);
        }
        NetworkConnectionsTest.assertTrue((boolean)nc.isStopped());
        NetworkConnectionsTest.assertFalse((boolean)nc.isStarted());
        LOG.info("Starting network connector...");
        nc.start();
        NetworkConnectionsTest.assertTrue((boolean)nc.isStarted());
        LOG.info("Stopping network connector...");
        nc.stop();
        while (nc.isStopping()) {
            LOG.info("... still stopping ...");
            Thread.sleep(100L);
        }
        NetworkConnectionsTest.assertTrue((boolean)nc.isStopped());
        NetworkConnectionsTest.assertFalse((boolean)nc.isStarted());
    }

    @Test
    public void testNetworkConnectionRestart() throws Exception {
        LOG.info("testNetworkConnectionRestart is starting...");
        LOG.info("Adding network connector...");
        NetworkConnector nc = this.localBroker.addNetworkConnector("static:(tcp://localhost:61617)");
        nc.setName("NC1");
        nc.start();
        NetworkConnectionsTest.assertTrue((boolean)nc.isStarted());
        LOG.info("Setting up Message Producer and Consumer");
        ActiveMQQueue destination = new ActiveMQQueue(DESTINATION_NAME);
        ActiveMQConnectionFactory localFactory = new ActiveMQConnectionFactory(LOCAL_BROKER_TRANSPORT_URI);
        Connection localConnection = localFactory.createConnection();
        localConnection.start();
        Session localSession = localConnection.createSession(false, 1);
        MessageProducer localProducer = localSession.createProducer((Destination)destination);
        ActiveMQConnectionFactory remoteFactory = new ActiveMQConnectionFactory(REMOTE_BROKER_TRANSPORT_URI);
        Connection remoteConnection = remoteFactory.createConnection();
        remoteConnection.start();
        Session remoteSession = remoteConnection.createSession(false, 1);
        MessageConsumer remoteConsumer = remoteSession.createConsumer((Destination)destination);
        TextMessage message = localSession.createTextMessage("test");
        localProducer.send((Message)message);
        LOG.info("Testing initial network connection...");
        message = remoteConsumer.receive(10000L);
        NetworkConnectionsTest.assertNotNull((Object)message);
        LOG.info("Stopping network connection...");
        nc.stop();
        NetworkConnectionsTest.assertFalse((boolean)nc.isStarted());
        LOG.info("Sending 2nd message...");
        message = localSession.createTextMessage("test stop");
        localProducer.send((Message)message);
        message = remoteConsumer.receive(1000L);
        NetworkConnectionsTest.assertNull((String)"Message should not have been delivered since NetworkConnector was stopped", (Object)message);
        LOG.info("(Re)starting network connection...");
        nc.start();
        NetworkConnectionsTest.assertTrue((boolean)nc.isStarted());
        LOG.info("Wait for 2nd message to get forwarded and received...");
        message = remoteConsumer.receive(10000L);
        NetworkConnectionsTest.assertNotNull((String)"Should have received 2nd message", (Object)message);
    }

    @Test
    public void testNetworkConnectionReAddURI() throws Exception {
        LOG.info("testNetworkConnectionReAddURI is starting...");
        LOG.info("Adding network connector 'NC1'...");
        NetworkConnector nc = this.localBroker.addNetworkConnector("static:(tcp://localhost:61617)");
        nc.setName("NC1");
        nc.start();
        NetworkConnectionsTest.assertTrue((boolean)nc.isStarted());
        LOG.info("Looking up network connector by name...");
        NetworkConnector nc1 = this.localBroker.getNetworkConnectorByName("NC1");
        NetworkConnectionsTest.assertNotNull((String)"Should find network connector 'NC1'", (Object)nc1);
        NetworkConnectionsTest.assertTrue((boolean)nc1.isStarted());
        NetworkConnectionsTest.assertEquals((Object)nc, (Object)nc1);
        LOG.info("Setting up producer and consumer...");
        ActiveMQQueue destination = new ActiveMQQueue(DESTINATION_NAME);
        ActiveMQConnectionFactory localFactory = new ActiveMQConnectionFactory(LOCAL_BROKER_TRANSPORT_URI);
        Connection localConnection = localFactory.createConnection();
        localConnection.start();
        Session localSession = localConnection.createSession(false, 1);
        MessageProducer localProducer = localSession.createProducer((Destination)destination);
        ActiveMQConnectionFactory remoteFactory = new ActiveMQConnectionFactory(REMOTE_BROKER_TRANSPORT_URI);
        Connection remoteConnection = remoteFactory.createConnection();
        remoteConnection.start();
        Session remoteSession = remoteConnection.createSession(false, 1);
        MessageConsumer remoteConsumer = remoteSession.createConsumer((Destination)destination);
        TextMessage message = localSession.createTextMessage("test");
        localProducer.send((Message)message);
        LOG.info("Testing initial network connection...");
        message = remoteConsumer.receive(10000L);
        NetworkConnectionsTest.assertNotNull((Object)message);
        LOG.info("Stopping network connector 'NC1'...");
        nc.stop();
        NetworkConnectionsTest.assertFalse((boolean)nc.isStarted());
        LOG.info("Removing network connector...");
        NetworkConnectionsTest.assertTrue((boolean)this.localBroker.removeNetworkConnector(nc));
        nc1 = this.localBroker.getNetworkConnectorByName("NC1");
        NetworkConnectionsTest.assertNull((String)"Should not find network connector 'NC1'", (Object)nc1);
        LOG.info("Re-adding network connector 'NC2'...");
        nc = this.localBroker.addNetworkConnector("static:(tcp://localhost:61617)");
        nc.setName("NC2");
        nc.start();
        NetworkConnectionsTest.assertTrue((boolean)nc.isStarted());
        LOG.info("Looking up network connector by name...");
        NetworkConnector nc2 = this.localBroker.getNetworkConnectorByName("NC2");
        NetworkConnectionsTest.assertNotNull((Object)nc2);
        NetworkConnectionsTest.assertTrue((boolean)nc2.isStarted());
        NetworkConnectionsTest.assertEquals((Object)nc, (Object)nc2);
        LOG.info("Testing re-added network connection...");
        message = localSession.createTextMessage("test");
        localProducer.send((Message)message);
        message = remoteConsumer.receive(10000L);
        NetworkConnectionsTest.assertNotNull((Object)message);
        LOG.info("Stopping network connector...");
        nc.stop();
        NetworkConnectionsTest.assertFalse((boolean)nc.isStarted());
        LOG.info("Removing network connection 'NC2'");
        NetworkConnectionsTest.assertTrue((boolean)this.localBroker.removeNetworkConnector(nc));
        nc2 = this.localBroker.getNetworkConnectorByName("NC2");
        NetworkConnectionsTest.assertNull((String)"Should not find network connector 'NC2'", (Object)nc2);
    }

    protected void setUp() throws Exception {
        LOG.info("Setting up LocalBroker");
        this.localBroker = new BrokerService();
        this.localBroker.setBrokerName("LocalBroker");
        this.localBroker.setUseJmx(false);
        this.localBroker.setPersistent(false);
        this.localBroker.setTransportConnectorURIs(new String[]{LOCAL_BROKER_TRANSPORT_URI});
        this.localBroker.start();
        this.localBroker.waitUntilStarted();
        LOG.info("Setting up RemoteBroker");
        this.remoteBroker = new BrokerService();
        this.remoteBroker.setBrokerName("RemoteBroker");
        this.remoteBroker.setUseJmx(false);
        this.remoteBroker.setPersistent(false);
        this.remoteBroker.setTransportConnectorURIs(new String[]{REMOTE_BROKER_TRANSPORT_URI});
        this.remoteBroker.start();
        this.remoteBroker.waitUntilStarted();
    }

    protected void tearDown() throws Exception {
        if (this.localBroker.isStarted()) {
            LOG.info("Stopping LocalBroker");
            this.localBroker.stop();
            this.localBroker.waitUntilStopped();
            this.localBroker = null;
        }
        if (this.remoteBroker.isStarted()) {
            LOG.info("Stopping RemoteBroker");
            this.remoteBroker.stop();
            this.remoteBroker.waitUntilStopped();
            this.remoteBroker = null;
        }
    }
}

