/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.security;

import java.io.IOException;
import java.io.InputStream;
import org.apache.activemq.security.AbstractCachedLDAPAuthorizationMapLegacyTest;
import org.apache.activemq.security.SimpleCachedLDAPAuthorizationMap;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.ldap.client.api.LdapNetworkConnection;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.ApplyLdifFiles;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.junit.runner.RunWith;

@RunWith(value=FrameworkRunner.class)
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP")})
@ApplyLdifFiles(value={"org/apache/activemq/security/activemq-apacheds-legacy.ldif"})
public class CachedLDAPAuthorizationModuleLegacyTest
extends AbstractCachedLDAPAuthorizationMapLegacyTest {
    @Override
    protected SimpleCachedLDAPAuthorizationMap createMap() {
        SimpleCachedLDAPAuthorizationMap map = super.createMap();
        map.setConnectionURL("ldap://localhost:" + CachedLDAPAuthorizationModuleLegacyTest.getLdapServer().getPort());
        map.setConnectionPassword("secret");
        return map;
    }

    @Override
    protected InputStream getAddLdif() {
        return ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/apache/activemq/security/activemq-apacheds-legacy-add.ldif");
    }

    @Override
    protected InputStream getRemoveLdif() {
        return ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/apache/activemq/security/activemq-apacheds-legacy-delete.ldif");
    }

    @Override
    protected String getQueueBaseDn() {
        return "ou=Queue,ou=Destination,ou=ActiveMQ,ou=system";
    }

    @Override
    protected LdapConnection getLdapConnection() throws LdapException, IOException {
        LdapNetworkConnection connection = new LdapNetworkConnection("localhost", CachedLDAPAuthorizationModuleLegacyTest.getLdapServer().getPort());
        connection.bind(new Dn(new String[]{"uid=admin,ou=system"}), "secret");
        return connection;
    }
}

