/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.selector;

import javax.jms.InvalidSelectorException;
import junit.framework.TestCase;
import org.apache.activemq.filter.BooleanExpression;
import org.apache.activemq.filter.BooleanFunctionCallExpr;
import org.apache.activemq.filter.ComparisonExpression;
import org.apache.activemq.filter.Expression;
import org.apache.activemq.filter.LogicExpression;
import org.apache.activemq.filter.PropertyExpression;
import org.apache.activemq.filter.XPathExpression;
import org.apache.activemq.selector.SelectorParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectorParserTest
extends TestCase {
    private static final Logger LOG = LoggerFactory.getLogger(SelectorParserTest.class);

    public void testFunctionCall() throws Exception {
        BooleanExpression filter = this.parse("REGEX('sales.*', group)");
        SelectorParserTest.assertTrue((String)"expected type", (boolean)(filter instanceof BooleanFunctionCallExpr));
        LOG.info("function exp:" + filter);
        try {
            this.parse("DoesNotExist('sales.*', group)");
            SelectorParserTest.fail((String)"expect ex on non existent function");
        }
        catch (InvalidSelectorException invalidSelectorException) {
            // empty catch block
        }
    }

    public void testParseXPath() throws Exception {
        BooleanExpression filter = this.parse("XPATH '//title[@lang=''eng'']'");
        SelectorParserTest.assertTrue((String)"Created XPath expression", (boolean)(filter instanceof XPathExpression));
        LOG.info("Expression: " + filter);
    }

    public void testParseWithParensAround() throws Exception {
        String[] values = new String[]{"x = 1 and y = 2", "(x = 1) and (y = 2)", "((x = 1) and (y = 2))"};
        for (int i = 0; i < values.length; ++i) {
            String value = values[i];
            LOG.info("Parsing: " + value);
            BooleanExpression andExpression = this.parse(value);
            SelectorParserTest.assertTrue((String)"Created LogicExpression expression", (boolean)(andExpression instanceof LogicExpression));
            LogicExpression logicExpression = (LogicExpression)andExpression;
            Expression left = logicExpression.getLeft();
            Expression right = logicExpression.getRight();
            SelectorParserTest.assertTrue((String)"Left is a binary filter", (boolean)(left instanceof ComparisonExpression));
            SelectorParserTest.assertTrue((String)"Right is a binary filter", (boolean)(right instanceof ComparisonExpression));
            ComparisonExpression leftCompare = (ComparisonExpression)left;
            ComparisonExpression rightCompare = (ComparisonExpression)right;
            this.assertPropertyExpression("left", leftCompare.getLeft(), "x");
            this.assertPropertyExpression("right", rightCompare.getLeft(), "y");
        }
    }

    protected void assertPropertyExpression(String message, Expression expression, String expected) {
        SelectorParserTest.assertTrue((String)(message + ". Must be PropertyExpression"), (boolean)(expression instanceof PropertyExpression));
        PropertyExpression propExp = (PropertyExpression)expression;
        SelectorParserTest.assertEquals((String)(message + ". Property name"), (String)expected, (String)propExp.getName());
    }

    protected BooleanExpression parse(String text) throws Exception {
        return SelectorParser.parse((String)text);
    }
}

