/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadb;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import javax.jms.JMSException;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.kahadb.FilteredKahaDBPersistenceAdapter;
import org.apache.activemq.store.kahadb.KahaDBPersistenceAdapter;
import org.apache.activemq.store.kahadb.MultiKahaDBPersistenceAdapter;
import org.apache.activemq.store.kahadb.MultiKahaDBTopicDeletionTest;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMultiKahaDBDeletionTest {
    protected static final Logger LOG = LoggerFactory.getLogger(MultiKahaDBTopicDeletionTest.class);
    protected BrokerService brokerService;
    protected Broker broker;
    protected URI brokerConnectURI;
    protected File storeDir;
    protected ActiveMQDestination dest1;
    protected ActiveMQDestination dest2;
    @Rule
    public TemporaryFolder tempTestDir = new TemporaryFolder();

    public AbstractMultiKahaDBDeletionTest(ActiveMQDestination dest1, ActiveMQDestination dest2) {
        this.dest1 = dest1;
        this.dest2 = dest2;
    }

    @Before
    public void startBroker() throws Exception {
        this.setUpBroker(true);
    }

    protected void setUpBroker(boolean clearDataDir) throws Exception {
        this.brokerService = new BrokerService();
        this.initPersistence(this.brokerService);
        TransportConnector connector = this.brokerService.addConnector(new TransportConnector());
        connector.setUri(new URI("tcp://0.0.0.0:0"));
        connector.setName("tcp");
        this.brokerService.start();
        this.brokerService.waitUntilStarted();
        this.brokerConnectURI = this.brokerService.getConnectorByName("tcp").getConnectUri();
        this.broker = this.brokerService.getBroker();
    }

    @After
    public void stopBroker() throws Exception {
        this.brokerService.stop();
        this.brokerService.waitUntilStopped();
    }

    protected void initPersistence(BrokerService brokerService) throws IOException {
        this.storeDir = this.tempTestDir.getRoot();
        brokerService.setPersistent(true);
        MultiKahaDBPersistenceAdapter persistenceAdapter = new MultiKahaDBPersistenceAdapter();
        persistenceAdapter.setDirectory(this.storeDir);
        KahaDBPersistenceAdapter kahaStore = new KahaDBPersistenceAdapter();
        kahaStore.setJournalMaxFileLength(524288);
        FilteredKahaDBPersistenceAdapter filtered = new FilteredKahaDBPersistenceAdapter();
        filtered.setPersistenceAdapter((PersistenceAdapter)kahaStore);
        filtered.setPerDestination(true);
        ArrayList<FilteredKahaDBPersistenceAdapter> stores = new ArrayList<FilteredKahaDBPersistenceAdapter>();
        stores.add(filtered);
        persistenceAdapter.setFilteredPersistenceAdapters(stores);
        brokerService.setPersistenceAdapter((PersistenceAdapter)persistenceAdapter);
    }

    @Test
    public void testDest1Deletion() throws Exception {
        LOG.info("Creating {} first, {} second", (Object)this.dest1, (Object)this.dest2);
        LOG.info("Removing {}, subscribing to {}", (Object)this.dest1, (Object)this.dest2);
        this.broker.addDestination(this.brokerService.getAdminConnectionContext(), this.dest1, false);
        this.broker.addDestination(this.brokerService.getAdminConnectionContext(), this.dest2, false);
        this.broker.removeDestination(this.brokerService.getAdminConnectionContext(), this.dest1, 100L);
        this.createConsumer(this.dest2);
        Collection storeFiles = FileUtils.listFiles((File)this.storeDir, (IOFileFilter)new WildcardFileFilter("db*"), (IOFileFilter)this.getStoreFileFilter());
        Assert.assertTrue((String)"Store index should still exist", (storeFiles.size() >= 1 ? 1 : 0) != 0);
    }

    @Test
    public void testDest2Deletion() throws Exception {
        LOG.info("Creating {} first, {} second", (Object)this.dest1, (Object)this.dest2);
        LOG.info("Removing {}, subscribing to {}", (Object)this.dest2, (Object)this.dest1);
        this.broker.addDestination(this.brokerService.getAdminConnectionContext(), this.dest1, false);
        this.broker.addDestination(this.brokerService.getAdminConnectionContext(), this.dest2, false);
        this.broker.removeDestination(this.brokerService.getAdminConnectionContext(), this.dest2, 100L);
        this.createConsumer(this.dest1);
        Collection storeFiles = FileUtils.listFiles((File)this.storeDir, (IOFileFilter)new WildcardFileFilter("db*"), (IOFileFilter)this.getStoreFileFilter());
        Assert.assertTrue((String)"Store index should still exist", (storeFiles.size() >= 1 ? 1 : 0) != 0);
    }

    @Test
    public void testStoreCleanupDeleteDest1First() throws Exception {
        LOG.info("Creating {} first, {} second", (Object)this.dest1, (Object)this.dest2);
        LOG.info("Deleting {} first, {} second", (Object)this.dest1, (Object)this.dest2);
        this.broker.addDestination(this.brokerService.getAdminConnectionContext(), this.dest1, false);
        this.broker.addDestination(this.brokerService.getAdminConnectionContext(), this.dest2, false);
        this.broker.removeDestination(this.brokerService.getAdminConnectionContext(), this.dest1, 100L);
        this.broker.removeDestination(this.brokerService.getAdminConnectionContext(), this.dest2, 100L);
        Collection storeFiles = FileUtils.listFiles((File)this.storeDir, (IOFileFilter)new WildcardFileFilter("db*"), (IOFileFilter)this.getStoreFileFilter());
        Assert.assertEquals((String)"Store files should be deleted", (long)0L, (long)storeFiles.size());
    }

    @Test
    public void testStoreCleanupDeleteDest2First() throws Exception {
        LOG.info("Creating {} first, {} second", (Object)this.dest1, (Object)this.dest2);
        LOG.info("Deleting {} first, {} second", (Object)this.dest2, (Object)this.dest1);
        this.broker.addDestination(this.brokerService.getAdminConnectionContext(), this.dest1, false);
        this.broker.addDestination(this.brokerService.getAdminConnectionContext(), this.dest2, false);
        this.broker.removeDestination(this.brokerService.getAdminConnectionContext(), this.dest2, 100L);
        this.broker.removeDestination(this.brokerService.getAdminConnectionContext(), this.dest1, 100L);
        Collection storeFiles = FileUtils.listFiles((File)this.storeDir, (IOFileFilter)new WildcardFileFilter("db*"), (IOFileFilter)this.getStoreFileFilter());
        Assert.assertEquals((String)"Store files should be deleted", (long)0L, (long)storeFiles.size());
    }

    protected abstract void createConsumer(ActiveMQDestination var1) throws JMSException;

    protected abstract WildcardFileFilter getStoreFileFilter();
}

