/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.test;

import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import org.apache.activemq.EmbeddedBrokerAndConnectionTestSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemporaryDestinationToFromNameTest
extends EmbeddedBrokerAndConnectionTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(TemporaryDestinationToFromNameTest.class);

    public void testCreateTemporaryQueueThenCreateAQueueFromItsName() throws Exception {
        Session session = this.connection.createSession(false, 1);
        TemporaryQueue tempQueue = session.createTemporaryQueue();
        String name = tempQueue.getQueueName();
        LOG.info("Created queue named: " + name);
        Queue createdQueue = session.createQueue(name);
        TemporaryDestinationToFromNameTest.assertEquals((String)"created queue not equal to temporary queue", (Object)tempQueue, (Object)createdQueue);
    }

    public void testCreateTemporaryTopicThenCreateATopicFromItsName() throws Exception {
        Session session = this.connection.createSession(false, 1);
        TemporaryTopic tempTopic = session.createTemporaryTopic();
        String name = tempTopic.getTopicName();
        LOG.info("Created topic named: " + name);
        Topic createdTopic = session.createTopic(name);
        TemporaryDestinationToFromNameTest.assertEquals((String)"created topic not equal to temporary topic", (Object)tempTopic, (Object)createdTopic);
    }
}

