/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.auto;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.BrokerFilter;
import org.apache.activemq.broker.BrokerPlugin;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.TransportConnection;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.command.ConnectionInfo;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class AutoSslAuthTest {
    public static final String KEYSTORE_TYPE = "jks";
    public static final String PASSWORD = "password";
    public static final String SERVER_KEYSTORE = "src/test/resources/server.keystore";
    public static final String TRUST_KEYSTORE = "src/test/resources/client.keystore";
    private String uri;
    private final String protocol;
    private AtomicInteger hasCertificateCount = new AtomicInteger();
    private BrokerService brokerService;

    @Parameterized.Parameters(name="protocol={0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"auto+nio+ssl"}, {"auto+ssl"});
    }

    @Before
    public void before() throws Exception {
        BrokerService brokerService = new BrokerService();
        brokerService.setPersistent(false);
        TransportConnector connector = brokerService.addConnector(this.protocol + "://localhost:0?transport.needClientAuth=true");
        connector.setName("auto");
        this.uri = connector.getPublishableConnectString();
        ArrayList<1> plugins = new ArrayList<1>();
        plugins.add(new BrokerPlugin(){

            public Broker installPlugin(Broker broker) throws Exception {
                return new BrokerFilter(broker){

                    public void addConnection(ConnectionContext context, ConnectionInfo info) throws Exception {
                        super.addConnection(context, info);
                        if (info.getTransportContext() instanceof X509Certificate[]) {
                            AutoSslAuthTest.this.hasCertificateCount.getAndIncrement();
                        }
                    }
                };
            }
        });
        if (!plugins.isEmpty()) {
            BrokerPlugin[] array = new BrokerPlugin[plugins.size()];
            brokerService.setPlugins(plugins.toArray(array));
        }
        this.brokerService = brokerService;
        brokerService.start();
        brokerService.waitUntilStarted();
    }

    @After
    public void after() throws Exception {
        if (this.brokerService != null) {
            this.brokerService.stop();
            this.brokerService.waitUntilStopped();
        }
    }

    public AutoSslAuthTest(String protocol) {
        this.protocol = protocol;
    }

    @Test(timeout=60000L)
    public void testConnect() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory();
        factory.setBrokerURL(this.uri);
        for (int i = 0; i < 5; ++i) {
            factory.createConnection().start();
        }
        Assert.assertTrue((this.hasCertificateCount.get() == 5 ? 1 : 0) != 0);
        for (TransportConnection connection : this.brokerService.getTransportConnectorByName("auto").getConnections()) {
            Assert.assertTrue((connection.getTransport().getPeerCertificates() != null ? 1 : 0) != 0);
        }
    }

    static {
        System.setProperty("javax.net.ssl.trustStore", TRUST_KEYSTORE);
        System.setProperty("javax.net.ssl.trustStorePassword", PASSWORD);
        System.setProperty("javax.net.ssl.trustStoreType", KEYSTORE_TYPE);
        System.setProperty("javax.net.ssl.keyStore", SERVER_KEYSTORE);
        System.setProperty("javax.net.ssl.keyStorePassword", PASSWORD);
        System.setProperty("javax.net.ssl.keyStoreType", KEYSTORE_TYPE);
    }
}

