/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.tcp;

import java.net.Socket;
import java.util.HashMap;
import junit.framework.TestCase;
import org.apache.activemq.transport.tcp.QualityOfServiceUtils;

public class QualityOfServiceUtilsTest
extends TestCase {
    private int ECN;

    protected void setUp() throws Exception {
        Socket socket = new Socket();
        this.ECN = socket.getTrafficClass() & Integer.parseInt("00000011", 2);
        socket.close();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testValidDiffServIntegerValues() {
        int[] values;
        for (int val : values = new int[]{0, 1, 32, 62, 63}) {
            this.testValidDiffServIntegerValue(val);
        }
    }

    public void testInvalidDiffServIntegerValues() {
        int[] values;
        for (int val : values = new int[]{-2, -1, 64, 65}) {
            this.testInvalidDiffServIntegerValue(val);
        }
    }

    public void testValidDiffServNames() {
        HashMap<String, Integer> namesToExpected = new HashMap<String, Integer>();
        namesToExpected.put("CS0", Integer.valueOf("000000", 2));
        namesToExpected.put("CS1", Integer.valueOf("001000", 2));
        namesToExpected.put("CS2", Integer.valueOf("010000", 2));
        namesToExpected.put("CS3", Integer.valueOf("011000", 2));
        namesToExpected.put("CS4", Integer.valueOf("100000", 2));
        namesToExpected.put("CS5", Integer.valueOf("101000", 2));
        namesToExpected.put("CS6", Integer.valueOf("110000", 2));
        namesToExpected.put("CS7", Integer.valueOf("111000", 2));
        namesToExpected.put("EF", Integer.valueOf("101110", 2));
        namesToExpected.put("AF11", Integer.valueOf("001010", 2));
        namesToExpected.put("AF12", Integer.valueOf("001100", 2));
        namesToExpected.put("AF13", Integer.valueOf("001110", 2));
        namesToExpected.put("AF21", Integer.valueOf("010010", 2));
        namesToExpected.put("AF22", Integer.valueOf("010100", 2));
        namesToExpected.put("AF23", Integer.valueOf("010110", 2));
        namesToExpected.put("AF31", Integer.valueOf("011010", 2));
        namesToExpected.put("AF32", Integer.valueOf("011100", 2));
        namesToExpected.put("AF33", Integer.valueOf("011110", 2));
        namesToExpected.put("AF41", Integer.valueOf("100010", 2));
        namesToExpected.put("AF42", Integer.valueOf("100100", 2));
        namesToExpected.put("AF43", Integer.valueOf("100110", 2));
        for (String name : namesToExpected.keySet()) {
            this.testValidDiffServName(name, (Integer)namesToExpected.get(name));
        }
    }

    public void testInvalidDiffServNames() {
        String[] names;
        for (String name : names = new String[]{"hello_world", "", "abcd"}) {
            this.testInvalidDiffServName(name);
        }
    }

    private void testValidDiffServName(String name, int expected) {
        int dscp = -1;
        try {
            dscp = QualityOfServiceUtils.getDSCP((String)name);
        }
        catch (IllegalArgumentException e) {
            QualityOfServiceUtilsTest.fail((String)("IllegalArgumentException thrown for valid Differentiated  Services name: " + name));
        }
        QualityOfServiceUtilsTest.assertEquals((String)("Incorrect Differentiated Services Code Point " + dscp + " returned for name " + name + "."), (int)(this.ECN | expected << 2), (int)dscp);
    }

    private void testInvalidDiffServName(String name) {
        try {
            QualityOfServiceUtils.getDSCP((String)name);
            QualityOfServiceUtilsTest.fail((String)("No IllegalArgumentException thrown for invalid Differentiated Services value: " + name + "."));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void testValidDiffServIntegerValue(int val) {
        try {
            int dscp = QualityOfServiceUtils.getDSCP((String)Integer.toString(val));
            QualityOfServiceUtilsTest.assertEquals((String)("Incorrect Differentiated Services Code Point returned for value " + val + "."), (int)(this.ECN | val << 2), (int)dscp);
        }
        catch (IllegalArgumentException e) {
            QualityOfServiceUtilsTest.fail((String)("IllegalArgumentException thrown for valid Differentiated Services value " + val));
        }
    }

    private void testInvalidDiffServIntegerValue(int val) {
        try {
            QualityOfServiceUtils.getDSCP((String)Integer.toString(val));
            QualityOfServiceUtilsTest.fail((String)("No IllegalArgumentException thrown for invalid Differentiated Services value " + val + "."));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testValidTypeOfServiceValues() {
        int[] values;
        for (int val : values = new int[]{0, 1, 32, 100, 255}) {
            this.testValidTypeOfServiceValue(val);
        }
    }

    public void testInvalidTypeOfServiceValues() {
        int[] values;
        for (int val : values = new int[]{-2, -1, 256, 257}) {
            this.testInvalidTypeOfServiceValue(val);
        }
    }

    private void testValidTypeOfServiceValue(int val) {
        try {
            int typeOfService = QualityOfServiceUtils.getToS((int)val);
            QualityOfServiceUtilsTest.assertEquals((String)("Incorrect Type of Services value returned for " + val + "."), (int)val, (int)typeOfService);
        }
        catch (IllegalArgumentException e) {
            QualityOfServiceUtilsTest.fail((String)("IllegalArgumentException thrown for valid Type of Service value " + val + "."));
        }
    }

    private void testInvalidTypeOfServiceValue(int val) {
        try {
            QualityOfServiceUtils.getToS((int)val);
            QualityOfServiceUtilsTest.fail((String)("No IllegalArgumentException thrown for invalid Type of Service value " + val + "."));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

