/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.util.ArrayList;
import java.util.Collection;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import org.apache.activemq.store.kahadb.KahaDBPersistenceAdapter;
import org.apache.activemq.usecases.DurableSubscriptionOfflineTestBase;
import org.apache.activemq.usecases.DurableSubscriptionOfflineTestListener;
import org.apache.activemq.util.Wait;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class DurableSubscriptionOffline4Test
extends DurableSubscriptionOfflineTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(DurableSubscriptionOffline4Test.class);

    @Parameterized.Parameters(name="keepDurableSubsActive_{0}")
    public static Collection<Boolean[]> getTestParameters() {
        Boolean[] f = new Boolean[]{Boolean.FALSE};
        Boolean[] t = new Boolean[]{Boolean.TRUE};
        ArrayList<Boolean[]> booleanChoices = new ArrayList<Boolean[]>();
        booleanChoices.add(f);
        booleanChoices.add(t);
        return booleanChoices;
    }

    public DurableSubscriptionOffline4Test(Boolean keepDurableSubsActive) {
        this.journalMaxFileLength = 65536;
        this.keepDurableSubsActive = keepDurableSubsActive;
        LOG.info(">>>> running {} with keepDurableSubsActive: {}, journalMaxFileLength", new Object[]{this.testName.getMethodName(), this.keepDurableSubsActive, this.journalMaxFileLength});
    }

    @Test(timeout=60000L)
    public void testCleanupDeletedSubAfterRestart() throws Exception {
        int sent;
        Connection con = this.createConnection("cli1");
        Session session = con.createSession(false, 1);
        session.createDurableSubscriber((Topic)this.topic, "SubsId", null, true);
        session.close();
        con.close();
        con = this.createConnection("cli2");
        session = con.createSession(false, 1);
        session.createDurableSubscriber((Topic)this.topic, "SubsId", null, true);
        session.close();
        con.close();
        con = this.createConnection();
        session = con.createSession(false, 1);
        MessageProducer producer = session.createProducer(null);
        int toSend = 500;
        String payload = new byte[40960].toString();
        for (int i = sent = 0; i < 500; ++i) {
            TextMessage message = session.createTextMessage(payload);
            message.setStringProperty("filter", "false");
            message.setIntProperty("ID", i);
            producer.send((Destination)this.topic, (Message)message);
            ++sent;
        }
        con.close();
        LOG.info("sent: " + sent);
        con = this.createConnection("cli1");
        session = con.createSession(false, 1);
        session.unsubscribe("SubsId");
        this.destroyBroker();
        this.createBroker(false);
        con = this.createConnection("cli2");
        session = con.createSession(false, 1);
        TopicSubscriber consumer = session.createDurableSubscriber((Topic)this.topic, "SubsId", null, true);
        final DurableSubscriptionOfflineTestListener listener = new DurableSubscriptionOfflineTestListener();
        consumer.setMessageListener((MessageListener)listener);
        Assert.assertTrue((String)"got all sent", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                LOG.info("Want: 500, current: " + listener.count);
                return listener.count == 500;
            }
        }));
        session.close();
        con.close();
        this.destroyBroker();
        this.createBroker(false);
        final KahaDBPersistenceAdapter pa = (KahaDBPersistenceAdapter)this.broker.getPersistenceAdapter();
        Assert.assertTrue((String)("Should have less than three journal files left but was: " + pa.getStore().getJournal().getFileMap().size()), (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return pa.getStore().getJournal().getFileMap().size() <= 3;
            }
        }));
    }
}

