/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.kahadb.KahaDBPersistenceAdapter;
import org.apache.activemq.store.kahadb.MessageDatabase;
import org.apache.activemq.util.DefaultTestAppender;
import org.apache.log4j.Appender;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;

public class EmptyTransactionTest
extends TestCase {
    private static final int CHECKPOINT_INTERVAL = 500;
    private BrokerService broker;

    public void testEmptyTransactionsCheckpoint() throws Exception {
        final AtomicBoolean hadRecovery = new AtomicBoolean(false);
        DefaultTestAppender appender = new DefaultTestAppender(){

            public void doAppend(LoggingEvent event) {
                if (event.getMessage().toString().contains("Recovering from the journal @")) {
                    hadRecovery.set(true);
                }
            }
        };
        Logger.getLogger(MessageDatabase.class).addAppender((Appender)appender);
        this.start(true);
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("vm://localhost");
        Connection connection = factory.createConnection();
        Session session = connection.createSession(true, 0);
        MessageProducer producer = session.createProducer((Destination)new ActiveMQQueue("QueueName"));
        producer.setDeliveryMode(1);
        this.sendMessage(session, producer);
        Thread.sleep(1000L);
        for (int i = 0; i < 5; ++i) {
            this.sendMessage(session, producer);
        }
        this.restart();
        EmptyTransactionTest.assertFalse((boolean)hadRecovery.get());
    }

    private void sendMessage(Session session, MessageProducer producer) throws JMSException {
        TextMessage m = session.createTextMessage("Hi");
        producer.send((Message)m);
        session.commit();
    }

    private void restart() throws Exception {
        this.broker.stop();
        this.broker.waitUntilStopped();
        this.start(false);
    }

    private void start(boolean deleteMessages) throws Exception {
        this.broker = new BrokerService();
        KahaDBPersistenceAdapter kahaDB = new KahaDBPersistenceAdapter();
        kahaDB.setCheckpointInterval(500L);
        this.broker.setPersistenceAdapter((PersistenceAdapter)kahaDB);
        this.broker.setPersistent(true);
        this.broker.setDeleteAllMessagesOnStartup(deleteMessages);
        this.broker.start();
        this.broker.waitUntilStarted();
    }
}

